<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace Angie\Search;

/**
 * Search item interface.
 *
 * @package Angie\Search
 */
interface Item
{
    const FIELD_BOOLEAN = 'boolean';
    const FIELD_NUMERIC = 'numeric';
    const FIELD_DATE = 'date';
    const FIELD_DATETIME = 'datetime';
    const FIELD_STRING = 'string';
    const FIELD_TEXT = 'text';
    const FIELD_ATTACHMENTS = 'attachments';

    /**
     * Return a list of fields that are indexed for this type.
     *
     * @return array
     */
    public function getSearchFields();

    /**
     * Serialize object to be indexed.
     *
     * @return array
     */
    public function searchSerialize();

    /**
     * Return type under which it this object is stored in the search index.
     *
     * @return string
     */
    public function getSearchIndexType();

    /**
     * Get object ID.
     *
     * @return int
     */
    public function getId();

    /**
     * Return url path.
     *
     * @return string
     */
    public function getUrlPath();

    /**
     * Return name of this model.
     *
     * @param  bool   $underscore
     * @param  bool   $singular
     * @return string
     */
    public function getModelName($underscore = false, $singular = false);
}
