<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Add type field to remote invoices table.
 *
 * @package activeCollab.modules.system
 */
class MigrateAddTypeFieldToRemoteInvoicesTable extends AngieModelMigration
{
    /**
     * Migrate up.
     */
    public function up()
    {
        if (!$this->tableExists('remote_invoices')) {
            $this->createTable('remote_invoices', [
                DBIdColumn::create(),
                DBStringColumn::create('invoice_number', 45),
                DBStringColumn::create('client', 75),
                DBIntegerColumn::create('remote_id'),
                DBMoneyColumn::create('amount', 0),
                DBMoneyColumn::create('balance', 0),
                DBUpdatedOnByColumn::create(),
            ]);
        }

        $remote_invoices = $this->useTableForAlter('remote_invoices');

        $remote_invoices->addColumn(DBTypeColumn::create('RemoteInvoice'), 'id');

        $this->doneUsingTables();
    }
}
