<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Add additional properties field to remote invoices table.
 *
 * @package activeCollab.modules.system
 */
class MigrateAddAdditionalPropertiesFieldToRemoteInvoicesTable extends AngieModelMigration
{
    /**
     * Migrate up.
     */
    public function up()
    {
        $remote_invoices = $this->useTableForAlter('remote_invoices');

        $remote_invoices->addColumn(DBAdditionalPropertiesColumn::create(), 'balance');

        $this->doneUsingTables();
    }
}
