<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * @package ActiveCollab.migrations
 */
class MigrateAddLastLoginOnToUsersTable extends AngieModelMigration
{
    /**
     * {@inheritdoc}
     */
    public function up()
    {
        $users = $this->useTableForAlter('users');

        if (!$users->getColumn('last_login_on')) {
            $this->execute('ALTER TABLE users ADD last_login_on DATETIME NULL');
            $this->execute('ALTER TABLE users ADD INDEX(last_login_on)');

            $this->execute('CREATE TRIGGER new_subscription_updates_login_timestamp AFTER INSERT ON api_subscriptions FOR EACH ROW 
                BEGIN
                    IF NEW.created_on IS NOT NULL THEN
                        UPDATE users SET last_login_on = NEW.created_on WHERE id = NEW.user_id;
                    END IF;
                END');
            $this->execute('CREATE TRIGGER new_session_updates_login_timestamp AFTER INSERT ON user_sessions FOR EACH ROW 
                BEGIN
                    IF NEW.created_on IS NOT NULL THEN
                        UPDATE users SET last_login_on = NEW.created_on WHERE id = NEW.user_id;
                    END IF;
                END');

            if ($rows = $this->execute('SELECT MAX(created_on) AS "created_on", user_id FROM api_subscriptions GROUP BY user_id')) {
                $rows->setCasting(['created_on' => DBResult::CAST_DATETIME]);

                foreach ($rows as $row) {
                    $this->execute('UPDATE users SET last_login_on = ? WHERE id = ?', $row['created_on'], $row['user_id']);
                }
            }
        }
    }
}
