<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Search\Filter;

/**
 * on_user_search_filter event handler.
 *
 * @package activeCollab.modules.invoicing
 * @subpackage handlers
 */

/**
 * @param User   $user
 * @param Filter $filter
 */
function invoicing_handle_on_user_access_search_filter(User $user, Filter &$filter)
{
    if ($user->isFinancialManager()) {
        $filter->byType('Invoice');
        $filter->byType('Estimate');
    }
}
