<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Http\Request;

AngieApplication::useController('admin', EnvironmentFramework::INJECT_INTO);

/**
 * Password policy controller.
 *
 * @package activeCollab.modules.password_policy
 * @subpackage controllers
 */
class PasswordPolicyController extends AdminController
{
    /**
     * Show password policy settings data.
     */
    public function show_settings()
    {
        return ConfigOptions::getValue([
            'password_policy_min_length',
            'password_policy_require_numbers',
            'password_policy_require_mixed_case',
            'password_policy_require_symbols',
        ]);
    }

    /**
     * Save password policy settings data.
     *
     * @param  Request $request
     * @return array
     */
    public function save_settings(Request $request)
    {
        $put = $request->put();

        ConfigOptions::setValue([
            'password_policy_min_length' => array_key_exists('password_policy_min_length', $put) ? (int) $put['password_policy_min_length'] : 0,
            'password_policy_require_numbers' => isset($put['password_policy_require_numbers']) && $put['password_policy_require_numbers'],
            'password_policy_require_mixed_case' => isset($put['password_policy_require_mixed_case']) && $put['password_policy_require_mixed_case'],
            'password_policy_require_symbols' => isset($put['password_policy_require_symbols']) && $put['password_policy_require_symbols'],
        ]);

        return ConfigOptions::getValue(['password_policy_min_length', 'password_policy_require_numbers', 'password_policy_require_mixed_case', 'password_policy_require_symbols']);
    }
}
