<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Inflector;
use Angie\Search;

/**
 * on_search_rebuild_index event handler.
 *
 * @package activeCollab.modules.system
 * @subpackage handlers
 */

/**
 * @param Angie\NamedList $actions
 */
function system_handle_on_search_rebuild_index(Angie\NamedList &$actions)
{
    $actions->add('rebuild_users', [
        'label' => 'Rebuild users search index',
        'callback' => function () {
            if ($users = Users::find(['order' => 'id'])) {
                Search::getAdapter()->batchStart('User');

                foreach ($users as $user) {
                    Search::getAdapter()->batchAdd($user);
                }

                Search::getAdapter()->batchDone('User');
            }
        },
    ]);

    $actions->add('rebuild_companies', [
        'label' => lang('Rebuild companies search index'),
        'callback' => function () {
            if ($companies = Companies::find(['conditions' => ['is_trashed' => false], 'order' => 'id'])) {
                Search::getAdapter()->batchStart('Company');

                foreach ($companies as $company) {
                    Search::getAdapter()->batchAdd($company);
                }

                Search::getAdapter()->batchDone('Company');
            }
        },
    ]);

    /** @var Project[] $projects */
    $projects = Projects::find(['conditions' => ['is_trashed' => false]]);

    $actions->add('rebuild_projects', [
        'label' => lang('Rebuild projects search index'),
        'callback' => function () use ($projects) {
            if (!empty($projects)) {
                Search::getAdapter()->batchStart('Project');

                foreach ($projects as $project) {
                    Search::getAdapter()->batchAdd($project);
                }

                Search::getAdapter()->batchDone('Project');
            }
        },
    ]);

    foreach (['task_lists', 'tasks', 'discussions', 'files', 'notes'] as $project_elements) {
        $manager = Inflector::camelize($project_elements);
        $object = Inflector::camelize(Inflector::singularize($project_elements));

        $actions->add("rebuild_project_{$project_elements}", [
            'label' => lang("Rebuild $project_elements search index"),
            'callback' => function () use ($projects, $manager, $object) {
                if ($rows = call_user_func("$manager::find", ['conditions' => ['is_trashed' => false], 'order' => 'id'])) {
                    Search::getAdapter()->batchStart($object);

                    foreach ($rows as $row) {
                        Search::getAdapter()->batchAdd($row);
                    }

                    Search::getAdapter()->batchDone($object);
                }
            },
        ]);
    }
}
