<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Search\Filter;

/**
 * on_user_search_filter event handler.
 *
 * @package activeCollab.modules.system
 * @subpackage handlers
 */

/**
 * @param User   $user
 * @param Filter $filter
 */
function system_handle_on_user_access_search_filter(User $user, Filter &$filter)
{
    $filter->byTypeAndIds(User::class, $user->getVisibleUserIds());

    $project_ids = $user->getProjectIds();

    if ($project_ids && is_foreachable($project_ids)) {
        $filter->byTypeAndIds(Project::class, $project_ids);

        $project_element_properties_filter = ['project_id' => $project_ids];

        if ($user instanceof Client) {
            $project_element_properties_filter['is_hidden_from_clients'] = false;
        }

        foreach (Projects::getAvailableProjectElementClasses() as $project_element_type) {
            $filter->byTypeAndProperties($project_element_type, $project_element_properties_filter);
        }
    }

    $filter->byTypeAndIds(Company::class, $user->getVisibleCompanyIds());
}
