<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Initial user settings collection.
 *
 * @package ActiveCollab.modules.system
 * @subpackage models
 */
class InitialUserSettingsCollection extends FwInitialUserSettingsCollection
{
    /**
     * {@inheritdoc}
     */
    protected function onLoadSettings(array &$settings, User $user)
    {
        $settings['display_mode_projects'] = ConfigOptions::getValueFor('display_mode_projects', $user);
        $settings['display_mode_project_files'] = ConfigOptions::getValueFor('display_mode_project_files', $user);
        $settings['display_mode_project_tasks'] = ConfigOptions::getValueFor('display_mode_project_tasks', $user);
        $settings['display_mode_project_time'] = ConfigOptions::getValueFor('display_mode_project_time', $user);
        $settings['display_mode_invoices'] = ConfigOptions::getValueFor('display_mode_invoices', $user);
        $settings['display_mode_estimates'] = ConfigOptions::getValueFor('display_mode_estimates', $user);
        $settings['group_mode_people'] = ConfigOptions::getValueFor('group_mode_people', $user);
        $settings['sort_mode_projects'] = ConfigOptions::getValueFor('sort_mode_projects', $user);
        $settings['sort_mode_project_notes'] = ConfigOptions::getValueFor('sort_mode_project_notes', $user);
        $settings['default_project_label_id'] = Labels::findDefaultId('ProjectLabel');
        $settings['my_work_projects_order'] = ConfigOptions::getValueFor('my_work_projects_order', $user);
        $settings['my_work_collapsed_sections'] = ConfigOptions::getValueFor('my_work_collapsed_sections', $user);
        $settings['show_visual_editor_toolbar'] = ConfigOptions::getValueFor('show_visual_editor_toolbar', $user);
        $settings['filter_client_projects'] = ConfigOptions::getValueFor('filter_client_projects', $user);
        $settings['filter_label_projects'] = ConfigOptions::getValueFor('filter_label_projects', $user);
        $settings['filter_category_projects'] = ConfigOptions::getValueFor('filter_category_projects', $user);

        if (empty($settings['my_work_projects_order'])) {
            $settings['my_work_projects_order'] = [];
        }

        if (empty($settings['my_work_collapsed_sections'])) {
            $settings['my_work_collapsed_sections'] = [];
        }
    }

    /**
     * {@inheritdoc}
     */
    protected function onLoadCollections(array &$collections, User $user)
    {
        $collections['users'] = Users::prepareCollection(DataManager::ALL, $user);
        $collections['companies'] = Companies::prepareCollection(DataManager::ALL, $user);
        $collections['projects'] = Projects::prepareCollection('active_projects_page_1', $user);
        $collections['system_notifications'] = SystemNotifications::prepareCollection('active_recipient_system_notifications', $user);
    }
}
