<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/**
 * Security logs table definition.
 *
 * @package angie.frameworks.authentication
 * @subpackage resources
 */

return DB::createTable('security_logs')->addColumns([
    DBIdColumn::create()->setSize(DBColumn::BIG),
    DBUserColumn::create('user', true),
    DBUserColumn::create('login_as', true),
    DBUserColumn::create('logout_by', true),
    DBEnumColumn::create('event', ['login', 'logout', 'expired', 'failed']),
    DBDateTimeColumn::create('event_on'),
    DBIpAddressColumn::create('user_ip'),
    DBTextColumn::create('user_agent'),
])->addIndices([
    DBIndex::create('event_on'),
]);
