<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

use Angie\Http\Request;
use Angie\Http\Response;

AngieApplication::useController('users', SystemModule::NAME);

/**
 * User tasks controller.
 *
 * @package ActiveCollab.modules.tasks
 * @subpackage controllers
 */
class UserTasksController extends UsersController
{
    /**
     * Show user assignments.
     *
     * @param  Request             $request
     * @param  User                $user
     * @return ModelCollection|int
     */
    public function index(Request $request, User $user)
    {
        return $this->active_user->isLoaded() && $this->active_user->canView($user) ?
            Users::prepareCollection('open_assignments_for_assignee_' . $this->active_user->getId(), $user) :
            Response::NOT_FOUND;
    }
}
