<?php

/*
 * This file is part of the Active Collab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\ActiveCollabJobs\Jobs\Shepherd;

use InvalidArgumentException;

/**
 * @package ActiveCollab\ActiveCollabJobs\Jobs\Shepherd
 */
class RegisterNewUser extends ExecuteShephedCliCommand
{
    /**
     * {@inheritdoc}
     */
    public function __construct(array $data = null)
    {
        $data['instance_id'] = !empty($data['instance_id']) ? (int) $data['instance_id'] : 0;

        if ($data['instance_id'] < 1) {
            throw new InvalidArgumentException('Valid instance_id is required');
        }

        $command_options = ['instance' => $data['instance_id']];

        foreach (['email', 'user_id'] as $required_parameter) {
            if (empty($data[$required_parameter])) {
                throw new InvalidArgumentException("Valid $required_parameter is required");
            }
        }

        $command_options['email'] = $data['email'];
        $command_options['user-id'] = $data['user_id'];
        $command_options['first-name'] = empty($data['first_name']) ? '' : trim($data['first_name']);
        $command_options['last-name'] = empty($data['last_name']) ? '' : trim($data['last_name']);
        $command_options['welcome'] = (int) !empty($data['send_welcome_message']);

        if (!empty($data['activecollab_arguments'])) {
            $command_options['activecollab'] = json_encode($data['activecollab_arguments']);
        }

        parent::__construct(array_merge($data, [
            'command' => 'new_id_user',
            'command_arguments' => [],
            'command_options' => $command_options,
        ]));
    }
}
