<?php
  
  return function ($name, $data, $url_base, $query_arg_separator, $anchor) {
    switch ($name) {
      case 'api_info':
        return Router::doAssemble('api_info', 'info', array ( 'controller' => 'utilities', 'action' => array ( 'GET' => 'info', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trash':
        return Router::doAssemble('trash', 'trash', array ( 'action' => array ( 'GET' => 'show_content', 'DELETE' => 'empty_trash', ), 'controller' => 'trash', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'move_to_archive':
        return Router::doAssemble('move_to_archive', 'move-to-archive/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'archive', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'restore_from_archive':
        return Router::doAssemble('restore_from_archive', 'restore-from-archive/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'restore_from_archive', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'move_to_trash':
        return Router::doAssemble('move_to_trash', 'move-to-trash/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'trash', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'restore_from_trash':
        return Router::doAssemble('restore_from_trash', 'restore-from-trash/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'restore_from_trash', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'permanently_delete':
        return Router::doAssemble('permanently_delete', 'permanently-delete/:parent_type/:parent_id', array ( 'action' => array ( 'DELETE' => 'permanently_delete', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reactivate':
        return Router::doAssemble('reactivate', 'reactivate/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'reactivate', ), 'controller' => 'state', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'access_logs':
        return Router::doAssemble('access_logs', 'access-logs/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', 'PUT' => 'log_access', ), 'controller' => 'access_logs', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'upload_files':
        return Router::doAssemble('upload_files', 'upload-files', array ( 'action' => array ( 'POST' => 'index', 'GET' => 'prepare', ), 'controller' => 'upload_files', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'search':
        return Router::doAssemble('search', 'search', array ( 'action' => array ( 'GET' => 'query', ), 'controller' => 'search', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'search_suggest':
        return Router::doAssemble('search_suggest', 'search/suggest', array ( 'action' => array ( 'GET' => 'suggest', ), 'controller' => 'search', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'config_options':
        return Router::doAssemble('config_options', 'config-options', array ( 'action' => array ( 'GET' => 'get', 'PUT' => 'set', ), 'controller' => 'config_options', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'personalized_config_options':
        return Router::doAssemble('personalized_config_options', 'personalized-config-options', array ( 'action' => array ( 'GET' => 'personalized_get', 'PUT' => 'personalized_set', ), 'controller' => 'config_options', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'initial':
        return Router::doAssemble('initial', 'initial', array ( 'controller' => 'initial', 'action' => 'index', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'initial_speed_test':
        return Router::doAssemble('initial_speed_test', 'initial/test-speed', array ( 'controller' => 'initial', 'action' => 'test_action_speed', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'system_status':
        return Router::doAssemble('system_status', 'system-status', array ( 'controller' => 'system_status', 'action' => 'index', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'check_for_updates':
        return Router::doAssemble('check_for_updates', 'system-status/check-for-updates', array ( 'controller' => 'system_status', 'action' => 'check_for_updates', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'download_release':
        return Router::doAssemble('download_release', 'system-status/download-release', array ( 'controller' => 'system_status', 'action' => array ( 'GET' => 'get_download_progress', 'POST' => 'start_download', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'check_environment':
        return Router::doAssemble('check_environment', 'system-status/check-environment', array ( 'controller' => 'system_status', 'action' => 'check_environment', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'upgrade':
        return Router::doAssemble('upgrade', 'upgrade', array ( 'controller' => 'upgrade', 'action' => array ( 'GET' => 'index', 'POST' => 'finish', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'upgrade_release_notes':
        return Router::doAssemble('upgrade_release_notes', 'upgrade/release-notes', array ( 'controller' => 'upgrade', 'action' => 'release_notes', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'wallpapers':
        return Router::doAssemble('wallpapers', 'wallpapers', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'wallpapers', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'day_offs':
        return Router::doAssemble('day_offs', 'day-offs', array ( 'module' => 'system', 'controller' => 'day_offs', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'day_off':
        return Router::doAssemble('day_off', 'day-offs/:day_off_id', array ( 'module' => 'system', 'controller' => 'day_offs', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'languages':
        return Router::doAssemble('languages', 'languages', array ( 'module' => 'system', 'controller' => 'languages', 'action' => array ( 'GET' => 'index', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'language':
        return Router::doAssemble('language', 'languages/:language_id', array ( 'module' => 'system', 'controller' => 'languages', 'action' => array ( 'GET' => 'view', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'languages_default':
        return Router::doAssemble('languages_default', 'languages/default', array ( 'controller' => 'languages', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'currencies':
        return Router::doAssemble('currencies', 'currencies', array ( 'module' => 'system', 'controller' => 'currencies', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'currency':
        return Router::doAssemble('currency', 'currencies/:currency_id', array ( 'module' => 'system', 'controller' => 'currencies', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'currencies_default':
        return Router::doAssemble('currencies_default', 'currencies/default', array ( 'controller' => 'currencies', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'integration_singletons':
        return Router::doAssemble('integration_singletons', 'integrations/:integration_type', array ( 'module' => 'system', 'controller' => 'integration_singletons', 'action' => array ( 'GET' => 'get', 'PUT' => 'set', 'DELETE' => 'forget', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'integrations':
        return Router::doAssemble('integrations', 'integrations', array ( 'module' => 'system', 'controller' => 'integrations', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'integration':
        return Router::doAssemble('integration', 'integrations/:integration_id', array ( 'module' => 'system', 'controller' => 'integrations', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'search_integration_test_connection':
        return Router::doAssemble('search_integration_test_connection', 'integrations/search/test-connection', array ( 'module' => 'system', 'controller' => 'search_integration', 'action' => array ( 'POST' => 'test_connection', ), 'integration_type' => 'search', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'cron_integration':
        return Router::doAssemble('cron_integration', 'integrations/cron', array ( 'module' => 'system', 'controller' => 'cron_integration', 'action' => 'get', 'integration_type' => 'cron', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'localization':
        return Router::doAssemble('localization', 'localization', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'localization_timezones':
        return Router::doAssemble('localization_timezones', 'localization/timezones', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_timezones', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'localization_date_formats':
        return Router::doAssemble('localization_date_formats', 'localization/date-formats', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_date_formats', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'localization_time_formats':
        return Router::doAssemble('localization_time_formats', 'localization/time-formats', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_time_formats', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'workweek':
        return Router::doAssemble('workweek', 'workweek', array ( 'controller' => 'workweek', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reports':
        return Router::doAssemble('reports', 'reports', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reports_run':
        return Router::doAssemble('reports_run', 'reports/run', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'run', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reports_export':
        return Router::doAssemble('reports_export', 'reports/export', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'complete':
        return Router::doAssemble('complete', 'complete/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'complete', ), 'controller' => 'complete', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'open':
        return Router::doAssemble('open', 'open/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'open', ), 'controller' => 'complete', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'data_filters':
        return Router::doAssemble('data_filters', 'data-filters', array ( 'module' => 'system', 'controller' => 'data_filters', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'data_filter':
        return Router::doAssemble('data_filter', 'data-filters/:data_filter_id', array ( 'module' => 'system', 'controller' => 'data_filters', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'favorites':
        return Router::doAssemble('favorites', 'favorites', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'favorites', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'favorite':
        return Router::doAssemble('favorite', 'favorites/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'check', 'PUT' => 'add', 'DELETE' => 'remove', ), 'controller' => 'favorites', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'compare_text':
        return Router::doAssemble('compare_text', 'compare-text', array ( 'action' => array ( 'POST' => 'compare', ), 'controller' => 'compare_text', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'system_notifications_dismiss':
        return Router::doAssemble('system_notifications_dismiss', 'system-notifications/:notification_id/dismiss', array ( 'controller' => 'system_notifications', 'action' => array ( 'GET' => 'dismiss', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'warehouse_pingback':
        return Router::doAssemble('warehouse_pingback', 'integrations/warehouse/pingback', array ( 'controller' => 'warehouse', 'action' => array ( 'POST' => 'pingback', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'warehouse_store_export_complete_pingback':
        return Router::doAssemble('warehouse_store_export_complete_pingback', 'integrations/warehouse/store/export', array ( 'controller' => 'warehouse', 'action' => array ( 'POST' => 'storeExportPingback', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'google_drive_batch':
        return Router::doAssemble('google_drive_batch', 'integrations/google-drive/batch', array ( 'controller' => 'google_drive', 'action' => array ( 'POST' => 'batch_add', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'dropbox_batch':
        return Router::doAssemble('dropbox_batch', 'integrations/dropbox/batch', array ( 'controller' => 'dropbox', 'action' => array ( 'POST' => 'batch_add', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'activity_logs':
        return Router::doAssemble('activity_logs', 'activity-logs', array ( 'module' => 'activity_logs', 'controller' => 'activity_logs', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'activity_log':
        return Router::doAssemble('activity_log', 'activity-logs/:activity_log_id', array ( 'module' => 'activity_logs', 'controller' => 'activity_logs', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'whats_new':
        return Router::doAssemble('whats_new', 'whats-new', array ( 'controller' => 'whats_new', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'whats_new_daily':
        return Router::doAssemble('whats_new_daily', 'whats-new/daily/:day', array ( 'controller' => 'whats_new', 'action' => array ( 'GET' => 'daily', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'history':
        return Router::doAssemble('history', 'history/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'history', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'email_integration_email_log':
        return Router::doAssemble('email_integration_email_log', 'integrations/email/email-log', array ( 'module' => 'system', 'controller' => 'email_integration', 'action' => array ( 'GET' => 'email_log', ), 'integration_type' => 'email', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'email_integration_test_connection':
        return Router::doAssemble('email_integration_test_connection', 'integrations/email/test-connection', array ( 'module' => 'system', 'controller' => 'email_integration', 'action' => array ( 'POST' => 'test_connection', ), 'integration_type' => 'email', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'attachments':
        return Router::doAssemble('attachments', 'attachments', array ( 'module' => 'system', 'controller' => 'attachments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'attachment':
        return Router::doAssemble('attachment', 'attachments/:attachment_id', array ( 'module' => 'system', 'controller' => 'attachments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'attachment_download':
        return Router::doAssemble('attachment_download', 'attachments/:attachment_id/download', array ( 'controller' => 'attachments', 'action' => array ( 'GET' => 'download', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'attachments_batch_download':
        return Router::doAssemble('attachments_batch_download', 'attachments/:parent_type/:parent_id/download', array ( 'controller' => 'attachments_archive', 'action' => array ( 'POST' => 'prepare', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notifications':
        return Router::doAssemble('notifications', 'notifications', array ( 'module' => 'system', 'controller' => 'notifications', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notification':
        return Router::doAssemble('notification', 'notifications/:notification_id', array ( 'module' => 'system', 'controller' => 'notifications', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notifications_unread':
        return Router::doAssemble('notifications_unread', 'notifications/unread', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'unread', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notifications_object_updates':
        return Router::doAssemble('notifications_object_updates', 'notifications/object-updates', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'object_updates', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notifications_recent_object_updates':
        return Router::doAssemble('notifications_recent_object_updates', 'notifications/object-updates/recent', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'recent_object_updates', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notifications_mark_all_as_read':
        return Router::doAssemble('notifications_mark_all_as_read', 'notifications/mark-all-as-read', array ( 'controller' => 'notifications', 'action' => array ( 'PUT' => 'mark_all_as_read', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'public_notifications_subscribe':
        return Router::doAssemble('public_notifications_subscribe', 'public/notifications/subscribe', array ( 'controller' => 'public_notifications', 'action' => 'subscribe', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'public_notifications_unsubscribe':
        return Router::doAssemble('public_notifications_unsubscribe', 'public/notifications/unsubscribe', array ( 'controller' => 'public_notifications', 'action' => 'unsubscribe', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subscribers':
        return Router::doAssemble('subscribers', 'subscribers/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', 'POST' => 'bulk_subscribe', 'PUT' => 'bulk_update', 'DELETE' => 'bulk_unsubscribe', ), 'controller' => 'subscribers', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subscriber':
        return Router::doAssemble('subscriber', 'subscribers/:parent_type/:parent_id/users/:user_id', array ( 'action' => array ( 'POST' => 'subscribe', 'DELETE' => 'unsubscribe', ), 'controller' => 'subscribers', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'comments':
        return Router::doAssemble('comments', 'comments/:parent_type/:parent_id', array ( 'module' => 'system', 'controller' => 'comments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'comment':
        return Router::doAssemble('comment', 'comments/:comment_id', array ( 'module' => 'system', 'controller' => 'comments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'categories':
        return Router::doAssemble('categories', 'categories', array ( 'module' => 'system', 'controller' => 'categories', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'category':
        return Router::doAssemble('category', 'categories/:category_id', array ( 'module' => 'system', 'controller' => 'categories', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'labels':
        return Router::doAssemble('labels', 'labels', array ( 'module' => 'system', 'controller' => 'labels', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'label':
        return Router::doAssemble('label', 'labels/:label_id', array ( 'module' => 'system', 'controller' => 'labels', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'labels_reorder':
        return Router::doAssemble('labels_reorder', 'labels/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'labels', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'label_set_as_default':
        return Router::doAssemble('label_set_as_default', 'labels/:label_id/set-as-default', array ( 'action' => array ( 'PUT' => 'set_as_default', ), 'controller' => 'labels', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'payments':
        return Router::doAssemble('payments', 'payments', array ( 'module' => 'system', 'controller' => 'payments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'payment':
        return Router::doAssemble('payment', 'payments/:payment_id', array ( 'module' => 'system', 'controller' => 'payments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'public_payments':
        return Router::doAssemble('public_payments', 'public_payments', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'view', 'POST' => 'add', 'PUT' => 'update', 'delete' => 'cancel', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'public_payment_authorizenet_confirm':
        return Router::doAssemble('public_payment_authorizenet_confirm', 'public_payments/authorizenet-confirm', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'authorizenet_confirm', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'public_payment_authorizenet_form':
        return Router::doAssemble('public_payment_authorizenet_form', 'public_payments/authorizenet-form', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'authorizenet_form', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'payment_gateways':
        return Router::doAssemble('payment_gateways', 'payment-gateways', array ( 'controller' => 'payment_gateways', 'action' => array ( 'GET' => 'get_settings', 'PUT' => 'update_settings', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'payment_gateway_clear_paypal':
        return Router::doAssemble('payment_gateway_clear_paypal', 'payment-gateways/clear-paypal', array ( 'controller' => 'payment_gateways', 'action' => array ( 'DELETE' => 'clear_paypal', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'payment_gateway_clear_credit_card':
        return Router::doAssemble('payment_gateway_clear_credit_card', 'payment-gateways/clear-credit-card', array ( 'controller' => 'payment_gateways', 'action' => array ( 'DELETE' => 'clear_credit_card', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reminders':
        return Router::doAssemble('reminders', 'reminders/:parent_type/:parent_id', array ( 'module' => 'system', 'controller' => 'reminders', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'reminder':
        return Router::doAssemble('reminder', 'reminders/:reminder_id', array ( 'module' => 'system', 'controller' => 'reminders', 'action' => array ( 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendars':
        return Router::doAssemble('calendars', 'calendars', array ( 'module' => 'system', 'controller' => 'calendars', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar':
        return Router::doAssemble('calendar', 'calendars/:calendar_id', array ( 'module' => 'system', 'controller' => 'calendars', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendars_events':
        return Router::doAssemble('calendars_events', 'calendars/events', array ( 'controller' => 'calendars', 'action' => array ( 'GET' => 'all_calendar_events', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar_events':
        return Router::doAssemble('calendar_events', 'calendars/:calendar_id/events', array ( 'module' => 'system', 'controller' => 'calendar_events', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar_event':
        return Router::doAssemble('calendar_event', 'calendars/:calendar_id/events/:calendar_event_id', array ( 'module' => 'system', 'controller' => 'calendar_events', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'users':
        return Router::doAssemble('users', 'users', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user':
        return Router::doAssemble('user', 'users/:user_id', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'users_invite':
        return Router::doAssemble('users_invite', 'users/invite', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'POST' => 'invite', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'users_all':
        return Router::doAssemble('users_all', 'users/all', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'all', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'users_archive':
        return Router::doAssemble('users_archive', 'users/archive', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'archive', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'users_check_email':
        return Router::doAssemble('users_check_email', 'users/check-email', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'check_email', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_archive':
        return Router::doAssemble('user_archive', 'users/:user_id/archive', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'move_to_archive', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_reactivate':
        return Router::doAssemble('user_reactivate', 'users/:user_id/reactivate', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'reactivate', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_change_password':
        return Router::doAssemble('user_change_password', 'users/:user_id/change-password', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'change_password', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_resend_invitation':
        return Router::doAssemble('user_resend_invitation', 'users/:user_id/resend-invitation', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'resend_invitation', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_get_invitation':
        return Router::doAssemble('user_get_invitation', 'users/:user_id/get-invitation', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'get_invitation', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_get_accept_invitation_url':
        return Router::doAssemble('user_get_accept_invitation_url', 'users/:user_id/get-invitation/accept-url', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'get_accept_invitation_url', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_export':
        return Router::doAssemble('user_export', 'users/:user_id/export', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'export', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_activities':
        return Router::doAssemble('user_activities', 'users/:user_id/activities', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'activities', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_clear_avatar':
        return Router::doAssemble('user_clear_avatar', 'users/:user_id/clear-avatar', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'DELETE' => 'clear_avatar', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_change_role':
        return Router::doAssemble('user_change_role', 'users/:user_id/change-role', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'change_role', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_sessions':
        return Router::doAssemble('user_sessions', 'users/:user_id/sessions', array ( 'module' => 'system', 'controller' => 'user_sessions', 'action' => array ( 'GET' => 'index', 'DELETE' => 'remove', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'api_subscriptions':
        return Router::doAssemble('api_subscriptions', 'users/:user_id/api-subscriptions', array ( 'module' => 'system', 'controller' => 'api_subscriptions', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'api_subscription':
        return Router::doAssemble('api_subscription', 'users/:user_id/api-subscriptions/:api_subscription_id', array ( 'module' => 'system', 'controller' => 'api_subscriptions', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_session':
        return Router::doAssemble('user_session', 'user-session', array ( 'controller' => 'user_session', 'action' => array ( 'GET' => 'who_am_i', 'POST' => 'login', 'DELETE' => 'logout', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'issue_token':
        return Router::doAssemble('issue_token', 'issue-token', array ( 'controller' => 'user_session', 'action' => array ( 'POST' => 'issue_token', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'issue_token_by_intent':
        return Router::doAssemble('issue_token_by_intent', 'issue-token-intent', array ( 'controller' => 'user_session', 'action' => array ( 'POST' => 'issue_token', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'accept_invitation':
        return Router::doAssemble('accept_invitation', 'accept-invitation', array ( 'controller' => 'user_session', 'action' => array ( 'GET' => 'view_invitation', 'POST' => 'accept_invitation', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'password_recovery_send_code':
        return Router::doAssemble('password_recovery_send_code', 'password-recovery/send-code', array ( 'controller' => 'password_recovery', 'action' => array ( 'POST' => 'send_code', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'password_recovery_reset_password':
        return Router::doAssemble('password_recovery_reset_password', 'password-recovery/reset-password', array ( 'controller' => 'password_recovery', 'action' => array ( 'POST' => 'reset_password', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'companies':
        return Router::doAssemble('companies', 'companies', array ( 'module' => 'system', 'controller' => 'companies', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company':
        return Router::doAssemble('company', 'companies/:company_id', array ( 'module' => 'system', 'controller' => 'companies', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'companies_all':
        return Router::doAssemble('companies_all', 'companies/all', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'all', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'companies_archive':
        return Router::doAssemble('companies_archive', 'companies/archive', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'archive', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'companies_notes':
        return Router::doAssemble('companies_notes', 'companies/notes', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'notes', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company_export':
        return Router::doAssemble('company_export', 'companies/:company_id/export', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company_projects':
        return Router::doAssemble('company_projects', 'companies/:company_id/projects', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'projects', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company_project_names':
        return Router::doAssemble('company_project_names', 'companies/:company_id/project-names', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'project_names', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company_invoices':
        return Router::doAssemble('company_invoices', 'companies/:company_id/invoices', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'invoices', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'teams':
        return Router::doAssemble('teams', 'teams', array ( 'module' => 'system', 'controller' => 'teams', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'team':
        return Router::doAssemble('team', 'teams/:team_id', array ( 'module' => 'system', 'controller' => 'teams', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'team_members':
        return Router::doAssemble('team_members', 'teams/:team_id/members', array ( 'controller' => 'team_members', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'team_member':
        return Router::doAssemble('team_member', 'teams/:team_id/members/:user_id', array ( 'controller' => 'team_members', 'action' => array ( 'DELETE' => 'delete', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects':
        return Router::doAssemble('projects', 'projects', array ( 'module' => 'system', 'controller' => 'projects', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project':
        return Router::doAssemble('project', 'projects/:project_id', array ( 'module' => 'system', 'controller' => 'projects', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_filter':
        return Router::doAssemble('projects_filter', 'projects/filter', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'filter', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_archive':
        return Router::doAssemble('projects_archive', 'projects/archive', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'archive', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_names':
        return Router::doAssemble('projects_names', 'projects/names', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'names', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_with_tracking_enabled':
        return Router::doAssemble('projects_with_tracking_enabled', 'projects/with-tracking-enabled', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'with_tracking_enabled', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_labels':
        return Router::doAssemble('projects_labels', 'projects/labels', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'labels', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_calendar_events':
        return Router::doAssemble('projects_calendar_events', 'projects/calendar-events', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'calendar_events', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_categories':
        return Router::doAssemble('projects_categories', 'projects/categories', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'categories', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_whats_new':
        return Router::doAssemble('project_whats_new', 'projects/:project_id/whats-new', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'whats_new', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_budget':
        return Router::doAssemble('project_budget', 'projects/:project_id/budget', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'budget', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_export':
        return Router::doAssemble('project_export', 'projects/:project_id/export', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_members':
        return Router::doAssemble('project_members', 'projects/:project_id/members', array ( 'controller' => 'project_members', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_member':
        return Router::doAssemble('project_member', 'projects/:project_id/members/:user_id', array ( 'controller' => 'project_members', 'action' => array ( 'PUT' => 'replace', 'DELETE' => 'delete', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_revoke_client_access':
        return Router::doAssemble('project_revoke_client_access', 'projects/:project_id/revoke-client-access', array ( 'controller' => 'project_members', 'action' => array ( 'PUT' => 'revoke_client_access', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_responsibilities':
        return Router::doAssemble('project_responsibilities', 'projects/:project_id/responsibilities', array ( 'controller' => 'project_members', 'action' => array ( 'GET' => 'responsibilities', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_lists':
        return Router::doAssemble('task_lists', 'projects/:project_id/task-lists', array ( 'module' => 'tasks', 'controller' => 'task_lists', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_list':
        return Router::doAssemble('task_list', 'projects/:project_id/task-lists/:task_list_id', array ( 'module' => 'tasks', 'controller' => 'task_lists', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_lists_archive':
        return Router::doAssemble('task_lists_archive', 'projects/:project_id/task-lists/archive', array ( 'action' => array ( 'GET' => 'archive', ), 'controller' => 'task_lists', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_lists_reorder':
        return Router::doAssemble('task_lists_reorder', 'projects/:project_id/task-lists/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'task_lists', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_list_move_to_project':
        return Router::doAssemble('task_list_move_to_project', 'projects/:project_id/task-lists/:task_list_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'task_lists', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_list_completed_tasks':
        return Router::doAssemble('task_list_completed_tasks', 'projects/:project_id/task-lists/:task_list_id/completed-tasks', array ( 'action' => array ( 'GET' => 'completed_tasks', ), 'controller' => 'task_lists', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tasks':
        return Router::doAssemble('tasks', 'projects/:project_id/tasks', array ( 'module' => 'tasks', 'controller' => 'tasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', 'PUT' => 'batch_update', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task':
        return Router::doAssemble('task', 'projects/:project_id/tasks/:task_id', array ( 'module' => 'tasks', 'controller' => 'tasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tasks_archive':
        return Router::doAssemble('tasks_archive', 'projects/:project_id/tasks/archive', array ( 'action' => array ( 'GET' => 'archive', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tasks_reorder':
        return Router::doAssemble('tasks_reorder', 'projects/:project_id/tasks/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_time_records':
        return Router::doAssemble('task_time_records', 'projects/:project_id/tasks/:task_id/time-records', array ( 'action' => array ( 'GET' => 'time_records', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_expenses':
        return Router::doAssemble('task_expenses', 'projects/:project_id/tasks/:task_id/expenses', array ( 'action' => array ( 'GET' => 'expenses', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subtasks':
        return Router::doAssemble('subtasks', 'projects/:project_id/tasks/:task_id/subtasks', array ( 'module' => 'tasks', 'controller' => 'subtasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subtask':
        return Router::doAssemble('subtask', 'projects/:project_id/tasks/:task_id/subtasks/:subtask_id', array ( 'module' => 'tasks', 'controller' => 'subtasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subtasks_reorder':
        return Router::doAssemble('subtasks_reorder', 'projects/:project_id/tasks/:task_id/subtasks/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'subtasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'subtask_promote_to_task':
        return Router::doAssemble('subtask_promote_to_task', 'projects/:project_id/tasks/:task_id/subtasks/:subtask_id/promote-to-task', array ( 'action' => array ( 'POST' => 'promote_to_task', ), 'controller' => 'subtasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_move_to_project':
        return Router::doAssemble('task_move_to_project', 'projects/:project_id/tasks/:task_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_duplicate':
        return Router::doAssemble('task_duplicate', 'projects/:project_id/tasks/:task_id/duplicate', array ( 'action' => array ( 'POST' => 'duplicate', ), 'controller' => 'tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_tasks':
        return Router::doAssemble('recurring_tasks', 'projects/:project_id/recurring-tasks', array ( 'module' => 'tasks', 'controller' => 'recurring_tasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_task':
        return Router::doAssemble('recurring_task', 'projects/:project_id/recurring-tasks/:recurring_task_id', array ( 'module' => 'tasks', 'controller' => 'recurring_tasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_task_create_task':
        return Router::doAssemble('recurring_task_create_task', 'projects/:project_id/recurring-tasks/:recurring_task_id/create-task', array ( 'action' => array ( 'POST' => 'create_task', ), 'controller' => 'recurring_tasks', 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'discussions':
        return Router::doAssemble('discussions', 'projects/:project_id/discussions', array ( 'module' => 'discussions', 'controller' => 'discussions', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'discussion':
        return Router::doAssemble('discussion', 'projects/:project_id/discussions/:discussion_id', array ( 'module' => 'discussions', 'controller' => 'discussions', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'discussions_read_status':
        return Router::doAssemble('discussions_read_status', 'projects/:project_id/discussions/read-status', array ( 'action' => array ( 'GET' => 'read_status', ), 'controller' => 'discussions', 'module' => 'discussions', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'discussion_move_to_project':
        return Router::doAssemble('discussion_move_to_project', 'projects/:project_id/discussions/:discussion_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'discussions', 'module' => 'discussions', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'discussion_promote_to_task':
        return Router::doAssemble('discussion_promote_to_task', 'projects/:project_id/discussions/:discussion_id/promote-to-task', array ( 'action' => array ( 'POST' => 'promote_to_task', ), 'controller' => 'discussions', 'module' => 'discussions', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'files':
        return Router::doAssemble('files', 'projects/:project_id/files', array ( 'module' => 'files', 'controller' => 'files', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'file':
        return Router::doAssemble('file', 'projects/:project_id/files/:file_id', array ( 'module' => 'files', 'controller' => 'files', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'files_batch':
        return Router::doAssemble('files_batch', 'projects/:project_id/files/batch', array ( 'action' => array ( 'GET' => 'batch_download', 'POST' => 'batch_add', ), 'controller' => 'files', 'module' => 'files', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'file_download':
        return Router::doAssemble('file_download', 'projects/:project_id/files/:file_id/download', array ( 'action' => array ( 'GET' => 'download', ), 'controller' => 'files', 'module' => 'files', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'file_move_to_project':
        return Router::doAssemble('file_move_to_project', 'projects/:project_id/files/:file_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'files', 'module' => 'files', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notes':
        return Router::doAssemble('notes', 'projects/:project_id/notes', array ( 'module' => 'notes', 'controller' => 'notes', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note':
        return Router::doAssemble('note', 'projects/:project_id/notes/:note_id', array ( 'module' => 'notes', 'controller' => 'notes', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'notes_reorder':
        return Router::doAssemble('notes_reorder', 'projects/:project_id/notes/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'notes', 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_move_to_group':
        return Router::doAssemble('note_move_to_group', 'projects/:project_id/notes/:note_id/move-to-group', array ( 'action' => array ( 'PUT' => 'move_to_group', ), 'controller' => 'notes', 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_move_to_project':
        return Router::doAssemble('note_move_to_project', 'projects/:project_id/notes/:note_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'notes', 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_versions':
        return Router::doAssemble('note_versions', 'projects/:project_id/notes/:note_id/versions', array ( 'action' => array ( 'GET' => 'versions', ), 'controller' => 'notes', 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_groups':
        return Router::doAssemble('note_groups', 'projects/:project_id/note-groups', array ( 'module' => 'notes', 'controller' => 'note_groups', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_group':
        return Router::doAssemble('note_group', 'projects/:project_id/note-groups/:note_group_id', array ( 'module' => 'notes', 'controller' => 'note_groups', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_group_notes':
        return Router::doAssemble('note_group_notes', 'projects/:project_id/note-groups/:note_group_id/notes', array ( 'controller' => 'note_groups', 'action' => array ( 'GET' => 'notes', ), 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_group_reorder_notes':
        return Router::doAssemble('note_group_reorder_notes', 'projects/:project_id/note-groups/:note_group_id/reorder-notes', array ( 'controller' => 'note_groups', 'action' => array ( 'PUT' => 'reorder_notes', ), 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'note_group_move_to_group':
        return Router::doAssemble('note_group_move_to_group', 'projects/:project_id/note-groups/:note_group_id/move-to-group', array ( 'controller' => 'note_groups', 'action' => array ( 'PUT' => 'move_to_group', ), 'module' => 'notes', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'time_records':
        return Router::doAssemble('time_records', 'projects/:project_id/time-records', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'time_record':
        return Router::doAssemble('time_record', 'projects/:project_id/time-records/:time_record_id', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'time_records_filtered_by_date':
        return Router::doAssemble('time_records_filtered_by_date', 'projects/:project_id/time-records/filtered-by-date', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'filtered_by_date', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'time_record_move':
        return Router::doAssemble('time_record_move', 'projects/:project_id/time-records/:time_record_id/move', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'PUT' => 'move', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expenses':
        return Router::doAssemble('expenses', 'projects/:project_id/expenses', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense':
        return Router::doAssemble('expense', 'projects/:project_id/expenses/:expense_id', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense_move':
        return Router::doAssemble('expense_move', 'projects/:project_id/expenses/:expense_id/move', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'PUT' => 'move', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_labels':
        return Router::doAssemble('project_labels', 'labels/project-labels', array ( 'controller' => 'labels', 'action' => array ( 'GET' => 'project_labels', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'task_labels':
        return Router::doAssemble('task_labels', 'labels/task-labels', array ( 'controller' => 'labels', 'action' => array ( 'GET' => 'task_labels', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_templates':
        return Router::doAssemble('project_templates', 'project-templates', array ( 'module' => 'system', 'controller' => 'project_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template':
        return Router::doAssemble('project_template', 'project-templates/:project_template_id', array ( 'module' => 'system', 'controller' => 'project_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_duplicate':
        return Router::doAssemble('project_template_duplicate', 'project-templates/:project_template_id/duplicate', array ( 'controller' => 'project_templates', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_reorder':
        return Router::doAssemble('project_template_reorder', 'project-templates/:project_template_id/reorder', array ( 'controller' => 'project_templates', 'action' => array ( 'PUT' => 'reorder', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_elements':
        return Router::doAssemble('project_template_elements', 'project-templates/:project_template_id/elements', array ( 'module' => 'system', 'controller' => 'project_template_elements', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_element':
        return Router::doAssemble('project_template_element', 'project-templates/:project_template_id/elements/:project_template_element_id', array ( 'module' => 'system', 'controller' => 'project_template_elements', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_elements_batch':
        return Router::doAssemble('project_template_elements_batch', 'project-templates/:project_template_id/elements/batch', array ( 'action' => array ( 'POST' => 'batch_add', ), 'controller' => 'project_template_elements', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_element_download':
        return Router::doAssemble('project_template_element_download', 'project-templates/:project_template_id/elements/download', array ( 'action' => array ( 'GET' => 'download', ), 'controller' => 'project_template_elements', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'project_template_elements_reorder':
        return Router::doAssemble('project_template_elements_reorder', 'project-templates/:project_template_id/elements/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'project_template_elements', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'projects_with_people_permissions':
        return Router::doAssemble('projects_with_people_permissions', 'projects/with-people-permissions', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'with_people_permissions', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_projects':
        return Router::doAssemble('user_projects', 'users/:user_id/projects', array ( 'controller' => 'users', 'action' => array ( 'GET' => 'projects', 'POST' => 'add_to_projects', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_project_ids':
        return Router::doAssemble('user_project_ids', 'users/:user_id/projects/ids', array ( 'controller' => 'users', 'action' => array ( 'GET' => 'project_ids', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'feedback':
        return Router::doAssemble('feedback', 'feedback', array ( 'controller' => 'feedback', 'action' => array ( 'POST' => 'send', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'feedback_check':
        return Router::doAssemble('feedback_check', 'feedback/check', array ( 'controller' => 'feedback', 'action' => array ( 'GET' => 'check', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'new_features':
        return Router::doAssemble('new_features', 'new-features', array ( 'controller' => 'new_features', 'action' => array ( 'GET' => 'list_new_features', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'maintenance_mode':
        return Router::doAssemble('maintenance_mode', 'maintenance-mode', array ( 'controller' => 'maintenance_mode', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'password_policy':
        return Router::doAssemble('password_policy', 'password-policy', array ( 'controller' => 'password_policy', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'announce':
        return Router::doAssemble('announce', 'announce', array ( 'action' => array ( 'POST' => 'announce', ), 'controller' => 'announcements', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'versions':
        return Router::doAssemble('versions', 'system/versions/old-versions', array ( 'controller' => 'versions', 'action' => array ( 'GET' => 'check_old_versions', 'DELETE' => 'delete_old_versions', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'basecamp_check_credentials':
        return Router::doAssemble('basecamp_check_credentials', 'integrations/basecamp-importer/check-credentials', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'check_credentials', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'basecamp_schedule_import':
        return Router::doAssemble('basecamp_schedule_import', 'integrations/basecamp-importer/schedule-import', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'schedule_import', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'basecamp_start_over':
        return Router::doAssemble('basecamp_start_over', 'integrations/basecamp-importer/start-over', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'start_over', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'basecamp_check_status':
        return Router::doAssemble('basecamp_check_status', 'integrations/basecamp-importer/check-status', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'GET' => 'check_status', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'basecamp_invite_users':
        return Router::doAssemble('basecamp_invite_users', 'integrations/basecamp-importer/invite-users', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'invite_users', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'client_plus':
        return Router::doAssemble('client_plus', 'integrations/client-plus', array ( 'controller' => 'client_plus_integration', 'action' => array ( 'POST' => 'activate', 'DELETE' => 'deactivate', ), 'integration_type' => 'client_plus', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_request_url':
        return Router::doAssemble('trello_request_url', 'integrations/trello-importer/request-url', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_authorize':
        return Router::doAssemble('trello_authorize', 'integrations/trello-importer/authorize', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'PUT' => 'authorize', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_schedule_import':
        return Router::doAssemble('trello_schedule_import', 'integrations/trello-importer/schedule-import', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'POST' => 'schedule_import', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_start_over':
        return Router::doAssemble('trello_start_over', 'integrations/trello-importer/start-over', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'POST' => 'start_over', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_check_status':
        return Router::doAssemble('trello_check_status', 'integrations/trello-importer/check-status', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'check_status', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'trello_invite_users':
        return Router::doAssemble('trello_invite_users', 'integrations/trello-importer/invite-users', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'invite_users', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'slack_connect':
        return Router::doAssemble('slack_connect', 'integrations/slack/connect', array ( 'controller' => 'slack_integration', 'action' => array ( 'PUT' => 'connect', ), 'integration_type' => 'slack', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'slack_notification_channel':
        return Router::doAssemble('slack_notification_channel', 'integrations/slack/notification-channels/:notification_channel_id', array ( 'controller' => 'slack_integration', 'action' => array ( 'PUT' => 'edit', 'DELETE' => 'delete', ), 'notification_channel_id' => '\\d+', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'webhooks_integration_ids':
        return Router::doAssemble('webhooks_integration_ids', 'integrations/webhooks/:webhook_id', array ( 'controller' => 'webhooks_integration', 'action' => array ( 'PUT' => 'edit', 'DELETE' => 'delete', ), 'integration_type' => 'webhooks', 'webhook_id' => '\\d+', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'webhooks_integration':
        return Router::doAssemble('webhooks_integration', 'integrations/webhooks', array ( 'controller' => 'webhooks_integration', 'action' => array ( 'POST' => 'add', ), 'integration_type' => 'webhooks', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar_feeds':
        return Router::doAssemble('calendar_feeds', 'calendar-feeds', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar_feeds_project':
        return Router::doAssemble('calendar_feeds_project', 'calendar-feeds/projects/:project_id', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'project', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'calendar_feeds_calendar':
        return Router::doAssemble('calendar_feeds_calendar', 'calendar-feeds/calendars/:calendar_id', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'calendar', ), 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'zapier_integration':
        return Router::doAssemble('zapier_integration', 'integrations/zapier', array ( 'controller' => 'zapier_integration', 'action' => array ( 'GET' => 'get_data', 'POST' => 'enable', 'DELETE' => 'disable', ), 'integration_type' => 'zapier', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'zapier_webhooks':
        return Router::doAssemble('zapier_webhooks', 'integrations/zapier/webhooks', array ( 'module' => 'system', 'controller' => 'zapier_webhooks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'zapier_webhook':
        return Router::doAssemble('zapier_webhook', 'integrations/zapier/webhooks/:zapier_webhook_id', array ( 'module' => 'system', 'controller' => 'zapier_webhooks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'one_login_credentials':
        return Router::doAssemble('one_login_credentials', 'integrations/one-login/credentials', array ( 'controller' => 'one_login_integration', 'action' => array ( 'POST' => 'credentials', ), 'integration_type' => 'one-login', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'one_login_enable':
        return Router::doAssemble('one_login_enable', 'integrations/one-login/enable', array ( 'controller' => 'one_login_integration', 'action' => array ( 'GET' => 'enable', ), 'integration_type' => 'one-login', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'one_login_disable':
        return Router::doAssemble('one_login_disable', 'integrations/one-login/disable', array ( 'controller' => 'one_login_integration', 'action' => array ( 'GET' => 'disable', ), 'integration_type' => 'one-login', 'module' => 'system', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_items':
        return Router::doAssemble('invoice_items', 'invoice-items', array ( 'module' => 'invoicing', 'controller' => 'invoice_items', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_item':
        return Router::doAssemble('invoice_item', 'invoice-items/:invoice_item_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_items', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoices':
        return Router::doAssemble('invoices', 'invoices', array ( 'module' => 'invoicing', 'controller' => 'invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice':
        return Router::doAssemble('invoice', 'invoices/:invoice_id', array ( 'module' => 'invoicing', 'controller' => 'invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoices_archive':
        return Router::doAssemble('invoices_archive', 'invoices/archive', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoices_private_notes':
        return Router::doAssemble('invoices_private_notes', 'invoices/private-notes', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'private_notes', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoices_preview_items':
        return Router::doAssemble('invoices_preview_items', 'invoices/preview-items', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'preview_items', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_send':
        return Router::doAssemble('invoice_send', 'invoices/:invoice_id/send', array ( 'controller' => 'invoices', 'action' => array ( 'PUT' => 'send', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_export':
        return Router::doAssemble('invoice_export', 'invoices/:invoice_id/export', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'export', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_duplicate':
        return Router::doAssemble('invoice_duplicate', 'invoices/:invoice_id/duplicate', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_cancel':
        return Router::doAssemble('invoice_cancel', 'invoices/:invoice_id/cancel', array ( 'controller' => 'invoices', 'action' => array ( 'PUT' => 'cancel', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_related_records':
        return Router::doAssemble('invoice_related_records', 'invoices/:invoice_id/related-records', array ( 'controller' => 'invoices', 'action' => array ( 'DELETE' => 'release_related_records', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_mark_as_sent':
        return Router::doAssemble('invoice_mark_as_sent', 'invoices/:invoice_id/mark-as-sent', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'mark_as_sent', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_mark_zero_invoice_as_paid':
        return Router::doAssemble('invoice_mark_zero_invoice_as_paid', 'invoices/:invoice_id/mark-zero-invoice-as-paid', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'mark_zero_invoice_as_paid', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_public':
        return Router::doAssemble('invoice_public', 's/invoice', array ( 'controller' => 'public_invoice', 'action' => array ( 'GET' => 'view', 'PUT' => 'make_payment', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimates':
        return Router::doAssemble('estimates', 'estimates', array ( 'module' => 'invoicing', 'controller' => 'estimates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimate':
        return Router::doAssemble('estimate', 'estimates/:estimate_id', array ( 'module' => 'invoicing', 'controller' => 'estimates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimates_archive':
        return Router::doAssemble('estimates_archive', 'estimates/archive', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimates_private_notes':
        return Router::doAssemble('estimates_private_notes', 'estimates/private-notes', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'private_notes', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimate_send':
        return Router::doAssemble('estimate_send', 'estimates/:estimate_id/send', array ( 'controller' => 'estimates', 'action' => array ( 'PUT' => 'send', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimate_export':
        return Router::doAssemble('estimate_export', 'estimates/:estimate_id/export', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'export', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'estimate_duplicate':
        return Router::doAssemble('estimate_duplicate', 'estimates/:estimate_id/duplicate', array ( 'controller' => 'estimates', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_profiles':
        return Router::doAssemble('recurring_profiles', 'recurring-profiles', array ( 'module' => 'invoicing', 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_profile':
        return Router::doAssemble('recurring_profile', 'recurring-profiles/:recurring_profile_id', array ( 'module' => 'invoicing', 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_profiles_archive':
        return Router::doAssemble('recurring_profiles_archive', 'recurring-profiles/archive', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_profiles_trigger':
        return Router::doAssemble('recurring_profiles_trigger', 'recurring-profiles/trigger', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'POST' => 'trigger', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'recurring_profile_next_trigger_on':
        return Router::doAssemble('recurring_profile_next_trigger_on', 'recurring-profiles/:recurring_profile_id/next-trigger-on', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'next_trigger_on', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_template':
        return Router::doAssemble('invoice_template', 'invoice-template', array ( 'controller' => 'invoice_template', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoices_suggest_number':
        return Router::doAssemble('invoices_suggest_number', 'invoices/suggest-number', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'suggest_number', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_note_templates':
        return Router::doAssemble('invoice_note_templates', 'invoice-note-templates', array ( 'module' => 'invoicing', 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_note_template':
        return Router::doAssemble('invoice_note_template', 'invoice-note-templates/:invoice_note_template_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_note_templates_default':
        return Router::doAssemble('invoice_note_templates_default', 'invoice-note-templates/default', array ( 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', 'DELETE' => 'unset_default', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_item_templates':
        return Router::doAssemble('invoice_item_templates', 'invoice-item-templates', array ( 'module' => 'invoicing', 'controller' => 'invoice_item_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'invoice_item_template':
        return Router::doAssemble('invoice_item_template', 'invoice-item-templates/:invoice_item_template_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_item_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tax_rates':
        return Router::doAssemble('tax_rates', 'tax-rates', array ( 'module' => 'invoicing', 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tax_rate':
        return Router::doAssemble('tax_rate', 'tax-rates/:tax_rate_id', array ( 'module' => 'invoicing', 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'tax_rates_default':
        return Router::doAssemble('tax_rates_default', 'tax-rates/default', array ( 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', 'DELETE' => 'unset_default', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'company_addresses_for_invoicing':
        return Router::doAssemble('company_addresses_for_invoicing', 'companies/addresses-for-invoicing', array ( 'controller' => 'company_addresses', 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_payments':
        return Router::doAssemble('quickbooks_payments', 'integrations/quickbooks/payments', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'sync_payments', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_request_url':
        return Router::doAssemble('quickbooks_request_url', 'integrations/quickbooks/request-url', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_authorize':
        return Router::doAssemble('quickbooks_authorize', 'integrations/quickbooks/authorize', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'PUT' => 'authorize', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_integration':
        return Router::doAssemble('quickbooks_integration', 'integrations/quickbooks/data', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'get_data', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_invoices':
        return Router::doAssemble('quickbooks_invoices', 'quickbooks/invoices', array ( 'module' => 'invoicing', 'controller' => 'quickbooks_invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_invoice':
        return Router::doAssemble('quickbooks_invoice', 'quickbooks/invoices/:quickbooks_invoice_id', array ( 'module' => 'invoicing', 'controller' => 'quickbooks_invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'quickbooks_invoices_sync':
        return Router::doAssemble('quickbooks_invoices_sync', 'quickbooks/invoices/sync', array ( 'controller' => 'quickbooks_invoices', 'action' => array ( 'PUT' => 'sync', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_payments':
        return Router::doAssemble('xero_payments', 'integrations/xero/payments', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'sync_payments', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_request_url':
        return Router::doAssemble('xero_request_url', 'integrations/xero/request-url', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_authorize':
        return Router::doAssemble('xero_authorize', 'integrations/xero/authorize', array ( 'controller' => 'xero_integration', 'action' => array ( 'PUT' => 'authorize', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_integration':
        return Router::doAssemble('xero_integration', 'integrations/xero/data', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'get_data', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_invoices':
        return Router::doAssemble('xero_invoices', 'xero/invoices', array ( 'module' => 'invoicing', 'controller' => 'xero_invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_invoice':
        return Router::doAssemble('xero_invoice', 'xero/invoices/:xero_invoice_id', array ( 'module' => 'invoicing', 'controller' => 'xero_invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'xero_invoices_sync':
        return Router::doAssemble('xero_invoices_sync', 'xero/invoices/sync', array ( 'controller' => 'xero_invoices', 'action' => array ( 'PUT' => 'sync', ), 'module' => 'invoicing', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'team_tasks':
        return Router::doAssemble('team_tasks', 'teams/:team_id/tasks', array ( 'controller' => 'team_tasks', 'action' => array ( 'GET' => 'index', ), 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_tasks':
        return Router::doAssemble('user_tasks', 'users/:user_id/tasks', array ( 'controller' => 'user_tasks', 'action' => array ( 'GET' => 'index', ), 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'unscheduled_task_counts':
        return Router::doAssemble('unscheduled_task_counts', 'reports/unscheduled-tasks/count-by-project', array ( 'controller' => 'unscheduled_tasks', 'action' => array ( 'GET' => 'count_by_project', ), 'module' => 'tasks', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_time_records':
        return Router::doAssemble('user_time_records', 'users/:user_id/time-records', array ( 'controller' => 'user_time_records', 'action' => array ( 'GET' => 'index', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'user_time_records_filtered_by_date':
        return Router::doAssemble('user_time_records_filtered_by_date', 'users/:user_id/time-records/filtered-by-date', array ( 'controller' => 'user_time_records', 'action' => array ( 'GET' => 'filtered_by_date', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'job_types':
        return Router::doAssemble('job_types', 'job-types', array ( 'module' => 'tracking', 'controller' => 'job_types', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'job_type':
        return Router::doAssemble('job_type', 'job-types/:job_type_id', array ( 'module' => 'tracking', 'controller' => 'job_types', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'job_types_default':
        return Router::doAssemble('job_types_default', 'job-types/default', array ( 'controller' => 'job_types', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'job_types_batch_edit':
        return Router::doAssemble('job_types_batch_edit', 'job-types/edit-batch', array ( 'controller' => 'job_types', 'action' => array ( 'PUT' => 'batch_edit', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense_categories':
        return Router::doAssemble('expense_categories', 'expense-categories', array ( 'module' => 'tracking', 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense_category':
        return Router::doAssemble('expense_category', 'expense-categories/:expense_category_id', array ( 'module' => 'tracking', 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense_categories_default':
        return Router::doAssemble('expense_categories_default', 'expense-categories/default', array ( 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      case 'expense_categories_batch_edit':
        return Router::doAssemble('expense_categories_batch_edit', 'expense-categories/edit-batch', array ( 'controller' => 'expense_categories', 'action' => array ( 'PUT' => 'batch_edit', ), 'module' => 'tracking', ), $data, $url_base, $query_arg_separator, $anchor);
      default:
        return '';
    }
  };
