<?php
  
  return function ($path, $query_string) {
    $matches = null;
    if (preg_match('/^expense-categories\\/edit-batch$/', $path, $matches)) {
      return Router::doMatch($path, 'expense_categories_batch_edit', 'expense-categories/edit-batch', array ( 'controller' => 'expense_categories', 'action' => array ( 'PUT' => 'batch_edit', ), 'module' => 'tracking', ), array(), $matches, $query_string);
    } elseif (preg_match('/^expense-categories\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'expense_categories_default', 'expense-categories/default', array ( 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'tracking', ), array(), $matches, $query_string);
    } elseif (preg_match('/^expense-categories\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'expense_category', 'expense-categories/:expense_category_id', array ( 'module' => 'tracking', 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'expense_category_id',
), $matches, $query_string);
    } elseif (preg_match('/^expense-categories$/', $path, $matches)) {
      return Router::doMatch($path, 'expense_categories', 'expense-categories', array ( 'module' => 'tracking', 'controller' => 'expense_categories', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^job-types\\/edit-batch$/', $path, $matches)) {
      return Router::doMatch($path, 'job_types_batch_edit', 'job-types/edit-batch', array ( 'controller' => 'job_types', 'action' => array ( 'PUT' => 'batch_edit', ), 'module' => 'tracking', ), array(), $matches, $query_string);
    } elseif (preg_match('/^job-types\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'job_types_default', 'job-types/default', array ( 'controller' => 'job_types', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'tracking', ), array(), $matches, $query_string);
    } elseif (preg_match('/^job-types\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'job_type', 'job-types/:job_type_id', array ( 'module' => 'tracking', 'controller' => 'job_types', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'job_type_id',
), $matches, $query_string);
    } elseif (preg_match('/^job-types$/', $path, $matches)) {
      return Router::doMatch($path, 'job_types', 'job-types', array ( 'module' => 'tracking', 'controller' => 'job_types', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/time-records\\/filtered-by-date$/', $path, $matches)) {
      return Router::doMatch($path, 'user_time_records_filtered_by_date', 'users/:user_id/time-records/filtered-by-date', array ( 'controller' => 'user_time_records', 'action' => array ( 'GET' => 'filtered_by_date', ), 'module' => 'tracking', ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/time-records$/', $path, $matches)) {
      return Router::doMatch($path, 'user_time_records', 'users/:user_id/time-records', array ( 'controller' => 'user_time_records', 'action' => array ( 'GET' => 'index', ), 'module' => 'tracking', ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^reports\\/unscheduled-tasks\\/count-by-project$/', $path, $matches)) {
      return Router::doMatch($path, 'unscheduled_task_counts', 'reports/unscheduled-tasks/count-by-project', array ( 'controller' => 'unscheduled_tasks', 'action' => array ( 'GET' => 'count_by_project', ), 'module' => 'tasks', ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/tasks$/', $path, $matches)) {
      return Router::doMatch($path, 'user_tasks', 'users/:user_id/tasks', array ( 'controller' => 'user_tasks', 'action' => array ( 'GET' => 'index', ), 'module' => 'tasks', ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^teams\\/(\\d+)\\/tasks$/', $path, $matches)) {
      return Router::doMatch($path, 'team_tasks', 'teams/:team_id/tasks', array ( 'controller' => 'team_tasks', 'action' => array ( 'GET' => 'index', ), 'module' => 'tasks', ), array (
  0 => 'team_id',
), $matches, $query_string);
    } elseif (preg_match('/^xero\\/invoices\\/sync$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_invoices_sync', '/xero/invoices/sync', array ( 'controller' => 'xero_invoices', 'action' => array ( 'PUT' => 'sync', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^xero\\/invoices\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_invoice', '/xero/invoices/:xero_invoice_id', array ( 'module' => 'invoicing', 'controller' => 'xero_invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'xero_invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^xero\\/invoices$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_invoices', '/xero/invoices', array ( 'module' => 'invoicing', 'controller' => 'xero_invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/xero\\/data$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_integration', '/integrations/xero/data', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'get_data', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/xero\\/authorize$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_authorize', '/integrations/xero/authorize', array ( 'controller' => 'xero_integration', 'action' => array ( 'PUT' => 'authorize', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/xero\\/request-url$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_request_url', '/integrations/xero/request-url', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/xero\\/payments$/', $path, $matches)) {
      return Router::doMatch($path, 'xero_payments', '/integrations/xero/payments', array ( 'controller' => 'xero_integration', 'action' => array ( 'GET' => 'sync_payments', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^quickbooks\\/invoices\\/sync$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_invoices_sync', '/quickbooks/invoices/sync', array ( 'controller' => 'quickbooks_invoices', 'action' => array ( 'PUT' => 'sync', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^quickbooks\\/invoices\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_invoice', '/quickbooks/invoices/:quickbooks_invoice_id', array ( 'module' => 'invoicing', 'controller' => 'quickbooks_invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'quickbooks_invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^quickbooks\\/invoices$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_invoices', '/quickbooks/invoices', array ( 'module' => 'invoicing', 'controller' => 'quickbooks_invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/quickbooks\\/data$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_integration', '/integrations/quickbooks/data', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'get_data', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/quickbooks\\/authorize$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_authorize', '/integrations/quickbooks/authorize', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'PUT' => 'authorize', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/quickbooks\\/request-url$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_request_url', '/integrations/quickbooks/request-url', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/quickbooks\\/payments$/', $path, $matches)) {
      return Router::doMatch($path, 'quickbooks_payments', '/integrations/quickbooks/payments', array ( 'controller' => 'quickbooks_integration', 'action' => array ( 'GET' => 'sync_payments', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^companies\\/addresses-for-invoicing$/', $path, $matches)) {
      return Router::doMatch($path, 'company_addresses_for_invoicing', 'companies/addresses-for-invoicing', array ( 'controller' => 'company_addresses', 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^tax-rates\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'tax_rates_default', 'tax-rates/default', array ( 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', 'DELETE' => 'unset_default', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^tax-rates\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'tax_rate', 'tax-rates/:tax_rate_id', array ( 'module' => 'invoicing', 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'tax_rate_id',
), $matches, $query_string);
    } elseif (preg_match('/^tax-rates$/', $path, $matches)) {
      return Router::doMatch($path, 'tax_rates', 'tax-rates', array ( 'module' => 'invoicing', 'controller' => 'tax_rates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoice-item-templates\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_item_template', 'invoice-item-templates/:invoice_item_template_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_item_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'invoice_item_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoice-item-templates$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_item_templates', 'invoice-item-templates', array ( 'module' => 'invoicing', 'controller' => 'invoice_item_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoice-note-templates\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_note_templates_default', 'invoice-note-templates/default', array ( 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', 'DELETE' => 'unset_default', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoice-note-templates\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_note_template', 'invoice-note-templates/:invoice_note_template_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'invoice_note_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoice-note-templates$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_note_templates', 'invoice-note-templates', array ( 'module' => 'invoicing', 'controller' => 'invoice_note_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/suggest-number$/', $path, $matches)) {
      return Router::doMatch($path, 'invoices_suggest_number', 'invoices/suggest-number', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'suggest_number', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoice-template$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_template', 'invoice-template', array ( 'controller' => 'invoice_template', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^recurring-profiles\\/(\\d+)\\/next-trigger-on$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_profile_next_trigger_on', 'recurring-profiles/:recurring_profile_id/next-trigger-on', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'next_trigger_on', ), 'module' => 'invoicing', ), array (
  0 => 'recurring_profile_id',
), $matches, $query_string);
    } elseif (preg_match('/^recurring-profiles\\/trigger$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_profiles_trigger', 'recurring-profiles/trigger', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'POST' => 'trigger', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^recurring-profiles\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_profiles_archive', 'recurring-profiles/archive', array ( 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^recurring-profiles\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_profile', 'recurring-profiles/:recurring_profile_id', array ( 'module' => 'invoicing', 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'recurring_profile_id',
), $matches, $query_string);
    } elseif (preg_match('/^recurring-profiles$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_profiles', 'recurring-profiles', array ( 'module' => 'invoicing', 'controller' => 'recurring_profiles', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/(\\d+)\\/duplicate$/', $path, $matches)) {
      return Router::doMatch($path, 'estimate_duplicate', 'estimates/:estimate_id/duplicate', array ( 'controller' => 'estimates', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'invoicing', ), array (
  0 => 'estimate_id',
), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/(\\d+)\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'estimate_export', 'estimates/:estimate_id/export', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'export', ), 'module' => 'invoicing', ), array (
  0 => 'estimate_id',
), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/(\\d+)\\/send$/', $path, $matches)) {
      return Router::doMatch($path, 'estimate_send', 'estimates/:estimate_id/send', array ( 'controller' => 'estimates', 'action' => array ( 'PUT' => 'send', ), 'module' => 'invoicing', ), array (
  0 => 'estimate_id',
), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/private-notes$/', $path, $matches)) {
      return Router::doMatch($path, 'estimates_private_notes', 'estimates/private-notes', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'private_notes', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'estimates_archive', 'estimates/archive', array ( 'controller' => 'estimates', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^estimates\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'estimate', 'estimates/:estimate_id', array ( 'module' => 'invoicing', 'controller' => 'estimates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'estimate_id',
), $matches, $query_string);
    } elseif (preg_match('/^estimates$/', $path, $matches)) {
      return Router::doMatch($path, 'estimates', 'estimates', array ( 'module' => 'invoicing', 'controller' => 'estimates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^s\\/invoice$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_public', 's/invoice', array ( 'controller' => 'public_invoice', 'action' => array ( 'GET' => 'view', 'PUT' => 'make_payment', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/mark-zero-invoice-as-paid$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_mark_zero_invoice_as_paid', 'invoices/:invoice_id/mark-zero-invoice-as-paid', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'mark_zero_invoice_as_paid', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/mark-as-sent$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_mark_as_sent', 'invoices/:invoice_id/mark-as-sent', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'mark_as_sent', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/related-records$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_related_records', 'invoices/:invoice_id/related-records', array ( 'controller' => 'invoices', 'action' => array ( 'DELETE' => 'release_related_records', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/cancel$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_cancel', 'invoices/:invoice_id/cancel', array ( 'controller' => 'invoices', 'action' => array ( 'PUT' => 'cancel', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/duplicate$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_duplicate', 'invoices/:invoice_id/duplicate', array ( 'controller' => 'invoices', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_export', 'invoices/:invoice_id/export', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'export', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)\\/send$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_send', 'invoices/:invoice_id/send', array ( 'controller' => 'invoices', 'action' => array ( 'PUT' => 'send', ), 'module' => 'invoicing', ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/preview-items$/', $path, $matches)) {
      return Router::doMatch($path, 'invoices_preview_items', 'invoices/preview-items', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'preview_items', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/private-notes$/', $path, $matches)) {
      return Router::doMatch($path, 'invoices_private_notes', 'invoices/private-notes', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'private_notes', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'invoices_archive', 'invoices/archive', array ( 'controller' => 'invoices', 'action' => array ( 'GET' => 'archive', ), 'module' => 'invoicing', ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoices\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice', 'invoices/:invoice_id', array ( 'module' => 'invoicing', 'controller' => 'invoices', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'invoice_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoices$/', $path, $matches)) {
      return Router::doMatch($path, 'invoices', 'invoices', array ( 'module' => 'invoicing', 'controller' => 'invoices', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^invoice-items\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_item', 'invoice-items/:invoice_item_id', array ( 'module' => 'invoicing', 'controller' => 'invoice_items', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'invoice_item_id',
), $matches, $query_string);
    } elseif (preg_match('/^invoice-items$/', $path, $matches)) {
      return Router::doMatch($path, 'invoice_items', 'invoice-items', array ( 'module' => 'invoicing', 'controller' => 'invoice_items', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/one-login\\/disable$/', $path, $matches)) {
      return Router::doMatch($path, 'one_login_disable', 'integrations/one-login/disable', array ( 'controller' => 'one_login_integration', 'action' => array ( 'GET' => 'disable', ), 'integration_type' => 'one-login', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/one-login\\/enable$/', $path, $matches)) {
      return Router::doMatch($path, 'one_login_enable', 'integrations/one-login/enable', array ( 'controller' => 'one_login_integration', 'action' => array ( 'GET' => 'enable', ), 'integration_type' => 'one-login', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/one-login\\/credentials$/', $path, $matches)) {
      return Router::doMatch($path, 'one_login_credentials', 'integrations/one-login/credentials', array ( 'controller' => 'one_login_integration', 'action' => array ( 'POST' => 'credentials', ), 'integration_type' => 'one-login', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/zapier\\/webhooks\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'zapier_webhook', '/integrations/zapier/webhooks/:zapier_webhook_id', array ( 'module' => 'system', 'controller' => 'zapier_webhooks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'zapier_webhook_id',
), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/zapier\\/webhooks$/', $path, $matches)) {
      return Router::doMatch($path, 'zapier_webhooks', '/integrations/zapier/webhooks', array ( 'module' => 'system', 'controller' => 'zapier_webhooks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/zapier$/', $path, $matches)) {
      return Router::doMatch($path, 'zapier_integration', 'integrations/zapier', array ( 'controller' => 'zapier_integration', 'action' => array ( 'GET' => 'get_data', 'POST' => 'enable', 'DELETE' => 'disable', ), 'integration_type' => 'zapier', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^calendar-feeds\\/calendars\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar_feeds_calendar', 'calendar-feeds/calendars/:calendar_id', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'calendar', ), 'module' => 'system', ), array (
  0 => 'calendar_id',
), $matches, $query_string);
    } elseif (preg_match('/^calendar-feeds\\/projects\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar_feeds_project', 'calendar-feeds/projects/:project_id', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'project', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^calendar-feeds$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar_feeds', 'calendar-feeds', array ( 'controller' => 'calendar_feeds', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/webhooks$/', $path, $matches)) {
      return Router::doMatch($path, 'webhooks_integration', 'integrations/webhooks', array ( 'controller' => 'webhooks_integration', 'action' => array ( 'POST' => 'add', ), 'integration_type' => 'webhooks', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/webhooks\\/([a-z0-9\\-\\._]+)$/', $path, $matches)) {
      return Router::doMatch($path, 'webhooks_integration_ids', 'integrations/webhooks/:webhook_id', array ( 'controller' => 'webhooks_integration', 'action' => array ( 'PUT' => 'edit', 'DELETE' => 'delete', ), 'integration_type' => 'webhooks', 'webhook_id' => '\\d+', 'module' => 'system', ), array (
  0 => 'webhook_id',
), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/slack\\/notification-channels\\/([a-z0-9\\-\\._]+)$/', $path, $matches)) {
      return Router::doMatch($path, 'slack_notification_channel', 'integrations/slack/notification-channels/:notification_channel_id', array ( 'controller' => 'slack_integration', 'action' => array ( 'PUT' => 'edit', 'DELETE' => 'delete', ), 'notification_channel_id' => '\\d+', 'module' => 'system', ), array (
  0 => 'notification_channel_id',
), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/slack\\/connect$/', $path, $matches)) {
      return Router::doMatch($path, 'slack_connect', 'integrations/slack/connect', array ( 'controller' => 'slack_integration', 'action' => array ( 'PUT' => 'connect', ), 'integration_type' => 'slack', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/invite-users$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_invite_users', 'integrations/trello-importer/invite-users', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'invite_users', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/check-status$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_check_status', 'integrations/trello-importer/check-status', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'check_status', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/start-over$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_start_over', 'integrations/trello-importer/start-over', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'POST' => 'start_over', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/schedule-import$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_schedule_import', 'integrations/trello-importer/schedule-import', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'POST' => 'schedule_import', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/authorize$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_authorize', 'integrations/trello-importer/authorize', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'PUT' => 'authorize', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/trello-importer\\/request-url$/', $path, $matches)) {
      return Router::doMatch($path, 'trello_request_url', 'integrations/trello-importer/request-url', array ( 'controller' => 'trello_importer_integration', 'action' => array ( 'GET' => 'get_request_url', ), 'integration_type' => 'trello-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/client-plus$/', $path, $matches)) {
      return Router::doMatch($path, 'client_plus', 'integrations/client-plus', array ( 'controller' => 'client_plus_integration', 'action' => array ( 'POST' => 'activate', 'DELETE' => 'deactivate', ), 'integration_type' => 'client_plus', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/basecamp-importer\\/invite-users$/', $path, $matches)) {
      return Router::doMatch($path, 'basecamp_invite_users', 'integrations/basecamp-importer/invite-users', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'invite_users', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/basecamp-importer\\/check-status$/', $path, $matches)) {
      return Router::doMatch($path, 'basecamp_check_status', 'integrations/basecamp-importer/check-status', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'GET' => 'check_status', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/basecamp-importer\\/start-over$/', $path, $matches)) {
      return Router::doMatch($path, 'basecamp_start_over', 'integrations/basecamp-importer/start-over', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'start_over', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/basecamp-importer\\/schedule-import$/', $path, $matches)) {
      return Router::doMatch($path, 'basecamp_schedule_import', 'integrations/basecamp-importer/schedule-import', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'schedule_import', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/basecamp-importer\\/check-credentials$/', $path, $matches)) {
      return Router::doMatch($path, 'basecamp_check_credentials', 'integrations/basecamp-importer/check-credentials', array ( 'controller' => 'basecamp_importer_integration', 'action' => array ( 'POST' => 'check_credentials', ), 'integration_type' => 'basecamp-importer', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system\\/versions\\/old-versions$/', $path, $matches)) {
      return Router::doMatch($path, 'versions', 'system/versions/old-versions', array ( 'controller' => 'versions', 'action' => array ( 'GET' => 'check_old_versions', 'DELETE' => 'delete_old_versions', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^announce$/', $path, $matches)) {
      return Router::doMatch($path, 'announce', 'announce', array ( 'action' => array ( 'POST' => 'announce', ), 'controller' => 'announcements', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^password-policy$/', $path, $matches)) {
      return Router::doMatch($path, 'password_policy', 'password-policy', array ( 'controller' => 'password_policy', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^maintenance-mode$/', $path, $matches)) {
      return Router::doMatch($path, 'maintenance_mode', 'maintenance-mode', array ( 'controller' => 'maintenance_mode', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^new-features$/', $path, $matches)) {
      return Router::doMatch($path, 'new_features', 'new-features', array ( 'controller' => 'new_features', 'action' => array ( 'GET' => 'list_new_features', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^feedback\\/check$/', $path, $matches)) {
      return Router::doMatch($path, 'feedback_check', 'feedback/check', array ( 'controller' => 'feedback', 'action' => array ( 'GET' => 'check', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^feedback$/', $path, $matches)) {
      return Router::doMatch($path, 'feedback', 'feedback', array ( 'controller' => 'feedback', 'action' => array ( 'POST' => 'send', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/projects\\/ids$/', $path, $matches)) {
      return Router::doMatch($path, 'user_project_ids', 'users/:user_id/projects/ids', array ( 'controller' => 'users', 'action' => array ( 'GET' => 'project_ids', ), 'module' => 'system', ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/projects$/', $path, $matches)) {
      return Router::doMatch($path, 'user_projects', 'users/:user_id/projects', array ( 'controller' => 'users', 'action' => array ( 'GET' => 'projects', 'POST' => 'add_to_projects', ), 'module' => 'system', ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/with-people-permissions$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_with_people_permissions', '/projects/with-people-permissions', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'with_people_permissions', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/elements\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_elements_reorder', 'project-templates/:project_template_id/elements/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'project_template_elements', 'module' => 'system', ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/elements\\/download$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_element_download', 'project-templates/:project_template_id/elements/download', array ( 'action' => array ( 'GET' => 'download', ), 'controller' => 'project_template_elements', 'module' => 'system', ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/elements\\/batch$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_elements_batch', 'project-templates/:project_template_id/elements/batch', array ( 'action' => array ( 'POST' => 'batch_add', ), 'controller' => 'project_template_elements', 'module' => 'system', ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/elements\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_element', 'project-templates/:project_template_id/elements/:project_template_element_id', array ( 'module' => 'system', 'controller' => 'project_template_elements', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_template_id',
  1 => 'project_template_element_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/elements$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_elements', 'project-templates/:project_template_id/elements', array ( 'module' => 'system', 'controller' => 'project_template_elements', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_reorder', 'project-templates/:project_template_id/reorder', array ( 'controller' => 'project_templates', 'action' => array ( 'PUT' => 'reorder', ), 'module' => 'system', ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/([a-z0-9\\-\\._]+)\\/duplicate$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template_duplicate', 'project-templates/:project_template_id/duplicate', array ( 'controller' => 'project_templates', 'action' => array ( 'POST' => 'duplicate', ), 'module' => 'system', ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'project_template', 'project-templates/:project_template_id', array ( 'module' => 'system', 'controller' => 'project_templates', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_template_id',
), $matches, $query_string);
    } elseif (preg_match('/^project-templates$/', $path, $matches)) {
      return Router::doMatch($path, 'project_templates', 'project-templates', array ( 'module' => 'system', 'controller' => 'project_templates', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^labels\\/task-labels$/', $path, $matches)) {
      return Router::doMatch($path, 'task_labels', 'labels/task-labels', array ( 'controller' => 'labels', 'action' => array ( 'GET' => 'task_labels', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^labels\\/project-labels$/', $path, $matches)) {
      return Router::doMatch($path, 'project_labels', 'labels/project-labels', array ( 'controller' => 'labels', 'action' => array ( 'GET' => 'project_labels', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/expenses\\/(\\d+)\\/move$/', $path, $matches)) {
      return Router::doMatch($path, 'expense_move', 'projects/:project_id/expenses/:expense_id/move', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'PUT' => 'move', ), ), array (
  0 => 'project_id',
  1 => 'expense_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/expenses\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'expense', 'projects/:project_id/expenses/:expense_id', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'expense_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/expenses$/', $path, $matches)) {
      return Router::doMatch($path, 'expenses', 'projects/:project_id/expenses', array ( 'module' => 'tracking', 'controller' => 'expenses', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/time-records\\/(\\d+)\\/move$/', $path, $matches)) {
      return Router::doMatch($path, 'time_record_move', 'projects/:project_id/time-records/:time_record_id/move', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'PUT' => 'move', ), ), array (
  0 => 'project_id',
  1 => 'time_record_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/time-records\\/filtered-by-date$/', $path, $matches)) {
      return Router::doMatch($path, 'time_records_filtered_by_date', 'projects/:project_id/time-records/filtered-by-date', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'filtered_by_date', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/time-records\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'time_record', 'projects/:project_id/time-records/:time_record_id', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'time_record_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/time-records$/', $path, $matches)) {
      return Router::doMatch($path, 'time_records', 'projects/:project_id/time-records', array ( 'module' => 'tracking', 'controller' => 'time_records', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/note-groups\\/(\\d+)\\/move-to-group$/', $path, $matches)) {
      return Router::doMatch($path, 'note_group_move_to_group', 'projects/:project_id/note-groups/:note_group_id/move-to-group', array ( 'controller' => 'note_groups', 'action' => array ( 'PUT' => 'move_to_group', ), 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_group_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/note-groups\\/(\\d+)\\/reorder-notes$/', $path, $matches)) {
      return Router::doMatch($path, 'note_group_reorder_notes', 'projects/:project_id/note-groups/:note_group_id/reorder-notes', array ( 'controller' => 'note_groups', 'action' => array ( 'PUT' => 'reorder_notes', ), 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_group_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/note-groups\\/(\\d+)\\/notes$/', $path, $matches)) {
      return Router::doMatch($path, 'note_group_notes', 'projects/:project_id/note-groups/:note_group_id/notes', array ( 'controller' => 'note_groups', 'action' => array ( 'GET' => 'notes', ), 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_group_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/note-groups\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'note_group', 'projects/:project_id/note-groups/:note_group_id', array ( 'module' => 'notes', 'controller' => 'note_groups', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'note_group_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/note-groups$/', $path, $matches)) {
      return Router::doMatch($path, 'note_groups', 'projects/:project_id/note-groups', array ( 'module' => 'notes', 'controller' => 'note_groups', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes\\/(\\d+)\\/versions$/', $path, $matches)) {
      return Router::doMatch($path, 'note_versions', 'projects/:project_id/notes/:note_id/versions', array ( 'action' => array ( 'GET' => 'versions', ), 'controller' => 'notes', 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes\\/(\\d+)\\/move-to-project$/', $path, $matches)) {
      return Router::doMatch($path, 'note_move_to_project', 'projects/:project_id/notes/:note_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'notes', 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes\\/(\\d+)\\/move-to-group$/', $path, $matches)) {
      return Router::doMatch($path, 'note_move_to_group', 'projects/:project_id/notes/:note_id/move-to-group', array ( 'action' => array ( 'PUT' => 'move_to_group', ), 'controller' => 'notes', 'module' => 'notes', ), array (
  0 => 'project_id',
  1 => 'note_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'notes_reorder', 'projects/:project_id/notes/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'notes', 'module' => 'notes', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'note', 'projects/:project_id/notes/:note_id', array ( 'module' => 'notes', 'controller' => 'notes', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'note_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/notes$/', $path, $matches)) {
      return Router::doMatch($path, 'notes', 'projects/:project_id/notes', array ( 'module' => 'notes', 'controller' => 'notes', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/files\\/(\\d+)\\/move-to-project$/', $path, $matches)) {
      return Router::doMatch($path, 'file_move_to_project', 'projects/:project_id/files/:file_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'files', 'module' => 'files', ), array (
  0 => 'project_id',
  1 => 'file_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/files\\/(\\d+)\\/download$/', $path, $matches)) {
      return Router::doMatch($path, 'file_download', 'projects/:project_id/files/:file_id/download', array ( 'action' => array ( 'GET' => 'download', ), 'controller' => 'files', 'module' => 'files', ), array (
  0 => 'project_id',
  1 => 'file_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/files\\/batch$/', $path, $matches)) {
      return Router::doMatch($path, 'files_batch', 'projects/:project_id/files/batch', array ( 'action' => array ( 'GET' => 'batch_download', 'POST' => 'batch_add', ), 'controller' => 'files', 'module' => 'files', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/files\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'file', 'projects/:project_id/files/:file_id', array ( 'module' => 'files', 'controller' => 'files', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'file_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/files$/', $path, $matches)) {
      return Router::doMatch($path, 'files', 'projects/:project_id/files', array ( 'module' => 'files', 'controller' => 'files', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/discussions\\/(\\d+)\\/promote-to-task$/', $path, $matches)) {
      return Router::doMatch($path, 'discussion_promote_to_task', 'projects/:project_id/discussions/:discussion_id/promote-to-task', array ( 'action' => array ( 'POST' => 'promote_to_task', ), 'controller' => 'discussions', 'module' => 'discussions', ), array (
  0 => 'project_id',
  1 => 'discussion_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/discussions\\/(\\d+)\\/move-to-project$/', $path, $matches)) {
      return Router::doMatch($path, 'discussion_move_to_project', 'projects/:project_id/discussions/:discussion_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'discussions', 'module' => 'discussions', ), array (
  0 => 'project_id',
  1 => 'discussion_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/discussions\\/read-status$/', $path, $matches)) {
      return Router::doMatch($path, 'discussions_read_status', 'projects/:project_id/discussions/read-status', array ( 'action' => array ( 'GET' => 'read_status', ), 'controller' => 'discussions', 'module' => 'discussions', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/discussions\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'discussion', 'projects/:project_id/discussions/:discussion_id', array ( 'module' => 'discussions', 'controller' => 'discussions', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'discussion_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/discussions$/', $path, $matches)) {
      return Router::doMatch($path, 'discussions', 'projects/:project_id/discussions', array ( 'module' => 'discussions', 'controller' => 'discussions', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/recurring-tasks\\/(\\d+)\\/create-task$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_task_create_task', 'projects/:project_id/recurring-tasks/:recurring_task_id/create-task', array ( 'action' => array ( 'POST' => 'create_task', ), 'controller' => 'recurring_tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'recurring_task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/recurring-tasks\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_task', 'projects/:project_id/recurring-tasks/:recurring_task_id', array ( 'module' => 'tasks', 'controller' => 'recurring_tasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'recurring_task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/recurring-tasks$/', $path, $matches)) {
      return Router::doMatch($path, 'recurring_tasks', 'projects/:project_id/recurring-tasks', array ( 'module' => 'tasks', 'controller' => 'recurring_tasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/(\\d+)\\/duplicate$/', $path, $matches)) {
      return Router::doMatch($path, 'task_duplicate', 'projects/:project_id/tasks/:task_id/duplicate', array ( 'action' => array ( 'POST' => 'duplicate', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/(\\d+)\\/move-to-project$/', $path, $matches)) {
      return Router::doMatch($path, 'task_move_to_project', 'projects/:project_id/tasks/:task_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/([a-z0-9\\-\\._]+)\\/subtasks\\/(\\d+)\\/promote-to-task$/', $path, $matches)) {
      return Router::doMatch($path, 'subtask_promote_to_task', 'projects/:project_id/tasks/:task_id/subtasks/:subtask_id/promote-to-task', array ( 'action' => array ( 'POST' => 'promote_to_task', ), 'controller' => 'subtasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
  2 => 'subtask_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/([a-z0-9\\-\\._]+)\\/subtasks\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'subtasks_reorder', 'projects/:project_id/tasks/:task_id/subtasks/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'subtasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/([a-z0-9\\-\\._]+)\\/subtasks\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'subtask', 'projects/:project_id/tasks/:task_id/subtasks/:subtask_id', array ( 'module' => 'tasks', 'controller' => 'subtasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'task_id',
  2 => 'subtask_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/([a-z0-9\\-\\._]+)\\/subtasks$/', $path, $matches)) {
      return Router::doMatch($path, 'subtasks', 'projects/:project_id/tasks/:task_id/subtasks', array ( 'module' => 'tasks', 'controller' => 'subtasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/(\\d+)\\/expenses$/', $path, $matches)) {
      return Router::doMatch($path, 'task_expenses', 'projects/:project_id/tasks/:task_id/expenses', array ( 'action' => array ( 'GET' => 'expenses', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/(\\d+)\\/time-records$/', $path, $matches)) {
      return Router::doMatch($path, 'task_time_records', 'projects/:project_id/tasks/:task_id/time-records', array ( 'action' => array ( 'GET' => 'time_records', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'tasks_reorder', 'projects/:project_id/tasks/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'tasks_archive', 'projects/:project_id/tasks/archive', array ( 'action' => array ( 'GET' => 'archive', ), 'controller' => 'tasks', 'module' => 'tasks', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'task', 'projects/:project_id/tasks/:task_id', array ( 'module' => 'tasks', 'controller' => 'tasks', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'task_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/tasks$/', $path, $matches)) {
      return Router::doMatch($path, 'tasks', 'projects/:project_id/tasks', array ( 'module' => 'tasks', 'controller' => 'tasks', 'action' => array ( 'GET' => 'index', 'POST' => 'add', 'PUT' => 'batch_update', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists\\/(\\d+)\\/completed-tasks$/', $path, $matches)) {
      return Router::doMatch($path, 'task_list_completed_tasks', 'projects/:project_id/task-lists/:task_list_id/completed-tasks', array ( 'action' => array ( 'GET' => 'completed_tasks', ), 'controller' => 'task_lists', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_list_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists\\/(\\d+)\\/move-to-project$/', $path, $matches)) {
      return Router::doMatch($path, 'task_list_move_to_project', 'projects/:project_id/task-lists/:task_list_id/move-to-project', array ( 'action' => array ( 'PUT' => 'move_to_project', ), 'controller' => 'task_lists', 'module' => 'tasks', ), array (
  0 => 'project_id',
  1 => 'task_list_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'task_lists_reorder', 'projects/:project_id/task-lists/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'task_lists', 'module' => 'tasks', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'task_lists_archive', 'projects/:project_id/task-lists/archive', array ( 'action' => array ( 'GET' => 'archive', ), 'controller' => 'task_lists', 'module' => 'tasks', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'task_list', 'projects/:project_id/task-lists/:task_list_id', array ( 'module' => 'tasks', 'controller' => 'task_lists', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
  1 => 'task_list_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/task-lists$/', $path, $matches)) {
      return Router::doMatch($path, 'task_lists', 'projects/:project_id/task-lists', array ( 'module' => 'tasks', 'controller' => 'task_lists', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/responsibilities$/', $path, $matches)) {
      return Router::doMatch($path, 'project_responsibilities', 'projects/:project_id/responsibilities', array ( 'controller' => 'project_members', 'action' => array ( 'GET' => 'responsibilities', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/revoke-client-access$/', $path, $matches)) {
      return Router::doMatch($path, 'project_revoke_client_access', 'projects/:project_id/revoke-client-access', array ( 'controller' => 'project_members', 'action' => array ( 'PUT' => 'revoke_client_access', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/(\\d+)\\/members\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'project_member', 'projects/:project_id/members/:user_id', array ( 'controller' => 'project_members', 'action' => array ( 'PUT' => 'replace', 'DELETE' => 'delete', ), 'module' => 'system', ), array (
  0 => 'project_id',
  1 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/([a-z0-9\\-\\._]+)\\/members$/', $path, $matches)) {
      return Router::doMatch($path, 'project_members', 'projects/:project_id/members', array ( 'controller' => 'project_members', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/(\\d+)\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'project_export', 'projects/:project_id/export', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/(\\d+)\\/budget$/', $path, $matches)) {
      return Router::doMatch($path, 'project_budget', 'projects/:project_id/budget', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'budget', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/(\\d+)\\/whats-new$/', $path, $matches)) {
      return Router::doMatch($path, 'project_whats_new', 'projects/:project_id/whats-new', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'whats_new', ), 'module' => 'system', ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects\\/categories$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_categories', 'projects/categories', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'categories', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/calendar-events$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_calendar_events', 'projects/calendar-events', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'calendar_events', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/labels$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_labels', 'projects/labels', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'labels', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/with-tracking-enabled$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_with_tracking_enabled', 'projects/with-tracking-enabled', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'with_tracking_enabled', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/names$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_names', 'projects/names', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'names', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_archive', 'projects/archive', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'archive', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/filter$/', $path, $matches)) {
      return Router::doMatch($path, 'projects_filter', 'projects/filter', array ( 'controller' => 'projects', 'action' => array ( 'GET' => 'filter', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^projects\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'project', 'projects/:project_id', array ( 'module' => 'system', 'controller' => 'projects', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'project_id',
), $matches, $query_string);
    } elseif (preg_match('/^projects$/', $path, $matches)) {
      return Router::doMatch($path, 'projects', 'projects', array ( 'module' => 'system', 'controller' => 'projects', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^teams\\/(\\d+)\\/members\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'team_member', 'teams/:team_id/members/:user_id', array ( 'controller' => 'team_members', 'action' => array ( 'DELETE' => 'delete', ), 'module' => 'system', ), array (
  0 => 'team_id',
  1 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^teams\\/([a-z0-9\\-\\._]+)\\/members$/', $path, $matches)) {
      return Router::doMatch($path, 'team_members', 'teams/:team_id/members', array ( 'controller' => 'team_members', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), 'module' => 'system', ), array (
  0 => 'team_id',
), $matches, $query_string);
    } elseif (preg_match('/^teams\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'team', 'teams/:team_id', array ( 'module' => 'system', 'controller' => 'teams', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'team_id',
), $matches, $query_string);
    } elseif (preg_match('/^teams$/', $path, $matches)) {
      return Router::doMatch($path, 'teams', 'teams', array ( 'module' => 'system', 'controller' => 'teams', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^companies\\/(\\d+)\\/invoices$/', $path, $matches)) {
      return Router::doMatch($path, 'company_invoices', 'companies/:company_id/invoices', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'invoices', ), 'module' => 'system', ), array (
  0 => 'company_id',
), $matches, $query_string);
    } elseif (preg_match('/^companies\\/(\\d+)\\/project-names$/', $path, $matches)) {
      return Router::doMatch($path, 'company_project_names', 'companies/:company_id/project-names', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'project_names', ), 'module' => 'system', ), array (
  0 => 'company_id',
), $matches, $query_string);
    } elseif (preg_match('/^companies\\/(\\d+)\\/projects$/', $path, $matches)) {
      return Router::doMatch($path, 'company_projects', 'companies/:company_id/projects', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'projects', ), 'module' => 'system', ), array (
  0 => 'company_id',
), $matches, $query_string);
    } elseif (preg_match('/^companies\\/(\\d+)\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'company_export', 'companies/:company_id/export', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), array (
  0 => 'company_id',
), $matches, $query_string);
    } elseif (preg_match('/^companies\\/notes$/', $path, $matches)) {
      return Router::doMatch($path, 'companies_notes', 'companies/notes', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'notes', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^companies\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'companies_archive', 'companies/archive', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'archive', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^companies\\/all$/', $path, $matches)) {
      return Router::doMatch($path, 'companies_all', 'companies/all', array ( 'controller' => 'companies', 'action' => array ( 'GET' => 'all', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^companies\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'company', 'companies/:company_id', array ( 'module' => 'system', 'controller' => 'companies', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'company_id',
), $matches, $query_string);
    } elseif (preg_match('/^companies$/', $path, $matches)) {
      return Router::doMatch($path, 'companies', 'companies', array ( 'module' => 'system', 'controller' => 'companies', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^password-recovery\\/reset-password$/', $path, $matches)) {
      return Router::doMatch($path, 'password_recovery_reset_password', 'password-recovery/reset-password', array ( 'controller' => 'password_recovery', 'action' => array ( 'POST' => 'reset_password', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^password-recovery\\/send-code$/', $path, $matches)) {
      return Router::doMatch($path, 'password_recovery_send_code', 'password-recovery/send-code', array ( 'controller' => 'password_recovery', 'action' => array ( 'POST' => 'send_code', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^accept-invitation$/', $path, $matches)) {
      return Router::doMatch($path, 'accept_invitation', 'accept-invitation', array ( 'controller' => 'user_session', 'action' => array ( 'GET' => 'view_invitation', 'POST' => 'accept_invitation', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^issue-token-intent$/', $path, $matches)) {
      return Router::doMatch($path, 'issue_token_by_intent', 'issue-token-intent', array ( 'controller' => 'user_session', 'action' => array ( 'POST' => 'issue_token', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^issue-token$/', $path, $matches)) {
      return Router::doMatch($path, 'issue_token', 'issue-token', array ( 'controller' => 'user_session', 'action' => array ( 'POST' => 'issue_token', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^user-session$/', $path, $matches)) {
      return Router::doMatch($path, 'user_session', 'user-session', array ( 'controller' => 'user_session', 'action' => array ( 'GET' => 'who_am_i', 'POST' => 'login', 'DELETE' => 'logout', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/api-subscriptions\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'api_subscription', 'users/:user_id/api-subscriptions/:api_subscription_id', array ( 'module' => 'system', 'controller' => 'api_subscriptions', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'user_id',
  1 => 'api_subscription_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/api-subscriptions$/', $path, $matches)) {
      return Router::doMatch($path, 'api_subscriptions', 'users/:user_id/api-subscriptions', array ( 'module' => 'system', 'controller' => 'api_subscriptions', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/sessions$/', $path, $matches)) {
      return Router::doMatch($path, 'user_sessions', 'users/:user_id/sessions', array ( 'module' => 'system', 'controller' => 'user_sessions', 'action' => array ( 'GET' => 'index', 'DELETE' => 'remove', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/change-role$/', $path, $matches)) {
      return Router::doMatch($path, 'user_change_role', 'users/:user_id/change-role', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'change_role', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/clear-avatar$/', $path, $matches)) {
      return Router::doMatch($path, 'user_clear_avatar', 'users/:user_id/clear-avatar', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'DELETE' => 'clear_avatar', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/activities$/', $path, $matches)) {
      return Router::doMatch($path, 'user_activities', 'users/:user_id/activities', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'activities', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'user_export', 'users/:user_id/export', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'export', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/get-invitation\\/accept-url$/', $path, $matches)) {
      return Router::doMatch($path, 'user_get_accept_invitation_url', 'users/:user_id/get-invitation/accept-url', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'get_accept_invitation_url', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/get-invitation$/', $path, $matches)) {
      return Router::doMatch($path, 'user_get_invitation', 'users/:user_id/get-invitation', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'get_invitation', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/resend-invitation$/', $path, $matches)) {
      return Router::doMatch($path, 'user_resend_invitation', 'users/:user_id/resend-invitation', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'resend_invitation', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/change-password$/', $path, $matches)) {
      return Router::doMatch($path, 'user_change_password', 'users/:user_id/change-password', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'change_password', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/reactivate$/', $path, $matches)) {
      return Router::doMatch($path, 'user_reactivate', 'users/:user_id/reactivate', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'reactivate', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'user_archive', 'users/:user_id/archive', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'PUT' => 'move_to_archive', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users\\/check-email$/', $path, $matches)) {
      return Router::doMatch($path, 'users_check_email', 'users/check-email', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'check_email', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/archive$/', $path, $matches)) {
      return Router::doMatch($path, 'users_archive', 'users/archive', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'archive', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/all$/', $path, $matches)) {
      return Router::doMatch($path, 'users_all', 'users/all', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'all', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/invite$/', $path, $matches)) {
      return Router::doMatch($path, 'users_invite', 'users/invite', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'POST' => 'invite', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^users\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'user', 'users/:user_id', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^users$/', $path, $matches)) {
      return Router::doMatch($path, 'users', 'users', array ( 'module' => 'system', 'controller' => 'users', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^calendars\\/([a-z0-9\\-\\._]+)\\/events\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar_event', 'calendars/:calendar_id/events/:calendar_event_id', array ( 'module' => 'system', 'controller' => 'calendar_events', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'calendar_id',
  1 => 'calendar_event_id',
), $matches, $query_string);
    } elseif (preg_match('/^calendars\\/([a-z0-9\\-\\._]+)\\/events$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar_events', 'calendars/:calendar_id/events', array ( 'module' => 'system', 'controller' => 'calendar_events', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'calendar_id',
), $matches, $query_string);
    } elseif (preg_match('/^calendars\\/events$/', $path, $matches)) {
      return Router::doMatch($path, 'calendars_events', 'calendars/events', array ( 'controller' => 'calendars', 'action' => array ( 'GET' => 'all_calendar_events', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^calendars\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'calendar', 'calendars/:calendar_id', array ( 'module' => 'system', 'controller' => 'calendars', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'calendar_id',
), $matches, $query_string);
    } elseif (preg_match('/^calendars$/', $path, $matches)) {
      return Router::doMatch($path, 'calendars', 'calendars', array ( 'module' => 'system', 'controller' => 'calendars', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^reminders\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'reminder', 'reminders/:reminder_id', array ( 'module' => 'system', 'controller' => 'reminders', 'action' => array ( 'DELETE' => 'delete', ), ), array (
  0 => 'reminder_id',
), $matches, $query_string);
    } elseif (preg_match('/^reminders\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'reminders', 'reminders/:parent_type/:parent_id', array ( 'module' => 'system', 'controller' => 'reminders', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^payment-gateways\\/clear-credit-card$/', $path, $matches)) {
      return Router::doMatch($path, 'payment_gateway_clear_credit_card', 'payment-gateways/clear-credit-card', array ( 'controller' => 'payment_gateways', 'action' => array ( 'DELETE' => 'clear_credit_card', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^payment-gateways\\/clear-paypal$/', $path, $matches)) {
      return Router::doMatch($path, 'payment_gateway_clear_paypal', 'payment-gateways/clear-paypal', array ( 'controller' => 'payment_gateways', 'action' => array ( 'DELETE' => 'clear_paypal', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^payment-gateways$/', $path, $matches)) {
      return Router::doMatch($path, 'payment_gateways', 'payment-gateways', array ( 'controller' => 'payment_gateways', 'action' => array ( 'GET' => 'get_settings', 'PUT' => 'update_settings', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^public_payments\\/authorizenet-form$/', $path, $matches)) {
      return Router::doMatch($path, 'public_payment_authorizenet_form', 'public_payments/authorizenet-form', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'authorizenet_form', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^public_payments\\/authorizenet-confirm$/', $path, $matches)) {
      return Router::doMatch($path, 'public_payment_authorizenet_confirm', 'public_payments/authorizenet-confirm', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'authorizenet_confirm', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^public_payments$/', $path, $matches)) {
      return Router::doMatch($path, 'public_payments', 'public_payments', array ( 'controller' => 'public_payments', 'action' => array ( 'GET' => 'view', 'POST' => 'add', 'PUT' => 'update', 'delete' => 'cancel', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^payments\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'payment', 'payments/:payment_id', array ( 'module' => 'system', 'controller' => 'payments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'payment_id',
), $matches, $query_string);
    } elseif (preg_match('/^payments$/', $path, $matches)) {
      return Router::doMatch($path, 'payments', 'payments', array ( 'module' => 'system', 'controller' => 'payments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^labels\\/(\\d+)\\/set-as-default$/', $path, $matches)) {
      return Router::doMatch($path, 'label_set_as_default', 'labels/:label_id/set-as-default', array ( 'action' => array ( 'PUT' => 'set_as_default', ), 'controller' => 'labels', 'module' => 'system', ), array (
  0 => 'label_id',
), $matches, $query_string);
    } elseif (preg_match('/^labels\\/reorder$/', $path, $matches)) {
      return Router::doMatch($path, 'labels_reorder', 'labels/reorder', array ( 'action' => array ( 'PUT' => 'reorder', ), 'controller' => 'labels', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^labels\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'label', 'labels/:label_id', array ( 'module' => 'system', 'controller' => 'labels', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'label_id',
), $matches, $query_string);
    } elseif (preg_match('/^labels$/', $path, $matches)) {
      return Router::doMatch($path, 'labels', 'labels', array ( 'module' => 'system', 'controller' => 'labels', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^categories\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'category', 'categories/:category_id', array ( 'module' => 'system', 'controller' => 'categories', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'category_id',
), $matches, $query_string);
    } elseif (preg_match('/^categories$/', $path, $matches)) {
      return Router::doMatch($path, 'categories', 'categories', array ( 'module' => 'system', 'controller' => 'categories', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^comments\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'comment', 'comments/:comment_id', array ( 'module' => 'system', 'controller' => 'comments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'comment_id',
), $matches, $query_string);
    } elseif (preg_match('/^comments\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'comments', 'comments/:parent_type/:parent_id', array ( 'module' => 'system', 'controller' => 'comments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^subscribers\\/([a-z0-9\\-\\._]+)\\/(\\d+)\\/users\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'subscriber', 'subscribers/:parent_type/:parent_id/users/:user_id', array ( 'action' => array ( 'POST' => 'subscribe', 'DELETE' => 'unsubscribe', ), 'controller' => 'subscribers', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
  2 => 'user_id',
), $matches, $query_string);
    } elseif (preg_match('/^subscribers\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'subscribers', 'subscribers/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', 'POST' => 'bulk_subscribe', 'PUT' => 'bulk_update', 'DELETE' => 'bulk_unsubscribe', ), 'controller' => 'subscribers', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^public\\/notifications\\/unsubscribe$/', $path, $matches)) {
      return Router::doMatch($path, 'public_notifications_unsubscribe', 'public/notifications/unsubscribe', array ( 'controller' => 'public_notifications', 'action' => 'unsubscribe', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^public\\/notifications\\/subscribe$/', $path, $matches)) {
      return Router::doMatch($path, 'public_notifications_subscribe', 'public/notifications/subscribe', array ( 'controller' => 'public_notifications', 'action' => 'subscribe', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^notifications\\/mark-all-as-read$/', $path, $matches)) {
      return Router::doMatch($path, 'notifications_mark_all_as_read', 'notifications/mark-all-as-read', array ( 'controller' => 'notifications', 'action' => array ( 'PUT' => 'mark_all_as_read', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^notifications\\/object-updates\\/recent$/', $path, $matches)) {
      return Router::doMatch($path, 'notifications_recent_object_updates', 'notifications/object-updates/recent', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'recent_object_updates', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^notifications\\/object-updates$/', $path, $matches)) {
      return Router::doMatch($path, 'notifications_object_updates', 'notifications/object-updates', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'object_updates', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^notifications\\/unread$/', $path, $matches)) {
      return Router::doMatch($path, 'notifications_unread', 'notifications/unread', array ( 'controller' => 'notifications', 'action' => array ( 'GET' => 'unread', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^notifications\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'notification', 'notifications/:notification_id', array ( 'module' => 'system', 'controller' => 'notifications', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'notification_id',
), $matches, $query_string);
    } elseif (preg_match('/^notifications$/', $path, $matches)) {
      return Router::doMatch($path, 'notifications', 'notifications', array ( 'module' => 'system', 'controller' => 'notifications', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^attachments\\/([a-z0-9\\-\\._]+)\\/([a-z0-9\\-\\._]+)\\/download$/', $path, $matches)) {
      return Router::doMatch($path, 'attachments_batch_download', 'attachments/:parent_type/:parent_id/download', array ( 'controller' => 'attachments_archive', 'action' => array ( 'POST' => 'prepare', ), 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^attachments\\/(\\d+)\\/download$/', $path, $matches)) {
      return Router::doMatch($path, 'attachment_download', 'attachments/:attachment_id/download', array ( 'controller' => 'attachments', 'action' => array ( 'GET' => 'download', ), 'module' => 'system', ), array (
  0 => 'attachment_id',
), $matches, $query_string);
    } elseif (preg_match('/^attachments\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'attachment', 'attachments/:attachment_id', array ( 'module' => 'system', 'controller' => 'attachments', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'attachment_id',
), $matches, $query_string);
    } elseif (preg_match('/^attachments$/', $path, $matches)) {
      return Router::doMatch($path, 'attachments', 'attachments', array ( 'module' => 'system', 'controller' => 'attachments', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/email\\/test-connection$/', $path, $matches)) {
      return Router::doMatch($path, 'email_integration_test_connection', 'integrations/email/test-connection', array ( 'module' => 'system', 'controller' => 'email_integration', 'action' => array ( 'POST' => 'test_connection', ), 'integration_type' => 'email', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/email\\/email-log$/', $path, $matches)) {
      return Router::doMatch($path, 'email_integration_email_log', 'integrations/email/email-log', array ( 'module' => 'system', 'controller' => 'email_integration', 'action' => array ( 'GET' => 'email_log', ), 'integration_type' => 'email', ), array(), $matches, $query_string);
    } elseif (preg_match('/^history\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'history', 'history/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'history', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^whats-new\\/daily\\/(([0-9]{2,4})-([0-1][0-9])-([0-3][0-9]))$/', $path, $matches)) {
      return Router::doMatch($path, 'whats_new_daily', 'whats-new/daily/:day', array ( 'controller' => 'whats_new', 'action' => array ( 'GET' => 'daily', ), 'module' => 'system', ), array (
  0 => 'day',
), $matches, $query_string);
    } elseif (preg_match('/^whats-new$/', $path, $matches)) {
      return Router::doMatch($path, 'whats_new', 'whats-new', array ( 'controller' => 'whats_new', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^activity-logs\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'activity_log', 'activity-logs/:activity_log_id', array ( 'module' => 'activity_logs', 'controller' => 'activity_logs', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'activity_log_id',
), $matches, $query_string);
    } elseif (preg_match('/^activity-logs$/', $path, $matches)) {
      return Router::doMatch($path, 'activity_logs', 'activity-logs', array ( 'module' => 'activity_logs', 'controller' => 'activity_logs', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/dropbox\\/batch$/', $path, $matches)) {
      return Router::doMatch($path, 'dropbox_batch', 'integrations/dropbox/batch', array ( 'controller' => 'dropbox', 'action' => array ( 'POST' => 'batch_add', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/google-drive\\/batch$/', $path, $matches)) {
      return Router::doMatch($path, 'google_drive_batch', 'integrations/google-drive/batch', array ( 'controller' => 'google_drive', 'action' => array ( 'POST' => 'batch_add', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/warehouse\\/store\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'warehouse_store_export_complete_pingback', 'integrations/warehouse/store/export', array ( 'controller' => 'warehouse', 'action' => array ( 'POST' => 'storeExportPingback', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/warehouse\\/pingback$/', $path, $matches)) {
      return Router::doMatch($path, 'warehouse_pingback', 'integrations/warehouse/pingback', array ( 'controller' => 'warehouse', 'action' => array ( 'POST' => 'pingback', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system-notifications\\/([a-z0-9\\-\\._]+)\\/dismiss$/', $path, $matches)) {
      return Router::doMatch($path, 'system_notifications_dismiss', '/system-notifications/:notification_id/dismiss', array ( 'controller' => 'system_notifications', 'action' => array ( 'GET' => 'dismiss', ), 'module' => 'system', ), array (
  0 => 'notification_id',
), $matches, $query_string);
    } elseif (preg_match('/^compare-text$/', $path, $matches)) {
      return Router::doMatch($path, 'compare_text', 'compare-text', array ( 'action' => array ( 'POST' => 'compare', ), 'controller' => 'compare_text', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^favorites\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'favorite', 'favorites/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'check', 'PUT' => 'add', 'DELETE' => 'remove', ), 'controller' => 'favorites', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^favorites$/', $path, $matches)) {
      return Router::doMatch($path, 'favorites', 'favorites', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'favorites', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^data-filters\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'data_filter', 'data-filters/:data_filter_id', array ( 'module' => 'system', 'controller' => 'data_filters', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'data_filter_id',
), $matches, $query_string);
    } elseif (preg_match('/^data-filters$/', $path, $matches)) {
      return Router::doMatch($path, 'data_filters', 'data-filters', array ( 'module' => 'system', 'controller' => 'data_filters', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^open\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'open', 'open/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'open', ), 'controller' => 'complete', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^complete\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'complete', 'complete/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'complete', ), 'controller' => 'complete', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^reports\\/export$/', $path, $matches)) {
      return Router::doMatch($path, 'reports_export', 'reports/export', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'export', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^reports\\/run$/', $path, $matches)) {
      return Router::doMatch($path, 'reports_run', 'reports/run', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'run', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^reports$/', $path, $matches)) {
      return Router::doMatch($path, 'reports', 'reports', array ( 'controller' => 'reports', 'action' => array ( 'GET' => 'index', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^workweek$/', $path, $matches)) {
      return Router::doMatch($path, 'workweek', 'workweek', array ( 'controller' => 'workweek', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^localization\\/time-formats$/', $path, $matches)) {
      return Router::doMatch($path, 'localization_time_formats', 'localization/time-formats', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_time_formats', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^localization\\/date-formats$/', $path, $matches)) {
      return Router::doMatch($path, 'localization_date_formats', 'localization/date-formats', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_date_formats', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^localization\\/timezones$/', $path, $matches)) {
      return Router::doMatch($path, 'localization_timezones', 'localization/timezones', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_timezones', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^localization$/', $path, $matches)) {
      return Router::doMatch($path, 'localization', 'localization', array ( 'controller' => 'localization', 'action' => array ( 'GET' => 'show_settings', 'PUT' => 'save_settings', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/cron$/', $path, $matches)) {
      return Router::doMatch($path, 'cron_integration', 'integrations/cron', array ( 'module' => 'system', 'controller' => 'cron_integration', 'action' => 'get', 'integration_type' => 'cron', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/search\\/test-connection$/', $path, $matches)) {
      return Router::doMatch($path, 'search_integration_test_connection', 'integrations/search/test-connection', array ( 'module' => 'system', 'controller' => 'search_integration', 'action' => array ( 'POST' => 'test_connection', ), 'integration_type' => 'search', ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'integration', 'integrations/:integration_id', array ( 'module' => 'system', 'controller' => 'integrations', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'integration_id',
), $matches, $query_string);
    } elseif (preg_match('/^integrations$/', $path, $matches)) {
      return Router::doMatch($path, 'integrations', 'integrations', array ( 'module' => 'system', 'controller' => 'integrations', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^integrations\\/([a-z0-9\\-\\._]+)$/', $path, $matches)) {
      return Router::doMatch($path, 'integration_singletons', 'integrations/:integration_type', array ( 'module' => 'system', 'controller' => 'integration_singletons', 'action' => array ( 'GET' => 'get', 'PUT' => 'set', 'DELETE' => 'forget', ), ), array (
  0 => 'integration_type',
), $matches, $query_string);
    } elseif (preg_match('/^currencies\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'currencies_default', 'currencies/default', array ( 'controller' => 'currencies', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^currencies\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'currency', 'currencies/:currency_id', array ( 'module' => 'system', 'controller' => 'currencies', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'currency_id',
), $matches, $query_string);
    } elseif (preg_match('/^currencies$/', $path, $matches)) {
      return Router::doMatch($path, 'currencies', 'currencies', array ( 'module' => 'system', 'controller' => 'currencies', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^languages\\/default$/', $path, $matches)) {
      return Router::doMatch($path, 'languages_default', 'languages/default', array ( 'controller' => 'languages', 'action' => array ( 'GET' => 'view_default', 'PUT' => 'set_default', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^languages\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'language', 'languages/:language_id', array ( 'module' => 'system', 'controller' => 'languages', 'action' => array ( 'GET' => 'view', ), ), array (
  0 => 'language_id',
), $matches, $query_string);
    } elseif (preg_match('/^languages$/', $path, $matches)) {
      return Router::doMatch($path, 'languages', 'languages', array ( 'module' => 'system', 'controller' => 'languages', 'action' => array ( 'GET' => 'index', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^day-offs\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'day_off', 'day-offs/:day_off_id', array ( 'module' => 'system', 'controller' => 'day_offs', 'action' => array ( 'GET' => 'view', 'PUT' => 'edit', 'DELETE' => 'delete', ), ), array (
  0 => 'day_off_id',
), $matches, $query_string);
    } elseif (preg_match('/^day-offs$/', $path, $matches)) {
      return Router::doMatch($path, 'day_offs', 'day-offs', array ( 'module' => 'system', 'controller' => 'day_offs', 'action' => array ( 'GET' => 'index', 'POST' => 'add', ), ), array(), $matches, $query_string);
    } elseif (preg_match('/^wallpapers$/', $path, $matches)) {
      return Router::doMatch($path, 'wallpapers', 'wallpapers', array ( 'action' => array ( 'GET' => 'index', ), 'controller' => 'wallpapers', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^upgrade\\/release-notes$/', $path, $matches)) {
      return Router::doMatch($path, 'upgrade_release_notes', 'upgrade/release-notes', array ( 'controller' => 'upgrade', 'action' => 'release_notes', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^upgrade$/', $path, $matches)) {
      return Router::doMatch($path, 'upgrade', 'upgrade', array ( 'controller' => 'upgrade', 'action' => array ( 'GET' => 'index', 'POST' => 'finish', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system-status\\/check-environment$/', $path, $matches)) {
      return Router::doMatch($path, 'check_environment', 'system-status/check-environment', array ( 'controller' => 'system_status', 'action' => 'check_environment', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system-status\\/download-release$/', $path, $matches)) {
      return Router::doMatch($path, 'download_release', 'system-status/download-release', array ( 'controller' => 'system_status', 'action' => array ( 'GET' => 'get_download_progress', 'POST' => 'start_download', ), 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system-status\\/check-for-updates$/', $path, $matches)) {
      return Router::doMatch($path, 'check_for_updates', 'system-status/check-for-updates', array ( 'controller' => 'system_status', 'action' => 'check_for_updates', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^system-status$/', $path, $matches)) {
      return Router::doMatch($path, 'system_status', 'system-status', array ( 'controller' => 'system_status', 'action' => 'index', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^initial\\/test-speed$/', $path, $matches)) {
      return Router::doMatch($path, 'initial_speed_test', 'initial/test-speed', array ( 'controller' => 'initial', 'action' => 'test_action_speed', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^initial$/', $path, $matches)) {
      return Router::doMatch($path, 'initial', 'initial', array ( 'controller' => 'initial', 'action' => 'index', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^personalized-config-options$/', $path, $matches)) {
      return Router::doMatch($path, 'personalized_config_options', 'personalized-config-options', array ( 'action' => array ( 'GET' => 'personalized_get', 'PUT' => 'personalized_set', ), 'controller' => 'config_options', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^config-options$/', $path, $matches)) {
      return Router::doMatch($path, 'config_options', 'config-options', array ( 'action' => array ( 'GET' => 'get', 'PUT' => 'set', ), 'controller' => 'config_options', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^search\\/suggest$/', $path, $matches)) {
      return Router::doMatch($path, 'search_suggest', 'search/suggest', array ( 'action' => array ( 'GET' => 'suggest', ), 'controller' => 'search', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^search$/', $path, $matches)) {
      return Router::doMatch($path, 'search', 'search', array ( 'action' => array ( 'GET' => 'query', ), 'controller' => 'search', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^upload-files$/', $path, $matches)) {
      return Router::doMatch($path, 'upload_files', 'upload-files', array ( 'action' => array ( 'POST' => 'index', 'GET' => 'prepare', ), 'controller' => 'upload_files', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^access-logs\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'access_logs', 'access-logs/:parent_type/:parent_id', array ( 'action' => array ( 'GET' => 'index', 'PUT' => 'log_access', ), 'controller' => 'access_logs', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^reactivate\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'reactivate', 'reactivate/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'reactivate', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^permanently-delete\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'permanently_delete', 'permanently-delete/:parent_type/:parent_id', array ( 'action' => array ( 'DELETE' => 'permanently_delete', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^restore-from-trash\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'restore_from_trash', 'restore-from-trash/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'restore_from_trash', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^move-to-trash\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'move_to_trash', 'move-to-trash/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'trash', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^restore-from-archive\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'restore_from_archive', 'restore-from-archive/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'restore_from_archive', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^move-to-archive\\/([a-z0-9\\-\\._]+)\\/(\\d+)$/', $path, $matches)) {
      return Router::doMatch($path, 'move_to_archive', 'move-to-archive/:parent_type/:parent_id', array ( 'action' => array ( 'PUT' => 'archive', ), 'controller' => 'state', 'module' => 'system', ), array (
  0 => 'parent_type',
  1 => 'parent_id',
), $matches, $query_string);
    } elseif (preg_match('/^trash$/', $path, $matches)) {
      return Router::doMatch($path, 'trash', 'trash', array ( 'action' => array ( 'GET' => 'show_content', 'DELETE' => 'empty_trash', ), 'controller' => 'trash', 'module' => 'system', ), array(), $matches, $query_string);
    } elseif (preg_match('/^info$/', $path, $matches)) {
      return Router::doMatch($path, 'api_info', 'info', array ( 'controller' => 'utilities', 'action' => array ( 'GET' => 'info', ), 'module' => 'system', ), array(), $matches, $query_string);
    }

    return false;
  };