<?php
/*------------------------------------------------------------------------
# com_vportfolio - Vportfolio component
# ------------------------------------------------------------------------
# author    Vsmart Extensions
# copyright Copyright (C) 2010 www.vsmart-extensions.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.vsmart-extensions.com
# Technical Support:  Forum - http://www.vsmart-extensions.com
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.application.component.model' );

/**
 * @package Joomla
 * @subpackage Vportfolio
 */
class vportfolioCategoryComponentModel extends JModel
{
	/** @var object JTable object */
	var $_table = '#__vportfolio_category';
	var $lists;
	var $items;
	var $pagination;

	/**
	 * Returns the internal table object
	 * @return JTable
	 */
	function &getTable()
	{
		if ($this->_table == null) {
			$this->_table = JTable::getInstance('component', $this->getDBO() );
		}
		return $this->_table;
	}

	function &getListItem(){
		global $option;
		
		$option = JRequest::getVar('option');
		
		$mainframe = JFactory::getApplication();
		
		$db =& JFactory::getDBO();
		$search				= $mainframe->getUserStateFromRequest( "$option.search", 'search', '','string' );
		
		$search				= JString::strtolower( $search );

		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart = $mainframe->getUserStateFromRequest( $option.'.limitstart', 'limitstart', 0, 'int' );

		$where = array();
		if (isset( $search ) && $search!= '')
		{
			$searchEscaped = $db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
			$where[] = 'a.name LIKE '.$searchEscaped.' OR a.description LIKE '.$searchEscaped;
		}

		$where = ( count( $where ) ? ' WHERE (' . implode( ') AND (', $where ) . ')' : '' );

		$query = 'SELECT COUNT(a.id)'
		. ' FROM #__vportfolio_category AS a'
		. $where
		;
		$db->setQuery( $query );
		$total = $db->loadResult();

		jimport('joomla.html.pagination');
		$pagination = new JPagination( $total, $limitstart, $limit );
		
		$query = 'SELECT a.* '
			. ' FROM #__vportfolio_category AS a'
			. $where
		;
		$db->setQuery( $query, $pagination->limitstart, $pagination->limit );
		$rows = $db->loadObjectList();
		
		$lists['search']= $search;

		$this->lists = $lists;
		$this->items = $rows;
		$this->pagination = $pagination;
	}
	function &getItem($id=0){
	
		$cid		= JRequest::getVar( 'cid', array(0), '', 'array' );
		if($cid[0] =="")
			$cid[0] = $id;
		$edit		= JRequest::getVar('edit',true);
		JArrayHelper::toInteger($cid, array(0));
		
		$db 		=& JFactory::getDBO();
		
		$query = 'SELECT * FROM #__vportfolio_category WHERE id="'.$cid[0].'"';
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		$row = $rows[0];

		return $row;
	}
	function &saveItem(){
		global $mainframe;
		
		$option = JRequest::getCmd( 'option');
		
		$id		= JRequest::getVar('id',0);
		
		//Save data
		$post = JRequest::get('post');
		$post['description'] = JRequest::getVar('description', '', 'post', 'string', JREQUEST_ALLOWRAW);
		
		$item = new VSTPortfolioCategory($id);
		
		
		if (!$item->bind($post)){
			return false;
		}
		$currentId = $item->save();
		return $currentId;
	}
	function publicItem(){
		$row = $this->getItem();
		if($row->public == 1) $row->public = 0;
		else $row->public = 1;
		$db 		=& JFactory::getDBO();
		$sql = "UPDATE #__vportfolio_category SET ".
					"public = '".$row->public."'".
					" WHERE id = '".$row->id."'";
		$db->setQuery($sql);
		$return = $db->query();	
		return $return;
	}
	//----------
	/**
	 * Method to (un)publish  class
	 * @access	public
	 * @return	boolean	True on success
	 * @since	1.5
	 * $publish = 1 -> pub , $publish = 0 -> unpub
	 */
	function publish($cid = array(), $publish = 1)
	{
		if (count( $cid ))
		{					
			JArrayHelper::toInteger($cid);
			$cids = implode( ',', $cid );				
			$query = 'UPDATE #__vportfolio_category '
				. ' SET public = '.(int) $publish
				. ' WHERE id IN ( '.$cids.' )';
			$db =& JFactory::getDBO();
			$db->setQuery( $query );
			if (!$db->query()) {
				$this->setError($db->getErrorMsg());
				return false;
			}
		}
		return true;
	}		
	function deleteListItem(){
		$cid = JRequest::getVar( 'cid', array(0), '', 'array' );
		
		
		for($i=0;$i<sizeof($cid);$i++){
			$db 		=& JFactory::getDBO();
			$id = $cid[$i];
			
			$query = 'SELECT * FROM #__vportfolio WHERE categoryId="'.$id.'"';
			$db->setQuery($query);
			$rows = $db->loadObjectList();
			if(sizeof($rows) > 0 ){
				$query = 'SELECT name FROM #__vportfolio_category WHERE id="'.$id.'"';
				$db->setQuery($query);
				$categoryName = $db->loadResult();
				$msg = JText::sprintf("ERROR: $categoryName contain items!");
				return $msg;
			}else{
				$sql = "DELETE FROM #__vportfolio_category WHERE id = '".$id."'";
				$db->setQuery($sql);
				$db->query();
			}
		}
		return $msg;
		
	}
}
class VSTPortfolioCategory extends JObject{
	
	var $id					= null;
	var $name				= null;
	var $description		= null;
	var $public				= 1;
	
	function VSTPortfolioCategory($id = 0 ){
		$this->id = $id;
	}
	function bind(& $array){
		
		
		// Bind the array
		if (!$this->setProperties($array)) {
			$this->setError("Unable to bind array to item object");
			return false;
		}
		
		// Make sure its an integer
		$this->id = (int) $this->id;

		return true;
		
	}
	function save(){
		$db 	=& JFactory::getDBO();
		if($this->id != 0){
			$sql = "UPDATE #__vportfolio_category SET ".
					"name = '".mysql_escape_string($this->name)."',".
					"description = '".mysql_escape_string($this->description)."',".
					"public = '".$this->public."'".
					" WHERE id = '".$this->id."'"; 
		}else{
			$sql = "INSERT INTO #__vportfolio_category SET ".
					"name = '".mysql_escape_string($this->name)."',".
					"description = '".mysql_escape_string($this->description)."',".
					"public = '".$this->public."'";
			
		}

		$db->setQuery($sql);
		$return = $db->query();
		
		if($this->id == 0 )
			$this->id = $db->insertid();
		
		return $this->id;
		
	}
	
}
?>
