<?php
/*------------------------------------------------------------------------
# com_vportfolio - Vportfolio component
# ------------------------------------------------------------------------
# author    Vsmart Extensions
# copyright Copyright (C) 2010 www.vsmart-extensions.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.vsmart-extensions.com
# Technical Support:  Forum - http://www.vsmart-extensions.com
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );

/**
 * @package Joomla
 * @subpackage Vportfolio
 */
class vportfolioCategoryComponentView extends JView
{
	/**
	 * Display the view
	 */
	 var $items;
	 var $pagination;
	 var $lists;
	 
	function setModel($model){
	
		$this->items = $model->items;
		$this->pagination = $model->pagination;
		$this->lists = $model->lists;
	}
	
	function display()
	{
		//DEVNOTE: set document title
		$document = & JFactory::getDocument();
		$document->setTitle( JText::_('Vsmarttech Portfolio Component') );
    
    //DEVNOTE: Print Hellpworld and language name
?>
        
  <form action="index.php?option=com_vportfolio" method="post" name="adminForm">
	<table>
		<tr>
			<td width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $this->lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			<td nowrap="nowrap">
			</td>
		</tr>
	</table>

	<table class="adminlist" cellpadding="1">
		<thead>
			<tr>
				<th width="2%" class="title">
					<?php echo JText::_( 'NUM' ); ?>
				</th>
				<th width="3%" class="title">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
				</th>
				<th  width="15%" class="title">
					<?php echo JText::_( 'Title' ); ?>
				</th>
				<th  class="title">
					<?php echo JText::_( 'Description' ); ?>
				</th>
                <th width="5%" class="title" nowrap="nowrap">
					<?php echo JText::_( 'Public' ); ?>
				</th>
				<th width="1%" class="title" nowrap="nowrap">
					<?php echo JText::_( 'ID' ); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
			$k = 0;
			for ($i=0, $n=count( $this->items ); $i < $n; $i++)
			{
				$row 	=& $this->items[$i];

				$link 	= 'index.php?option=com_vportfolio&amp;task=edit&amp;controller=category&amp;cid[]='. $row->id. '';

			?>
			<tr class="<?php echo "row$k"; ?>">
				<td align="center">
					<?php echo $i+1+$this->pagination->limitstart;?>
				</td>
				<td align="center">
					<?php echo JHTML::_('grid.id', $i, $row->id ); ?>
				</td>
				<td>
					<a href="<?php echo $link; ?>">
						<?php echo $row->name; ?></a>
				</td>
				<td>
					<?php echo truncString(cleanHtml($row->description),350,'false'); ?>
				</td>
				<td align="center">
						<?php echo JHtml::_('jgrid.published', $row->public, $i); ?>
				</td>
				<td align="center">
					<?php echo $row->id; ?>
				</td>
			</tr>
			<?php
				$k = 1 - $k;
				}
			?>
		</tbody>
	</table>

	<input type="hidden" name="option" value="com_vportfolio" />
	<input type="hidden" name="task" value="" />
    <input type="hidden" name="controller" value="category" />
	<input type="hidden" name="boxchecked" value="0" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php 
  }
  function displayItem($item){
  	global $mainframe;
	
	// Load the JEditor object
	$editor =& JFactory::getEditor();
	

  ?>
  <script src="components/com_vportfolio/js/messages.js" type="text/javascript"></script>
   <script>
   		function submitbutton(pressbutton) {
			
			var form = document.adminForm;
			
			var text = <?php echo $editor->getContent( 'description' ); ?>
			<?php echo $editor->save( 'description' ); ?>
			
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
		
			// do field validation
			if (trim(form.name.value) == "") {
				inlineMsg('name','You must enter your name.',2);
			} else {
				submitform( pressbutton );
			}
		}
   </script>
   <style>
   		#msg {display:none; position:absolute; z-index:200; background:url(components/com_vportfolio/images/msg_arrow.gif) left center no-repeat; padding-left:7px}
		#msgcontent {display:block; background:#f3e6e6; border:2px solid #924949; border-left:none; padding:5px; min-width:150px; max-width:250px}
   </style>
  	<form action="index.php" method="post" name="adminForm" autocomplete="off">
		<fieldset class="adminform">
		<legend><?php echo JText::_( 'Item Details' ); ?></legend>
			<table class="admintable" cellspacing="1">
				<tr>
					<td width="150" class="key">
						<label for="tile">
							<?php echo JText::_( 'Title' ); ?>
						</label>
					</td>
					<td>
						<input type="text" name="name" id="name" class="inputbox" size="40" value="<?php if(isset($item->name)) echo $item->name; ?>" />
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="description">
							<?php echo JText::_( 'Description' ); ?>
						</label>
					</td>
					<td>
                        <?php 
						$desced = '';
						if(isset($item->description)) $desced .= $item->description;
                        echo $editor->display('description', $desced, '750', '400', '70', '15');
						?>
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="public">
							<?php echo JText::_( 'Public' ); ?>
						</label>
					</td>
					<td>
						<fieldset class="radio" id="jform_published">
                    	<input type="radio" name="public" id="published1" value="1" <?php if(isset($item->public) && $item->public == 1) echo "checked"; ?>  />
						<label for="published1">Yes</label>
						<input type="radio" name="public" id="published0" value="0"  <?php if(isset($item->public) && $item->public == 0) echo "checked"; ?> />
						<label for="published0">No</label>
						</fieldset>
					</td>
				</tr>
            </table>
        </fieldset>
    

	<input type="hidden" name="id" value="<?php if(isset($item->id)) echo $item->id; ?>" />
	<input type="hidden" name="cid[]" value="<?php if(isset($item->id)) echo $item->id; ?>" />
	<input type="hidden" name="option" value="com_vportfolio" />
    <input type="hidden" name="controller" value="category" />
	<input type="hidden" name="task" value="" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
  <?php
  }
}
?>
