<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
    }
    
	public function index()
	{
		$data = array(
            'history' => $this->get_history()
        );

		$this->load->view('main', $data);
	}

	public function check()
	{
		$this->load->helper(array('form', 'url', 'array'));
		$this->load->library('form_validation');
		
		$tlds = array('com','org','net','info','co.uk');

		$string = str_replace( array(' ','_'), '', $this->input->post('keywords'));
		$data['keywords'] = preg_replace('/[^a-zA-Z0-9]/', '-', $string);
		
		$data['domains'] =  array();
		$data['status'] =  TRUE;
		$data['message'] =  '';
		
		$this->form_validation->set_rules('keywords', 'Keywords', 'required|min_length[3]|max_length[64]|alpha_dash|xss_clean');
		
		if ($this->form_validation->run() == FALSE)
		{
			$data['status'] = FALSE;
			$data['message'] = validation_errors();
		}
		else
		{
			foreach ($tlds as $tld)
			{
				$domain = $data['keywords'].'.'.$tld;
				$availability = $this->is_available($domain);
				
				if($availability){
					$data['domains'][$tld] = $this->whois($domain);	
				}else{
					$data['domains'][$tld] = false;	
				}
			}
		}
		
		print json_encode($data);
	}

	private function get_history()
	{
		$this->load->library('session');
		return $this->session->userdata('domain');
	}
	
	public function add_history()
	{
		$this->load->library(array('session', 'form_validation'));
		
		$this->form_validation->set_rules('domain', 'Domain', 'required|xss_clean');
		
		$domain = $this->input->post('domain');
		$domains = array();
		
		if ($this->form_validation->run())
		{
			$domains = array();
		
			if($this->session->userdata('domain')!=null)
			{
				foreach($this->session->userdata('domain') as $item)
				{
					array_push($domains, $item);
				}
			}
		
			array_push($domains, $domain);
		
			$history = array(
                   'domain'  => $domains
               	);

			$this->session->set_userdata($history);
			echo $domain;
		}
	}
	
	public function clear_history()
	{
		$this->load->helper('url');
		$this->load->library('session');
		
		$this->session->unset_userdata('domain');
		redirect('/', 'refresh');
	}

	private function is_available($domain) 
	{
    	ob_start();
    		$domain = escapeshellarg($domain);
    		$command = "dig +time=1 +tries=1 $domain | grep NXDOMAIN | wc -l";
    		passthru($command);
        	$lookup = ob_get_contents(); 
    	ob_end_clean();
    	return $lookup!=0;
	}
	
	private function whois($domain){
		$_domain = explode('.', $domain);
		$lst = count($_domain)-1;
		$ext = $_domain[$lst];

		$servers = array(
			"biz"  => "whois.neulevel.biz",
			"org"  => "whois.pir.org",
			"cc"   => "whois.nic.cc",
			"info" => "whois.afilias.net",
			"com"  => "whois.internic.net",
			"net"  => "whois.internic.net",
			"edu"  => "whois.internic.net",
		);
		
		//pattern match for not available domain
		$pattern = array(
			"biz"  => "Not found",
			"org"  => "NOT FOUND",
			"cc"   => "No match",
			"info" => "NOT FOUND",
			"com"  => "No match",
			"net"  => "No match",
			"edu"  => "No match",
		);
		
		if (!isset($servers[$ext])){
			return TRUE;
		}else{
			$nic_server = $servers[$ext];
			$output = '';
			// connect to whois server:
			if ($conn = fsockopen ($nic_server, 43)) {
				fputs($conn, $domain."\r\n");
			
				while(!feof($conn)) {
					$output .= fgets($conn,128);
				}
			
				fclose($conn);
				
				return (strpos($output, $pattern[$ext])!== false);
			}else{
				return TRUE;
			}
			//echo nl2br($output);
		}
	}
}

/* End of file main.php */
/* Location: ./application/controllers/main.php */