/*
 *  Project: bootalerts jQuery plugin
 *  Description: a lightweight replace of the browser alerts/prompts based on bootstrap
 *  Author: Girolamo Tomaselli http://bygiro.com
 *  License:	MIT
 */
;(function ($, window, document, undefined) {
    var pluginName = "bootAlertsByGiro",
        dataPlugin = "plugin_" + pluginName,
        defaults = {
            text: {
                cancel: "Cancel",
                ok: "Ok"
            },
            msgContainerClass: "",
            msgContainer: '<div class="alert"></div>',
            dismissalBtn: '<span class="close" data-dismiss="alert">&times;</span>',
            okBtn: '<span class="btn btn-primary btn-mini bootAlert-ok"></span>',
            cancelBtn: '<span class="btn btn-danger btn-mini bootAlert-cancel"></span>',
            inputs: '\
			<div class="control-group form-vertical">\
				<div class="control-label" for="text"></div>\
				<div class="controls">\
					<input autocomplete="off" type="text" name="text" value="" />\
				</div>\
			</div>'
        };
    var Plugin = function (element) {
            this.others_opts = {
                event_initialized: pluginName + "_initialized",
                event_msg_added: pluginName + "_msg_added",
                event_msg_removed: pluginName + "_msg_removed",
                event_modal_show: pluginName + "_modal_show",
                event_modal_hide: pluginName + "_modal_hide",
                initialized: false
            };
            this.options = $.extend({}, defaults);
        },
        serializeObject = function (obj) {
            var a, o = {};
            a = obj.find("input,textarea,select").serializeArray();
            $.each(a, function (i, v) {
                if (o[this.name] !== undefined) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || "");
                } else {
                    o[this.name] = this.value || "";
                }
            });
            return o;
        };
    Plugin.prototype = {
        init: function (options) {
            var that = this;
            if (this.options.initialized) {
                return;
            }
            $.extend(this.options, options, this.others_opts);
            this.id = this.element.attr("id");
            var my_data = {};
            $("body").append(' 				<div id="windowAlertModal" data-backdrop="static" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true"> 					<div class="modal-body"></div>				</div> 			');
            window._originalAlert = window.alert;
            window.alert = function (text, callBack, extraOpts) {
                return that.alert.call(that, "alert", extraOpts, text, callBack);
            };
            window._originalConfirm = window.confirm;
            window.confirm = function (text, callBack, extraOpts) {
                return that.alert.call(that, "confirm", extraOpts, text, callBack);
            };
            window._originalPrompt = window.prompt;
            window.prompt = function (text, defaultText, callBack, extraOpts) {
                return that.alert.call(that, "prompt", extraOpts, text, defaultText, callBack);
            };
            $("#windowAlertModal").on("closed", ".alert", function () {
                if ($("#windowAlertModal").find(".alert").length <= 1) {
                    var evt = $.Event(that.options.event_modal_hide);
                    that.$element.trigger(evt, my_data);
                    $("#windowAlertModal").modal("hide");
                }
            });
            this.options.initialized = true;
            var evt = $.Event(this.options.event_initialized);
            this.$element.trigger(evt, my_data);
        },
        alert: function (type, extraOpts, opt1, opt2, opt3) {
            var opts = $.extend({}, this.options, extraOpts),
                that = this,
                content = $(opts.msgContainer),
                my_data = {
                    type: type,
                    opt1: opt1,
                    opt2: opt2,
                    opt3: opt3,
                    opts: opts
                };
            content.find(".alert").addClass(opts.msgContainerClass);
            var html = "";
            switch (type) {
            case "prompt":
            case "confirm":
                if (type == "confirm") {
                    html += opt1;
                } else {
                    html += opts.inputs;
                }
                html += '<p class="bta-btn-container">' + opts.cancelBtn + " " + opts.okBtn + "</p>";
                content.html(html);
                if (type == "prompt" && (typeof extraOpts == "undefined" || typeof extraOpts.inputs == "undefined" || extraOpts.inputs == "")) {
                    content.find('[for="text"]').html(opt1);
                    content.find('[name="text"]').val(opt2);
                }
                content.find(".bootAlert-ok").html(opts.text.ok).off("click").on("click", function () {
                    var alertMsg = $(this).closest(".alert"),
                        data = serializeObject(alertMsg);
                    if (typeof opt2 == "function" && type == "confirm") {
                        opt2(true);
                    } else {
                        if (typeof opt3 == "function" && type != "confirm") {
                            opt3(data);
                        }
                    }
                    alertMsg.alert("close");
                });
                content.find(".bootAlert-cancel").html(opts.text.cancel).off("click").on("click", function () {
                    var alertMsg = $(this).closest(".alert");
                    if (typeof opt2 == "function" && type == "confirm") {
                        opt2(false);
                    } else {
                        if (typeof opt3 == "function" && type != "confirm") {
                            opt3(false);
                        }
                    }
                    alertMsg.alert("close");
                });
                $(this).closest(".alert").on("closed", function () {
                    var evt = $.Event(that.options.event_msg_removed);
                    that.$element.trigger(evt, my_data);
                });
                break;
            case "alert":
            default:
                html += opts.dismissalBtn + opt1;
                content.html(html);
                $(this).closest(".alert").on("closed", function () {
                    if (typeof opt2 == "function") {
                        opt2();
                    }
                    var evt = $.Event(that.options.event_msg_removed);
                    that.$element.trigger(evt, my_data);
                });
                break;
            }
            $("#windowAlertModal .modal-body").append(content);
            var evt = $.Event(this.options.event_msg_added);
            this.$element.trigger(evt, my_data);
            if (!$("#windowAlertModal").hasClass("in")) {
                var evt = $.Event(this.options.event_modal_show);
                this.$element.trigger(evt, my_data);
                $("#windowAlertModal").modal();
            }
        },
        addOpts: function (opts) {
            $.extend(this.options, opts);
        },
        destroy: function () {
            window.alert = window._originalAlert;
            window.confirm = window._originalConfirm;
            window.prompt = window._originalPrompt;
            $("#windowAlertModal").remove();
            this.element.data(dataPlugin, null);
        }
    };
    $.fn[pluginName] = function (arg) {
        var args, instance;
        if (!(this.data(dataPlugin) instanceof Plugin)) {
            this.data(dataPlugin, new Plugin(this));
        }
        instance = this.data(dataPlugin);
        instance.element = this;
        instance.$element = jQuery(this);
        if (typeof arg === "undefined" || typeof arg === "object") {
            if (typeof instance.init === "function") {
                instance.init(arg);
            }
        } else {
            if (typeof arg === "string" && typeof instance[arg] === "function") {
                args = Array.prototype.slice.call(arguments, 1);
                return instance[arg].apply(instance, args);
            } else {
                $.error("Method " + arg + " does not exist on jQuery." + pluginName);
            }
        }
    };
    $(document).ready(function () {
        $("body").bootAlertsByGiro();
    });
}(jQuery, window, document));