<?php
class WhoisdomaincheckUS
{
	var $nameserverArr;
	var $SERVERS_ENABLED;
	var $SERVERS;
	var $SERVERS_DISABLED;
	var $errorMsg;
	var $SCRIPT;
	var $domain;
	var $ext;
	var $server_id;
	var $server;
	var $allServers;
	
	function readFileFromdir() {
		$dir = "whois/whoisInfo/";
		$contentArr = array();
		// Open a known directory, and proceed to read its contents
		if (is_dir($dir)) {
			if ($dh = opendir($dir)) {
				while (($file = readdir($dh)) !== false) {
					if($file != "." && $file != "..") {
						$fh = fopen($dir . $file, "r");
						$filesize = (filesize($dir . $file)>0)?filesize($dir . $file):"1024";
						$contentArr[] = fread($fh, $filesize);
						fclose($fh);
						//echo "filename: $file : filetype: " . filetype($dir . $file) . "\n";
					}
				}
				closedir($dh);
			}
		}
		return implode("\n", $contentArr);
	}
	
	function WhoisdomaincheckUS() {
		$fcontent = $this->readFileFromdir();
		/*
		$this->errorMsg = array();
		$whoisFile = "whois/whois.txt";
		$fh = fopen($whoisFile, "r");
		$filesize = (filesize($whoisFile)>0)?filesize($whoisFile):"1024";
		$fcontent = fread($fh, $filesize);
		fclose($fh);
		$fcontent = base64_decode($fcontent);
		*/
		$this->SCRIPT['QUERYWHOIS']['enabled'] = true;
		$this->SCRIPT['QUERYWHOIS']['regex'] = "/(?:Whois Server|Registrar Whois): (.+)/i";
		$this->SCRIPT['QUERYWHOIS']['tdlServerExempt'] = array("whois.nic.af","whois.nic.gs","whois.nic.mu","whois.nic.net.ng","whois.nic.net.sb","whois.website.ws");
		$this->SCRIPT['limit_bypass'] = true;

		$fcontentArr = explode("\n", $fcontent);
		$nameserverArr = array();
		foreach($fcontentArr as $ind => $val) {
			$whoisArr = explode("#", $val);
			
			$this->nameserverArr[$whoisArr[0]]['enabled'] = (isset($whoisArr[1]))?$whoisArr[1]:"";
			$this->nameserverArr[$whoisArr[0]]['keyword'] = (isset($whoisArr[2]))?$whoisArr[2]:"";
			$this->nameserverArr[$whoisArr[0]]['format'] = (isset($whoisArr[3]))?$whoisArr[3]:"";
			$this->nameserverArr[$whoisArr[0]]['limit_format'] = (isset($whoisArr[4]))?$whoisArr[4]:"";
			$this->nameserverArr[$whoisArr[0]]['limit_keyword'] = (isset($whoisArr[5]))?$whoisArr[5]:"";
			$this->nameserverArr[$whoisArr[0]]['advanced_custom_query'] = (isset($whoisArr[6]))?$whoisArr[6]:"";
			$this->nameserverArr[$whoisArr[0]]['advanced_limit_custom_query'] = (isset($whoisArr[7]))?$whoisArr[7]:"";
			$this->nameserverArr[$whoisArr[0]]['advanced_custom_query_address'] = (isset($whoisArr[8]))?$whoisArr[8]:"";
			$this->nameserverArr[$whoisArr[0]]['timeout'] = (isset($whoisArr[9]))?$whoisArr[9]:"";
			$this->nameserverArr[$whoisArr[0]]['extensions'] = (isset($whoisArr[10]))?$whoisArr[10]:"";
			$this->nameserverArr[$whoisArr[0]]['extensions_disabled'] = (isset($whoisArr[11]))?$whoisArr[11]:"";
		}
		$this->getAllInfo();
		
		return;
	}
	
	function returnWhoisDetail($dataArr=array()) {
		$domain = (isset($dataArr['domain']))?$dataArr['domain']:"";
		$ext = (isset($dataArr['tld']))?$dataArr['tld']:"";
		
		$this->domain = $domain;
		$this->ext = $ext;
		
		if (empty($ext))
			$this->errorMsg[] = ("no_extension");
		
		// validate domain
		$this->validateDomain($domain, $ext);
		$this->getAllServerNames();
		
		if (!in_array($ext, $this->getAllExtensions()))
			$this->errorMsg[] = ("bad_extension:::{$ext}");

		// return new whois request object
		$this->Whois_Engine($domain, $ext);
		
		// perform full whois lookup
		$this->lookup(true);
		
		//return $this->whoisData;
	}
	
	function lookup($full_whois = false) {
		$this->fullWhois = $full_whois;

		// perform normal lookup operations
		// +------------------------------
		//	Main Lookup Operations
		// +------------------------------
		// determine address and port (NOTE c-slashes is used to preserve \r, \n, etc.)
		if (preg_match("#(.*?):([^:/]+):?([^/]*)(.*)#", stripcslashes($this->nameserverArr[$this->server]['advanced_custom_query_address']), $address_matches)) {
			// detect address and port
			if (!is_numeric($address_matches[2])) {
				$port = $address_matches[3];
				$address = $address_matches[1] . ":" . $address_matches[2] . $address_matches[4];
			} else {
				$port = $address_matches[2];
				$address = $address_matches[1];
			}
		} else { // attempt default settings if we couldn't find a match
			$port = 43;
			$address = $this->server;
		}

		// if port is not a number
		if (!is_numeric($port)) {
			// hard code an error, as this should probably be found by the webmaster before the client.
			$this->errorMsg[] = ("Bad custom address for nameserver {$this->server}. Please contact webmaster.");
		}
		// replace common var [[SERVER]]
		$address = str_replace("[[SERVER]]", $this->server, $address);
		// +------------------------------
		//	Whois Request
		// +------------------------------
		
		// generate whois request ($request, $used_limit are pass by ref)
		$request = $this->generateWhoisRequest($request, $used_limit);

		// +------------------------------
		//	Send domain data and get report
		// +------------------------------
		// connect to server / get request
		$whoisSocket = $this->fetchWhoisData($address, $port, $this->nameserverArr[$this->server]['timeout'], $request, $this->whoisData);

		// check if successful
		if ($whoisSocket && !in_array($address, $this->SCRIPT['QUERYWHOIS']['tdlServerExempt'])) {
			// +------------------------------
			//	Perform post-whois report operations
			// +------------------------------
			// determine availability
			$this->processAvailable($used_limit);
			$status = true;
			// if domain is not available and QUERYWHOIS is enabled, attempt to find / query whois server
			if (!$this->available && $this->SCRIPT['QUERYWHOIS']['enabled']) {
				if (($num_matches = preg_match_all(stripcslashes($this->SCRIPT['QUERYWHOIS']['regex']), $this->whoisData, $matches)) > 0) {
					// if more than one match, try to determine correct one
					if ($num_matches > 1) {
						if (preg_match("/((?:Domain|Server)\s*(?:Name)?: " . $this->getPunycode($this->domain, $this->ext) . "." . $this->ext . ")\s+/is", $this->whoisData, $more_matches)) {
							$offset_position = strpos($this->whoisData, $more_matches[1]);

							if (preg_match_all(stripcslashes($this->SCRIPT['QUERYWHOIS']['regex']), substr($this->whoisData, $offset_position), $new_matches)) {
								$whoisServer = $new_matches[1][0];
							} else {
								$whoisServer = $matches[1][0];
							}
						} else {
							$whoisServer = $matches[1][0];
						}
					} else { // only one match means only one whois server
						$whoisServer = $matches[1][0];
					}
					// +------------------------------
					//	Send domain data and get report
					// +------------------------------

					$whoisSocketDeep = $this->fetchWhoisData($whoisServer, 43, 5, $this->getPunycode($this->domain, $this->ext) . "." . $this->ext . "\r\n", $whoisData);

					if (!$whoisSocketDeep) {
						$whoisData = "";
					}
				}
			}				

			// trim and combine whois information
			if (isset($whoisData) && $whoisData != "")
				$this->whoisData = trim($whoisData) . "\r\n\r\n" . trim($this->whoisData);
			
		} elseif ($server = $this->getServer()) {
			// use backup server
			$this->server = $server;
			$status = $this->lookup($this->fullWhois);
		} else { // else error with no server available
			$status = false;
		}

		return $status;
	}
	
	function Whois_Engine($domain, $ext) {
		$this->domain = $domain;
		if ($ext{0} == ".")
			$this->ext = substr($ext, 1);
		else
			$this->ext = $ext;
		// server id
		$this->server_id = 0;
		// find server
		$this->server = $this->getServer();
	}
	
	
	function getAllInfo() {
		
		foreach($this->nameserverArr as $nameserver => $array_val) {
			// if nameserver enabled
			if ($array_val['enabled']) {
				// fetch enabled extensions
				$extensions = explode(",", str_replace(" ", "", $array_val['extensions']));
				// add extensions to enabled array
				foreach($extensions as $current_ext) {
					$this->SERVERS_ENABLED[$current_ext][] = $nameserver;
					$this->SERVERS[$current_ext][] = $nameserver;
				}
			} else { // else assume nameserver is disabled
				// fetch enabled extensions
				$extensions = explode(",", str_replace(" ", "", $array_val['extensions']));
				
				// add extensions to disabled array
				foreach($extensions as $current_ext) {
					$this->SERVERS_DISABLED[$current_ext][] = $nameserver;
					$this->SERVERS[$current_ext][] = $nameserver;
				}
			}
			// fetch disabled extensions
			$disabled_extensions = explode(",", str_replace(" ", "", $array_val['extensions_disabled']));
			
			// add extensions to disabled array
			foreach($disabled_extensions as $current_ext) {
				$this->SERVERS_DISABLED[$current_ext][] = $nameserver;
				$this->SERVERS[$current_ext][] = $nameserver;
			}
		}
	}
	
	function validateDomain(&$domain, &$extensions, $silent = false) {
		// error result
		$validation_result = true;

		if (is_array($extensions))
			$ext = $extensions[0];
		else
			$ext = $extensions;

		// change to lowercase
		$ext = strtolower($ext);
		//$domain = strtolower($domain);

		// remove www
		$domain = preg_replace("/^www\./i", "", $domain);
		
		// remove if contains extension
		if (($end_str = strchr($domain, ".")) !== false) {
			if (in_array(substr(strtolower($end_str), 1), $this->getAllExtensions())) {
				$domain = str_replace($end_str, "", $domain);
				$extensions = array_merge(array(substr($end_str, 1)), $extensions);
			} else {
				$domain = substr($end_str, 1);
				// recursive
				$this->validateDomain($domain, $extensions);
			}
		}
		// build array of extension(s) for verification
		if (is_array($extensions))
			$extensions_to_verify = $extensions;
		else
			$extensions_to_verify = array($extensions);

		// get IDN representation
		foreach($extensions_to_verify as $current_extension) {
			if (($idn_domain = $this->getPunycode($domain, $current_extension)) !== false) {
				// check format
				if (!preg_match("!^[a-zA-Z0-9]+[a-zA-Z0-9-]*[a-zA-Z0-9]+$!", $idn_domain)) {
					$validation_result = false;
					if (!$silent)
						$this->errorMsg[] = ("domain_badformat");
				} elseif ($idn_domain == $domain) {
					$domain = strtolower($domain);
				}

				// check length
				if ((strlen($idn_domain) > 63) || (strlen($idn_domain) < 2)) {
					$validation_result = false;
					if (!$silent)
						$this->errorMsg[] = "(domain_badlength)";
				}
			} else { // error (a false means IDN conversion failed)
				$validation_result = false;
				// bad format
				if (!$silent)
					$this->errorMsg[] = ("domain_badformat");
			}
		}

		return $validation_result;
	}
	
	function getAllServerNames() {
		$i = 0;
		while($this->getDomainServer($this->ext, $i) != false) {
			$this->allServers[] = $this->getDomainServer($this->ext, $i);
			$i++;
		}

		//return $this->allServers;
	}
	
	function getAllExtensions($alphabetize = "") {
		$allExtensionsKey = "default";

		if (empty($this->allExtensions[$allExtensionsKey])) {
			// if pulling enabled and disabled extensions
			if ($this->allServers)
				$this->allExtensions[$allExtensionsKey] = array_keys($this->SERVERS);
			else // if pulling only enabled
				$this->allExtensions[$allExtensionsKey] = array_keys($this->SERVERS_ENABLED);
		}

		return $this->allExtensions[$allExtensionsKey];
	}
	
	function getPunycode($domain, $ext) {
		return $domain;
	}
	
	function fetchWhoisData($address, $port, $timeout, $request, &$data) {
		
		$request1 = $request."\r\n";
		
		//echo "$address, $port, $timeout, $request";
		//exit;
		$addressArr = explode("----", $address);
		if($addressArr[0] == "curl") {
			$command = str_replace("--domainname--", $request, $addressArr[1]);
			exec("/usr/bin/curl ".$command, $arg1, $arg2);
			if(is_array($arg1) && count($arg1)>0) {
				if(isset($addressArr[2]) && $addressArr[2]=="html") {
					$data = implode("", $arg1);
				} else {
					$data = implode("<br />", $arg1);
				}
			}
			return true;
		} else {
			$whoisSocket = fsockopen($address, $port, $errno, $errstr, $timeout);
			if (!$whoisSocket) {
				return false;
			} else {
				fputs($whoisSocket, $request1);
				while(!feof($whoisSocket))
					$data .= fgets($whoisSocket, 16384 );
				fclose($whoisSocket);
				return true;
			}
		}
	}
	
	function generateWhoisRequest(&$request, &$used_limit) {
		// if not full whois and limit bypass enabled and limit format is set
		if ($this->SCRIPT['limit_bypass'] && !$this->fullWhois
			&& !empty($this->nameserverArr[$this->server]['limit_format'])) {
			$used_limit = true;

			// strip slashes & use custom query
			$request = stripcslashes(
				str_replace("[[QUERY]]", $this->nameserverArr[$this->server]['limit_format'], $this->nameserverArr[$this->server]['advanced_limit_custom_query'])
				);
		} else { // use normal format
			$used_limit = false;

			// strip slashes & use custom query
			$request = stripcslashes(
				str_replace("[[QUERY]]", $this->nameserverArr[$this->server]['format'], $this->nameserverArr[$this->server]['advanced_custom_query'])
				);
		}

		// replace templates with actual data
		$request = str_replace("[[DOMAIN]]", $this->getPunycode($this->domain, $this->ext), $request);
		$request = str_replace("[[EXT]]", $this->ext, $request);
		$request = str_replace("[[SERVER]]", $this->server, $request);
		return $request;
	}
	
	function processAvailable($used_limit) {
		// determine matching type
		if (strpos($this->nameserverArr[$this->server][($used_limit ? "limit_keyword" : "keyword")], "!!!") === 0) {
			$opposite = true;
			$keyword = substr($this->nameserverArr[$this->server][($used_limit ? "limit_keyword" : "keyword")], 3);
		} else {
			$opposite = false;
			$keyword = $this->nameserverArr[$this->server][($used_limit ? "limit_keyword" : "keyword")];
		}
		// determine if available
		if (preg_match("!$keyword!i", $this->whoisData))
			$this->available = true && !$opposite;
		else
			$this->available = false || $opposite;
	}
	
	function getServer() {
		if ($this->getDomainServer($this->ext, $this->server_id) != false) {
			$server = $this->getDomainServer($this->ext, $this->server_id);
			$this->server_id++;
		} else {
			$server = false;
		}
		return $server;
	}
	function getDomainServer($ext, $id) {
		// if all servers
		if (isset($this->SERVERS[$ext][$id]) && $this->allServers)
			return $this->SERVERS[$ext][$id];
		else if (isset($this->SERVERS_ENABLED[$ext][$id]) && !$this->allServers) // only enabled servers
			return $this->SERVERS_ENABLED[$ext][$id];
		else // if no more servers
			return false;
	}
}

?>