<?php
error_reporting(1);

// get page
$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'none';
$plugin_url = isset($_REQUEST['plugin_url']) ? $_REQUEST['plugin_url'] : '';
$theRules = isset($_REQUEST['rules']) ? $_REQUEST['rules'] : array();

// valid request actions
$validActions = array('print-panel', 'seocheck');

// return as invalid action
if(!in_array($action, $validActions)){
	die('error: invalid action!');
}

// call WP Database main class from global
global $wpdb;

// swich throw actions
if($_REQUEST['action'] == 'print-panel'){
	
	$primary_key = isset($_REQUEST['primary_key']) ? $_REQUEST['primary_key'] : '';
	
	// Turn on output buffering
	ob_start();
	require_once( 'box-check.php' );
	
	// copy current buffer contents into $theHtml variable and delete current output buffer 
	$theHtml = str_replace("{plugin_url}", $plugin_url, ob_get_clean());
	//echo $theHtml  . '<br />' . PHP_EOL;echo __FILE__ . ":" . __LINE__;die . PHP_EOL;    // temp
	
	die( json_encode(array(
		'status' 	=> 'valid',
		'html'		=> $theHtml
	)) );
}

elseif ($_REQUEST['action'] == 'seocheck'){
	
	require_once( 'classes/seo.class.php' );
	$smartSeo = smartSeo::getInstance();
	
	$recives = array(
		'keyword'            => $_REQUEST['primary_keyword'],
		'meta_title'         => $_REQUEST['meta_title'],
		'meta_description'   => $_REQUEST['meta_description'],
		'meta_keywords'      => $_REQUEST['meta_keywords'],
		'content'            => $_REQUEST['content']
	);

	// defautl set all to false
	$scoreArray = array(
		'in_title' => 0,
		'in_desc' => 0,
		'in_key' => 0,
		'h1' => 0,
		'h2' => 0,
		'h3' => 0,
		'fontsize' => 0,
		'alt'  => 0
	);

	if(trim($recives['keyword']) == ""){
		// print as json
		echo json_encode($scoreArray);
		die;
	}

	// Keyword in title tag
	$__['in_title'] = $smartSeo->rule_keyword_in_string($recives['meta_title'], $recives['keyword']);
	if($__['in_title'] > 0){
		$scoreArray['in_title'] = 1;
	}

	// Keywords in description
	$__['in_desc'] = $smartSeo->rule_keyword_in_string($recives['meta_description'], $recives['keyword']);
	if($__['in_desc'] > 0){
		$scoreArray['in_desc'] = 1;
	}

	// Keywords in keywords
	$__['in_key'] = $smartSeo->rule_keyword_in_string($recives['meta_keywords'], $recives['keyword']);
	if($__['in_key'] > 0){
		$scoreArray['in_key'] = 1;
	}

	// Keywords in H1
	$__['h1'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'h1');
	if($__['h1'] > 0){
		$scoreArray['h1'] = 1;
	}

	// Keywords in H2
	$__['h2'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'h2');
	if($__['h2'] > 0){
		$scoreArray['h2'] = 1;
	}

	// Keywords in H3
	$__['h3'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'h3');
	if($__['h3'] > 0){
		$scoreArray['h3'] = 1;
	}

	// Keywords in fontsize
	$__['keyword_meta_b'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'b');
	$__['keyword_meta_bold'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'bold');
	$__['keyword_meta_strong'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'strong');
	$__['keyword_meta_em'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'em');
	if($__['fontsize'] > 0 ||
			$__['keyword_meta_bold'] > 0 ||
			$__['keyword_meta_strong'] > 0 ||
			$__['keyword_meta_em'] > 0 ||
			$__['keyword_meta_b'] > 0
	   ){
		$scoreArray['fontsize'] = 1;
	}

	// Keywords in H3
	$__['alt'] = $smartSeo->rule_keyword_in_tag($recives['content'], $recives['keyword'], 'img_alt');
	if($__['alt'] > 0){
		$scoreArray['alt'] = 1;
	}

	// Keywords density
	$__['thedensity'] = $smartSeo->count_occurences($recives['content'], $recives['keyword'], false);
	$wordsCount = $smartSeo->word_count($recives['content']);
	$density = ($__['thedensity'] / $wordsCount) * 100;
	$density = number_format($density, 1);
	$scoreArray['thedensity'] = $density;

	// print as json
	die( json_encode(array(
		'status' 	=> 'valid',
		'array'		=> $scoreArray
	)) );
}