<?php

  /**
   * Text document version activity log callback
   * 
   * @package activeCollab.modules.files
   * @subpackage models
   */
  class TextDocumentVersionCreatedActivityLogCallback extends ParentActivityLogCallback {
    
    /**
     * Construct callback
     */
    function __construct() {
    	$interface = AngieApplication::getPreferedInterface();

      $this->setRssSubjectWithTarget(lang('New version of :name text document in :target_name project created'));
      $this->setRssSubjectWithoutTarget(lang('New version of :name text document created'));
    	
    	if($interface == AngieApplication::INTERFACE_DEFAULT) {
    		$this->setWithTargetLang(lang('New version of <a href=":url" title=":name">:name_short</a> text document in <a href=":target_url" title=":target_name">:target_name_short</a> project created'));
      	$this->setWithoutTargetLang(lang('New version of <a href=":url" title=":name">:name_short</a> text document created'));
    	} elseif($interface == AngieApplication::INTERFACE_PHONE) {
    		$this->setWithTargetLang(lang('New version of :name text document in :target_name project created'));
      	$this->setWithoutTargetLang(lang('New version of :name text document created'));
    	} elseif($interface == AngieApplication::INTERFACE_PRINTER) {
    		$this->setWithTargetLang(lang('New version of :name text document in :target_name project created'));
      	$this->setWithoutTargetLang(lang('New version of :name text document created'));
    	} // if
      
      $this->setActionNameLang(lang('New Version'));
    } // __construct
    
  }