{object object=$active_invoice user=$logged_user show_inspector=false}
	<div class="invoice">
	  <div class="invoice_content">
	    <div class="invoice_data">
	    	<ul class="properties">
	        <li class="property">
	          <span class="property_title"></span>
	          <span class="property_data invoice_name">{$active_invoice->getName()}</span>
	        </li>
	        
	        <li class="property">
	          <span class="property_title">{lang}Currency{/lang}</span>
	          <span class="property_data">{$active_invoice->getCurrencyCode()}</span>
	        </li>
	        
	        {assign var=project value=$active_invoice->getProject() instanceof Project}
	        <li class="property {if !$project}hidden{/if}">
	          <span class="property_title">{lang}Project{/lang}</span>
	          <span class="property_data">{if $active_invoice->getProject() instanceof Project}{object_link object=$active_invoice->getProject()}{/if}</span>
	        </li>
	        
	        <li class="property">
	          <span class="property_title">{lang}Created On{/lang}</span>
	          <span class="property_data">{$active_invoice->getCreatedOn()|date}</span>
	        </li>
	        
					{if $active_invoice->getStatus() == $smarty.const.INVOICE_STATUS_ISSUED}
	        <li class="property">
	          <span class="property_title">{lang}Issued On{/lang}</span>
	          <span class="property_data">{$active_invoice->getIssuedOn()|date}</span>
	        </li>
					{/if}
					
					{assign var=due_on value=$active_invoice->getDueOn()}
	        <li class="property {if !$due_on}hidden{/if}">
	          <span class="property_title">{lang}Payment Due On{/lang}</span>
	          <span class="property_data">{$active_invoice->getDueOn()|date}</span>
	        </li>
	        
	        {if $active_invoice->getStatus() == $smarty.const.INVOICE_STATUS_PAID}
	        <li class="property">
	          <span class="property_title">{lang}Paid On{/lang}</span>
	          <span class="property_data">{$active_invoice->getClosedOn()|date}</span>
	        </li>
					{/if}
					
					{assign var=closed_on value=$active_invoice->getClosedOn() instanceof DateValue}
	        <li class="property {if !$closed_on}hidden{/if}">
	          <span class="property_title">{lang}Closed On{/lang}</span>
	          <span class="property_data">{$active_invoice->getClosedOn()|date}</span>
	        </li>
	        
	        <li class="property company_name">
	          <span class="property_title">Company</span>
	          <span class="property_data">{company_link company=$active_invoice->getCompany()}</span>
	        </li>
	        
	        <li class="property company_address">
	          <span class="property_title"></span>
	          <span class="property_data">{$active_invoice->getCompanyAddress()|clean|nl2br nofilter}</span>
	        </li>
	      </ul>
	    </div>
			
			<div class="invoice_paper_items">
		    {if is_foreachable($active_invoice->getItems())}
		      <table cellspacing="0" >
		        <thead>
		          <tr>
		            <td class="description">{lang}Description{/lang}</td>
		            <td class="unit_cost">{lang}Unit Cost{/lang}</td>
		            <td class="quantity">{lang}Qty.{/lang}</td>
		            <td class="tax_rate">{lang}Tax{/lang}</td>
		            <td class="total">{lang}Total{/lang}</td>
		          </tr>
		        </thead>
		        <tbody>
		        {foreach from=$active_invoice->getItems() item=invoice_item}
		          <tr class="{cycle values='odd,even'}">
		            <td class="description">{$invoice_item->getDescription()}</td>
		            <td class="unit_cost">{$invoice_item->getUnitCost()|money}</td>
		            <td class="quantity">{$invoice_item->getQuantity()|money}</td>
		            <td class="tax_rate">{$invoice_item->getTaxRateName()}</td>
		            <td class="total">{$invoice_item->getTotal()|money}</td>
		          </tr>
		        {/foreach}
		        </tbody>
		        <tfoot>
		          <tr>
		            <td colspan="4" class="label">{lang}Subtotal{/lang}</td>
		            <td class="value"><span class="property_wrapper property_invoice_subtotal">{$active_invoice->getTotal()|money}</span></td>
		          </tr>
		          <tr>
		            <td colspan="4" class="label">{lang}Tax{/lang}</td>
		            <td class="value"><span class="property_wrapper property_invoice_tax">{$active_invoice->getTax()|money}</span></td>
		          </tr>
		          <tr class="total">
		            <td colspan="4" class="label">{lang}Total{/lang}</td>
		            <td class="value total"><span class="property_wrapper property_invoice_total">{$active_invoice->getTaxedTotal()|money}</span></td>
		          </tr>
		        </tfoot>
		      </table>
		    {else}
		      <p class="empty_page"><span class="inner">{lang}This invoice has no items{/lang}</span></p>
		    {/if}
	    </div>
	    
	    <div class="invoice_comment" style="display: {if $active_invoice->getComment()}block{else}none{/if}">
	    	<h3>{lang}Comment{/lang}</h3>
	    	<p>{$active_invoice->getComment()}</p>
	    </div>
			
			<div class="invoice_paper_notes" style="display: {if $active_invoice->getNote()}block{else}none{/if}">
        <h3>{lang}Note{/lang}</h3>
        <p><span>{$active_invoice->getNote()|clean|nl2br nofilter}</span></p>
      </div>
	  </div>
	  
	  <div class="invoice_bottom"></div>
	  <div class="invoice_bottom_shadow_left"></div><div class="invoice_bottom_shadow_right"></div>
  </div>
{/object}