<?php

/**
 * on_load_control_tower event handler
 *
 * @package angie.frameworks.system
 * @subpackage handlers
 */

/**
 * Handle on_load_control_tower event
 *
 * @param ControlTower $control_tower
 * @param User $user
 */
function system_handle_on_load_control_tower(ControlTower &$control_tower, User &$user) {

  // ---------------------------------------------------
  //  Email to Comment
  // ---------------------------------------------------

  $reply_to_comment_label = null;
  if(ConfigOptions::getValue('control_tower_check_for_new_version')) {
    $control_tower->widgets()->add('check_for_new_version', array(
      'label' => lang('activeCollab Version'),
      'renderer' => function() {
        $current_version = AngieApplication::getVersion();
        $latest_version = ConfigOptions::getValue('latest_version');

        if ($current_version == 'current') {
          $version_info = '<p>' . lang('You are running development version of activeCollab') . '</p>';
          $version_info.= '<p class="control_tower_version_bubble_wrapper"><span class="control_tower_version_bubble development">' . lang('Development') . '</span></p>';
        } else if (version_compare($latest_version, $current_version) > 0) {
          $link_id = HTML::uniqueId('check_for_new_version');
          $version_info = '<p>' . lang('There is a new version of activeCollab available') . '</p>';
          $version_info.= '<p class="control_tower_version_bubble_wrapper"><a class="control_tower_version_bubble new_version_available" href="' . Router::assemble('new_version_details') . '" id="' . $link_id . '" title="' . lang('New Version Details') . '">' . $latest_version . '</a></p>';
          $version_info.= "<script type='text/javascript'>";
          $version_info.= "$('#" . $link_id . "').flyout({'width' : 'narrow', 'success' : function () { $('#context_popup.statusbar_item_control_tower_popup').remove();}});";
          $version_info.= "</script>";
        } else {
      
          $version_info.= '<p class="control_tower_version_bubble_wrapper"><span class="control_tower_version_bubble running_latest">' . $current_version . '</span></p>';
        } // if

        return '<div>' . $version_info . '</div>';
      }
    ));
  } // if

} // system_handle_on_load_control_tower