<?php
ob_start ("ob_gzhandler");
header("Content-type: text/css; charset: UTF-8");
header("Cache-Control: must-revalidate");
$expires_time = 1440;
$offset = 60 * $expires_time ;
$ExpStr = "Expires: " .
gmdate("D, d M Y H:i:s",
time() + $offset) . " GMT";
header($ExpStr);
                ?>

/*** template.css ***/

/*
Title:		AMMON main css file
Author:		mhogas@gmail.com // Marius Hogas 

*/

.rt-container {padding:0 10px; width:940px; background:none;}
.rt-alpha {margin-left:0;}
.rt-omega {margin-right:0;}
.rt-block {padding:0; margin-bottom:0;}
h1, h2 {letter-spacing:0;}
.module-title h2, h3, h4, h5 {letter-spacing: 0;}
h1, h2, h3, h4, h5 {margin-top:auto;}
ul, ol { padding-left:0; }
.rt-article {padding-bottom: 35px;}
.component-content td p { margin-bottom:15px; }


@font-face {
    font-family: 'CartoGothicStdBook';
    src: url('../fonts/CartoGothicStd-Book-webfont.eot');
    src: url('../fonts/CartoGothicStd-Book-webfont.eot?#iefix') format('embedded-opentype'),
         url('../fonts/CartoGothicStd-Book-webfont.woff') format('woff'),
         url('../fonts/CartoGothicStd-Book-webfont.ttf') format('truetype'),
         url('../fonts/CartoGothicStd-Book-webfont.svg#CartoGothicStdBook') format('svg');
    font-weight: normal;
    font-style: normal;
}
html {overflow-x:hidden; }

body { font-family: Arial, Helvetica, tahoma sans-serif; font-size:12px; line-height:1.6; color:#282828; background:#fff; }


/* Heading */
h1, h2, h3, h4, h5, h6 { font-weight:normal; color:#454545; line-height:1; }
h1{ font-size:2.5em; margin-bottom:15px; }
h2{ font-size:2.2em; margin-bottom:15px; }
h3{ font-size:1.9em; margin-bottom:15px; }
h4{ font-size:1.5em; margin-bottom:15px; }
h5{ font-size:1.5em; margin-bottom: 15px; padding:0px; font-style:italic; }
h6{ font-size:1.3em; margin-bottom: 15px; padding:0px; letter-spacing: 1px; }

/* links */
a { text-decoration:none; }
a:hover{ color:#555555; }
a img, img { border:none; vertical-align:top;}

/* paragraphs,blockquote,code */
p { margin-bottom:15px; }
blockquote { margin: 0 0 15px 0; color: #8a8a8a; font-style: italic; font-family: Georgia, "Times New Roman", Times, serif; line-height: 1.4em; font-size: 14px; }
blockquote p { line-height: 1.4em; font-size: 14px; }
blockquote small { font-size:12px }
code, pre { background:url(../images/code.png) #f7f7f7; padding: 0px 10px; display: block; font-size: 12px; color: #555; margin-bottom: 10px; border: 1px solid #ccc; clear: both; font:12px/1.5  Courier, "Courier New", monospace; white-space: pre; overflow:auto; }


/* Lists */
ol { margin: 20px 0 20px 25px; list-style-type: decimal; }
ol li { font-size: 12px; margin: 5px 0; padding-bottom: 5px; color: #666666; } 
ul { margin-bottom: 20px; }

/* CUSTOM LISTS */
.mainbody ul {list-style:disc; margin-left:15px; margin-bottom:20px;}
ul.list-type-1,ul.list-type-2,ul.list-type-3,ul.list-type-4,ul.list-type-5,ul.list-type-6,ul.list-type-7,ul.list-type-8,ul.list-type-9 {padding-left:0; margin-bottom:20px; margin-left:0px;}
ul.list-type-1 li {padding-left:15px; list-style:none; background:url(../images/bullet-list_01.png) no-repeat 0 0; line-height:20px;}
ul.list-type-2 li {padding-left:15px; list-style:none; background:url(../images/bullet-list_02.png) no-repeat 0 0; line-height:20px;}
ul.list-type-3 li {padding-left:15px; list-style:none; background:url(../images/bullet-list_03.png) no-repeat 0 0; line-height:20px;}
ul.list-type-4 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_04.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}
ul.list-type-5 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_05.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}
ul.list-type-6 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_06.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}
ul.list-type-7 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_07.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}
ul.list-type-8 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_08.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}
ul.list-type-9 li {padding-left:25px; list-style:none; background:url(../images/bullet-list_09.png) no-repeat 0 0; line-height:20px; margin-bottom:5px;}

.hlight_black25, .hlight {background-color:#dedede; padding:2px 4px; text-shadow:0 1px 0 #fff;}
.hlight_black50 {background-color:#bbb; padding:2px 4px; text-shadow:0 1px 0 #ddd; color:#222;}
.hlight_red {background-color:#A71216; padding:2px 4px; text-shadow:0 1px 0 rgba(0,0,0,0.5); color:#fff;}
.hlight_blue {background-color:#365985; padding:2px 4px; text-shadow:0 1px 0 rgba(0,0,0,0.5); color:#fff;}
.hlight_green {background-color: #1A7340; padding:2px 4px; text-shadow:0 1px 0 rgba(0,0,0,0.5); color:#fff;}
.hlight_yellow {background-color: #C9E047; padding:2px 4px; text-shadow:0 1px 0 #FFF; color:#333;}



.pre {font: 11px Courier, "Courier New", monospace; padding: 5px 5px 5px 15px; border: 1px solid #ccc; background:#efefef; -webkit-border-radius: 5px; -moz-border-radius:  5px; border-radius: 5px ; color: #333; line-height: 19px;overflow:auto;overflow-Y: hidden; clear:both; margin-bottom:20px;}

.separator {background:#f1f1f1; height: 2px;  margin: 0 0 35px; }

/* fancy shadows */
.block-img-shadow {display:inline-block; position:relative; } /* in case the image needs to be inserted into an article, it must be set to inline block */
.under-shadow {text-align:center;}

/* zoom overlay */
.head-image {padding:4px; border:1px solid #c0c0c0; }
a:hover img.head-image {border:1px solid #888;}
a .zoom-overlay {opacity:0; filter:alpha(opacity=0); display:block; width:100%; height:100%; background:url(../images/head-image-overlay.png) no-repeat center 50%; position:absolute; top:0;
-moz-transition: opacity 250ms ease-in;
-webkit-transition: opacity 250ms ease-in;
-o-transition: opacity 250ms ease-in;
transition: opacity 250ms ease-in;
}
a:hover .zoom-overlay {opacity:1; filter:alpha(opacity=100);}

img.shadow {padding:4px; border:1px solid #ededed;-webkit-border-radius: 2px;-moz-border-radius: 2px;border-radius: 2px; -webkit-transition: all .3s ease; -moz-transition: all .3s ease; -o-transition: all .3s ease; transition: all .3s ease; }


/* buttons variation */
.btn-style1 { background: #e3e3e3; border: 1px solid #bbb; -moz-border-radius: 3px; -webkit-border-radius: 3px; border-radius: 3px; -moz-box-shadow: inset 0 0 1px 1px #f6f6f6; -webkit-box-shadow: inset 0 0 1px 1px #f6f6f6; box-shadow: inset 0 0 1px 1px #f6f6f6; color: #333; font-family: "helvetica neue", helvetica, arial, sans-serif; font-size: 12px; line-height: 1; padding: 4px 8px; text-align: center; text-shadow: 0 1px 0 #fff; }
.btn-style1.rounded { -moz-border-radius: 12px; -webkit-border-radius: 12px; border-radius: 12px; padding-left:13px; padding-right:13px; }
.btn-style1:hover { background: #d9d9d9; -moz-box-shadow: inset 0 0 1px 1px #eaeaea; -webkit-box-shadow: inset 0 0 1px 1px #eaeaea; box-shadow: inset 0 0 1px 1px #eaeaea; color: #222; cursor: pointer; }
.btn-style1:active { background: #d0d0d0; -moz-box-shadow: inset 0 0 1px 1px #e3e3e3; -webkit-box-shadow: inset 0 0 1px 1px #e3e3e3; box-shadow: inset 0 0 1px 1px #e3e3e3; color: #000; }
.btn-style2 { background: #eee; background: -moz-linear-gradient(top, #eee 0%, #ccc 100%); background: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#eee), to(#ccc)); border: 1px solid #ccc; border-bottom: 1px solid #bbb; -moz-border-radius: 3px; -webkit-border-radius: 3px; border-radius: 3px; color: #333; font-family: "Lucida Grande", "Lucida Sans Unicode", "Lucida Sans", Geneva, Verdana, sans-serif; font-size: 11px; font-weight: bold; line-height: 1; padding: 4px 8px; text-align: center; text-shadow: 0 1px 0 #eee; }
.btn-style2.rounded { -moz-border-radius: 12px; -webkit-border-radius: 12px; border-radius: 12px; padding-left:13px; padding-right:13px; }
.btn-style2:hover { background: #ddd; background: -moz-linear-gradient(top, #ddd 0%, #bbb 100%); background: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#ddd), to(#bbb)); border: 1px solid #bbb; border-bottom: 1px solid #999; cursor: pointer; text-shadow: 0 1px 0 #ddd; }
.btn-style2:active { border: 1px solid #aaa; border-bottom: 1px solid #888; -moz-box-shadow: inset 0 0 5px 2px #aaa, 0 1px 0 0 #eee; -webkit-box-shadow: inset 0 0 5px 2px #aaa, 0 1px 0 0 #eee; box-shadow: inset 0 0 5px 2px #aaa, 0 1px 0 0 #eee; }

.big-button {
background: #cccccc;
background: -moz-linear-gradient(top, #cccccc 0%, #bbbbbb 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#cccccc), color-stop(100%,#bbbbbb));
background: -webkit-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -o-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -ms-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#cccccc', endColorstr='#bbbbbb',GradientType=0 );
background: linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
color: #FFF;
cursor: pointer;
font-size: 19px;
font-weight: bold;
padding: 14px 25px;
overflow: visible;
display: inline-block;
text-decoration: none !important;
text-shadow: 0 1px 0 rgba(0,0,0,0.4);
-webkit-border-radius: 5px;
-moz-border-radius: 5px;
border-radius: 5px;
-webkit-box-shadow: inset 0 1px 1px rgba(255,255,255,0.3), inset 0 -1px 1px rgba(0,0,0,0.3), 0 5px 7px rgba(0,0,0,0.3);
-moz-box-shadow: inset 0 1px 1px rgba(255,255,255,0.3), inset 0 -1px 1px rgba(0,0,0,0.3), 0 5px 7px rgba(0,0,0,0.3);
box-shadow: inset 0 1px 1px rgba(255,255,255,0.3), inset 0 -1px 1px rgba(0,0,0,0.3), 0 5px 7px rgba(0,0,0,0.3);
}
.big-button:hover {
color:#fff;
background: #bbbbbb;
background: -moz-linear-gradient(top, #bbbbbb 0%, #cccccc 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#bbbbbb), color-stop(100%,#cccccc));
background: -webkit-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -o-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -ms-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#bbbbbb', endColorstr='#cccccc',GradientType=0 );
background: linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
}
.medium-button {
background: #cccccc;
background: -moz-linear-gradient(top, #cccccc 0%, #bbbbbb 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#cccccc), color-stop(100%,#bbbbbb));
background: -webkit-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -o-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -ms-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#cccccc', endColorstr='#bbbbbb',GradientType=0 );
background: linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
color: #FFF;
cursor: pointer;
font-size: 14px;
font-weight: bold;
padding: 8px 20px;
overflow: visible;
display: inline-block;
text-decoration: none !important;
text-shadow: 0 1px 0 rgba(0,0,0,0.4);
-webkit-border-radius: 5px;
-moz-border-radius: 5px;
border-radius: 5px;
-webkit-box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
-moz-box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
}
.medium-button:hover {
color:#fff;
background: #bbbbbb;
background: -moz-linear-gradient(top, #bbbbbb 0%, #cccccc 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#bbbbbb), color-stop(100%,#cccccc));
background: -webkit-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -o-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -ms-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#bbbbbb', endColorstr='#cccccc',GradientType=0 );
background: linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
}

.small-button {
background: #cccccc;
background: -moz-linear-gradient(top, #cccccc 0%, #bbbbbb 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#cccccc), color-stop(100%,#bbbbbb));
background: -webkit-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -o-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
background: -ms-linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#cccccc', endColorstr='#bbbbbb',GradientType=0 );
background: linear-gradient(top, #cccccc 0%,#bbbbbb 100%);
color: #FFF;
cursor: pointer;
font-size: 12px;
font-weight: bold;
padding: 4px 12px;
overflow: visible;
display: inline-block;
text-decoration: none !important;
text-shadow: 0 1px 0 rgba(0,0,0,0.4);
-webkit-border-radius: 5px;
-moz-border-radius: 5px;
border-radius: 5px;
-webkit-box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
-moz-box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
box-shadow:0 1px 1px rgba(255, 255, 255, 0.3) inset, 0 -1px 1px rgba(0, 0, 0, 0.3) inset, 0 2px 4px rgba(0, 0, 0, 0.3);
}
.small-button:hover {
color:#fff;
background: #bbbbbb;
background: -moz-linear-gradient(top, #bbbbbb 0%, #cccccc 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#bbbbbb), color-stop(100%,#cccccc));
background: -webkit-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -o-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
background: -ms-linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#bbbbbb', endColorstr='#cccccc',GradientType=0 );
background: linear-gradient(top, #bbbbbb 0%,#cccccc 100%);
}

/* Gradient Colors */
.blue { 
background: #2e9fd8;
background: -moz-linear-gradient(top, #2e9fd8 0%, #0c72a4 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#2e9fd8), color-stop(100%,#0c72a4));
background: -webkit-linear-gradient(top, #2e9fd8 0%,#0c72a4 100%);
background: -o-linear-gradient(top, #2e9fd8 0%,#0c72a4 100%);
background: -ms-linear-gradient(top, #2e9fd8 0%,#0c72a4 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#2e9fd8', endColorstr='#0c72a4',GradientType=0 );
background: linear-gradient(top, #2e9fd8 0%,#0c72a4 100%);
}
a.blue:hover {
background: #0c72a4;
background: -moz-linear-gradient(top, #0c72a4 0%, #2e9fd8 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#0c72a4), color-stop(100%,#2e9fd8));
background: -webkit-linear-gradient(top, #0c72a4 0%,#2e9fd8 100%);
background: -o-linear-gradient(top, #0c72a4 0%,#2e9fd8 100%);
background: -ms-linear-gradient(top, #0c72a4 0%,#2e9fd8 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#0c72a4', endColorstr='#2e9fd8',GradientType=0 );
background: linear-gradient(top, #0c72a4 0%,#2e9fd8 100%);
}
.green {
background: #b7df63;
background: -moz-linear-gradient(top, #b7df63 0%, #74ab00 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#b7df63), color-stop(100%,#74ab00));
background: -webkit-linear-gradient(top, #b7df63 0%,#74ab00 100%);
background: -o-linear-gradient(top, #b7df63 0%,#74ab00 100%);
background: -ms-linear-gradient(top, #b7df63 0%,#74ab00 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#b7df63', endColorstr='#74ab00',GradientType=0 );
background: linear-gradient(top, #b7df63 0%,#74ab00 100%);
}
a.green:hover {
background: #74ab00;
background: -moz-linear-gradient(top, #74ab00 0%, #b7df63 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#74ab00), color-stop(100%,#b7df63));
background: -webkit-linear-gradient(top, #74ab00 0%,#b7df63 100%);
background: -o-linear-gradient(top, #74ab00 0%,#b7df63 100%);
background: -ms-linear-gradient(top, #74ab00 0%,#b7df63 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#74ab00', endColorstr='#b7df63',GradientType=0 );
background: linear-gradient(top, #74ab00 0%,#b7df63 100%);
}
.yellow {
background: #ffd700;
background: -moz-linear-gradient(top, #ffd700 0%, #ffaf00 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffd700), color-stop(100%,#ffaf00));
background: -webkit-linear-gradient(top, #ffd700 0%,#ffaf00 100%);
background: -o-linear-gradient(top, #ffd700 0%,#ffaf00 100%);
background: -ms-linear-gradient(top, #ffd700 0%,#ffaf00 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ffd700', endColorstr='#ffaf00',GradientType=0 );
background: linear-gradient(top, #ffd700 0%,#ffaf00 100%);
}
a.yellow:hover {
background: #ffaf00;
background: -moz-linear-gradient(top, #ffaf00 0%, #ffd700 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffaf00), color-stop(100%,#ffd700));
background: -webkit-linear-gradient(top, #ffaf00 0%,#ffd700 100%);
background: -o-linear-gradient(top, #ffaf00 0%,#ffd700 100%);
background: -ms-linear-gradient(top, #ffaf00 0%,#ffd700 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ffaf00', endColorstr='#ffd700',GradientType=0 );
background: linear-gradient(top, #ffaf00 0%,#ffd700 100%);
}
.red{
background: #d11313;
background: -moz-linear-gradient(top, #d11313 0%, #a30a0a 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#d11313), color-stop(100%,#a30a0a));
background: -webkit-linear-gradient(top, #d11313 0%,#a30a0a 100%);
background: -o-linear-gradient(top, #d11313 0%,#a30a0a 100%);
background: -ms-linear-gradient(top, #d11313 0%,#a30a0a 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#d11313', endColorstr='#a30a0a',GradientType=0 );
background: linear-gradient(top, #d11313 0%,#a30a0a 100%);
}
a.red:hover  {
background: #a30a0a;
background: -moz-linear-gradient(top, #a30a0a 0%, #d11313 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#a30a0a), color-stop(100%,#d11313));
background: -webkit-linear-gradient(top, #a30a0a 0%,#d11313 100%);
background: -o-linear-gradient(top, #a30a0a 0%,#d11313 100%);
background: -ms-linear-gradient(top, #a30a0a 0%,#d11313 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#a30a0a', endColorstr='#d11313',GradientType=0 );
background: linear-gradient(top, #a30a0a 0%,#d11313 100%);
}


/* warning boxes */
.info, .success, .warning, .error { border: 1px solid; margin: 10px 0px; padding:15px 10px 15px 50px; background-repeat: no-repeat; background-position: 10px center; }
.info { color: #00529B; background-color: #BDE5F8; background-image: url('../images/icon-info.png'); }
.success { color: #4F8A10; background-color: #DFF2BF; background-image:url('../images/icon-tick.png'); }
.warning { color: #9F6000; background-color: #FEEFB3; background-image: url('../images/icon-warning.png'); }
.error { color: #D8000C; background-color: #FFBABA; background-image: url('../images/icon-cross.png'); }

/* Selections */
::-moz-selection { color: #fff !important; }
::selection { color: #fff !important; }

/* INPUT, TEXTAREA, SUBMIT */
input {margin:0; padding:0;}
input[type=text], input[type=password],input[type=email], textarea { border:1px solid #e3e3e3; padding:7px; font-size:11px; color:#777; }
input[type=text], input[type=password],input[type=email], textarea, select { background: #ffffff;
background: -moz-linear-gradient(top, #ffffff 0%, #f4f4f4 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(100%,#f4f4f4));
background: -webkit-linear-gradient(top, #ffffff 0%,#f4f4f4 100%);
background: -o-linear-gradient(top, #ffffff 0%,#f4f4f4 100%);
background: -ms-linear-gradient(top, #ffffff 0%,#f4f4f4 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ffffff', endColorstr='#f4f4f4',GradientType=0 );
background: linear-gradient(top, #ffffff 0%,#f4f4f4 100%);
-webkit-transition: all .3s ease; -moz-transition: all .3s ease; -o-transition: all .3s ease; transition: all .3s ease;
outline:0 none !important;
}
input[type=text].rounded, input[type=password].rounded,input[type=email].rounded , textarea.rounded, select.rounded, input[type=submit].rounded, button.rounded {-webkit-border-radius:3px; -moz-border-radius:3px; border-radius:3px;  }
input[type=text]:hover, input[type=password]:hover ,input[type=email]:hover, textarea:hover { border:1px solid #b4b4b4; }

input[type=submit], button { padding: 4px 14px; color:#fff; text-shadow:0 1px 0 rgba(0,0,0,0.5); text-transform:uppercase; cursor:pointer; border:1px solid #444;
-webkit-box-shadow: 0 2px 6px rgba(255, 255, 255, 0.5) inset; -moz-box-shadow: 0 2px 6px rgba(255, 255, 255, 0.5) inset; box-shadow: 0 2px 6px rgba(255, 255, 255, 0.5) inset; }
input[type=submit]:hover, button:hover { -webkit-box-shadow: 0 0 3px rgba(0, 0, 0, 0.4), 0 -2px 6px rgba(255, 255, 255, 0.5) inset; -moz-box-shadow: 0 0 3px rgba(0, 0, 0, 0.4), 0 -2px 6px rgba(255, 255, 255, 0.5) inset; box-shadow: 0 0 3px rgba(0, 0, 0, 0.4), 0 -2px 6px rgba(255, 255, 255, 0.5) inset;}
input[type=submit]:active, button:active {-webkit-box-shadow: 0 2px 6px rgba(0, 0, 0, 0.5) inset; -moz-box-shadow: 0 2px 6px rgba(0, 0, 0, 0.5) inset; box-shadow: 0 2px 6px rgba(0, 0, 0, 0.5) inset;}
/* you can activate the rounded fields only setting the .rounded-fields class to the parent form */
.rounded-fields input[type=text], .rounded-fields input[type=password], .rounded-fields input[type=email], .rounded-fields textarea, .rounded-fields select, .rounded-fields input[type=submit], .rounded-fields button {-webkit-border-radius:3px; -moz-border-radius:3px; border-radius:3px;  }

select {padding:7px; border:1px solid #e3e3e3;}
select:hover { border:1px solid #b4b4b4; }

form > div {margin-bottom:15px;}
form label {color:#454545;}

.infield form > div, form.infield > p {position:relative;}
.infield form label {position:absolute; left:7px; top:5px; font-size:11px; color:#888;}

.form-preset input[type=text], .form-preset input[type=password] {width:240px;}
.form-preset textarea {width:450px;}

/* READON BUTTON */
.readon {color: #fff;font-size: 13px;font-weight: normal;padding: 3px 6px;text-shadow: 1px 1px 0 #555555;}
.readon:hover {color:#fff; background-image:url(../images/transparent_png/black10.png); }
.readon:active {color:#fff; background-image:url(../images/transparent_png/black20.png); }

/* 404 ERROR */
.error404 {font-weight:bold; font-size: 220px; line-height:1; color:#CCC; text-align:center; text-shadow: 0 0 1px #000; text-transform:uppercase; margin:40px 0;}
.error404 span {display:block;}
.error404 p {font-size:30px;}

/* CLEAR FIX - http://nicolasgallagher.com/micro-clearfix-hack/ */
.clear:before, .clear:after {content:""; display:table;}
.clear:after {clear:both;}
.clear {zoom:1;}

/* SPACING HELPERS - in case you need some extra spaces and you don't want to use empty paragraphs */
.space1 { height: 1px; }
.space2 { height: 2px; }
.space3 { height: 3px; }
.space4 { height: 4px; }
.space5 { height: 5px; }
.space6 { height: 6px; }
.space7 { height: 7px; }
.space8 { height: 8px; }
.space9 { height: 9px; }
.space10 { height: 10px; }
.space11 { height: 11px; }
.space12 { height: 12px; }
.space13 { height: 13px; }
.space14 { height: 14px; }
.space15 { height: 15px; }
.space16 { height: 16px; }
.space17 { height: 17px; }
.space18 { height: 18px; }
.space19 { height: 19px; }
.space20 { height: 20px; }
.space21 { height: 21px; }
.space22 { height: 22px; }
.space23 { height: 23px; }
.space24 { height: 24px; }
.space25 { height: 25px; }
.space26 { height: 26px; }
.space27 { height: 27px; }
.space28 { height: 28px; }
.space29 { height: 29px; }
.space30 { height: 30px; }

/* ACCORDION - Tutorial by Soh Tanaka - http://www.sohtanaka.com/web-design/easy-toggle-jquery-tutorial/ */
.acc_trigger {padding: 0; margin: 0; width:100%; display:block; background:url(../images/acc_style_1_arr_closed.png) no-repeat right center; }
.acc_trigger.active {background:url(../images/acc_style_1_arr_opened.png) no-repeat right center;}
.acc_container { margin: 0 0 5px; padding: 0; overflow: hidden; clear: both; }
.acc_wrapper {border-bottom:1px solid #ccc;}

.accordion-style-1 {margin-bottom:25px;}
.accordion-style-1 .acc_trigger {font-size:22px; line-height:2.5; }
.accordion-style-1 .acc-item {border-bottom:1px solid #ccc;}

.accordion-style-2 {background:#f6f6f6; border:1px solid #dfdfdf; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; width:600px; margin-bottom:25px; }
.accordion-style-2 .acc_trigger {border-bottom:1px solid #dfdfdf; line-height:2.8; font-weight:bold; text-shadow:0 1px 0 #fff; color:#6e6e6e; width:auto;
background: #fafafa;
background: -moz-linear-gradient(top, #fafafa 0%, #e6e6e6 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#fafafa), color-stop(100%,#e6e6e6));
background: -webkit-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
background: -o-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
background: -ms-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#fafafa', endColorstr='#e6e6e6',GradientType=0 );
background: linear-gradient(top, #fafafa 0%,#e6e6e6 100%); }
.accordion-style-2 .acc_trigger span {display:block; padding:0 0 0 30px; background:url(../images/arr2.png) no-repeat 8px 13px; }
.accordion-style-2 .acc_trigger.active { color:#444; }
.accordion-style-2 .acc_trigger.active span {background:url(../images/arr2.png) no-repeat 8px -28px; }
.accordion-style-2 .acc-item.first .acc_trigger {
-webkit-border-top-left-radius: 4px; -moz-border-top-left-radius: 4px; border-top-left-radius: 4px;
-webkit-border-top-right-radius: 4px; -moz-border-top-right-radius: 4px; border-top-right-radius: 4px;}
.accordion-style-2 .acc-item.last .acc_trigger {border-bottom:0;
-webkit-border-bottom-left-radius: 4px; -moz-border-bottom-left-radius: 4px; border-bottom-left-radius: 4px;
-webkit-border-bottom-right-radius: 4px; -moz-border-bottom-right-radius: 4px; border-bottom-right-radius: 4px; }
.accordion-style-2 .acc_container {padding:20px 20px 0; border-bottom:1px solid #dfdfdf; margin:0; }
.accordion-style-2 .acc-item.last .acc_container {border-bottom:0; }


/* TOGGLES - Tutorial by Soh Tanaka - http://www.sohtanaka.com/web-design/easy-toggle-jquery-tutorial/*/
.tgg-trigger { padding: 0; margin: 0; width:100%; display:block; background:url(../images/acc_style_1_arr_closed.png) no-repeat right center; padding: 0; overflow: hidden; clear: both;  }
.tgg-trigger .active {background:url(../images/acc_style_1_arr_opened.png) no-repeat right center;}
.tgg_wrapper {border-bottom:1px solid #ccc;}

.toggle-style-1 {margin-bottom:25px;}
.toggle-style-1 .tgg-trigger {font-size:22px; line-height:2.5; }
.toggle-style-1 .tgg-item {border-bottom:1px solid #ccc;}

.toggle-style-2 {background:#f6f6f6; border:1px solid #dfdfdf; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; width:600px; margin-bottom:25px; }
.toggle-style-2 .tgg-trigger {border-bottom:1px solid #dfdfdf; line-height:2.8; font-weight:bold; text-shadow:0 1px 0 #fff; color:#6e6e6e; width:auto;
background: #fafafa;
background: -moz-linear-gradient(top, #fafafa 0%, #e6e6e6 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#fafafa), color-stop(100%,#e6e6e6));
background: -webkit-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
background: -o-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
background: -ms-linear-gradient(top, #fafafa 0%,#e6e6e6 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#fafafa', endColorstr='#e6e6e6',GradientType=0 );
background: linear-gradient(top, #fafafa 0%,#e6e6e6 100%); }
.toggle-style-2 .tgg-trigger span {display:block; padding:0 0 0 30px; background:url(../images/arr2.png) no-repeat 8px 13px; }
.toggle-style-2 .tgg-trigger.active { color:#444; }
.toggle-style-2 .tgg-trigger.active span {background:url(../images/arr2.png) no-repeat 8px -28px; }
.toggle-style-2 .tgg-item.first .tgg-trigger {
-webkit-border-top-left-radius: 4px; -moz-border-top-left-radius: 4px; border-top-left-radius: 4px;
-webkit-border-top-right-radius: 4px; -moz-border-top-right-radius: 4px; border-top-right-radius: 4px;}
.toggle-style-2 .tgg-item.last .tgg-trigger {border-bottom:0;
-webkit-border-bottom-left-radius: 4px; -moz-border-bottom-left-radius: 4px; border-bottom-left-radius: 4px;
-webkit-border-bottom-right-radius: 4px; -moz-border-bottom-right-radius: 4px; border-bottom-right-radius: 4px; }
.toggle-style-2 .toggle_container {padding:20px 20px 0; border-bottom:1px solid #dfdfdf; margin:0; }
.toggle-style-2 .tgg-item.last .toggle_container {border-bottom:0; }

.toggle-style-faq {border:1px solid #ddd; -webkit-border-radius:5px; -moz-border-radius:5px; border-radius:5px; color:#444; background-color:#eee; margin-bottom:30px; }
.toggle-style-faq .tgg-trigger {font-size:14px; line-height:1.8; padding:10px 15px 10px 40px; width:auto; border-top:1px solid #ddd; color:#444; background-image:url(../images/question_mark.gif); background-repeat:no-repeat; background-position:13px center; background-color:#fff;  }
.toggle-style-faq .tgg-trigger:first-child {border-top:0;} 
.toggle-style-faq .tgg-item.first .tgg-trigger {-webkit-border-top-left-radius: 5px; -moz-border-top-left-radius: 5px; border-top-left-radius: 5px;
-webkit-border-top-right-radius: 5px; -moz-border-top-right-radius: 5px; border-top-right-radius: 5px;}
.toggle-style-faq .tgg-item.last .tgg-trigger {-webkit-border-bottom-left-radius: 5px; -moz-border-bottom-left-radius: 5px; border-bottom-left-radius: 5px;
-webkit-border-bottom-right-radius: 5px; -moz-border-bottom-right-radius: 5px; border-bottom-right-radius: 5px; }
.toggle-style-faq .tgg-trigger.odd {background-color:#f5f5f5; text-shadow: 0 1px 0 white;} 
.toggle-style-faq .tgg-trigger.active {font-weight:bold; background-color:#eee;} 
.toggle-style-faq .tgg-trigger:hover {background-color:#eee;}
.toggle-style-faq .toggle_container {padding:15px;}

/* TABLES */
table.zebra-style {font-family:"Lucida Sans Unicode", "Lucida Grande", Sans-Serif; text-align:left; margin-bottom:25px;}
table.zebra-style th { color: #444; font-size: 14px; font-weight: normal; padding: 10px 8px; }
table.zebra-style td {color: #777;padding: 8px;}
table.zebra-style tr.odd {background:#f2f2f2;}

table.minimal-style { background: #FFFFFF; border-collapse: collapse; font-family: "Lucida Sans Unicode","Lucida Grande",Sans-Serif; font-size: 12px; text-align: left; min-width: 480px; margin-bottom:25px; }
table.minimal-style th { border-bottom: 2px solid #444; color: #666666; font-size: 14px; font-weight: normal; padding: 10px; }
table.minimal-style td { border-bottom: 1px solid #CCCCCC; color: #999; padding: 8px 10px; }
table.minimal-style tbody tr:hover td {color:#444;}

table.box-style {font-family:"Lucida Sans Unicode", "Lucida Grande", Sans-Serif;font-size:12px;min-width:480px;text-align:left;border-collapse:collapse;margin-bottom:25px; }
table.box-style th {font-size:14px;font-weight:normal;background:#ccc;border-top:4px solid #ddd;border-bottom:1px solid #fff;color:#666666;padding:10px;}
table.box-style td {background:#f9f9f9;border-bottom:1px solid #fff;color:#999;border-top:1px solid transparent;padding:8px 10px;}
table.box-style tr:hover td {background:#eee;color:#444;}

.onecol-style {font-family:"Lucida Sans Unicode", "Lucida Grande", Sans-Serif; font-size:12px; min-width:480px; text-align:left; border-collapse:separate !important; border-spacing:0; margin-bottom:25px;}
.onecol-style th {font-size:14px; font-weight:normal; color:#666666; padding:12px 15px;}
.onecol-style td {color:#999; border-top:1px solid #ccc; padding:10px 15px;}
.onecol-first {background:#dedede; border-right:10px solid transparent; border-left:10px solid transparent;}
.onecol-style tr:hover td {color:#444; background:#eee;}

.simple-style {border-top:1px solid #CFCFCF; border-left:1px solid #CFCFCF; border-right:0; border-bottom:0; width:100%;}
.simple-style td, .simple-style th {border-right:1px solid #CFCFCF; border-bottom:1px solid #CFCFCF; text-align:center; padding:5px 0; width:20%;}
.simple-style th {background-color:#dedede; font-size:120%;text-shadow: 0 1px 0 #fff;}
.simple-style tr:nth-child(even) {background: #fff;}
.simple-style tr:nth-child(odd) {background: #F6F6F6;}

/* STUFF */
.left-outline { padding:10px 20px 10px 10000px; margin: 0 0 25px -10000px; background:url('../php/rgba.php?name=black&a=40'); background:rgba(0,0,0,0.4); color:#fff; }
.right-outline { padding:10px 10000px 10px 20px; margin: 0 -10000px 25px 0 ; background:url('../php/rgba.php?name=black&a=40'); background:rgba(0,0,0,0.4); color:#fff; } 

/* STUFF */
.pricing-table {margin-bottom:35px; width:940px;}
.pricing-table.col3 .box {width:33.33%;}
.pricing-table.col4 .box {width:25%;}
.pricing-table.col5 .box {width:20%;}
.pricing-table.col6 .box {width:16.6%;}
.pricing-table .box {float:left; margin-top:7px; }
.pricing-table .box .box-inner {border:1px solid #dedede; padding:20px; text-align:center;
background: #f7f7f7;
background: -moz-linear-gradient(top, #f7f7f7 0%, #dedede 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#f7f7f7), color-stop(100%,#dedede));
background: -webkit-linear-gradient(top, #f7f7f7 0%,#dedede 100%);
background: -o-linear-gradient(top, #f7f7f7 0%,#dedede 100%);
background: -ms-linear-gradient(top, #f7f7f7 0%,#dedede 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f7f7f7', endColorstr='#dedede',GradientType=0 );
background: linear-gradient(top, #f7f7f7 0%,#dedede 100%); }
.pricing-table .first .box-inner  {-webkit-border-top-left-radius: 5px; -webkit-border-bottom-left-radius: 5px; -moz-border-radius-topleft: 5px; -moz-border-radius-bottomleft: 5px; border-top-left-radius: 5px; border-bottom-left-radius: 5px;}
.pricing-table .last .box-inner {-webkit-border-top-right-radius: 5px; -webkit-border-bottom-right-radius: 5px; -moz-border-radius-topright: 5px; -moz-border-radius-bottomright: 5px; border-top-right-radius: 5px; border-bottom-right-radius: 5px;}
.pricing-table .box .title {font-weight:700; font-size: 26px; line-height:1; margin-bottom:15px; text-shadow: 0 1px 0 rgba(255, 255, 255, 0.8), 0 2px 0 #CCCCCC; }
.pricing-table .box .price {font-size:3.5em; font-weight:700; letter-spacing:-1px; line-height:1; text-shadow: 0 1px 0 rgba(255, 255, 255, 0.8), 0 2px 0 #CCCCCC ; color:#454545; }
.pricing-table .box .price span.curr {font-size:0.6em; position:relative; top:-8px; }
.pricing-table .box .price-type {font-size:11px; color:#999;}
.pricing-table .box ul.description {margin:20px 0; text-shadow:0 1px 0 #fff; color:#454545; list-style:none; padding:0;}
.pricing-table .box ul.description li {line-height:19px;}
.pricing-table .box ul.description li a {line-height:19px; font-size:12px;}
.pricing-table .box .separator {margin:10px 0;}
.pricing-table .promoted .box-inner {border-width:7px; border-style:solid; position:relative; margin-top:-7px; margin-left:-7px; -webkit-border-radius:3px; -moz-border-radius:3px; border-radius:3px; -webkit-box-shadow:0 2px 15px rgba(0,0,0,0.2); -moz-box-shadow:0 2px 15px rgba(0,0,0,0.2); box-shadow:0 2px 15px rgba(0,0,0,0.33);  }
.pricing-table .box.promoted .box-inner  {
background: #dedede;
background: -moz-linear-gradient(top, #dedede 0%, #f7f7f7 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#dedede), color-stop(100%,#f7f7f7));
background: -webkit-linear-gradient(top, #dedede 0%,#f7f7f7 100%);
background: -o-linear-gradient(top, #dedede 0%,#f7f7f7 100%);
background: -ms-linear-gradient(top, #dedede 0%,#f7f7f7 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#dedede', endColorstr='#f7f7f7',GradientType=0 );
background: linear-gradient(top, #dedede 0%,#f7f7f7 100%); }
.pricing-table .action a {
padding: 9px 14px; color:#fff; text-shadow:0 1px 0 rgba(0,0,0,0.5); text-transform:uppercase;
-webkit-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(255, 255, 255, 0.5) inset; -moz-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(255, 255, 255, 0.5) inset; box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(255, 255, 255, 0.5) inset;
-webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; }
.pricing-table .action a:hover {
-webkit-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 -2px 6px rgba(255, 255, 255, 0.5) inset; -moz-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 -2px 6px rgba(255, 255, 255, 0.5) inset; box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 -2px 6px rgba(255, 255, 255, 0.5) inset;}
.pricing-table .action a:active {
-webkit-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(0, 0, 0, 0.5) inset; -moz-box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(0, 0, 0, 0.5) inset; box-shadow:0 0 1px rgba(0, 0, 0, 0.9) inset, 0 2px 6px rgba(0, 0, 0, 0.5) inset;}
.pricing-table .featured-badge {width:58px; height:51px; background:url(../images/featured-badge.png) no-repeat; top:-10px; right:-10px; position:absolute;}

.pricing-table .box.features .box-inner {border-right:none; background:#f5f5f5; text-align:left; margin-top:10px;}
.pricing-table .box.features .box-inner .title {margin-left:20px; text-shadow:none;}
.pricing-table .box.features .box-inner .price {font-size:1.6em; line-height:2.7; letter-spacing:0; margin-left:20px; text-shadow:none;}
.pricing-table .box.features ul.description {margin-left:20px;}
.pricing-table .box.features ul.description li .help { cursor:help;}

.pricing-table.orange-style {color:#EB540A;}
.pricing-table.orange-style .promoted .box-inner {border-color:#EB540A; }
.pricing-table.orange-style .action a { background-color:#EB540A; }
.pricing-table.blue-style {color:#08579C;}
.pricing-table.blue-style .promoted .box-inner {border-color:#08579C; }
.pricing-table.blue-style .action a { background-color:#08579C; }
.pricing-table.purple-style {color:#8A2D9A;}
.pricing-table.purple-style .promoted .box-inner {border-color:#8A2D9A; }
.pricing-table.purple-style .action a { background-color:#8A2D9A; }
.pricing-table.yellow-style {color:#FFC800;}
.pricing-table.yellow-style .promoted .box-inner {border-color:#FFC800; }
.pricing-table.yellow-style .action a { background-color:#FFC800; }
.pricing-table.turqoise-style {color:#12C6C2;}
.pricing-table.turqoise-style .promoted .box-inner {border-color:#12C6C2; }
.pricing-table.turqoise-style .action a { background-color:#12C6C2; }
.pricing-table.darkred-style {color:#C62B57;}
.pricing-table.darkred-style .promoted .box-inner {border-color:#C62B57; }
.pricing-table.darkred-style .action a { background-color:#C62B57; }
.pricing-table.red-style {color:#F02311;}
.pricing-table.red-style .promoted .box-inner {border-color:#F02311; }
.pricing-table.red-style .action a { background-color:#F02311; }
.pricing-table.green-style {color:#59A80F;}
.pricing-table.green-style .promoted .box-inner {border-color:#59A80F; }
.pricing-table.green-style .action a { background-color:#59A80F; }
.pricing-table.green-lemon-style {color:#9CC607;}
.pricing-table.green-lemon-style .promoted .box-inner {border-color:#9CC607; }
.pricing-table.green-lemon-style .action a { background-color:#9CC607; }

/* quotes */
.quotes {margin-top:40px; position:relative}
.quotes blockquote { margin-bottom: 40px; padding: 0 0 0 70px; position: relative; width: 90%; }
.quotes blockquote p { color: #444444; font-size: 18px; font-style: italic; margin: 0; }
blockquote { quotes:none;}
.quotes blockquote:before { color: #DDDDDD; content: "“"; display: block; font-size: 140px; font-family: Georgia, "Times New Roman", Times, serif; left: -10px; position: absolute; top: 40px; z-index: 3; }

/* PHOTO GALLERY */
ul.gallery {clear: both; list-style: none outside none; margin: 8px auto; overflow: hidden; padding: 8px 0;}
ul.gallery li {background:#FFFFFF; float: left; margin: 5px; padding: 0; list-style:none; }
ul.gallery li a img {padding:4px; border:1px solid #ededed;-webkit-border-radius: 2px;-moz-border-radius: 2px;border-radius: 2px; -webkit-transition: all .3s ease; -moz-transition: all .3s ease; -o-transition: all .3s ease; transition: all .3s ease; }
ul.gallery li a img:hover {-moz-box-shadow: 0 0 5px #EB540A;-webkit-box-shadow: 0 0 5px #EB540A; box-shadow: 0 0 5px #EB540A; border: 1px solid #EB540A;} 


/* MAIN */
#rt-logo { width:131px; height:50px; background: url(../images/logo/logo.png) 0 0 no-repeat; display:block; text-indent:-9999px; margin:10px 0; }

/* BEGIN TEMPLATE */
#rt-header {position:relative; z-index:9999; background:url('../php/rgba.php?name=black&a=60'); background:rgba(0,0,0,0.6); border-top:1px solid rgba(0,0,0,0.8); border-bottom:1px solid rgba(0,0,0,0.8); margin-top:20px;}
#rt-header .shadow-down {position:absolute; width:918px; height:20px; bottom:-20px; left:50%; margin-left:-459px; background:url(../images/shadow-down.png) no-repeat;}
#rt-header ul.menu {float:right; margin:0;}
#rt-header ul.menu li {float:left; margin-left:15px; padding-left:15px; background:url(../images/menu-separator.png) no-repeat left center; }
#rt-header ul.menu li:first-child {margin-left:0; padding-left:0; background:none;}
#rt-header ul.menu li a,
#rt-header ul.menu li span.separator {font:13px/1 'CartoGothicStdBook', arial, serif; color:#fff; text-shadow:1px 1px 0 #000; padding:28px 3px; display:block; text-transform:uppercase; opacity:0.8; filter:alpha(opacity=80); }
#rt-header ul.menu li span.separator {background:none; height:auto}
#rt-header ul.menu li a:hover,
#rt-header ul.menu li.active a,
#rt-header ul.menu li span.separator:hover,
#rt-header ul.menu li.active span.separator {opacity:1; filter:alpha(opacity=100);}
#rt-header ul.menu li .hover-mask {}
#rt-header ul.menu ul { background:url('../php/rgba.php?name=black&a=70'); background:rgba(0,0,0,0.7); margin-top:0px; }
#rt-header ul.menu ul li {margin:0; padding:0; background:none;}
#rt-header ul.menu ul li span.separator,
#rt-header ul.menu ul li a { font:12px/1  Arial, Helvetica, sans-serif; color:#ccc; padding:11px 10px; text-transform:none; display:block; margin:0 4px; border-top:1px solid #000; opacity:1; filter:alpha(opacity=100); }
#rt-header ul.menu ul li a:hover,
#rt-header ul.menu ul li.active a { color:#fff;}
#rt-header ul.menu ul li:first-child > a {border-top:none;}
#rt-header ul.menu li a > .sf-sub-indicator,
#rt-header ul.menu li span.separator > .sf-sub-indicator {top:3.6em !important; left:50%; margin-left:-5px; right:auto !important;}
#rt-header ul.menu li li a > .sf-sub-indicator,
#rt-header ul.menu li li span.separator > .sf-sub-indicator {top:50% !important; margin-top:-5px; left:95% !important;}
#rt-header .sf-menu > li:hover > ul,
#rt-header .sf-menu > li.sfHover > ul { top:5.9em;}


/* second header model styling */
.style2#rt-header {background-color:transparent; border:none;}
.style2#rt-header .shadow-down {display:none;}
.style2#rt-header ul.menu { background:url('../php/rgba.php?name=black&a=60'); background:rgba(0,0,0,0.6); padding:0 20px; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px;  }

/* third header model styling */
.style3#rt-header {background-color:transparent; border:none;}
.style3#rt-header .shadow-down {display:none;}
.style3#rt-header ul.menu { background:url('../php/rgba.php?name=black&a=60'); background:rgba(0,0,0,0.6); -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; padding:0px 10000px 0px 20px; margin: 0 -10000px 25px 0 ;  }


/* forth header model styling */
.style4#rt-header {background-color:transparent; border:none;}
.style4#rt-header .shadow-down {display:none;}
.style4#rt-header ul.menu {margin-top:12px;}
.style4#rt-header ul.menu > li {background:none; padding-left:0;}
.style4#rt-header ul.menu > li > a { background:url('../php/rgba.php?name=black&a=60'); background:rgba(0,0,0,0.6); padding:15px 10px; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px;  }
.style4#rt-header ul.menu li ul { -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px;  }
.style4#rt-header ul.menu li a > .sf-sub-indicator { top:2.2em !important;}
.style4#rt-header .sf-menu > li:hover > ul,
.style4#rt-header .sf-menu > li.sfHover > ul { top:3.9em;}

/* ICONS MENU (UNDER HEADER MENU) */
#icon-widgets {position:absolute; top:105px; right:50%; margin-right:-470px; z-index:2; background:url('../php/rgba.php?name=black&a=50'); background:rgba(0,0,0,0.5); -webkit-border-radius:3px; -moz-border-radius:3px; border-radius:3px;}
.icon-menu {float:right; margin:0; padding:0 3px;}
.icon-menu li {float:left; margin-left:3px; padding-left:3px; border-left:1px solid rgba(255,255,255,0.2); position:relative; overflow:hidden; list-style:none;}
.icon-menu li:first-child {margin-left:0; padding-left:0; border-left:0;}
.icon-menu li.social-icons > a,
.icon-menu li.search-box > a { display:block; width:25px; height:26px; margin:0; text-indent:-9999px; opacity:0.8; filter:alpha(opacity=80); float:left;}
.icon-menu li a:hover {opacity:1; filter:alpha(opacity=100);}
.icon-menu li.social-icons > a {background:url(../images/social-icons.png) no-repeat 50% 50%;}
.icon-menu li.search-box > a {background:url(../images/search-loupe.png) no-repeat 50% 50%;}
.icon-menu li.social-icons > a.opened {background:url(../images/close-icon-form-white.png) no-repeat 50% 50%;}
.icon-menu li.search-box > a.opened {background:url(../images/close-icon-form-white.png) no-repeat 50% 50%;}

#social-icons { padding:2px; height:20px; width:600px; position:absolute; margin-left:25px; left:0;  }
#social-icons .inner {float:left; padding-right:10px;}
#social-icons a {float:left; margin:3px; line-height:1;}

#search-box {position:absolute; margin-left:30px; left:0;}
#search-box input[type=text] {background:none; filter:none; border:none; margin:0; padding:0; color:#ddd; width:130px; height:25px;}
#search-box input[type=text]:focus {color:#fff; outline:none; -webkit-box-shadow:none; -moz-box-shadow:none; box-shadow:none; }

/* DEFAULTS */
#slideshow {height:358px;}
#container {top:189px; min-height:300px; width:100%; position:absolute;  }

#slideshow {position:absolute; top:0; left:0; z-index:-1; overflow: hidden; width:100%; background:url(../images/bg-slider.png) repeat-x center top #eb540a;}
#slideshow .shadow-up {position:absolute; width:918px; height:20px; bottom:169px; left:50%; margin-left:-459px; background:url(../images/shadow-up.png) no-repeat; z-index:1;}

/* PAGE TITLE */
#slideshow .page-title { line-height:1; padding:12px 20px 12px 10000px; margin: 0 0 0 -10000px; color:#fff; float:left; position:relative; left:0px; top:144px; width:920px; font-size:22px; font-weight: bold;  background:url('../php/rgba.php?name=black&a=40'); color:#eeeeee; background:rgba(0,0,0,0.4);  color:rgba(255,255,255,0.7); -webkit-border-top-right-radius: 3px; -moz-border-radius-topright: 3px; border-top-right-radius: 3px; }

.intro-text { font-size:20px; font-weight:bold; text-transform:uppercase; text-align:center; margin:30px 0; text-shadow:0px 1px 0 rgba(0,0,0,0.2), 0 0 5px #fff, 0 0 5px #fff, 0 0 5px #fff, 0 0 5px #fff, 0 0 10px #fff;}

/* MENU CHASER STYLES */
.forchaser {height:2px; display:block; position:relative;}
.chaser {background:#565656;  background:url('../php/rgba.php?name=black&a=75'); background:rgba(0,0,0,0.75); padding:0; position:fixed; right:0; top:0; width:100%; z-index: 999;}
.chaser ul.menu {float:none; display:block; margin:0 auto; padding:0 40px; max-width:960px;}
.chaser ul.menu > li {float:left; display:inline;}
.chaser ul.menu li a {color:#ddd;  font-size:12px; line-height:1;}
.chaser .sf-menu a.sf-with-ul {padding-right:25px;}
.chaser ul.menu li a:hover {color:#fff;}
.chaser ul.menu li ul { background:url('../php/rgba.php?name=black&a=75'); background:rgba(0,0,0,0.75); width:13em !important; }
.browserIE.browserIE7 .chaser {position:absolute; top:expression(documentElement.scrollTop);}
.chaser ul.sf-menu li li:hover ul,
.chaser ul.sf-menu li li.sfHover ul {left:13em !important;}

.bg-transparent {height:175px; width:100%; position:absolute; top:0; left:0; background:url(../images/bg-gradient.png) repeat-x 0 0; z-index:0;}

/* SLIDERS FROM THE SLIDESHOW DIV */
#swappers {height:50px; width:940px; margin-left: -470px; position:absolute; bottom:170px; left: 50%; z-index:300;}
.swapper {float:left; height:230px; top:0px; position:relative; padding:0 20px; color:#fff;}
#swappers .rt-grid-1 {width: 20px;}
#swappers .rt-grid-2 {width: 100px;}
#swappers .rt-grid-3 {width: 180px;}
#swappers .rt-grid-4 {width: 260px;}
#swappers .rt-grid-5 {width: 340px;}
#swappers .rt-grid-6 {width: 420px;}
#swappers .rt-grid-7 {width: 500px;}
#swappers .rt-grid-8 {width: 580px;}
#swappers .rt-grid-9 {width: 660px;}
#swappers .rt-grid-10 {width: 740px;}
#swappers .rt-grid-11 {width: 820px;}
#swappers .rt-grid-12 {width: 900px;}
.swapper .indicator {width:20px; height:20px; position:absolute; top:0; right:0; background:url(../images/swapper-indicator.png) no-repeat center bottom;}
.swapper .bgr {background-color:#000; opacity:0.5; filter:alpha(opacity=50); position:absolute; top:0; left:0; width:100%; height:100%; z-index:-1;}
.swapper p { opacity:0.5; filter:alpha(opacity=50); }
.swapper h3 {font-size:22px; line-height:2.4; border-bottom:1px solid #5a5a5a; text-shadow:1px 1px 0 #383838; text-transform:uppercase; color:#fff; text-align: center; }

/* FEATURES MODULES */
.feature-item {margin-bottom:35px;}
.feature-item h3 {font-size:20px; line-height:1;text-transform:uppercase; }
.feature-item img {float:left; margin:5px 15px 10px 0; opacity:.3; filter:alpha(opacity=30);}  
#rt-content-top .feature-item img {
opacity: .9;
filter: alpha(opacity=90);
}
/* EQUATION DIV */
.equation .box { min-height:150px; background:#eee; margin-bottom:35px; -webkit-border-radius:8px;  -moz-border-radius:8px; border-radius:8px; padding:15px; text-shadow:1px 1px 0 rgba(255,255,255,0.6);}
.equation .box:hover {background:#dedede;}
.equation .sign {display: block; font:400 90px/144px Arial, Helvetica, sans-serif;  margin-top: 20px; color:#ccc; text-align:center; }
.equation .box h4 { font:bold 13px/1 Arial, Helvetica, sans-serif; color:#444; text-transform:uppercase; }
.equation .box p, .equation .box ul { margin-bottom:0}

.breadcrumb {padding:20px 0; color: #333333;}
#current-date {float:right; padding:20px 0; color: #333333;}

.showcase-item {margin-bottom:35px; position:relative;}
.showcase-item h3 {font-size:22px; line-height:1;}
.showcase-item a.zoomimg {position:relative; display:block; }

/* FRONTPAGE PROJECTS & PORTFOLIO SHOWCASE */
.projects .items {margin:0; padding:0; list-style:none;}
.projects .items li {margin-bottom:20px; float:left; margin-right:20px; position:relative; width:220px;}
.projects .items li.last {margin-right:0;}
.projects .items li a.image-item { height: 163px; overflow: hidden; display: block;}
.projects.recent .items li {margin-bottom:35px;}
.projects.recent .items li:first-child {font-size:11px; line-height:1.4; text-shadow:1px 1px 0 rgba(255,255,255,0.7)}
.projects .items li img { position: relative; filter: alpha(opacity=50); opacity: 0.5; z-index:997;}
.projects .items li:hover img{ z-index: 999; filter: alpha(opacity=100); opacity: 1; }
.projects .items li .details { position: absolute; left: -10px; top: -10px; padding: 190px 10px 20px; width: 220px; display: none; background: #fff; border:1px solid #ddd; -webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;  -webkit-box-shadow:0 0 5px rgba(0,0,0,0.2); -moz-box-shadow:0 0 5px rgba(0,0,0,0.2); box-shadow:0 0 5px rgba(0,0,0,0.2); z-index:998; }
.projects .items li .details h4 { font:14px/1 Arial, Helvetica, sans-serif; margin-bottom:15px;}
.projects .items li .details p {padding: 0; margin: 0; font-size: 11px; line-height:1.4;}
.projects .items li:hover .details {display: block;}
.gkTab.portfolio_sortable {margin-top:20px;}
.gkTab.portfolio_sortable ul.gkTabs {float:right; list-style: none; height: 32px; border:none; width:auto; margin:-55px -10000px 0 0; padding:0 10000px 0 0;  background:url('../php/rgba.php?name=black&a=10'); background:rgba(0,0,0,0.1)}
.gkTab.portfolio_sortable ul.gkTabs li {border:0 !important; background:none !important; float: left; margin: 0; padding: 0; height: 31px; line-height: 31px;}
.gkTab.portfolio_sortable ul.gkTabs li a,
.gkTab.portfolio_sortable ul.gkTabs li span {border:none; color:#454545; display: block; padding: 0 20px; cursor:pointer;}
.gkTab.portfolio_sortable ul.gkTabs li a:hover,
.gkTab.portfolio_sortable ul.gkTabs li span:hover,
.gkTab.portfolio_sortable ul.gkTabs li.active a,
.gkTab.portfolio_sortable ul.gkTabs li.active span,
.gkTab.portfolio_sortable ul.gkTabs li.active a:hover,
.gkTab.portfolio_sortable ul.gkTabs li.active span:hover { background:url('../php/rgba.php?name=black&a=60'); background:rgba(0,0,0,0.6); color:#eee; border:none !important;}


#rt-mainbottom h2.title,
h3.title-square {background-color:#cbcbcb; padding:5px 10px; font-size:22px; line-height:1; text-shadow:1px 1px 0 rgba(255,255,255,0.7); display: inline-block; }

#rt-mainbottom {background:#e2e2e2; position:relative; z-index:2; text-shadow:1px 1px 0 rgba(255,255,255,0.7); padding-bottom:25px;}

/* LATEST POSTS MODULE */
.latest_posts .post {margin-bottom:15px; border-bottom:1px solid #cecece; padding-bottom:15px;}
.latest_posts .post.last {margin-bottom:0; border-bottom:0; padding-bottom:0;}
.latest_posts .post h5 {font:12px/1.5 Arial, Helvetica, sans-serif; font-weight:bold; font-style:normal; margin-bottom:0;}
.latest_posts .post p { margin-bottom:0px;}
.latest_posts .details {font-size:11px; display: inline-block; margin-bottom: 5px;}
.latest_posts .view_all { color: #777777; float: right; margin-top: -40px; }
.latest_posts .view_all:hover { color: #444; }

/* FLICKR FEED MODULE */
.flickr_feeds li {float:left; margin:0 14px 18px 0;list-style: none outside none;}
.flickr_feeds li.last {margin-right:0;} 
.flickr_feeds a img {width:57px; height:57px; border:1px solid #adadad;}
.flickr_feeds a img:hover {border:1px solid #888; -webkit-box-shadow:0 0 4px rgba(0,0,0,0.4); -moz-box-shadow:0 0 4px rgba(0,0,0,0.4); box-shadow:0 0 4px rgba(0,0,0,0.4);}

/* BOTTOM DIV */
#rt-bottom {border-top:5px solid #fff; position:relative; z-index:2; padding:35px 0; color:#919090;}
#rt-bottom .shadow-up {position:absolute; width:918px; height:20px; top:-25px; left:50%; margin-left:-459px;  z-index:1; opacity:0.5; filter:alpha(opacity=50);}
#rt-bottom ul.menu {list-style:none;}
#rt-bottom ul.menu li a {font-size:12px; line-height:1.5;}
#rt-bottom a {color:#cbcbcb; }
#rt-bottom a:hover {color:#fff;}
#rt-bottom h2.title {font:13px/1 'CartoGothicStdBook', arial, serif; color:#fff;}
.map_link, .mapa-link {background:url(../images/map_pin_stroke_12x12.png) no-repeat left center; padding-left:15px;}

#quote_wrap {overflow:hidden;}
#quote_wrap blockquote p {color:#8f8f8f; background:#262626; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; padding:7px 10px; margin:0; font-size:12px; line-height:1.6; }
#quote_wrap blockquote h6 {font-size:18px; line-height:1; color:#a1a1a1; padding-bottom:12px; text-shadow:1px 1px 0 #030303; display:block; text-align:right; background:url(../images/bg-testimonals-pin.png) no-repeat right bottom; text-transform:uppercase; margin:0; font-style: normal !important;}

/* NEWSLETTER */
#rt-bottom #newsletter-form p {position:relative;}
#rt-bottom #newsletter-form label {position:absolute; left:7px; top:5px; font-size:11px; color:#ccc;}
#rt-bottom #newsletter-form input[type=text] { border:1px solid #353535; background:#262626; width: 170px; padding:5px; height:16px; font-size:12px; color:#777; -webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px; -webkit-box-shadow:3px 3px 2px rgba(0, 0, 0, 0.3) inset; -moz-box-shadow:3px 3px 2px rgba(0, 0, 0, 0.3) inset; box-shadow:3px 3px 2px rgba(0, 0, 0, 0.3) inset; filter:none;}
#rt-bottom #newsletter-form input[type=text]:focus {border:1px solid #555; }
#rt-bottom #newsletter-form input[type=submit] {color:#ccc; width:80px; border:1px solid #424242; cursor:pointer; font-size:12px; opacity:0.7; text-transform:none; padding-bottom:3px; padding:2px 0; -webkit-box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7); -moz-box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7); box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7);
-webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px;
background: #454545;
background: -moz-linear-gradient(top, #454545 0%, #353535 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#454545), color-stop(100%,#353535));
background: -webkit-linear-gradient(top, #454545 0%,#353535 100%);
background: -o-linear-gradient(top, #454545 0%,#353535 100%);
background: -ms-linear-gradient(top, #454545 0%,#353535 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#454545', endColorstr='#353535',GradientType=0 );
background: linear-gradient(top, #454545 0%,#353535 100%);
}
.browserChrome #newsletter-form input[type=submit] {height:23px; }
#rt-bottom #newsletter-form input[type=submit]:active {
background: #353535;
background: -moz-linear-gradient(top, #353535 0%, #454545 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#353535), color-stop(100%,#454545));
background: -webkit-linear-gradient(top, #353535 0%,#454545 100%);
background: -o-linear-gradient(top, #353535 0%,#454545 100%);
background: -ms-linear-gradient(top, #353535 0%,#454545 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#353535', endColorstr='#454545',GradientType=0 );
background: linear-gradient(top, #353535 0%,#454545 100%);
}
#rt-bottom #newsletter-form:hover input[type=submit], #rt-bottom #newsletter-form input[type=submit]:hover {opacity:1;}
#rt-bottom .browserChrome #newsletter-form input[type=submit] {padding-top:4px;}
table.acymailing_form {margin:0 !important;}
p.acysubbuttons {margin:0; text-align:left;}

/* SCROLL TO TOP LINK */
#top-link { display:none; width:90px; background:url(../images/totop-arrow.png) left center no-repeat #181818; color:#ddd; font-size:11px; text-decoration:none; padding:6px 6px 6px 25px; position:fixed; right:-100px; bottom:100px; -webkit-border-radius: 3px;-moz-border-radius: 3px;border-radius: 3px; *height: 1.5%; z-index:998; border:1px solid #e2e2e2; font-size: 11px; line-height:1; text-transform:uppercase; }
#top-link:hover {background-color:#000; color:#fff; border:1px solid #FFF;}


#rt-footer {color:#919090; font:12px/1 'CartoGothicStdBook', arial, serif; padding-bottom: 15px; z-index:2;}

/* TWITTER STYLING */
.twitter-wrapper {background-color:#242424; padding:10px 0; }
#twitter {position:relative;}
#twitter #profileLink {position:absolute; top:5px; left:0; background:url(../images/twitter-bird-icon.png) no-repeat; display:block; text-indent:-9999px; width:30px; height:30px; }
#twitter .tweet {margin:0 0 0 50px; padding:10px 0; list-style:none; line-height:1; font-size:12px;}
#twitter span.time {position:absolute; right:0; top:5px; font-size:100% !important; line-height:1.8; border-left:1px dotted #444; padding-left: 15px; }

/* COPYRIGHT MODULE */
.copyright {padding:15px 0;}
.copyright img {float:left;width: 140px;}
.copyright .copyright-text {float:left; margin-left:15px; margin-top:10px;}

.social-connect {margin:20px 0 0;}
.social-connect li {float:right; margin-right:15px; list-style:none;}
.social-connect li a {font-size:12px; line-height:1.5;}
.social-connect li:first-child {margin-right:0;}

.social-connect li.tweet {width:100px;}
.social-connect li.gplus {width:60px;}
.social-connect li.fb-like {width:70px; padding-right:10px;}
#closefblive {position:absolute; top:-15px; right:-15px; display:block; width:30px; height:30px;}
.social-connect .live-comments {position:relative;}
.social-connect .live-comments .opener { padding:4px 0; line-height:1; color:#eee; border: 1px solid #555555; display:block;
-webkit-box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7); -moz-box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7); box-shadow:0px 0px 2px rgba(0, 0, 0, 0.7);
-webkit-border-radius:4px; -moz-border-radius:4px; border-radius:4px;
background: #454545;
background: -moz-linear-gradient(top, #454545 0%, #353535 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#454545), color-stop(100%,#353535));
background: -webkit-linear-gradient(top, #454545 0%,#353535 100%);
background: -o-linear-gradient(top, #454545 0%,#353535 100%);
background: -ms-linear-gradient(top, #454545 0%,#353535 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#454545', endColorstr='#353535',GradientType=0 );
background: linear-gradient(top, #454545 0%,#353535 100%);
}
.social-connect .live-comments .opener:hover { background: #353535;
background: -moz-linear-gradient(top, #353535 0%, #454545 100%);
background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#353535), color-stop(100%,#454545));
background: -webkit-linear-gradient(top, #353535 0%,#454545 100%);
background: -o-linear-gradient(top, #353535 0%,#454545 100%);
background: -ms-linear-gradient(top, #353535 0%,#454545 100%);
filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#353535', endColorstr='#454545',GradientType=0 );
background: linear-gradient(top, #353535 0%,#454545 100%); }
.social-connect .live-comments .opener:active, .social-connect .live-comments .opener.active { background: #252525; }

div.fb-comments {display:none;}
div.fb-comments.opened {display:block; overflow-y:scroll; position:absolute; top:-330px; left:0; margin-left:-200px; background:#fff; overflow-x:hidden; padding:10px; z-index:998;-webkit-box-shadow:0 0 11px rgba(0, 0, 0, 0.4); -moz-box-shadow:0 0 11px rgba(0, 0, 0, 0.4); box-shadow:0 0 11px rgba(0, 0, 0, 0.4); }

.social-connect .live-comments .opener span { padding:4px 8px 4px 20px; background:url(../images/live-comments-icon.png) no-repeat left center; }

/* HIDDEN MAP */
.hidden-map-wrapper {overflow:hidden; position:relative; height:0;}
.shadow-top {width:100%; height:17px; background:url(../images/map-shadows.png) repeat-x center top; position:absolute; top:0; left:0; z-index:2;}
.shadow-bottom {width:100%; height:17px; background:url(../images/map-shadows.png) repeat-x center bottom; position:absolute; bottom:0; left:0; z-index:2;}
.close-map {position:absolute; top:0; right:110px; width:50px; height:50px; background:url(../images/closeMap.png) no-repeat center top; cursor:pointer; z-index:2; }
.close-map:hover {background:url(../images/closeMap.png) no-repeat center bottom;}

/* FULL SLIDER (based on Plus Slider) */
.plusSlider {left:50%;}
.plusSlider .titles {position:absolute; top:300px; right:50%; width:940px; margin-right:-470px; }
.plusSlider .titles h2 { background:url('../php/rgba.php?name=black&a=80'); background:rgba(0,0,0,0.8); line-height:1; padding:10px 10000px 13px 20px; margin: 0 -10000px 0 0; color:#fff; text-transform:uppercase; float:right; position:relative; left:600px;  }
.plusSlider .titles h2 a {color:#fff;}
.plusSlider h2.first-title {font-size:36px; font-weight:700; margin-bottom:10px;}
.plusSlider h2.second-title {font-size:26px; font-weight:400;}
.plusSlider .description {width:300px; float:right; text-align:right; margin-top:20px;}
.plusSlider .description span { background:url('../php/rgba.php?name=black&a=80'); background:rgba(0,0,0,0.8); line-height:1.9; font-size:12px; padding:3px 0px; color:#fff;}

/* IN CASE YOU ADD OTHER SLIDESHOW EXTENSION, DONT FORGET TO ADD "slider-page" TO THE PAGE CLASS FIELD (in menu > menu item > 3rd tab on the right) */
.slider-page #slideshow {height: 850px;}
.slider-page #container {top: 680px;}

/* NIVO SLIDER */
.ns-container { width:940px; left:50%; margin-top:150px; margin-left:-550px; min-height:350px; position:relative; padding:0 80px 20px; background:url(../images/slider-shadow.png) no-repeat center bottom;}
#slideshow .nivoSlider { margin:0; -webkit-box-shadow:none; -moz-box-shadow:none; box-shadow:none; }
#slideshow .nivo-directionNav a { position: absolute; top: 80px; cursor: pointer; background: url(../images/plus-sprite.png) no-repeat; display: block; height: 32px; width: 32px; z-index: 200; text-indent: -9999px; }
#slideshow .nivo-directionNav .nivo-prevNav { left: -32px; bottom: 70px; top: auto; background-position: 0 -32px; -webkit-border-top-left-radius: 3px; -webkit-border-bottom-left-radius: 3px; -moz-border-radius-topleft: 3px; -moz-border-radius-bottomleft: 3px; border-top-left-radius: 3px; border-bottom-left-radius: 3px; }
#slideshow .nivo-directionNav .nivo-prevNav:hover { background-position: 0 0 }
#slideshow .nivo-directionNav .nivo-nextNav { right: -32px; background-position: -32px -32px; -webkit-border-top-right-radius: 3px; -webkit-border-bottom-right-radius: 3px; -moz-border-radius-topright: 3px; -moz-border-radius-bottomright: 3px; border-top-right-radius: 3px; border-bottom-right-radius: 3px; }
#slideshow .nivo-directionNav .nivo-nextNav:hover { background-position: -32px 0 }
#slideshow .nivo-controlNav { position: absolute; left: 50%; bottom: -30px; margin-left: -35px; }
#slideshow .nivo-controlNav a { position: relative; z-index: 9; cursor: pointer; display: block; float: left; height: 10px; margin: 0 8px 0 0; width: 10px; background: rgba(0, 0, 0, 0.4); text-indent: -9999px; font-size: 0; outline: 0 none; -webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px; }
#slideshow .nivo-controlNav a.active { font-weight: bold; background: rgba(0, 0, 0, 0.9); }
#slideshow .nivo-caption { position: absolute; left: 10px; bottom: 10px; background: #000; color: #fff; opacity: 0.8; width: 920px; z-index: 8; }
#slideshow .nivo-caption p { padding: 5px; margin: 0; }

/* STATIC CONTENT */
.static_content .sc-container { width:860px; margin:160px auto 0; padding:30px 40px 0 40px; position:relative;}
.static_content .bg_color {position:absolute; top:0; left:0; width:100%; height:100%; z-index:1;}
.static_content .border {position:absolute; top:0; left:0; width:99.8%; height:99.8%; z-index:1;}
.static_content .leftcontent {float:left;}
.static_content .sc-container .rightcontent {float:right; text-shadow: 0 1px 0 rgba(0, 0, 0, 0.4); position:relative;  z-index:2;}
.static_content .sc-container .rightcontent h2 {font-size:30px; font-weight:700; color:#fff; text-transform:uppercase; margin-bottom:35px;  padding:10px 10000px 13px 20px; margin: 0 -10000px 25px -20px; background:url('../php/rgba.php?name=black&a=40'); background-color: rgba(0, 0, 0, 0.4);}
.static_content .sc-container .rightcontent p {color:#fff; margin-bottom:25px;}
.static_content .sc-container .rightcontent h4 { color:#fff; font-weight:700; margin-bottom:25px; }
.static_content .sc-container .leftcontent { position:relative;  z-index:2;}
.static_content .sc-container .leftcontent img {outline: 2px solid rgba(0, 0, 0, 0.2); -moz-transition: outline 250ms ease-in; -webkit-transition: outline 250ms ease-in; -o-transition: outline 250ms ease-in; transition: outline 250ms ease-in;}
.static_content .sc-container .leftcontent img:hover { outline: 6px solid rgba(0, 0, 0, 0.4); }
.static_content .sc-container .medium-button { color:#fff; text-shadow:0 1px 1px rgba(0, 0, 0, 0.4); font-weight:bold; text-transform:uppercase; font-size:12px;}

/*#rt-main {margin-bottom:35px;}*/

/* SIDEBAR */
#rt-sidebar-a {background:none;}
#rt-sidebar-b, #rt-sidebar-c {background:#f5f5f5; padding:15px; -webkit-border-radius:3px;  -moz-border-radius:3px;  border-radius:3px; }
#rt-sidebar-a, #rt-sidebar-b, #rt-sidebar-c {margin-bottom:35px;}
#rt-sidebar-a .rt-block, #rt-sidebar-b .rt-block, #rt-sidebar-c .rt-block {margin-bottom:25px;}
#rt-sidebar-a .rt-block.last, #rt-sidebar-b .rt-block.last, #rt-sidebar-c .rt-block.last {margin-bottom:0;}
#rt-sidebar-c h2.title, #rt-sidebar-b h2.title, #rt-sidebar-c h2.title {font-size:20px;}
#rt-sidebar-a ul.menu, #rt-sidebar-b ul.menu, #rt-sidebar-c ul.menu {margin:0; border-bottom:1px solid #dedede; list-style:none; }
#rt-sidebar-a ul.menu ul, #rt-sidebar-b ul.menu ul, #rt-sidebar-c ul.menu ul {margin:0 0 0 20px; list-style:none;}
#rt-sidebar-a ul.menu li a, #rt-sidebar-b ul.menu li a, #rt-sidebar-c ul.menu li a {display:block; border-top:1px solid #dedede; padding:4px 0 4px 13px; background-image:url(../images/menu-bullet.png); background-repeat: no-repeat; background-position: left center; text-shadow:1px 1px 0 rgba(255,255,255,0.5); font-size:12px; line-height:19px;}
#rt-sidebar-a ul.menu li a:hover, #rt-sidebar-b ul.menu li a:hover, #rt-sidebar-c ul.menu li a:hover { background-color:#eee;}

/* ANYTHING SLIDER */
.anythingSlider .slide-item h2 {font-size:27px; font-weight:700; color:#fff; text-transform:uppercase; margin-bottom:25px; text-shadow: 0 1px 0 rgba(0, 0, 0, 0.4);}
.anythingSlider .slide-item > p:empty { margin:0; }
.anythingSlider .slide-item p { font-size:16px; color:#eee; }
.anythingSlider .slide-item .big-button { margin-top:5px; color:#2a2a2a; text-shadow:0 1px 1px rgba(255, 255, 255, 0.8);}
.anythingSlider .slide-item object { /*border:4px solid #fff; -webkit-box-shadow:0 0 4px #000; -moz-box-shadow:0 0 4px #000; box-shadow:0 0 4px #000;*/ }
.anythingSlider .slide-item object embed{ border:4px solid #fff; -webkit-box-shadow:0 0 4px #000; -moz-box-shadow:0 0 4px #000; box-shadow:0 0 4px #000; }
.anythingSlider .slide-item .sige {margin:0; display:inline;}
.anythingSlider .slide-item .sige > span {float:left; margin:7px;}
.anythingSlider .slide-item .sige .sige_thumb {background:none !important; float:none; margin:0; }
.anythingSlider .slide-item .sige a img { border:1px solid #ccc; padding:4px; background:#fff; -webkit-box-shadow:0 0 4px #000; margin:0; -moz-box-shadow:0 0 4px #000; box-shadow:0 0 4px #000;  -webkit-transition: all .3s ease; -moz-transition: all .3s ease; -o-transition: all .3s ease; transition: all .3s ease;  }
.anythingSlider .slide-item .sige a:hover img { border:1px solid #ffd700; padding:4px; background-color:#ffaf00; -webkit-box-shadow:0 0 4px #ffaf00; -moz-box-shadow:0 0 4px #ffaf00; box-shadow:0 0 4px #ffaf00; }

/* BREADCRUMBS */
.breadcrumbs {padding:20px 0; color: #333333;}
#rt-breadcrumbs .date-block {float:right; padding:20px 0; color: #333333;}

/* BLOG */
/*.post_block {border-bottom:1px solid #dedede; margin-bottom:25px; padding-bottom:10px;}*/
.post_block {margin-bottom:5px;}
.post_block .block-img-shadow {float:left;}
.post_block .post-title,
.blog_page h1.title {font:1em/1 arial, serif; padding:10px 20px 10px 10000px; margin: 0 0 10px -10000px; background:url('../php/rgba.php?name=black&a=40'); background:rgba(0,0,0,0.4); color:#fff;}
.post_block .post-title a,
.blog_page h1.title a {color:#fff; font:18px/1.4 'CartoGothicStdBook', arial, serif;  }
.post_data {list-style:none; margin:0 0 20px; padding:0 !important; display:inline-block;  font-size:12px; color:#444;}
.post_data li {float:left; margin-left:10px !important; padding-left:10px !important; border-left:1px dotted #ccc; line-height:1; font-size:11px !important; list-style:none; }
.post_data li a {font-size:11px; line-height:1;}
.post_data li:first-child {margin-left:0 !important; padding-left:0 !important;border-left:0;  }
.component-content .rt-article-bg {border:none; padding-bottom:0;}
.post_block .readmore {display:inline-block; background:#F8F8F8; font-size:12px; padding:5px 10px; -webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px;margin-top:15px; }
.itp-share { height: 70px; }

/* PAGINATION */
.rt-pagination {padding:3px; margin: 3px; text-align: center;}
.rt-pagination .rt-results {font-size:9px; color:#888;}
.rt-pagination > ul {display:inline-block;}
.rt-pagination a, .rt-pagination span { -webkit-border-radius: 3px;-moz-border-radius: 3px;border-radius: 3px;}
.rt-pagination a {display:inline-block; background:#F8F8F8; font-size:11px; padding:0 6px !important; margin:0 5px; border:1px solid #F8F8F8; }
.rt-pagination a:hover {border:1px solid #ddd; }
.rt-pagination li {padding:0 !important; border:0 !important; }
.rt-pagination span.pagenav {display:inline-block; color:#bbb;background:#F8F8F8; font-size:11px; padding:0 6px !important; margin:0 5px; border:1px solid #F8F8F8;}


.component-content .pagenav li a {-webkit-border-radius: 3px;-moz-border-radius: 3px;border-radius: 3px; background:#F8F8F8; font-size:11px; padding:4px 6px !important; margin:0 5px; border:1px solid #F8F8F8; line-height:1.6;}
.component-content .pagenav li a:hover {border:1px solid #ddd; }

/* HISTORIC YEARS */
.years .year {position:relative; padding-bottom:60px; margin-bottom:40px; }
.years .year.fromleft {padding-left:130px; background:url(../images/historic_fromleft.png) no-repeat left bottom;}
.years .year.fromright {padding-right:130px; background:url(../images/historic_fromright.png) no-repeat right bottom;}
.years .year .date {position:absolute; top:0; padding:6px 0; text-align:center; width:100px; font-size:16px; font-weight:bold; background:#ccc; color:#454545; text-shadow:0 1px 0 #fff; border-bottom:1px solid #999999; }
.years .year.fromleft .date {left:0;}
.years .year.fromright .date {right:0;}
.years .year.last {background:none; padding-bottom:0;}

.clients .gallery {margin-bottom:30px; padding:0; list-style:none;}
.clients .gallery li img {border:5px solid #fff; -webkit-box-shadow:0 0 2px #aaa; -moz-box-shadow:0 0 2px #aaa; box-shadow:0 0 2px #aaa; padding:0;}
.clients .gallery li img:hover {-webkit-box-shadow:0 0 4px #aaa; -moz-box-shadow:0 0 4px #aaa; box-shadow:0 0 4px #aaa; border:5px solid #fff; }

/* TEAM PAGE */
.executives {margin-bottom:35px; width:220px; margin-right:20px; float:left;}
.executives.last {margin-right:0; }
.executives span {display:block;}
.executives .name {font:14px/1.4 'CartoGothicStdBook', arial, serif; padding-top:10px; text-transform:uppercase; color:#EB540A; }
.executives .function {font:12px/1.4 'CartoGothicStdBook', arial, serif; padding-bottom: 15px; color:#999;}
.executives p {font-size:11px; color:#454545; line-height:1.5;}
.executives .social-profiles img {margin-right:5px;} 
.executives ul {list-style:none; margin:0 0 20px; padding:0;}
.executives ul li {font-size:11px; color:#454545;}
.executives ul li a {font-size:11px; line-height:1.3;}

.core_team {margin-bottom:35px; margin-right:20px; float:left; width:220px}
.core_team.last {margin-right:0;}
.core_team img.member {border:1px solid #bbb;}
.core_team img.member:hover {-webkit-box-shadow:0 0 2px #aaa; -moz-box-shadow:0 0 2px #aaa; box-shadow:0 0 2px #aaa;}
.core_team span {display:block;}
.core_team .name {font:14px/1 'CartoGothicStdBook', arial, serif; padding: 10px 0 15px; text-transform:uppercase;}
.core_team .function {font:12px/1.4 'CartoGothicStdBook', arial, serif; padding-bottom: 15px; color:#999;}
.core_team .social-profiles img {margin-right:5px;} 

/* CONTACT */
#contact_form textarea {width:400px; height:150px;}
#contact_form .note {color:#999;}

/* SITEMAP */
#xmap ul {margin:0; list-style:none; padding:0;}
#xmap li {line-height:19px;}
#xmap a {line-height:19px; font-size:12px;}
#xmap ul li a {background-image:url(../images/sitemap-arrow.png); background-repeat: no-repeat;}
#xmap ul li a {padding-left:40px; background-position: -270px 7px; }
#xmap ul li li a {padding-left:80px; background-position: -230px 7px; }
#xmap ul li li li a {padding-left:120px; background-position: -190px 7px; }
#xmap ul li li li li a {padding-left:160px; background-position: -150px 7px; }
#xmap ul li li li li li a {padding-left:200px; background-position: -110px 7px; }
#xmap .menutitle {margin-top:15px;}

/* PORTFOLIO CATEGORY */
.project {margin-bottom:35px; padding-bottom:20px; border-bottom:1px solid #eaeaea;}
.project h3 {font:16px/1.4 'CartoGothicStdBook', arial, serif; padding-top:10px; text-transform:uppercase; color:#111;}
.project .we_did li {width:160px; display:inline-block;}
.project .images-carousel { height: 300px; overflow:hidden;
outline: 2px solid rgba(0, 0, 0, 0.2);
-moz-transition: outline 250ms ease-in;
-webkit-transition: outline 250ms ease-in;
-o-transition: outline 250ms ease-in;
transition: outline 250ms ease-in;
}
.project .images-carousel:hover { outline: 6px solid rgba(0, 0, 0, 0.4); }
.project .images-carousel .viewport { float: left; width: 540px; height: 300px; overflow: hidden; position: relative; }
.project .images-carousel .buttons-container {width:65px; height:32px; position:absolute; left:50%; margin-left:-33px; bottom:14px;}
.project .images-carousel .buttons { background: url("../images/plus-sprite.png") no-repeat scroll 0 0 transparent; cursor: pointer; display: block; height: 32px; text-indent: -9999px; width: 32px; float:left; }
.project .images-carousel .prev { background-position: 0 -32px;
-webkit-border-top-left-radius: 3px;
-webkit-border-bottom-left-radius: 3px;
-moz-border-radius-topleft: 3px;
-moz-border-radius-bottomleft: 3px;
border-top-left-radius: 3px;
border-bottom-left-radius: 3px;}
.project .images-carousel .prev:hover{background-position: 0 0;}
.project .images-carousel .next { margin-left:1px; background-position: -32px -32px;
-webkit-border-top-right-radius: 3px;
-webkit-border-bottom-right-radius: 3px;
-moz-border-radius-topright: 3px;
-moz-border-radius-bottomright: 3px;
border-top-right-radius: 3px;
border-bottom-right-radius: 3px;
}
.project .images-carousel .next:hover{background-position: -32px 0;}

.project .images-carousel .disable { opacity:0.5; filter:alpha(opacity=50) }
.project .images-carousel .overview { list-style: none; position: absolute; padding: 0; margin: 0; left: 0; top: 0;}
.project .images-carousel .overview li { float: left; height: 300px; width: 540px; }

.vportfolio-component .pagination_links {padding:3px; margin: 3px 3px 20px; text-align: center;}
.vportfolio-component .pagination_links .rt-results {font-size:9px; color:#888;}
.vportfolio-component .pagination_links > ul {display:inline-block; list-style:none; margin:0; padding:0;}
.vportfolio-component .pagination_links a, .vportfolio-component .pagination_links span { -webkit-border-radius: 3px;-moz-border-radius: 3px;border-radius: 3px;}
.vportfolio-component .pagination_links a {display:inline-block; background:#F8F8F8; font-size:11px; padding:0 6px !important; margin:0 5px; border:1px solid #F8F8F8; }
.vportfolio-component .pagination_links a:hover {border:1px solid #ddd; }
.vportfolio-component .pagination_links li {padding:0 !important; border:0 !important; display:inline-block; margin-left:3px; }
.vportfolio-component .pagination_links li:first-child {margin-left:0px; }
.vportfolio-component .pagination_links span.pagenav {display:inline-block; color:#bbb;background:#F8F8F8; font-size:11px; padding:0 6px !important; margin:0 5px; border:1px solid #F8F8F8;}

/* PORTFOLIO PAGE */
.project-page {margin-bottom: 25px;}
.project-page h1.title {margin-bottom:25px;}
.project-page .portfolio-nav {float:right; margin:-55px -10000px 0 0; padding:0 10000px 0 0; background:url('../php/rgba.php?name=black&a=10'); background:rgba(0,0,0,0.1)}
.project-page .portfolio-nav li {border-right:1px solid #ccc; float:left;}
.project-page .portfolio-nav li a {border:none; color:#454545; width:30px; height:30px; display:block; text-indent:-9999px; background:url(../images/portfolio-nav.png) no-repeat; }
.project-page .portfolio-nav li a:hover { background-color:#222; background-color:rgba(0,0,0,0.6); color:#eee; }
.project-page .portfolio-nav li .portfolio-list {background-position:0 0;}
.project-page .portfolio-nav li .portfolio-prev {background-position:-30px 0;}
.project-page .portfolio-nav li .portfolio-next {background-position:-60px 0;}

/* LOGIN PAGE */
.login-form .login-fields {margin-bottom:15px;}
.login-form label {display:inline-block; width:130px;}
ul.login-list {margin:20px 0 0; padding:0; list-style:none;}
ul.login-list li {border-left:1px solid #dedede; padding-left:15px; margin-left:15px; list-style:none; float:left; line-height:1; }
ul.login-list li:first-child {border-left:0; padding-left:0; margin-left:0; }
ul.login-list li a {font-size:12px; line-height:1.6;}

/* REGISTER PAGE */
.register-form dt {margin-bottom:15px;}
.register-form label {display:inline-block; width:150px;}

.tip-wrap {background:#f5f5f5; border:1px solid #e5e5e5; -webkit-border-radius:3px; -moz-border-radius:3px; border-radius:3px; font-size:11px; padding:4px;}

/* Resets, stylers & helpers */
.alignleft {float:left; margin-right:15px;}
.alignright {float:right; margin-left:15px;}
.noMarginRight {margin-right:0 !important;}
.noMarginLeft {margin-left:0 !important;}
.noMarginTop {margin-top:0 !important;}
.noMarginBottom {margin-bottom:0 !important;}

div.anythingSlider .anythingControls {
bottom: 620px!important;
}
.telf-btn-skype {
    position: absolute;
    z-index: 2;
    color: #fff;
    right: -305px;
}
.customtelf-btn-skype span {
    margin-right: 10px;
}
.customtelf-btn-skype .border-puntos-right {
    border-right: 1px dashed #C9C9C9;
    padding-right: 10px;
}

.slider-personal h3 {
    color: #fff;
    font-size: 29px;
    font-weight: bold;
    text-shadow: 2px 2px 1px #333;
    text-transform: uppercase;
}
.customclass01 .medium-button.yellow {
    color: #333;
    text-shadow: 1px 1px 1px #fff;
}
#btcontentslider131 .bt-title {
    text-align: center;
    display: block;
}

#btcontentslider131.bt-cs .next, #btcontentslider131.bt-cs .prev {
    top: -15px !important;
}
.pag-servicios .post-title.left-outline {
    margin: 0;
    padding: 5px;
}
.pag-servicios .rt-article img {
    width: 75%;
    height: auto;
    margin: 10px auto 0 auto;
    text-align: center;
    display: block;
}
.menu-home.menu-pagina-home #rt-utility .equation .rt-grid-3 {
    width: 197px;
}
.menu-home.menu-pagina-home #rt-utility .equation .rt-grid-1 {
    margin: 0;
    width: 50px;
}
.menu-home.menu-pagina-home #rt-utility .equation .rt-grid-4 {
    width: 402px;
}
.customsliderh4 .alignleft {
    margin-right: 0;
}
.customsliderh4 .alignleft h2 {
    font-size: 30px;
}
body.menu-contact.pag-contacto #rt-showcase .rt-container, body.menu-contact.pag-contacto #rt-showcase .rt-container .rt-grid-12, body.menu-contacto.pag-contacto #rt-showcase .rt-container, body.menu-contacto.pag-contacto #rt-showcase .rt-container .rt-grid-12 {
    width: 100%;
    padding: 0;
}
#rsform_3_page_0 li.rsform-block.rsform-block-name, #rsform_3_page_0 .rsform-block.rsform-block-website, #rsform_3_page_0 .rsform-block.rsform-block-email, #rsform_3_page_0 .rsform-block.rsform-block-phone {
    width: 47%;
    display: inline-block;
}
#rsform_3_page_0 li.rsform-block-name .formBody .rsform-input-box, #rsform_3_page_0 li.rsform-block-name .formBody, #rsform_3_page_0 li.rsform-block-website .formBody .rsform-input-box, #rsform_3_page_0 li.rsform-block-website .formBody, #rsform_3_page_0 li.rsform-block-email .formBody .rsform-input-box, #rsform_3_page_0 li.rsform-block-email .formBody, #rsform_3_page_0 li.rsform-block-phone .formBody .rsform-input-box, #rsform_3_page_0 li.rsform-block-phone .formBody {
    width: 95%;
}
#rsform_3_page_0 .rsform-block.rsform-block-how-did-you-learnt-about-turnover {
    width: 47%;
}
#rsform_3_page_0 .rsform-block.rsform-block-how-did-you-learnt-about-turnover .formBody, #rsform_3_page_0 .rsform-block.rsform-block-how-did-you-learnt-about-turnover .formBody select {
    width: 96%;
}
#rsform_3_page_0 .rsform-block.rsform-block-additional-information, #rsform_3_page_0 .rsform-block.rsform-block-additional-information .formBody textarea, #rsform_3_page_0 .rsform-block.rsform-block-additional-information .formBody {
    width: 98%;
}
#rsform_3_page_0 .rsform-block-internet-marketing-services .formBody label {
    display: inline-block;
    padding-left: 3px;
    width: 200px;
}
#rsform_3_page_0 .rsform-block-internet-marketing-services .formBody {
    width: 100%;
}
body.menu-contact.pag-contacto #userForm legend {
    display: none;
}
body.menu-request-a-free-seo-proposal.pag-free-seo .rt-container, body.menu-request-a-free-seo-proposal.pag-free-seo #rt-main, body.menu-request-a-free-seo-proposal {
    width: 230px;
}
body.menu-request-a-free-seo-proposal{
	min-width: 230px;
}
body.menu-request-a-free-seo-proposal.pag-free-seo .rt-container{
	padding: 0 30px
}
body.menu-home.menu-pagina-home .pp_expand {
    display: none!important;
}
body.menu-request-a-free-seo-proposal.pag-free-seo .rt-container #userForm legend {
    display: none;
}
input#radioppc1 {
    margin-left: 20px;
}
#rsform_4_page_0 li .formCaption {
    display: none;
}
#rsform_4_page_0 li.rsform-block.rsform-block-radioppc2 .formCaption, #rsform_4_page_0 li.rsform-block.rsform-block-verification-code .formCaption {
    display: block;
    width: 100%;
    text-align: center;
    clear: both;
    float: left;
}
#rsform_4_page_0 li.rsform-block.rsform-block-radioppc2 .formBody, #rsform_4_page_0 li.rsform-block.rsform-block-verification-code .formBody {
    float: left;
    clear: both;
    width: 60%;
    margin-top: 28px;
}
#rsform_4_page_0 li.rsform-block.rsform-block-verification-code .formBody {
    margin-top: 7px;
    width: 96%;
}
#rsform_4_page_0 input, #rsform_4_page_0 .formBody {
    width: 95%;
}
.item-page.pag-free-seo h1 {
    font-size: 24px;
    text-align: center;
}
#Radioppc20, #Radioppc21 {
    width: auto !important;
}
#rsform_4_page_0 li.rsform-block.rsform-block-radioppc2 .formBody {
    display: block;
    left: 30%;
    margin: 30px auto 0;
    position: relative;
    width: 100px;
}
#Radioppc21 {
    margin-left: 20px;
}
.item-page.pag-free-seo .edit-icon {
    display: none;
}
#rsform_4_page_0 .rsform-block.rsform-block-marketing-budget select {
    width: 100%;
}
#rsform_4_page_0 li.rsform-block.rsform-block-verification-code .formBody input {
    width: 93%!important;
}
#rsform_4_page_0 li.rsform-block.rsform-block-verification-code .formBody img {
    padding: 0 58px;
}
#rsform_4_page_0 button#Submit {
    width: 100%;
}
.img-patnert .bloque-img-patnert {
    width: 30%;
    display: inline-table;
    height: 80px;
    vertical-align: middle;
    border: 1px solid #DEDEDE;
    margin: 2px;
    padding: 5px;
    position: relative;
    border-radius: 5px;
    box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.13);
}
.img-patnert {
    position: relative;
}
.img-patnert .bloque-img-patnert img {
    display: block;
    vertical-align: middle;
    margin: 0 auto;
    position: relative;
    left: 0%;
    top: 10px;
}
ul.sin-class li {
    list-style: square;
    color: #FFBB00;
    margin-left: 10px;
}
ul.sin-class li span{
	color:#333;
}
.bt-cs .bt-inner .bt-title {
    font-size: 11px;
}
#btcontentslider131.bt-cs .bt-inner img {
    border: medium none !important;
    height: 120px;
    width: auto !important;
    outline: none;
}
#btcontentslider131 a.bt-image-link {
    border: 1px solid #AEAEAE;
    display: block;
    width: 220px !important;
}
#btcontentslider131.bt-cs .prev {
    left: 10px;
}
#rsform_4_page_0 .rsform-block.rsform-block-message, #rsform_4_page_0 .rsform-block.rsform-block-message .formBody {
    width: 93% !important;
}
#rsform_4_page_0 .rsform-block.rsform-block-message .formBody textarea {
    width: 100%;
    height: 40px;
    max-height: 40px;
    max-width: 197px;
}
.pp_description {
    display: none!important;
}
.pp_details {
    position: absolute!important;
    top: -15px;
    right: 15px;
}
.pp_details a.pp_close {
    border-radius: 50% 50% 50% 50%;
}
.pp_content {
    height: 562px!important;
}
.anythingSlider .customslider5custom h2 {
    margin-bottom: 0;
}
.anythingSlider .customslider5custom p a.big-button.yellow {
    margin-top: 0;
}
.anythingSlider .customslider5custom ul {
    margin-bottom: 0;
}
.tabla-custom-1 table td {
    border: 1px solid #333;
    padding: 7px;
}
.blque-reports {
    display: inline-block;
    width: 100%;
    margin-bottom: 10px;
}
.blque-reports img {
    border-width: 1px;
    border-style: solid;
    padding: 2px;
    margin-right: 5px;
}
.tabla-custom-0 th, .tabla-custom-0 td {
    width: 14%!important;
}
.free-seo-proposal .module-title h2 {
    font-size: 18px!important;
}
.pag-testimonials .xtypo_quote p {
    margin: 0;
    text-align: justify;
}
.pag-testimonials .xtypo_quote h2 {
    font-size: 20px;
    padding-left: 60px;
    color: #F55100;
}
.pag-testimonials .xtypo_quote span {
    width: 100%;
    text-align: right;
    margin-top: 10px;
    display: block;
}
.localsearchhome .feature-item {
    margin-bottom: 15px;
}
.img-patnert.clients img {
    width: 68px;
}
.img-patnert.clients .img-client-1 {
    width: 83px;
    margin-top: -12px;
}
.img-patnert.clients .img-client-2 {
    width: 133px;
    margin-top: -12px;
}
.img-patnert.clients .img-client-3 {
    margin-top: -16px;
    width: 105px;
}
.img-patnert.clients .img-client-4 {
    width: 88px;
    margin-top: -14px;
}
.img-patnert.clients .img-client-5 {
    margin-top: -14px;
    width: 85px;
}
.img-patnert.clients .img-client-6 {
    margin-top: -14px;
    width: 95px;
}
.img-patnert.clients .img-client-7 {
    margin-top: -14px;
    width: 87px;
}
.img-patnert.clients .img-client-8 {
    margin-top: -11px;
    width: 82px;
}
.img-patnert.clients .img-client-9 {
    margin-top: -12px;
    width: 85px;
}

.modseftranslatorfree {
    position: absolute;
    top: 0;
    left: 0;
    z-index: 3;
}

a#bandera-us.flag {
    background: url("../images/bandera-us.png") no-repeat scroll 0 0 transparent;
    height: 16px;
    width: 20px;
}
a#bandera-br.flag {
    background: url("../images/bandera-br.png") no-repeat scroll 0 0 transparent;
    height: 16px;
    width: 20px;
}
a#bandera-es.flag {
    background: url("../images/bandera-es.png") no-repeat scroll 0 0 transparent;
    height: 16px;
    width: 21px;
}
a.flag img {
    width: 21px;
    height: 16px;
}
.rsform5, .pago2checkout {
    border: 1px solid #333333;
    border-radius: 6px;
    padding: 5px;
    margin-bottom: 10px;
}
#rsform_5_page_0 .rsform-block-amount .formCaption {
    display: inline-block;
    vertical-align: middle;
    width: 125px;
}
#rsform_5_page_0 .rsform-block-amount .formBody {
    display: inline-block;
    vertical-align: middle;
}
#rsform_5_page_0 .rsform-block-amount {
    display: inline-block;
    vertical-align: middle;
    width: 266px;
}
#rsform_5_page_0 .rsform-block-process-payment {
    display: inline-block;
    vertical-align: middle;
    width: 117px;
    padding-left: 0;
}
#rsform_5_page_0 .rsform-block-process-payment .formCaption {
    display: none;
}
.imagen-paypal-peque img {
    max-width: 700px;
}
.menu-search-domains #rt-main .rt-grid-9 {
    margin: 0;
}
.payment-plans-img {
    position: absolute;
    top: -20px;
    left: 150px;
}

.customcode_add_this {
    float: none;
    margin: 0 auto;
    max-width: 510px;
    width: 100%;
}
.menu-domain-search #rt-main .separator, .menu-seo-analyzer #rt-main .separator {
    background: none repeat scroll 0 0 rgba(0, 0, 0, 0);
    border: 0 none;
    margin: 5px;
}
.menu-seo-analyzer #rt-main iframe#blockrandom {
    overflow-x: hidden;
}

.menu-blog .rt-article-bg p, .menu-blog .rt-article-bg span {
    font-family: inherit!important;
    font-size: inherit!important;
    text-align: justify!important;
}
.escope_ee img {
    width: 61px;
    height: 61px;
}
.escope_ee a {
    display: block;
    display: inline-block;
    padding: 5px;
    width: 61px;
    height: 61px;
    overflow: hidden;
    background: #333;
    border-radius: 5px;
}
/*
.menu-home #rt-mainbottom .rt-grid-6.rt-alpha {
    width: 665px;
}
.menu-home #rt-mainbottom .rt-grid-6.rt-omega {
    width: 250px;
}
*/
div.pp_overlay {
    height: 100% !important;
}

.menu-home .slide-item img.img-video-slider {
    border: 3px solid #fff;
    box-shadow: 0 0 6px #333;
}
.custom.slider-personal.arriba-h3 h3 {
    position: relative;
    z-index: 2;
}
#item-315, #item-270,#item-271{
    display: none;
}

.addthis_floating_style {
    position: absolute;
    left: 805px!important;
    margin-top: 12px;
}
.item-page {
    padding-top: 30px;
}
.post_recent_blog .nspArt h4.nspHeader {
    font-size: 15px;
    padding-bottom: 0;
}
.post_recent_blog .nspInfo1 {
    margin-bottom: 0;
}
.post_recent_blog .nspText {
    text-align: justify!important;
    margin-bottom: 10px!important;
}
#rt-sidebar-b #item-142 span span, #rt-sidebar-b #item-232 span span{
    color: #EB540A
}

.class01.mod_es h3{
    font-size: 20px
}
.mod-languagesmodseftranslatorfree li {
list-style: none;
display: inline-block;
margin-top: 2px;
vertical-align: top;
}
.mod-languagesmodseftranslatorfree li img {
    border: 1px solid #918B00;
    height: 12px;
}
.nn_sliders_content{
    text-align:justify;
}#rt-footer .rt-grid-4.rt-omega {    position: absolute;    width: 0;}#rt-footer .rt-grid-4 {    width: 48%;}center.visible {    visibility: hidden;    display: none;}
#iframe-tmpl .rt-article{
    padding-bottom:0
}