<?php
/**
 * Shortcodes 
 *
 * @package		Joomla
 * @subpackage	Zauan Schortcodes
 * @copyright Copyright (C) 2011 Zauan. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @author Zauan
 * @author url http://themeforest.net/user/zauan
 */
  // no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );



/*
* ------------------------------------------------- *
*		Module anywhere		
* ------------------------------------------------- *		
*/
//code
function am_module( $atts, $content = null ) {
	//[module type="" title="" style=""]
	
	if(isset($atts["type"]) && $atts["type"]) {
		$type = trim($atts["type"]);
		if(isset($atts["title"])) {
			$title = $atts["title"];
		} else {
			$title = '';
		}
		if(isset($atts["style"])) {
			$style = trim($atts["style"]);
		} else {
			$style = 'xhtml';
		}
		jimport( 'joomla.document.html.renderer' );
		$attribs['style'] = $style;
		$attribs['title'] = $title;

		//print_r($module);
		$zn_module = JDocumentRendererModule::render( $type, $attribs );
	}
	else {
		$zn_module = "You must specify the module type";
	}
	return $zn_module;
}

add_shortcode('module', 'am_module');


//Google Maps Shortcode
// [googlemap width="" height="" src=""] [/googlemap]
function am_googleMaps($atts, $content = null) {
   extract(shortcode_atts(array(
      "width" => '320',
      "height" => '230',
      "src" => ''
   ), $atts));
   return '<iframe width="'.$width.'" height="'.$height.'" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="'.$src.'"></iframe>';
}
add_shortcode("googlemap", "am_googleMaps");

/*
* ------------------------------------------------- *
*		Code		
* ------------------------------------------------- *		
*/
//code
function am_code( $atts, $content = null ) {
	//[code][/code]
	$am_code='<code>';
	$content = preg_replace('#^<\/p>|<p>$#', '', trim($content));
	$am_code .= do_shortcode($content);
	$am_code .='</code>';
	return $am_code;
}

add_shortcode('code', 'am_code');

//pre
function am_pre( $atts, $content = null ) {
	//[pre][/pre]
	$am_pre='<pre>';
	$content = preg_replace('#^<\/p>|<p>$#', '', trim($content));
	$am_pre .= do_shortcode($content);
	$am_pre .='</pre>';
	return $am_pre;
}

add_shortcode('pre', 'am_pre');

 /*
* ------------------------------------------------- *
*		Headings		
* ------------------------------------------------- *		
*/

//H1
function am_h1( $atts, $content = null ) {
	//[h1]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h1='<h1 '.$order.'>';
	$am_h1 .= do_shortcode(strip_tags($content));
	$am_h1.='</h1>';
	return $am_h1;
}

add_shortcode('h1', 'am_h1');

//H1
function am_h2( $atts, $content = null ) {
	//[h2]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h2='<h2 '.$order.'>';
	$am_h2 .= do_shortcode(strip_tags($content));
	$am_h2.='</h2>';
	return $am_h2;
}

add_shortcode('h2', 'am_h2');
//H1
function am_h3( $atts, $content = null ) {
	//[h3]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h3='<h3 '.$order.'>';
	$am_h3 .= do_shortcode(strip_tags($content));
	$am_h3.='</h3>';
	return $am_h3;
}

add_shortcode('h3', 'am_h3');
//H1
function am_h4( $atts, $content = null ) {
	//[h4][/h4]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h4='<h4 '.$order.'>';
	$am_h4 .= do_shortcode(strip_tags($content));
	$am_h4.='</h4>';
	return $am_h4;
}

add_shortcode('h4', 'am_h4');
//H1
function am_h5( $atts, $content = null ) {
	//[h5]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h5='<h5 '.$order.'>';
	$am_h5 .= do_shortcode(strip_tags($content));
	$am_h5.='</h5>';
	return $am_h5;
}

add_shortcode('h5', 'am_h5');
//H1
function am_h6( $atts, $content = null ) {
	//[h6]
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= 'class="'.trim($atts[0]).'"';
	}
	$am_h6='<h6 '.$order.'>';
	$am_h6 .= do_shortcode(strip_tags($content));
	$am_h6.='</h6>';
	return $am_h6;
}

add_shortcode('h6', 'am_h6');


/*
* ------------------------------------------------- *
*		TYPOGRAPHY	
* ------------------------------------------------- *		
*/
//p
function am_paragraph( $atts, $content = null ) {
	//[paragraph][/paragraph]
	$am_paragraph='<p>';
	$am_paragraph .= do_shortcode(strip_tags($content));
	$am_paragraph.='</p>';
	return $am_paragraph;
}

add_shortcode('paragraph', 'am_paragraph');

//blockquote
function am_blockquote( $atts, $content = null ) {
	//[blockquote][/blockquote]
	$am_blockquote='<blockquote>';
	$am_blockquote .= do_shortcode(strip_tags($content));
	$am_blockquote.='</blockquote>';
	return $am_blockquote;
}

add_shortcode('blockquote', 'am_blockquote');

/*
* ------------------------------------------------- *
*		highlights
* ------------------------------------------------- *		
*/
function am_highlights( $atts, $content = null ) {
	// [hlight red - yellow - blue - green - black25 - black50][/hlight]
	
	//class
	if (isset($atts[0]) && trim($atts[0])){
		$class="hlight_".trim($atts[0]);		
	}else{
		$class="hlight";
	}
  
	//fix shortcode
	$content = fixshortcode($content);  
	$content = '<span class="'.$class.'">'.trim($content).'</span>';
	 
	return $content;
}
add_shortcode('hlight', 'am_highlights');

/*
* ------------------------------------------------- *
*		lists		
* ------------------------------------------------- *		
*/
function am_lined_list( $atts, $content = null ) {
	// [list 1 - 2 - 3 - 4 - 5 - 6 - 7 - 8 - 9][/list]
	
	//class
	if (isset($atts[0]) && trim($atts[0])){
		$class=trim($atts[0]);		
	}
  
	//fix shortcode
	$content = fixshortcode($content);  
	$content = preg_replace('#<ul>#', '<ul class="list-type-'.$class.'">', trim($content));
	 
	return $content;
}

add_shortcode('list', 'am_lined_list');



/*
* ------------------------------------------------- *
*		BUTTONS
* ------------------------------------------------- *
*/
function am_bigbutton( $atts, $content = null ) {
 	//[big-button color="" link=""][/big-button]
	extract(shortcode_atts(array(
		"color" => 'yellow',
		"link" => '#'
	), $atts));

	return '<a href="'.$atts['link'].'" class="big-button '.$atts['color'].'">'.$content.'</a>';
}
add_shortcode('big-button', 'am_bigbutton');

function am_mediumbutton( $atts, $content = null ) {
 	//[medium-button color="" link=""][/medium-button]
	extract(shortcode_atts(array(
		"color" => 'yellow',
		"link" => '#'
	), $atts));

	return '<a href="'.$atts['link'].'" class="medium-button '.$atts['color'].'">'.$content.'</a>';
}
add_shortcode('medium-button', 'am_mediumbutton');

//small button
function am_smallbutton( $atts, $content = null ) {
 	//[small-button color="" link=""][/small-button]
	extract(shortcode_atts(array(
		"color" => 'yellow',
		"link" => '#'
	), $atts));

	return '<a href="'.$atts['link'].'" class="small-button '.$atts['color'].'">'.$content.'</a>';
}
add_shortcode('small-button', 'am_smallbutton');


function am_shortcode_buttons( $atts, $content = null ) {
	//[button link="" title="" style="1" or style="2" rounded="yes"][/button]

	$style=trim($atts["style"]);
	
	$link=trim($atts["link"]);
	if(!$link)  $link="#";
	
	$rounded=trim($atts["rounded"]);
	if($rounded == "yes") {$rounded = "rounded";}
	
	$title=trim($atts["title"]);

	//fix shortcode
	$content = wpautop(do_shortcode($content));	
	$content = fixshortcode($content);
	$content = preg_replace('#<br \/>#', "",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content)); 
 
	return '<a href="'.$link.'" title="'.$title.'" class="btn-style'.$style.' '.$rounded.'">' . $content . '</a>';
}

add_shortcode('button', 'am_shortcode_buttons');


/*
* ------------------------------------------------- *
*		show shortcode :)
* ------------------------------------------------- *
*/

function am_shortcode_show_shortcode( $atts, $content = null ) {
 
	//convert html [] spacial chars  

	//fix shortcode
	$content = fixshortcode($content);
	$content = preg_replace('#<br \/>#', "\n",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content));
	$content = preg_replace('#\[\/braket_close\]#', "[/show_shortcode]",trim($content));

	if($atts['code'] == "html5") {
		//return '<pre xml:lang="html5">' . $content . '</pre>';
		return $content;
	} else {
		return '<code>' . htmlspecialchars($content) . '</code>';
	}
}

add_shortcode('show_shortcode', 'am_shortcode_show_shortcode');


/*
* ------------------------------------------------- *
*		Accordions
* ------------------------------------------------- *
*/

function am_shortcode_accordion( $atts, $content = null ) {
    //[accordion style="1" or style="2" width=""][/accordion]

    //class
	$style = '';
	if (isset($atts['style']) && trim($atts['style'])){
		$style .= trim($atts['style']);		
	}
   $width='';
	if($atts['width']) { $width = 'width:'.$atts['width'].'px'; }
	
    //fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
    $content = preg_replace('#<p>#', "",trim($content));
    $content = preg_replace('#<\/p>#', "",trim($content)); 
    
    return '<div class="accordion-style-'.$style.'" style="'.$width.'">'.$content.'</div>';
}

function am_shortcode_toggle( $atts, $content = null ) {
    //[toggle style="1" or style="2" width=""][/toggle]

    //class
	$style = '';
	if (isset($atts['style']) && trim($atts['style'])){
		$style .= trim($atts['style']);		
	}
	$width='';
	if($atts['width']) { $width = 'width:'.$atts['width'].'px'; }
   
    //fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
    $content = preg_replace('#<p>#', "",trim($content));
    $content = preg_replace('#<\/p>#', "",trim($content)); 
    
    return '<div class="toggle-style-'.$style.'" style="'.$width.'">'.$content.'</div>';
}

function am_shortcode_accordion_panel( $atts, $content = null ) {
	//[acc_pane title=""][/acc_pane]
    
    $pane_title=$atts['title'];
	
    //fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
    $content = preg_replace('#<p>#', "",trim($content));
    $content = preg_replace('#<\/p>#', "",trim($content)); 

    return '<div class="acc_wrapper"><a href="#" class="acc_trigger"><span>'.$pane_title.'</span></a><div class="acc_container">' . $content . '<div class="clear"></div></div></div>';
}

function am_shortcode_toggle_panel( $atts, $content = null ) {
	//[tgg_pane title=""][/tgg_pane]
    
    $pane_title=$atts['title'];
	
    //fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
    $content = preg_replace('#<p>#', "",trim($content));
    $content = preg_replace('#<\/p>#', "",trim($content)); 

    return '<div class="tgg_wrapper"><a href="#" class="tgg-trigger"><span>'.$pane_title.'</span></a><div class="toggle_container">' . $content . '<div class="clear"></div></div></div>';
}

add_shortcode('accordion', 'am_shortcode_accordion');
add_shortcode('acc_pane', 'am_shortcode_accordion_panel');
add_shortcode('toggle', 'am_shortcode_toggle');
add_shortcode('tgg_pane', 'am_shortcode_toggle_panel');



/*
* ------------------------------------------------- *
*		Info Box
* ------------------------------------------------- *
*/

function am_shortcode_infobox( $atts, $content = null ) {
    //[infobox title="" align=""][/infobox]

    //align
    $align = $atts['align'];
    if($align) $align =  'small _'.$align;
    
    //Title
    $title=$atts['title'];
    
   
    //fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
    $content = preg_replace('#<p>#', "",trim($content));
    $content = preg_replace('#<\/p>#', "",trim($content)); 
    
    return '<div class="info_box '.$align.'"><div class="info_box_title"><h3>'.$title.'</h3></div><div class="info_box_content">'.$content.'<div class="clear"></div></div></div>';
} 

add_shortcode('infobox', 'am_shortcode_infobox'); 



/*
* ------------------------------------------------- *
*		GRIDS
* ------------------------------------------------- *
*/
function orderval($order) {
	if($order == "first") {
		$orderval = 'rt-alpha';
	} else if($order == "last") {
		$orderval = 'rt-omega';
	}
	return $orderval;	
}

function am_grid1( $atts, $content = null ) {
 	//[grid1][/grid1]
	//[grid1 first][/grid1]
	//[grid1 last][/grid1]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-1 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid1', 'am_grid1');

function am_grid2( $atts, $content = null ) {
 	//[grid2][/grid2]
	//[grid2 first][/grid2]
	//[grid2 last][/grid2]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-2 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid2', 'am_grid2');

function am_grid3( $atts, $content = null ) {
 	//[grid3][/grid3]
	//[grid3 first][/grid3]
	//[grid3 last][/grid3]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-3 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid3', 'am_grid3');

function am_grid4( $atts, $content = null ) {
 	//[grid4][/grid4]
	//[grid4 first][/grid4]
	//[grid4 last][/grid4]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-4 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid4', 'am_grid4');

function am_grid5( $atts, $content = null ) {
 	//[grid5][/grid5]
	//[grid5 first][/grid5]
	//[grid5 last][/grid5]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-5 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid5', 'am_grid5');

function am_grid6( $atts, $content = null ) {
 	//[grid6][/grid6]
	//[grid6 first][/grid6]
	//[grid6 last][/grid6]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);

	$grid  = '<div class="rt-grid-6 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid6', 'am_grid6');

function am_grid7( $atts, $content = null ) {
 	//[grid7][/grid7]
	//[grid7 first][/grid7]
	//[grid7 last][/grid7]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-7 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid7', 'am_grid7');

function am_grid8( $atts, $content = null ) {
 	//[grid8][/grid8]
	//[grid8 first][/grid8]
	//[grid8 last][/grid8]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-8 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid8', 'am_grid8');

function am_grid9( $atts, $content = null ) {
 	//[grid9][/grid9]
	//[grid9 first][/grid9]
	//[grid9 last][/grid9]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-9 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid9', 'am_grid9');

function am_grid10( $atts, $content = null ) {
 	//[grid10][/grid10]
	//[grid10 first][/grid10]
	//[grid10 last][/grid10]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-10 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid10', 'am_grid10');

function am_grid11( $atts, $content = null ) {
 	//[grid11][/grid11]
	//[grid11 first][/grid11]
	//[grid11 last][/grid11]

	//class
	$order = '';
	if (isset($atts[0]) && trim($atts[0])){
		$order .= trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-11 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid11', 'am_grid11');

function am_grid12( $atts, $content = null ) {
 	//[grid12][/grid12]
	//[grid12 first][/grid12]
	//[grid12 last][/grid12]

	//class
	if (isset($atts[0]) && trim($atts[0])){
		$order=trim($atts[0]);		
	}
	$content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
	
	$grid  = '<div class="rt-grid-12 '.orderval($order).'">';
	$grid .= $content;
	$grid .= '</div>';
	if($order == "last") {
		$grid .= '<div class="clear"></div>';
	}
	return $grid;
}
add_shortcode('grid12', 'am_grid12');

/*
* ------------------------------------------------- *
*		ANYTHING SLIDER COLUMS
* ------------------------------------------------- *
*/

function am_left( $atts, $content = null ) {
 	//[left width="" type="" textalign=""][/left]
	$width = '';
	if($atts['width'] != '') {	$width .= 'width:'.$atts['width'].'px;'; }
	$type = $atts['type'];
	//$textalign = 'text-align:'.$atts['textalign'].';';

	//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));

	return '<div class="alignleft '.$type.'" style="'.$width.$textalign.'">'.$content.'</div>';
}
add_shortcode('left', 'am_left');

function am_right( $atts, $content = null ) {
 	//[right width="" type=""  textalign=""][/right]
	$width = '';
	if($atts['width'] != '') {	$width .= 'width:'.$atts['width'].'px;'; }
	$textalign = '';
	//if($atts['textalign'] != '') {	$textalign .= 'text-align:'.$atts['textalign'].';'; }
	$type = $atts['type'];
	
	//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
   
	return '<div class="alignright '.$type.'" style="'.$width.$textalign.'">'.$content.'</div>';
}
add_shortcode('right', 'am_right');



// vimeo video
function am_vimeo( $atts, $content = null ) {
 	//[vimeo id="" width="" height="" autoplay="" color=""]
	extract(shortcode_atts(array(
		"id" => $atts['id'],
		"width" => '475',
		"height" => '350',
		"autoplay" => '0',
		"color" => '00adef'
	), $atts));

	return '<object width="'.$width.'" height="'.$height.'"><param name="allowfullscreen" value="true" /><param name="wmode" value="transparent" /><param name="allowscriptaccess" value="always" /><param name="movie" value="http://vimeo.com/moogaloop.swf?clip_id='.$id.'&amp;server=vimeo.com&amp;show_title=0&amp;show_byline=0&amp;show_portrait=0&amp;color='.$color.'&amp;fullscreen=1&amp;autoplay='.$autoplay.'&amp;loop=0" /><embed src="http://vimeo.com/moogaloop.swf?clip_id='.$id.'&amp;server=vimeo.com&amp;show_title=0&amp;show_byline=0&amp;show_portrait=0&amp;color='.$color.'&amp;fullscreen=1&amp;autoplay='.$autoplay.'&amp;loop=0" type="application/x-shockwave-flash" allowfullscreen="true" wmode="transparent" allowscriptaccess="always" width="'.$width.'" height="'.$height.'"></embed></object>';
}
add_shortcode('vimeo', 'am_vimeo');

// youtube video
function am_youtube( $atts, $content = null ) {
 	//[youtube id="" width="" height="" autoplay="" playhd=""]
	extract(shortcode_atts(array(
		"id" => $atts['id'],
		"width" => '475',
		"height" => '350',
		"autoplay" => '0',
		"playhd" => '0'
	), $atts));

	return '<object width="'.$width.'" height="'.$height.'"><param name="movie" value="http://www.youtube.com/v/'.$id.'?version=3&amp;hl=en_US&amp;rel=0&amp;hd='.$playhd.'&amp;autoplay='.$autoplay.'"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="http://www.youtube.com/v/'.$id.'?version=3&amp;hl=en_US&amp;rel=0&amp;hd='.$playhd.'&amp;autoplay='.$autoplay.'" type="application/x-shockwave-flash" width="'.$width.'" height="'.$height.'" allowscriptaccess="always" allowfullscreen="true"></embed></object>';
}
add_shortcode('youtube', 'am_youtube');

// big-quote
function am_quotes( $atts, $content = null ) {
 	//[quotes name=""][/quotes]
	//fix shortcode
	$content = fixshortcode($content);
	$content = preg_replace('#<br \/>#', "",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content)); 
	return '
<div class="quotes">
<blockquote>
<p>'.$content.'<br />
<small>'.$atts['name'].'</small>
</p>
</blockquote>
</div>';
}
add_shortcode('quotes', 'am_quotes');


function am_historic( $atts, $content = null ) {
 	//[historic year="" title="" order="" direction=""][/historic]
	
	$direction = $atts['direction'];
    if($direction) $direction =  'from'.$direction;
	
	$historic = '';
	if($atts['order'] == 'first') $historic .= '<div class="years">';
	
	$historic .= '<div class="year '.$direction.' '.$atts['order'].'">';
    $historic .= '<div class="date">'.$atts['year'].'</div>';
    $historic .= '<h4>'.$atts['title'].'</h4>';
    $historic .= do_shortcode($content);
    $historic .= '</div>';
	
	if($atts['order'] == 'last') { 
		$historic .= '</div>';
	}	
	
	return $historic;
}
add_shortcode('historic', 'am_historic');


function am_clients( $atts, $content = null ) {
 	//[clients][/clients]
	$content = fixshortcode($content);
	$content = preg_replace('#<br \/>#', "",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content)); 
	return '<div class="clients">'.$content.'</div>';
}
add_shortcode('clients', 'am_clients');


function am_separator( $atts, $content = null ) {
 	//[separator]
	return '<div class="separator"></div>';
}
add_shortcode('separator', 'am_separator');


function am_space( $atts, $content = null ) {
 	//[space height=""]
	return '<div style="height:'.$atts['height'].'px;"></div>';
}
add_shortcode('space', 'am_space');


function am_executive( $atts, $content = null ) {
 	//[executive name="" function="" description="" email="" phone="" facebook="" twitter="" gplus="" linkedin="" flickr="" order="" image=""]
	$template_path = JURI::base().'templates/'.JFactory::getApplication()->getTemplate();
	
	$executive = '';
	if($atts['order'] == 'last') { 
		$executive .= '<div class="executives last">';
	} else {
		$executive .= '<div class="executives">';
	}
	
	if($atts['image']) $executive .= '
	<a href="'.$atts['image'].'" rel="colorbox"><img src="'.$template_path.'/php/img.php?src='.JURI::base(true).'/'.$atts['image'].'&amp;w=165" alt="" class="member" /></a>';
	if($atts['name'])  $executive .= '<span class="name">'.$atts['name'].'</span>';
	if($atts['function'])  $executive .= '<span class="function">'.$atts['function'].'</span>';
	if($atts['description'])  $executive .= '<p>'.$atts['description'].'</p>';
	
	$executive .= '<ul>';
	if($atts['email']) $executive .= '<li>Email: <a href="mailto:'.$atts['email'].'">'.$atts['email'].'</a></li>';
	if($atts['phone']) $executive .= '<li>Phone: '.$atts['phone'].'</li>';
	
	$executive .= '</ul>
	<span class="social-profiles">';
	if($atts['facebook']) $executive .= '<a href="'.$atts['facebook'].'"><img src="'.$template_path.'/images/social_icons/facebook.png" alt="" /></a>';
	if($atts['twitter']) $executive .= '<a href="'.$atts['twitter'].'"><img src="'.$template_path.'/images/social_icons/twitter.png" alt="" /></a>';
	if($atts['gplus']) $executive .= '<a href="'.$atts['gplus'].'"><img src="'.$template_path.'/images/social_icons/gplus.png" alt="" /></a>'; 
	if($atts['linkedin']) $executive .= '<a href="'.$atts['linkedin'].'"><img src="'.$template_path.'/images/social_icons/linkedin.png" alt="" /></a>'; 
	if($atts['flickr']) $executive .= '<a href="'.$atts['flickr'].'"><img src="'.$template_path.'/images/social_icons/flickr.png" alt="" /></a>';  
	$executive .= '</span>';

	$executive .= '</div>';
	if($atts['order'] == 'last') { 
		$executive .= '<div class="clear"></div><div class="separator"></div>';
	}
	
	return $executive;
}
add_shortcode('executive', 'am_executive');


function am_core( $atts, $content = null ) {
 	//[core name="" function="" tooltip="" facebook="" twitter="" gplus="" linkedin="" flickr="" image=""]
	$template_path = JURI::base().'templates/'.JFactory::getApplication()->getTemplate();
	
	if($atts['order'] == 'last') { 
		$core = '<div class="core_team last">';
	} else {
		$core = '<div class="core_team">';
	}
	if($atts['tooltip']) {
		$class = 'hasTip';
		$tooltip = $atts['tooltip'];
	}
	
	if($atts['image']) $core .= '<a href="'.$atts['image'].'" rel="colorbox"><img src="'.$template_path.'/php/img.php?src='.JURI::base(true).'/'.$atts['image'].'&amp;w=85" alt="" class="member '.$class.' alignleft" title="'.$tooltip.'" /></a>';
	
	if($atts['name'])  $core .= '<span class="name">'.$atts['name'].'</span>';
	if($atts['function'])  $core .= '<span class="function">'.$atts['function'].'</span>';

	$core .= '<span class="social-profiles">';
	if($atts['facebook']) $core .= '<a href="'.$atts['facebook'].'"><img src="'.$template_path.'/images/social_icons/facebook.png" alt="" /></a>';
	if($atts['twitter']) $core .= '<a href="'.$atts['twitter'].'"><img src="'.$template_path.'/images/social_icons/twitter.png" alt="" /></a>';
	if($atts['gplus']) $core .= '<a href="'.$atts['gplus'].'"><img src="'.$template_path.'/images/social_icons/gplus.png" alt="" /></a>'; 
	if($atts['linkedin']) $core .= '<a href="'.$atts['linkedin'].'"><img src="'.$template_path.'/images/social_icons/linkedin.png" alt="" /></a>'; 
	if($atts['flickr']) $core .= '<a href="'.$atts['flickr'].'"><img src="'.$template_path.'/images/social_icons/flickr.png" alt="" /></a>';  
	$core .= '</span>';

	$core .= '</div>';
	if($atts['order'] == 'last') { 
		$core .= '<div class="clear"></div>';
	}
	return $core;
}
add_shortcode('core', 'am_core');

/*
* ------------------------------------------------- *
*		PRICING TABLE
* ------------------------------------------------- *
*/

function am_pricing_table( $atts, $content = null ) {
 	//[pricing_table cols="" style=""]
	// styles: orange, blue, purple, yellow, turqoise, darkred, red, green, green-lemon
	
	//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content)); 
	
	extract(shortcode_atts(array(
		"cols" => '4',
		"style" => 'orange'
	), $atts));
	
	$pricing_table = '<div class="pricing-table col'.$cols.' '.$style.'-style">';
	$pricing_table .= $content;
	$pricing_table .= '<div class="clear"></div></div>';
	
	return $pricing_table;
}
add_shortcode('pricing_table', 'am_pricing_table');



function am_pricing_column($atts, $content = null ) {
 	//[pricing_column title="" currency="" price="" order="" description="" button_title="" button_link="" highlight=""]
	
	extract(shortcode_atts(array(
		"title" => '',
		"currency" => '$',
		"price" => '',
		"order" => '',
		"description" => '$',
		"button_title" => 'Order now',
		"highlight" => 'no',
		"button_link" => '#'		
	), $atts));
	
	//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<br \/>#', "",trim($content));
	$content = preg_replace('#<p>#', "",trim($content));
	$content = preg_replace('#<\/p>#', "",trim($content));
	
	
	$promoted = '';
	if($highlight == "true") { $promoted = 'promoted'; }

	$pricing_column = '
		<div class="box '.$order.' '.$promoted.'">
			<div class="box-inner">
				<div class="title">'.$title.'</div>
				<div class="price">
				  <span class="curr">'.$currency.'</span>'.$price.'
				</div>
				<div class="price-type">
				  '.$description.'
				</div>
				'.$content.'
				<div class="action">
				  <a href="'.$button_link.'">'.$button_title.'</a>
				</div>
			</div>
		</div><!-- Box end -->';
	
	return $pricing_column;
}
add_shortcode('pricing_column', 'am_pricing_column');

function am_header_column($atts, $content = null ) {
 	//[header_column title="" description="" ]
	
	extract(shortcode_atts(array(
		"title" => '',
		"description" => ''		
	), $atts));
	
	//fix shortcode
    $content = wpautop(do_shortcode($content));	
    $content = fixshortcode($content);
    $content = preg_replace('#<ul>#', '<ul class="description">', trim($content));

	$header_column = '
		<div class="box first features">
			<div class="box-inner">
				<div class="title">'.$title.'</div>
				<div class="price">'.$description.'</div>
				'.$content.'
			</div>
		</div>';
	
	return $header_column;
}
add_shortcode('header_column', 'am_header_column');

function am_pricing_features($atts, $content = null ) {
	//[pricing_features][/pricing_features]
	$content = wpautop(do_shortcode($content));	
	$content = preg_replace('#<ul>#', '<ul class="description">', trim($content));
	return $content;
}
add_shortcode('pricing_features', 'am_pricing_features');

function am_help_tip($atts, $content = null ) {
	//[help_tip sign="" content=""]
	return '<a href="#" class="help hasTip" title="'.$atts['content'].'">'.$atts['sign'].'</a>';
}
add_shortcode('help_tip', 'am_help_tip');


?>