<?php
/**
 * @package Gantry Template Framework - RocketTheme
 * @version 3.2.8 August 1, 2011
 * @author RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2011 RocketTheme, LLC
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */
// no direct access
defined( '_JEXEC' ) or die( 'Restricted index access' );

// load and inititialize gantry class
require_once('lib/gantry/gantry.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-gb" lang="en-gb" xmlns:fb="http://ogp.me/ns/fb#">
<head>
    
        <meta name="google-site-verification" content="HsSVyNGf-EwX0xZjqHPP1kxusuBTmC_x_G82uc6M7hM" />
        <?php
            $gantry->displayHead();
            $gantry->addStyles(array('styles.css'));
			$template_path = JURI::base().'templates/'.JFactory::getApplication()->getTemplate().'/';
			if(JApplicationHelper::getComponentName() == 'com_vportfolio' && JRequest::getCmd('view') == 'carousels') {
				$doc =& JFactory::getDocument();
				$doc->addScript($template_path."js/jquery.tinycarousel.min.js");
			}
        ?>
        <link rel="shortcut icon" href="<?php echo JURI::base().'templates/'.$this->template; ?>/images/favicon.png"/>
		<script type="text/javascript">
        var template_dir = '<?php echo $template_path; ?>',
			hasChaser = <?php echo $gantry->get('chaser') ?>;
		</script>
		<script type="text/javascript" src="<?php echo $template_path; ?>/js/functions.js"></script>
		
        <?php
		if($gantry->get('demopanel') == 1) {
			require_once('demo/demo_header.php');
		}
		?>
        
        <script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-43312913-1', 'turnoverweb.com');
  ga('send', 'pageview');

</script>
<meta name="robots" content="noodp,noydir" />
    </head>
    <body <?php echo $gantry->displayBodyTag(); ?>>
    
	<?php
    if($gantry->get('demopanel') == 1) {
        require_once('demo/demo_panel.php');
    }
    ?>
        
        <?php /** Begin Drawer **/ if ($gantry->countModules('drawer')) : ?>
        <div id="rt-drawer">
            <div class="rt-container">
                <?php echo $gantry->displayModules('drawer','standard','standard'); ?>
                <div class="clear"></div>
            </div>
        </div>
        <?php /** End Drawer **/ endif; ?>
		<?php /** Begin Top **/ if ($gantry->countModules('top')) : ?>
		<div id="rt-top" <?php echo $gantry->displayClassesByTag('rt-top'); ?>>
			<div class="rt-container">
				<?php echo $gantry->displayModules('top','standard','standard'); ?>
				<div class="clear"></div>
			</div>
		</div>
		<?php /** End Top **/ endif; ?>
		<?php /** Begin Header **/ if ($gantry->countModules('header')) : ?>
		<div id="rt-header" class="<?php echo ($gantry->get('header-style') == "default") ? "" : $gantry->get('header-style'); ?>">
			<div class="rt-container">
				<?php echo $gantry->displayModules('header','standard','standard'); ?>
				<div class="clear"></div>
			</div>
            <div class="shadow-down"></div>
		</div>
		<?php /** End Header **/ endif; ?>
        
        <?php /** Begin Icon Widgets **/ if ($gantry->countModules('icon_widgets')) : ?>
		<div id="icon-widgets">
			<ul class="icon-menu">
				<?php echo $gantry->displayModules('icon_widgets','basic','basic'); ?>
			</ul>
		</div>
		<?php /** End Icon Widgets **/ endif; ?>
        
		<?php /** Begin Slideshow **/ //if ($gantry->countModules('slideshow')) : ?>
		<div id="slideshow">
			
			<?php echo $gantry->displayModules('slideshow','basic','basic'); ?>
            
            
            <?php /** Begin Swappers **/ if ($gantry->countModules('swapper')) : ?>
            <div id="swappers">
                <?php echo $gantry->displayModules('swapper','swlayout','swapper'); ?>
            </div>
            <?php /** End Swappers **/ endif; ?>
            
            <div class="shadow-up"></div>
		</div>
		<?php /** End Slideshow **/ //endif; ?>
        
        <div id="container" <?php if ($gantry->countModules('breadcrumb') <= 0 || $gantry->countModules('date') <= 0) echo 'class="noBreadcr"'; ?>>
        	<?php if ($gantry->get('chaser') == 1) {
        		echo '<div class="forchaser"></div>';
			} ?>
            <div class="bg-transparent"></div>
            
			<?php /** Begin Showcase **/ if ($gantry->countModules('showcase')) : ?>
            <div id="rt-showcase">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('showcase','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Showcase **/ endif; ?>
            
            <?php /** Begin Syserrors **/ if ($gantry->countModules('syserrors')) : ?>
            <div id="rt-system-errors">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('syserrors','basic','basic'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Syserrors **/ endif; ?>
            <?php /** Begin Breadcrumbs **/ if ($gantry->countModules('breadcrumb')) : ?>
            <div id="rt-breadcrumbs">
                <div class="rt-container">
                	<div class="rt-grid-12 rt-alpha rt-omega">
						<?php echo $gantry->displayModules('date','basic','basic'); ?>
                        <?php echo $gantry->displayModules('breadcrumb','basic','basic'); ?>
                    </div>
                    <div class="clear"></div>
                    <div class="separator"></div>
                </div>
            </div>
            <?php /** End Breadcrumbs **/ endif; ?>
            <?php /** Begin Main Top **/ if ($gantry->countModules('maintop')) : ?>
            <div id="rt-maintop">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('maintop','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Main Top **/ endif; ?>
            <?php /** Begin Main Body **/ ?>
            <?php echo $gantry->displayMainbody('mainbody','sidebar','standard','standard','standard','standard','standard'); ?>
            <?php /** End Main Body **/ ?>
            <?php /** Begin Utility **/ if ($gantry->countModules('utility')) : ?>
            <div id="rt-utility">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('utility','standard','basic'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Utility **/ endif; ?>
            <?php /** Begin Feature **/ if ($gantry->countModules('feature')) : ?>
            <div id="rt-feature">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('feature','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Feature **/ endif; ?>
            <?php /** Begin Main Bottom **/ if ($gantry->countModules('mainbottom')) : ?>
            <div id="rt-mainbottom">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('mainbottom','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Main Bottom **/ endif; ?>
            <?php /** Begin Bottom **/ if ($gantry->countModules('bottom')) : ?>
            <div id="rt-bottom">
            	<div class="shadow-up"><img src="<?php echo JURI::base().'templates/'.$this->template; ?>/images/shadow-up.png" alt="" /></div>
                <div class="rt-container">
                    <?php echo $gantry->displayModules('bottom','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Bottom **/ endif; ?>
            <?php /** Begin Footer **/ if ($gantry->countModules('footer')) : ?>
            <div id="rt-footer">
            
            	<?php if($gantry->get('twitter-enabled') == 1) { ?>
                <div class="twitter-wrapper">
                    <div class="rt-container">
                        <div class="rt-grid-12 rt-alpha rt-omega">
                        	<div id="twitter">
                            	<a href="http://twitter.com/<?php echo $gantry->get('twitter-username'); ?>" id="profileLink" class="hasTip" title="Follow us on Twitter">Follow us on Twitter</a>
								<?php 
                                require_once('lib/twitter.php');
								$list = twitterHelper::getList($gantry->get('twitter-username'),1);
								if (!$list) {
									echo 'The Twitter feeds didn\'t got parsed';
								}
								foreach ($list as $key => $item) : 
									echo '<div class="tweet">'.$item->text.'</div>';
									echo '<span class="time">'.$item->created_date.'</span>';
								endforeach;
								?>
                            </div>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div><!-- Twitter Wrapper -->
            	<?php } ?>
                
                <div class="rt-container">
                    <?php echo $gantry->displayModules('footer','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End Footer **/ endif; ?>
            <?php /** Begin banner-bottom **/ if ($gantry->countModules('banner-bottom')) : ?>
            <div id="rt-banner-bottom">
                <div class="rt-container">
                    <?php echo $gantry->displayModules('banner-bottom','standard','standard'); ?>
                    <div class="clear"></div>
                </div>
            </div>
            <?php /** End banner-bottom **/ endif; ?>
            
            <?php /** Begin Hidden Map **/ if ($gantry->countModules('hidden-map')) : ?>
            <div class="hidden-map-wrapper">
                <div class="shadow-top"></div>
                <div class="shadow-bottom"></div>
                <div class="close-map"></div>
                <?php echo $gantry->displayModules('hidden-map','basic','basic'); ?>
            </div>
            <?php /** End Hidden Map **/ endif; ?>
            
            <?php
            if ($gantry->countModules('totop')) :
                echo $gantry->displayModules('totop','basic','basic');
            endif;
            ?>
        </div><!-- Container End -->
        
		<?php /** Begin Debug **/ if ($gantry->countModules('debug')) : ?>
		<div id="rt-debug">
			<div class="rt-container">
				<?php echo $gantry->displayModules('debug','standard','standard'); ?>
				<div class="clear"></div>
			</div>
		</div>
		<?php /** End Debug **/ endif; ?>
		<?php /** Begin Analytics **/ if ($gantry->countModules('analytics')) : ?>
		<?php echo $gantry->displayModules('analytics','basic','basic'); ?>
		<?php /** End Analytics **/ endif; ?>
        <script type="text/javascript">
			if(jQuery("#rokbox-preguntas-frecuentes").length>0)
			{
				jQuery("#rokbox-preguntas-frecuentes").click(function(e)
				{
                   setTimeout(function()
					{
						var _modal = jQuery(".rokbox-content").find('#preguntas-frecuentes').parent();
						_modal.html('');
						jQuery("#preguntas-frecuentes").appendTo(_modal);
						_modal.find("#preguntas-frecuentes").addClass("rokbox-content-element");
						_modal.find("#preguntas-frecuentes").show();
						jQuery('.rokbox-inner, .rokbox-controls .rokbox-close').bind('click', function(event)
						{
							if(event.target == this )
							{
								_modal.find("#preguntas-frecuentes").appendTo('#contenedor-preguntas-frecuentes');
								jQuery("#preguntas-frecuentes").hide();
								e.stopPropagation();
							}
						 });
						jQuery(document).keydown(function(e)
						{
							if(e.keyCode == 27)
							{
								var _modal = jQuery(".rokbox-content").find('#preguntas-frecuentes').parent();
								_modal.find("#preguntas-frecuentes").appendTo('#contenedor-preguntas-frecuentes');
								jQuery("#preguntas-frecuentes").hide();
							}
						});
					}, 2000); 
                });
			}
		</script>
	</body>
</html>
<?php
$gantry->finalize();
?>