<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package web2feel
 * @since web2feel 1.0
 */

get_header(); ?>

<div class="widecontainer">
	<?php get_template_part( 'slider', 'index' ); ?>
	<div class="cta">
	<p> <?php echo of_get_option('w2f_intro_text'); ?> </p>
</div>
</div>

<div class="container_12 main-cover cf">
		<div id="primary" class="content-area grid_8">
			<div id="content" class="site-content cf" role="main">
			
			<?php if ( have_posts() ) : ?>
			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>
				
			<article id="post-<?php the_ID(); ?>" <?php post_class('cf'); ?>>
				
				<?php
					$thumb = get_post_thumbnail_id();
					$img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the images too big)
					$image = aq_resize( $img_url, 280, 180, true ); //resize & crop the image
				?>
				
					<?php if($image) : ?>
						<a href="<?php the_permalink(); ?>"><img class="post-image" src="<?php echo $image ?>"/></a>
					<?php endif; ?>				
				
					<div class="boxright">
					<header class="entry-header">
						<h1 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'web2feel' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h1>

					</header><!-- .entry-header -->
					
					<div class="entry-summary">
						<?php wpe_excerpt('wpe_excerptlength_index', ''); ?>
					</div><!-- .entry-summary -->
					<a href="<?php the_permalink(); ?>" class="rmore" > Read More </a>
					</div>
				
	
			</article><!-- #post-<?php the_ID(); ?> -->

				<?php endwhile; ?>

				<div class="paginate ">
					<?php kriesi_pagination(); ?>
				</div>

			<?php elseif ( current_user_can( 'edit_posts' ) ) : ?>

				<?php get_template_part( 'no-results', 'index' ); ?>

			<?php endif; ?>

			</div><!-- #content .site-content -->
		</div><!-- #primary .content-area -->

<?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>