<?php
  
  /**
   * on_daily event handler
   * 
   * @package angie.frameworks.email
   * @subpackage handlers
   */

  /**
   * Handle on_daily event
   */
  function email_handle_on_daily() {
  	ApplicationMailer::sendDigest(OutgoingMessages::findByMethod(ApplicationMailer::SEND_DAILY));
    MailingActivityLogs::cleanUp();
    
    //if there is conflicts and send_on_daily is configured
    if(ConfigOptions::getValue('conflict_notifications_delivery') == IncomingMail::CONFLICT_NOTIFY_ON_DAILY && IncomingMails::countConflicts() > 0) {
      ApplicationMailer::notifier()->notifyAdministrators(null, 'email/conflict_notify_on_daily', array(
        'conflict_num' => IncomingMails::countConflicts(),
        'conflict_page_url' => Router::assemble('incoming_email_admin_conflict')
      ));
    }//if
    
  } // email_handle_on_daily