<?php

  /**
   * configure_homescreen helper implementation
   * 
   * @package angie.frameworks.homescreens
   * @subpackage helpers
   */

  /**
   * Configure homescreen helper
   * 
   * @param array $params
   * @param Smarty $smarty
   * @return string
   */
  function smarty_function_configure_homescreen($params, &$smarty) {
    $homescreen = array_required_var($params, 'homescreen', true, 'Homescreen');
    $user = array_required_var($params, 'user', true, 'IUser');
    
    $id = isset($params['id']) && $params['id'] ? $params['id'] : HTML::uniqueId('configure_homescreen');
    
    //$homescreen = new Homescreen();
    
    $settings = array(
      'add_tab_url' => $homescreen->getAddTabUrl(), 
      'reorder_tabs_url' => $homescreen->getReorderTabsUrl(), 
      'tabs' => array(), 
    );
    
    if($homescreen->getTabs() instanceof DBResult) {
      foreach($homescreen->getTabs() as $tab) {
        $settings['tabs'][] = $tab->describe($user, true, true);
      } // foreach
    } // if
    
    return '<div id="' . $id . '"></div><script type="text/javascript">$("#' . $id . '").configureHomescreen(' . JSON::encode($settings) . ');</script>';
  } // smarty_function_configure_homescreen