/* Minified: jquery.InvoiceForm.js, jquery.invoiceNote.js, jquery.selectInvoiceDueOn.js, widgets.invoiceDesigner.js */
(function($){var plugin_name="invoiceForm";var settings={mode:"add",notes:{},initial_note:"",item_templates:{},company_details_url:"",company_projects_url:"",move_icon_url:""};var public_methods={init:function(options){return this.each(function(){var _this=this;var $this=$(this);_initvar($this);_var($this).settings=$.extend({},settings,options||{});initialize_id_field.apply(_this);initialize_notes_chooser.apply(_this);initialize_company_chooser.apply(_this);initialize_items_editor.apply(_this);initialize_project_picker.apply(_this);validate_form_elements.apply(_this)})}};var validate_form_elements=function(){var wrapper=$(this);var occurrence=wrapper.find('input[type="text"].occurrence:first');if(occurrence.length){occurrence.bind("change blur",function(event){var value=occurrence.val();if(parseInt(value)!=value||value<1){App.Wireframe.Flash.error("Occurrence has to be numeric value");if(event.type=="blur"){setTimeout(function(){occurrence.focus()},100)}}})}};var initialize_items_editor=function(){var _this=this;var $this=$(this);var items_table=_var($this).items_table=$this.find("div.invoice_items_wrapper table:first");var items_table_body=_var($this).items_table_body=items_table.find("tbody:first");var main_form_column=_var($this).main_form_column=$this.find(".main_form_column");var tax_rates=_var($this).settings.tax_rates;var tax_rate_chooser=$('<select><option value="0" rate="0">'+App.lang("No Tax")+"</option></select>");var tax_rate_chooser_select=tax_rate_chooser;if(tax_rates){$.each(tax_rates,function(){tax_rate_chooser_select.append('<option rate="'+this.percentage+'" value="'+this.id+'">'+this.name+"</option>")})}_var($this).tax_rate_chooser=tax_rate_chooser;var add_item_button=_var($this).add_item_button=$this.find("div.invoice_items_wrapper #add_new:first");add_item_button.click(function(){add_item_row.apply(_this);return false});handle_keypresses.apply(_this);handle_input_changes.apply(_this);handle_deletion.apply(_this);handle_item_templates.apply(_this);handle_reordering.apply(_this);var items=_var($this).settings.items;if(items&&items.length){$.each(items,function(id,data){add_item_row.apply(_this,[{id:data.id,description:data.description,unit_cost:data.unit_cost,quantity:data.quantity,tax_rate_id:data.tax_rate_id},true])});recalculate_invoice_totals.apply(_this,[true]);reindex_item_rows.apply(_this);scroll_to_bottom.apply(_this,[true])}else{add_item_row.apply(_this);reindex_item_rows.apply(_this)}};var handle_item_templates=function(){var _this=this;var $this=$(this);var add_from_template_button=$this.find("div.invoice_items_wrapper #add_from_template:first");var item_templates=_var($this).settings.item_templates;add_from_template_button.find("a").each(function(){var anchor=$(this);anchor.click(function(){var current_template=item_templates[anchor.attr("href")];add_item_row.apply(_this,[{description:current_template.description,unit_cost:current_template.unit_cost,quantity:current_template.quantity,tax_rate_id:current_template.tax_rate_id}]);return false})})};var handle_deletion=function(){var _this=this;var $this=$(this);var items_table=_var($this).items_table;items_table.click(function(event){var invoker=event.target;var $invoker=$(invoker);if($invoker.is("img.button_remove")){delete_item_row.apply($this,[$invoker.parents("tr:first")]);return false}})};var handle_keypresses=function(){var _this=this;var $this=$(this);var items_table=_var($this).items_table;items_table.bind("keydown",function(event){var invoker=event.target;var invoker_class=invoker.tagName;if(invoker_class=="INPUT"||invoker_class=="SELECT"){if((event.which==13)&&(invoker_class=="INPUT")){$invoker=$(invoker);$invoker.change();var next_row=$invoker.parents("tr:first").next();if(next_row.is("tr")){next_row.find("input[type=text], select").eq(0).focus()}else{add_item_row.apply(_this)}return false}else{if(new RegExp("\\bnumber_input\\b").test(invoker.className)){if((event.which>=48)&&(event.which<=57)||(event.which==46)||(event.which==45)||(event.which==43)||(event.altKey||event.metaKey||event.ctrlKey||(event.keyCode>0))){if((event.which==46)&&(invoker.value.indexOf(".")>0)){return false}else{return true}}else{return false}}}return true}})};var handle_input_changes=function(){var _this=this;var $this=$(this);var items_table=_var($this).items_table;items_table.bind("change",function(event){var invoker=event.target;var invoker_class=invoker.tagName.toUpperCase();if(invoker_class=="INPUT"||invoker_class=="SELECT"){$invoker=$(invoker);var invoker_row=$invoker.parents("tr:first");if($invoker.is(".number_input")){$invoker.val(App.parseNumeric($invoker.val()).toFixed(2))}recalculate_item_row.apply(_this,[invoker_row,$invoker])}});items_table.bind("click",function(event){var invoker=event.target;var invoker_class=invoker.tagName.toUpperCase();if(invoker_class=="SELECT"){$invoker=$(invoker);var invoker_row=$invoker.parents("tr:first");recalculate_item_row.apply(_this,[invoker_row])}})};var add_item_row=function(values,batch_add){var _this=this;var $this=$(this);var items_table_body=_var($this).items_table_body;var one=1;var zero=0;var rows=items_table_body.find("tr");if(!batch_add){if(rows.length){var destination_row=null;rows.each(function(){var row=$(this);var row_description=row.find("td.description input:[type=text]:first");var row_quantity=row.find("td.quantity").find("input:[type=text], input:[type=number]").eq(0);var row_unit_cost=row.find("td.unit_cost").find("input:[type=text], input:[type=number]").eq(0);var row_unit_total=row.find("td.total").find("input:[type=text], input:[type=number]").eq(0);if(!row_description.val()&&!parseInt(row_unit_cost.val())&&!parseInt(row_unit_total.val())&&(row_quantity.val()==one.toFixed(2))){destination_row=row;return false}});if(destination_row){if(values){do_update_item_row.apply(_this,[destination_row,values])}else{destination_row.find('input[type="text"]:first').focus()}}else{do_add_item_row.apply(_this,[values])}}else{do_add_item_row.apply(_this,[values])}recalculate_invoice_totals.apply(_this);reindex_item_rows.apply(_this);scroll_to_bottom.apply(_this)}else{do_add_item_row.apply(_this,[values])}};var do_add_item_row=function(values){var _this=this;var $this=$(this);var items_table_body=_var($this).items_table_body;var zero=0;var one=1;var row_number=0;items_table_body.find("tr.item").each(function(){var loop_row_id=$(this).attr("row_number");row_number=Math.max(loop_row_id,row_number)});row_number++;var next_row_name="invoice[items]["+row_number+"]";var tax_rate_chooser=_var($this).tax_rate_chooser.clone().attr("name",next_row_name+"[tax_rate_id]").attr("value",(values&&values.tax_rate_id?values.tax_rate_id:""));var row=$('<tr class="item" id="items_row_'+row_number+'" row_number="'+row_number+'"><td class="num"><span></span><img src="'+_var($this).settings.move_icon_url+'" class="move_handle" /><input type="hidden" name="'+next_row_name+'[old_item_id]" value="'+(values&&values.id?values.id:0)+'"/></td><td class="description"><input type="text" name="'+next_row_name+'[description]" value="'+(values&&values.description?values.description:"")+'" required="true" /></td><td class="quantity"><input type="number" name="'+next_row_name+'[quantity]" class="short number_input input_quantity" step="0.01" value="'+(values&&values.quantity?values.quantity.toFixed(2):one.toFixed(2))+'" /></td><td class="unit_cost"><input type="number" name="'+next_row_name+'[unit_cost]" class="short number_input input_unit_cost" step="0.01" value="'+(values&&values.unit_cost?values.unit_cost.toFixed(2):zero.toFixed(2))+'" /></td><td class="tax_rate"></td><td class="subtotal" style="display: none"><input type="hidden" name="'+next_row_name+'[subtotal]" value="" /></td><td class="total"><input type="number" name="invoice'+next_row_name+'[total]" value="'+zero.toFixed(2)+'" class="number_input input_total" step="0.01"/></td><td class="options"><img src="'+_var($this).settings.delete_icon_url+'" class="button_remove" /></td></tr>');row.find("td.tax_rate").append(tax_rate_chooser);row.appendTo(items_table_body);if(!values&&_var($this).settings.default_tax_rate){tax_rate_chooser.val(_var($this).settings.default_tax_rate.id)}row.find("select, input[type=text]").eq(0).focus();recalculate_item_row.apply(_this,[row])};var do_update_item_row=function(row,values){var _this=this;var zero=0;var one=0;row.find("td.description input:first").attr("value",values&&values.description?values.description:"").focus();row.find("td.unit_cost input:first").attr("value",values&&values.unit_cost?values.unit_cost.toFixed(2):one.toFixed(2));row.find("td.quantity input:first").attr("value",values&&values.quantity?values.quantity.toFixed(2):zero.toFixed(2));var tax_rate=row.find("td.tax_rate select:first").attr("value",values&&values.tax_rate_id?values.tax_rate_id:"");if(values&&!values.tax_rate_id){tax_rate.find("option:first").attr("selected","selected")}recalculate_item_row.apply(_this,[row])};var delete_item_row=function(row){var _this=this;var $this=$(this);var prev_row=row.prev("tr");var next_row=row.next("tr");if((prev_row.length>0)||(next_row.length>0)){row.remove();if(prev_row.length>0){prev_row.find("select, input[type=text]").eq(0).focus()}else{if(next_row.length>0){next_row.find("select, input[type=text]").eq(0).focus()}}recalculate_invoice_totals.apply(_this);reindex_item_rows.apply(_this)}};var recalculate_item_row=function(row,invoker){var _this=this;var $this=$(this);var total_field=row.find("td.total input:first");var unit_cost_field=row.find("td.unit_cost input:first");var subtotal_field=row.find("td.subtotal input:first");var total=App.parseNumeric(total_field.val()).toFixed(2);var unit_cost=App.parseNumeric(unit_cost_field.val()).toFixed(2);var quantity=App.parseNumeric(row.find("td.quantity input").val()).toFixed(2);var tax_rate=App.parseNumeric(row.find("td.tax_rate select option:selected").attr("rate"));if(invoker&&invoker.is(".input_total")){if(isNaN(quantity)||isNaN(unit_cost)){var subtotal=0;var unit_cost=0}else{var subtotal=quantity*unit_cost;var unit_cost=total/(quantity*(1+tax_rate/100))}unit_cost_field.val(unit_cost.toFixed(2))}else{if(isNaN(quantity)||isNaN(unit_cost)){var subtotal=0;var total=0}else{var subtotal=quantity*unit_cost;var total=subtotal*(1+tax_rate/100)}total_field.val(total.toFixed(2))}subtotal_field.val(subtotal.toFixed(2));recalculate_invoice_totals.apply(_this)};var recalculate_invoice_totals=function(full_recalculation){var _this=this;var $this=$(this);var items_table=_var($this).items_table;var items_table_body=_var($this).items_table_body;if(full_recalculation){items_table_body.find("tr").each(function(){recalculate_item_row.apply(_this,[$(this)])})}var subtotal=0;var total=0;items_table_body.find("tr.item td.subtotal input").each(function(){subtotal+=App.parseNumeric($(this).val())});items_table_body.find("tr.item td.total input").each(function(){total+=App.parseNumeric($(this).val())});items_table.find("tfoot tr.invoice_subtotal td.total input:first").val(subtotal.toFixed(2));items_table.find("tfoot tr.invoice_total td.total input:first").val(total.toFixed(2))};var reindex_item_rows=function(){var _this=this;var $this=$(this);var items_table=_var($this).items_table;var counter=1;items_table.find("tr.item td.num span").each(function(){this.innerHTML=counter;counter++})};var scroll_to_bottom=function(with_delay){var _this=this;var $this=$(this);if(with_delay){setTimeout(function(){_var($this).main_form_column.scrollTo({top:_var($this).items_table_body.height()},{duration:1000})},500)}else{_var($this).main_form_column.scrollTo({top:_var($this).items_table_body.height()},{duration:1000})}};var handle_reordering=function(){var _this=this;var $this=$(this);var items_table_body=_var($this).items_table_body;items_table_body.sortable({axis:"y",items:"tr.item",handle:".move_handle",start:function(){},stop:function(){reindex_item_rows.apply(_this)}})};var initialize_id_field=function(){var _this=this;var $this=$(this);var ID_autogenerate=$this.find("#autogenerateID");var ID_manually=$this.find("#manuallyID");ID_autogenerate.find("a").click(function(){ID_autogenerate.hide();ID_manually.show();return false});ID_manually.find("a").click(function(){ID_autogenerate.show();ID_manually.hide();ID_manually.find("input").val("");return false})};var initialize_notes_chooser=function(){return true;var _this=this;var $this=$(this);var select_predefined=$this.find("#predefined_notes");var note_field=$this.find("#invoice_note");select_predefined.change(function(){var selected_id=select_predefined.attr("value");if(_var($this).settings.notes&&_var($this).settings.notes[selected_id]!==undefined){note_field.val(_var($this).settings.notes[selected_id]);note_field.show()}else{if(selected_id=="empty"){note_field.val("");note_field.hide()}else{if(selected_id=="original"){note_field.val(_var($this).settings.initial_note);note_field.show()}else{if(selected_id=="custom"){note_field.val("");note_field.show()}}}}});select_predefined.change()};var initialize_company_chooser=function(){var _this=this;var $this=$(this);if(_var($this).settings.company_details_url){var company_id=$this.find("#companyId");var company_address=$this.find("#companyAddress");var ajax_request;company_id.change(function(){if(company_id.val()){var ajax_url=App.extendUrl(_var($this).settings.company_details_url,{company_id:company_id.val(),async:1,skip_layout:1});if((ajax_request)&&(ajax_request.readyState!=4)){ajax_request.abort()}if(!company_address.is("loading")){company_address.addClass("loading")}company_address.attr("disabled",true);company_id.attr("disabled",true);ajax_request=$.ajax({url:ajax_url,success:function(response){company_address.val(response);company_address.removeClass("loading");company_address.attr("disabled",false);company_id.attr("disabled",false)}})}});if(_var($this).settings.mode=="add"){company_id.change()}}};var initialize_project_picker=function(){var _this=this;var $this=$(this);if(_var($this).settings.company_projects_url){var projects_picker=$this.find("select.select_project");var company_picker=$this.find("#companyId");var filter=$this.find("#selected_company_projects");var active_projects_wrapper=$("#opt_active");var completed_projects_wrapper=$("#opt_completed");var projects_list={active:[],completed:[]};if(projects_picker.length==0){filter.parent().remove();return}active_projects_wrapper.find("option").each(function(){projects_list.active[$(this).val()]=$(this).text()});completed_projects_wrapper.find("option").each(function(){projects_list.completed[$(this).val()]=$(this).text()});filter.click(function(){filter_projects()});company_picker.change(function(){filter_projects()});var filter_projects=function(){if(filter.is(":checked")){do_filter_projects()}else{show_all_projects()}};var do_filter_projects=function(){var company_project_ids=get_project_ids();if(company_project_ids.active.length==0&&company_project_ids.completed==0){hide_all_projects();App.Wireframe.Flash.error("Selected company is not client on any of existing projects")}else{feed_project_list(company_project_ids)}};var get_project_ids=function(){var project_ids;var company_projects_url=App.extendUrl(_var($this).settings.company_projects_url.replace("--COMPANY_ID--",company_picker.val()),{for_select_box:1,async:1});company_picker.attr("disabled",true);projects_picker.attr("disabled",true);$.ajax({url:company_projects_url,async:false,success:function(response){project_ids=response;company_picker.attr("disabled",false);projects_picker.attr("disabled",false)}});return project_ids};var show_all_projects=function(){feed_project_list(projects_list)};var hide_all_projects=function(){active_projects_wrapper.html("");completed_projects_wrapper.html("")};var feed_project_list=function(projects){hide_all_projects();$.each(projects.active,function(id,name){if(typeof name!=="undefined"){active_projects_wrapper.append('<option value="'+id+'">'+name+"</option>")}});$.each(projects.completed,function(id,name){if(typeof name!=="undefined"){completed_projects_wrapper.append('<option value="'+id+'">'+name+"</option>")}})}}};$.fn[plugin_name]=function(method){if(public_methods[method]){return public_methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof method==="object"||!method){return public_methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist on jQuery.invoiceForm")}}};var _var=function(element){return element.data(plugin_name+"Variables")};var _initvar=function(element){element.data(plugin_name+"Variables",{})}})(jQuery);
jQuery.fn.invoiceNote=function(s){var settings=jQuery.extend({label:App.lang("Invoice Note"),name:"invoice[note]",notes:[],value:null,required:false},s);return this.each(function(){var wrapper=$(this).addClass("invoice_note");var textarea_id=wrapper.attr("id")+"_textarea";if($(settings.notes).length){var select='<select class="invoice_note_from_template"><option value="">'+App.lang("-- From Template --")+'</option><option value=""></option>';for(var note_id in settings.notes){select+='<option value="'+note_id+'">'+settings.notes[note_id]["name"].clean()+"</option>"}select+="</select>"}else{var select=""}var content=select+"<label for="+textarea_id+' class="main_label">'+settings.label.clean()+": "+(settings.required?"*":"")+"</label><textarea name="+settings.name.clean()+' cols="48" rows="10""></textarea>';wrapper.append(content);wrapper.find("select.invoice_note_from_template").change(function(){var note_id=$(this).val();if(note_id&&typeof(settings.notes[note_id])=="object"&&settings.notes[note_id]){wrapper.find("textarea").val(settings.notes[note_id]["content"])}});if(settings.value){wrapper.find("textarea").val(settings.value)}})};
jQuery.fn.selectInvoiceDueOn=function(){return this.each(function(){var wrapper=$(this);wrapper.find("input[type=radio]").click(function(){if($(this).attr("value")=="selected"){wrapper.find("div.select_invoice_due_on_selected").slideDown()}else{wrapper.find("div.select_invoice_due_on_selected").slideUp()}})})};
(function($){var public_methods={init:function(options){return this.each(function(){var wrapper=$(this);var wrapper_dom=this;this.id_data={};this.id_data.settings=jQuery.extend({params:{},maximum_vertical_margin_offset:100,maximum_horizontal_margin_offset:80,guide_grid_size:5,section_offset:5},options);this.id_data.paper=wrapper.find(".invoice_designer_paper");this.id_data.settings_buttons=wrapper.find(".invoice_designer_buttons ul");init_settings_buttons.apply(this);init_event_listeners.apply(this);render_template.apply(this,[options.template])})}};var render_template=function(template){this.id_data.paper.find(".render").remove();this.id_data.render=$('<div class="render"></div>').appendTo(this.id_data.paper);if(template.background_image){this.id_data.render.append('<img src="'+template.background_image+'" class="background_image" />')}this.id_data.render_header=$('<div class="header"></div>').appendTo(this.id_data.render);this.id_data.render_body=$('<div class="body"></div>').appendTo(this.id_data.render);this.id_data.render_footer=$('<div class="footer"></div>').appendTo(this.id_data.render);if(template.print_logo){$('<div class="company_logo"><img src="'+template.company_logo+'" /></div>').appendTo(this.id_data.render_header)}if(template.print_company_details){$('<div class="company_details">'+template.company_name+"<br />"+template.company_details.nl2br()+"</div>").appendTo(this.id_data.render_header).css("color",template.header_text_color)}if(template.print_header_border){this.id_data.render_header.css("border-bottom","1px solid "+template.header_border_color)}if(parseInt(template.header_layout)){this.id_data.render_header.addClass("inverse_layout")}this.id_data.render_body_top=$('<div class="body_top"></div>').appendTo(this.id_data.render_body);this.id_data.render_invoice_details=$('<div class="invoice_details"></div>').appendTo(this.id_data.render_body_top).css("color",template.invoice_details_text_color);this.id_data.render_invoice_details.append('<div class="invoice_number">'+this.id_data.settings.invoice.name["long"]+"</div>");this.id_data.render_invoice_details.append('<div class="issued_on">'+App.lang("Issued On: :issue_date",{issue_date:this.id_data.settings.invoice.issued_on.formatted_date})+"</div>");this.id_data.render_invoice_details.append('<div class="due_on">'+App.lang("Payment Due On: :due_date",{due_date:this.id_data.settings.invoice.due_on.formatted_date})+"</div>");this.id_data.render_client_details=$('<div class="client_details"><div class="client_details_inner"><strong>'+this.id_data.settings.invoice.client.name+"</strong><br />"+this.id_data.settings.invoice.client.address.nl2br()+"</div></div>").appendTo(this.id_data.render_body_top).css("color",template.client_details_text_color);if(parseInt(template.body_layout)){this.id_data.render_body_top.addClass("inverse_layout")}this.id_data.render_table=$('<table class="items" cellspacing="0"><tr><th></th><th>'+App.lang("Description")+'</th><th class="quantity">'+App.lang("Qty.")+'</th><th class="unit_cost">'+App.lang("Unit Cost")+'</th><th class="tax">'+App.lang("Tax")+'</th><th class="total">'+App.lang("Total")+"</th></tr></table>").appendTo(this.id_data.render_body);var designer=this;$.each(this.id_data.settings.invoice.items,function(item){designer.id_data.render_table.append('<tr><td class="number">1.</td><td class="description">'+this.description+'</td><td class="quantity">'+this.quantity+'</td><td class="unit_cost">'+this.unit_cost.toFixed(2)+'</td><td class="tax">'+this.tax.value.toFixed(2)+'</td><td class="total">'+this.total.toFixed(2)+"</td></tr>")});this.id_data.render_items_total=$('<table class="items_total" cellspacing="0"></table>').insertAfter(this.id_data.render_table);this.id_data.render_items_total.append('<tr><td class="label">'+App.lang("Subtotal")+'</td><td class="amount">'+this.id_data.settings.invoice.subtotal.toFixed(2)+"</td></tr>");this.id_data.render_items_total.append('<tr><td class="label">'+App.lang("Tax Total")+'</td><td class="amount">'+this.id_data.settings.invoice.tax.toFixed(2)+"</td></tr>");this.id_data.render_items_total.append('<tr><td class="label">'+App.lang("Total")+'</td><td class="amount">'+this.id_data.settings.invoice.total.toFixed(2)+"</td></tr>");this.id_data.render_table.css("color",template.items_text_color);this.id_data.render_items_total.css("color",template.items_text_color);if(template.print_items_border){this.id_data.render_table.find("td,th").css("border-bottom","1px solid "+template.items_border_color);this.id_data.render_items_total.find("td").css("border-bottom","1px solid "+template.items_border_color)}if(template.print_table_border){this.id_data.render_table.find("th").css("border-bottom","1px solid "+template.table_border_color);this.id_data.render_table.find("tr:last-child td").css("border-bottom","1px solid "+template.table_border_color);this.id_data.render_items_total.find("tr:last-child td").css("border-bottom","1px solid "+template.table_border_color)}this.id_data.render_note=$('<div class="invoice_note"><strong>'+App.lang("Note")+":</strong><br />"+this.id_data.settings.invoice.note+"</div>").appendTo(this.id_data.render_body);this.id_data.render_note.css("color",template.note_text_color);if(template.print_footer){this.id_data.render_footer.css("color",template.footer_text_color);this.id_data.render_footer.append('<div class="invoice_number">'+this.id_data.settings.invoice.name["long"]+"</div>");this.id_data.render_footer.append('<div class="pager">'+App.lang("Page 1 of 1")+"</div>");if(template.print_footer_border){this.id_data.render_footer.css("border-top","1px solid "+template.footer_border_color)}if(parseInt(template.footer_layout)){this.id_data.render_footer.addClass("inverse_layout")}}};var init_event_listeners=function(){var designer=this;App.Wireframe.Events.bind("invoice_settings_updated.content",function(event,invoice_template){render_template.apply(designer,[invoice_template])})};var init_settings_buttons=function(){this.id_data.settings_buttons.find("a").each(function(){var anchor=$(this);anchor.flyoutForm({title:anchor.text(),success_event:"invoice_settings_updated",width:anchor.attr("flyout_width")?anchor.attr("flyout_width"):undefined})})};var plugin_name="invoiceDesigner";$.fn[plugin_name]=function(method){if(public_methods[method]){return public_methods[method].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof method==="object"||!method){return public_methods.init.apply(this,arguments)}else{$.error("Method "+method+" does not exist in jQuery."+plugin_name)}}}})(jQuery);
