<?php
/*------------------------------------------------------------------------
# com_vportfolio - Vportfolio component
# ------------------------------------------------------------------------
# author    Vsmart Extensions
# copyright Copyright (C) 2010 www.vsmart-extensions.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.vsmart-extensions.com
# Technical Support:  Forum - http://www.vsmart-extensions.com
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.application.component.controller' );

/**
 * Note: this view is intended only to be opened in a popup
 * @package Joomla
 * @subpackage Vportfolio
 */
class vportfolioCategoryController extends JController
{

	/**
	 * Custom Constructor
	 */
	//DEVNOTE: register task - Register (map) a task to a method in the class
	//function registerTask( $task, $method )
	function __construct( $default = array())
	{
		parent::__construct( $default );
	}
	
	function execute($task){
		switch($task){
			case "add":
			case "edit":
				$this->displayItem();
				break;
			case  "cancel":
				$this->cancel();
				break;
			case "save":
			case "apply":
				$this->save($task);
				break;
			case "public":
			case "unpublic":
				$this->publicItem();
				break;
				
			case "publish":
				$this->publish();
				break;
			case "unpublish":
				$this->unpublish();
				break;
				
			case "remove":
				$this->delete();
				break;
			default:
				$this->display();
				break;
		}
	}

	/**
	 * Cancel operation
	 */
	function cancel()
	{
		$this->setRedirect( 'index.php?option=com_vportfolio&controller=category' );
	}
	
	function display() {
	   $model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
	   $model->getListItem();
	   
	   $view = new vportfolioCategoryComponentView( );
	   $view->setModel( $model, true );
	   $view->display();
  }
  function displayItem($id=0){
  	   $model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
	   $item = $model->getItem($id);
	   $view = new vportfolioCategoryComponentView( );
	   $view->displayItem($item);
  }
  function save($task){
  	$model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
	$currentId = $model->saveItem();
	$msg = JText::sprintf( 'Successfully Saved Item');
	if($task == "save")
		$this->setRedirect( 'index.php?option=com_vportfolio&controller=category', $msg );
	else
		$this->displayItem($currentId);
  }
  function publicItem(){
  	$model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
	$model->publicItem();
	$msg = JText::sprintf( 'Successfully Updated Item');
	$this->setRedirect( 'index.php?option=com_vportfolio&controller=category', $msg );
  }
  //--------------------
	//Publish set 1 Un set 0
	function publish()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'Select an item to publish' ) );
		}
		$model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
		if(!$model->publish($cid, 1)) {
			echo "<script> alert('".$model->getError(true)."'); window.history.go(-1); </script>\n";
		}
		$msg = JText::sprintf( 'Successfully Updated Item');
		$this->setRedirect( 'index.php?option=com_vportfolio&controller=category', $msg );
	}
	function unpublish()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'Select an item to publish' ) );
		}
		$model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
		if(!$model->publish($cid, 0)) {
			echo "<script> alert('".$model->getError(true)."'); window.history.go(-1); </script>\n";
		}
		$msg = JText::sprintf( 'Successfully Updated Item');
		$this->setRedirect( 'index.php?option=com_vportfolio&controller=category', $msg );
	}
	//------------------------------
  function delete(){
  	$model = &JModel::getInstance( 'vportfolioCategoryComponentModel' );
	$msg = $model->deleteListItem();
	$this->setRedirect( 'index.php?option=com_vportfolio&controller=category', $msg );
  }
}
?>
