<?php
/*------------------------------------------------------------------------
# com_vportfolio - Vportfolio component
# ------------------------------------------------------------------------
# author    Vsmart Extensions
# copyright Copyright (C) 2010 www.vsmart-extensions.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.vsmart-extensions.com
# Technical Support:  Forum - http://www.vsmart-extensions.com
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

/**
 * Note: this view is intended only to be opened in a popup
 * @package Joomla
 * @subpackage Config
 */
//DEVNOTE: {HelloWorldController}.$controler 
class vportfolioController extends JController
{

	/**
	 * Custom Constructor
	 */
	function __constuct( $default = array())
	{
		parent::__construct( $default );
	}
	
	function execute($task){
		switch($task){
			case "add":
			case "edit":
				$this->displayItem();
				break;
			case  "cancel":
				$this->cancel();
				break;
			case "save":
			case "apply":
				$this->save($task);
				break;
			
			case "public":
			case "unpublic":
				$this->publicItem();
				break;
			case "publish":
				$this->publish();
				break;
			case "unpublish":
				$this->unpublish();
				break;
			
			case "remove":
				$this->delete();
				break;
			case "removeImage":
				$this->removeImage();
				break;
			case "setDefault":
				$this->setImageDefault();
				break;
			case "saveReview":
				$this->saveReview();
				break;
			case "publicReview":
				$this->publicReview();
				break;
			case "removeReview":
				$this->removeReview();
				break;
			default:
				$this->display();
				break;
		}
	}
	/**
	 * Cancel operation
	 */
	function cancel(){
		$this->setRedirect( 'index.php?option=com_vportfolio' );
	}
	function display() {
	   $model = &JModel::getInstance( 'vportfolioComponentModel' );
	   $model->getListItem();
	   $view = new vportfolioComponentView( );
	   $view->setModel( $model, true );
	   $view->display();
  } 
  function displayItem($id=0){
  
	   //get Config
	   $modelConfig = &JModel::getInstance( 'vportfolioConfigComponentModel' );
	   $config = $modelConfig->getConfig();

  	   $model = &JModel::getInstance( 'vportfolioComponentModel' );
	   $item = $model->getItem($id);
	   
	   $view = new vportfolioComponentView();
	   
	   $db = &JFactory::getDBO();

		$query = 'SELECT a.id as id, a.name AS text '
		. ' FROM #__vportfolio_category AS a'
		. ' ORDER BY a.id'
		;

		$db->setQuery( $query );
		$options = $db->loadObjectList( );
		
		//Get type project - only when use extra fields
		$types_ = explode(",",$config[6]->value);
		$types = array();
		
		for($i=1;$i<=sizeof($types_);$i++){
			$types[$i]->id = $i;
			$types[$i]->text = $types_[$i - 1];
		}
		
		$query = 'SELECT a.id as id, a.name AS text '
		. ' FROM #__users AS a'
		. ' ORDER BY a.id'
		;

		$db->setQuery( $query );
		
		//Get list of users
		$users[] 		= JHTML::_('select.option',  '0', '- '. JText::_( 'Select developers' ) .' -' );
		
		foreach( $db->loadObjectList() as $obj )
		{
			$users[] = JHTML::_('select.option',  $obj->id, JText::_( $obj->text ) );
		}

		$lists['catid']  = JHTML::_('select.genericlist',$options, 'categoryId', 'class="inputbox"','id','text', intval( $item->categoryId ) );
	
		//-------------------
		$typearray = explode(",",$item->type);		
		$lists['type'] = JHTML::_('select.genericlist',$types, 'type[]', 'class="inputbox" multiple="multiple" size = "'.sizeof($types_).'"','id','text',$typearray  );//intval( $item->type )
		
		$selected = explode(",",$item->developer_id);
		
		$lists['users']  = JHTML::_('select.genericlist',$users, 'developer_id[]', 'class="inputbox" size="10" multiple="true" ','value','text', $selected );
		
	    $view->displayItem($item,$lists,$config);
  }
  function save($task){
  	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$currentId = $model->saveItem();
	$msg = JText::sprintf( 'Successfully Saved Item');
	if($task == "save")
		$this->setRedirect( 'index.php?option=com_vportfolio', $msg );
	else
		$this->displayItem($currentId);
  }
  function publicItem(){
  	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->publicItem();
	$msg = JText::sprintf( 'Successfully Updated Item');
	$this->setRedirect( 'index.php?option=com_vportfolio', $msg );
  }
  //--------------------
	//Publish set 1 Un set 0
	function publish()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'Select an item to publish' ) );
		}
		$model = &JModel::getInstance( 'vportfolioComponentModel' );
		if(!$model->publish($cid, 1)) {
			echo "<script> alert('".$model->getError(true)."'); window.history.go(-1); </script>\n";
		}
		$msg = JText::sprintf( 'Successfully Updated Item');
		$this->setRedirect( 'index.php?option=com_vportfolio', $msg );			
	}
	function unpublish()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$cid = JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);
		if (count( $cid ) < 1) {
			JError::raiseError(500, JText::_( 'Select an item to publish' ) );
		}
		$model = &JModel::getInstance( 'vportfolioComponentModel' );
		if(!$model->publish($cid, 0)) {
			echo "<script> alert('".$model->getError(true)."'); window.history.go(-1); </script>\n";
		}
		$msg = JText::sprintf( 'Successfully Updated Item');
		$this->setRedirect( 'index.php?option=com_vportfolio', $msg );		
	}
	//------------------------------
  function delete(){
  	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->deleteListItem();
	$msg = JText::sprintf( 'Successfully Deleted Items');
	$this->setRedirect( 'index.php?option=com_vportfolio', $msg );
  }
  function removeImage(){
	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->removeImage();
	die();
  }
  function setImageDefault(){
  	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->setImageDefault();
  }
  function saveReview(){
	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->saveReview();
	die();
  }
  function publicReview(){
	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->publicReview();
	die();
  }
  function removeReview(){
	$model = &JModel::getInstance( 'vportfolioComponentModel' );
	$model->removeReview();
	die();
  }
}
?>
