CREATE TABLE `#__vportfolio` (
  `id` int(11) NOT NULL auto_increment,
  `categoryId` int(11) default NULL,
  `title` text,
  `description` text,
  `fulldescription` text,
  `url` text,
  `contact_link` text,
  `specification` text,
  `type` varchar(50) default '',
  `developers` text,
  `developer_id` text,
  `feature` int(1) default '0',
  `hit` int(25) default NULL,
  `public` int(1) default '1',
  `date_created` date default NULL,
  `last_modify` date default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `#__vportfolio_category` (
  `id` int(11) NOT NULL auto_increment,
  `name` text,
  `description` text,
  `public` int(1) default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `#__vportfolio_config` (
  `id` int(11) NOT NULL auto_increment,
  `name` text,
  `description` text,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert  into #__vportfolio_config values 
(1, 'Show url', 'Show or hide Url', '1'), 
(10, 'Link contact', 'Link contact default if not set in Item.', ''), 
(3, 'Show extra fields', 'Show extra fields for specifications item', '1'), 
(4, 'Use CB for developers', 'Use CB to manage profile developers. Default is textbox.', '1'), 
(5, 'Allow review', 'Allow user review', '1'), 
(6, 'Allow rating', 'Allow user rating', '1'), 
(7, 'Define Type', 'Define type for projects.Separate by \',\'.  Ex: Design, Develop, Fix bug...', ''), 
(8, 'Page Heading', 'Page heading', 'Vportfolio'), 
(9, 'Show category description', 'Show category description', '0'), 
(2, 'Show reviews', 'Show or hide reviews', '1'), 
(11, 'Auto public review', 'Allow auto public review', '1'),
(12, 'Click to thumb image', 'Click to thumb image', '1') ;

CREATE TABLE `#__vportfolio_image` (
  `id` int(11) NOT NULL auto_increment,
  `itemId` int(11) default NULL,
  `imageTitle` text,
  `imageSize` varchar(255) default NULL,
  `imageName` text,
  `default` int(1) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `#__vportfolio_rating` (
  `id` int(11) NOT NULL auto_increment,
  `itemId` int(11) default NULL,
  `rating` int(2) default NULL,
  `ip` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `#__vportfolio_review` (
  `id` int(11) NOT NULL auto_increment,
  `itemId` int(11) default NULL,
  `customer` text,
  `email` text,
  `review` text,
  `public` int(1) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/* Update jos_components
Set `name` = "V-Portpolio"
Where `option` = "com_vportpolio" AND `parent` = 0*/