<?php
/*------------------------------------------------------------------------
# com_vportfolio - Vportfolio component
# ------------------------------------------------------------------------
# author    Vsmart Extensions
# copyright Copyright (C) 2010 www.vsmart-extensions.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.vsmart-extensions.com
# Technical Support:  Forum - http://www.vsmart-extensions.com
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.application.component.view' );

/**
 * @package Joomla
 * @subpackage Vportfolio
 */
class vportfolioComponentView extends JView
{
	/**
	 * Display the view
	 */
	 var $items;
	 var $pagination;
	 var $lists;
	 
	function setModel($model){
	
		$this->items = $model->items;
		$this->pagination = $model->pagination;
		$this->lists = $model->lists;
	}
	function display()
	{
		//DEVNOTE: set document title
		$mainframe = JFactory::getApplication();
		
		$uri = JFactory::getURI();
		
		$mosConfig_live_site = $uri->base();
		$mosConfig_live_site = str_replace("administrator/","",$mosConfig_live_site);
		
		$document = & JFactory::getDocument();
		$document->setTitle( JText::_('V-Portfolio Component') );
		JHTML::_('behavior.tooltip');
    
    //DEVNOTE: Print Hellpworld and language name
?>
        
  <form action="index.php?option=com_vportfolio" method="post" name="adminForm">
	<table>
		<tr>
			<td width="100%">
				<?php echo JText::_( 'Filter' ); ?>:
				<input type="text" name="search" id="search" value="<?php echo $this->lists['search'];?>" class="text_area" onchange="document.adminForm.submit();" />
                <?php echo $this->lists['category']; ?>
				<button onclick="this.form.submit();"><?php echo JText::_( 'Go' ); ?></button>
				<button onclick="document.getElementById('search').value='';this.form.submit();"><?php echo JText::_( 'Reset' ); ?></button>
			</td>
			<td nowrap="nowrap">
			</td>
		</tr>
	</table>

	<table class="adminlist" cellpadding="1">
		<thead>
			<tr>
				<th width="2%" class="title">
					<?php echo JText::_( 'NUM' ); ?>
				</th>
				<th width="3%" class="title">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
				</th>
				<th class="title">
					<?php echo JText::_( 'Title' ); ?>
				</th>
				<th width="15%" class="title" >
					<?php echo JText::_( 'Address' ); ?>
				</th>
				<th width="5%" class="title" nowrap="nowrap">
					<?php echo JText::_( 'Public' ); ?>
				</th>
                
				<th width="10%" class="title">
					<?php echo JText::_( 'Hits' ); ?>
				</th>
				<th width="15%" class="title">
					<?php echo JText::_( 'Date Created' ); ?>
				</th>
				<th width="1%" class="title" nowrap="nowrap">
					<?php echo JText::_( 'ID' ); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
			$k = 0;
			for ($i=0, $n=count( $this->items ); $i < $n; $i++)
			{
				$row 	=& $this->items[$i];

				$img 	= $row->public ? 'tick.png' : 'publish_x.png';
				$task 	= $row->public ? 'unpublic' : 'public';
				$alt 	= $row->public ? JText::_( 'Public' ) : JText::_( 'Public' );
				$link 	= 'index.php?option=com_vportfolio&amp;task=edit&amp;cid[]='. $row->id. '';

			?>
			<tr class="<?php echo "row$k"; ?>">
				<td align="center">
					<?php echo $i+1+$this->pagination->limitstart;?>
				</td>
				<td align="center">
					<?php echo JHTML::_('grid.id', $i, $row->id ); ?>
				</td>
				<td>
                	<?php
						$img_path = $mosConfig_live_site."cache/com_vportfolio/images/".$row->id."/".$row->image->imageName;
					?>
                	<span class="editlinktip hasTip" title="<?php echo $row->title;?>::
<img border=&quot;1&quot; src=&quot;<?php echo $img_path; ?>&quot; name=&quot;imagelib&quot; alt=&quot;<?php echo JText::_( 'No preview available' ); ?>&quot; width=&quot;206&quot; height=&quot;145&quot; />">
                        <a href="<?php echo $link; ?>">
                            <?php echo $row->title; ?>
                        </a>
                   </span>
				</td>
				<td>
					<?php echo $row->url; ?>
				</td>
				<td align="center">
						<?php echo JHtml::_('jgrid.published', $row->public, $i); ?>
				</td>
                
				<td align="center">
					<?php echo JText::_( $row->hit ); ?>
				</td>
				<td nowrap="nowrap">
					<?php echo $row->date_created; ?>
				</td>
				<td align="center">
					<?php echo $row->id; ?>
				</td>
			</tr>
			<?php
				$k = 1 - $k;
				}
			?>
		</tbody>
	</table>

	<input type="hidden" name="option" value="com_vportfolio" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
<?php 
  }
  function displayItem($item,$lists,$config){
  	  
  	$mainframe = JFactory::getApplication();
  	
	$uri = JFactory::getURI();
		
	$mosConfig_live_site = $uri->base();
	$mosConfig_live_site = str_replace("administrator/","",$mosConfig_live_site);
	// Load the JEditor object
	$editor =& JFactory::getEditor();
	
	JHTML::_('behavior.tooltip');
  ?>
  	<script src="components/com_vportfolio/js/jquery.js" type="text/javascript" language="javascript"></script> 
	<script src="components/com_vportfolio/js/jquery.MultiFile.js" type="text/javascript" language="javascript"></script>
    <script src="components/com_vportfolio/js/jquery.MetaData.js" type="text/javascript" language="javascript"></script>
    <script src="components/com_vportfolio/js/jquery.blockUI.js" type="text/javascript" language="javascript"></script>
    
    <script src="components/com_vportfolio/js/jquery.shadow.js" type="text/javascript"></script>
    <script src="components/com_vportfolio/js/jquery.ifixpng.js" type="text/javascript"></script>
    
    <script src="components/com_vportfolio/js/jquery.dimensions.js" type="text/javascript"></script>
    <script src="components/com_vportfolio/js/jquery.fancyzoom.pack.js" type="text/javascript"></script>
    
    <script src="components/com_vportfolio/js/messages.js" type="text/javascript"></script>
    
    <script type="text/javascript">
		jQuery.noConflict();
		jQuery(function() {
			jQuery('#gallery img').fancyzoom(); 
		});
	</script>
    <script type="text/javascript">
		function deleteImage(id){
			
			jQuery.ajax({
			   type: "POST",
			   async: false,
			   url: "<?php echo $mosConfig_live_site."/administrator/index.php"; ?>",
			   data: "option=com_vportfolio&task=removeImage&id=" + id + "&itemId=<?php echo $item->id; ?>",
			   success: function(html){
				 document.getElementById('gallery').innerHTML = html;
				 jQuery(function() {
					jQuery('#gallery img').fancyzoom();
				});
			   }
			});
		}
		function setDefault(id){
			
			alert('Successfully set as default!');
			jQuery.ajax({
			   type: "POST",
			   async: false,
			   url: "<?php echo $mosConfig_live_site."/administrator/index.php"; ?>",
			   data: "option=com_vportfolio&task=setDefault&id=" + id + "&itemId=<?php echo $item->id; ?>",
			   success: function(html){
			   }
			});
		}
		function showReviewForm(){
			jQuery("div#reviewForm").show("slow");
		}
		function hideReviewForm(){
			jQuery("div#reviewForm").hide("slow");
		}
		function saveReview(){
			jQuery.ajax({
			   type: "POST",
			   async: false,
			   url: "<?php echo $mosConfig_live_site."/administrator/index.php"; ?>",
			   data: "option=com_vportfolio&task=saveReview&itemId=<?php echo $item->id; ?>&review=" + jQuery("#review").val() + "&customer="+jQuery("#customer").val(),
			   success: function(html){
				 jQuery('#reviewList').append(html);
				 jQuery("div#reviewForm").hide("slow");
				 document.getElementById('review').value = '';
				 document.getElementById('customer').value = '';
			   }
			});
		}
		function publicReview(id,public){
			jQuery.ajax({
			   type: "POST",
			   async: false,
			   url: "<?php echo $mosConfig_live_site."/administrator/index.php"; ?>",
			   data: "option=com_vportfolio&task=publicReview&id=" + id + "&public=" + public,
			   success: function(html){
				 document.getElementById('reviewList').innerHTML = html;
			   }
			});
		}
		function deleteReview(id){
			jQuery.ajax({
			   type: "POST",
			   async: false,
			   url: "<?php echo $mosConfig_live_site."/administrator/index.php"; ?>",
			   data: "option=com_vportfolio&task=removeReview&id=" + id,
			   success: function(html){
				 jQuery("div#reviewList").hide("slow");
				 document.getElementById('reviewList').innerHTML = html;
				  jQuery("div#reviewList").show("slow");
			   }
			});
		}
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			var text = <?php echo $editor->getContent( 'description' ); ?>
			<?php echo $editor->save( 'description' ); ?>
			
			var text1 = <?php echo $editor->getContent( 'fulldescription' ); ?>
			<?php echo $editor->save( 'fulldescription' ); ?>
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
		
			// do field validation
			if (trim(form.title.value) == "") {
				inlineMsg('title','You must enter your name.',2);
			} else {
				submitform( pressbutton );
			}
		}
	</script>
    <!-- Slide show -->
    <style>
		#gallery .imageBorder{
			float:left;
			margin-right:5px;
			margin-bottom:5px;
			width:125px;
			background-color:#F6F6F6;
			padding:5px;
		}
		#gallery .imageBackground{
			height:125px;
			padding:3px;
			background-color:#fff;
			border:1px solid #ddd;
			text-align:center;
			overflow:hidden;
		}
		#gallery .defaultRadio{
			margin-left:10px;
			#margin-left:3px;
		}
		#reviewForm{
			display:none;
		}
		.spanLink{
			cursor:pointer;
			color:#0B55C4;
		}
		textarea.inputbox{
			font-family:Arial, Helvetica, sans-serif;
		}
		.thumbImage{
			width:110px;
			float:none;
			margin:0px;
		}
		#msg {display:none; position:absolute; z-index:200; background:url(components/com_vportfolio/images/msg_arrow.gif) left center no-repeat; padding-left:7px}
		#msgcontent {display:block; background:#f3e6e6; border:2px solid #924949; border-left:none; padding:5px; min-width:150px; max-width:250px}
		div.star{float:left;width:17px;height:15px;text-indent:-999em;cursor:pointer;display:block;background:transparent;overflow:hidden}
		div.star span.star{display:block;width:16px;height:100%;background-position:0 0px;border:1 solid #FF0000;background:url(components/com_vportfolio/images/star.gif) no-repeat 0 0px;}
		div.star_on span.star{float:left;width:17px;height:15px;text-indent:-999em;cursor:pointer;display:block;background:transparent;overflow:hidden;background:url(components/com_vportfolio/images/star.gif) no-repeat 0 -16px;}
	</style>
  	<div class="width-20 fltrt" style="float:right">
    	<fieldset class="adminform">
            <table class="admintable" cellspacing="1">
            	<tr>
                	<td colspan="2">
                    	<?php
							for($k=1;$k<=$item->rating;$k++){
								echo "<div class='star_on'>";
								echo "<span class='star'></span>";
								echo "</div>";
							}
							
							for($l=1;$l<=(5-$item->rating);$l++){
								echo "<div class='star'>";
								echo "<span class='star'></span>";
								echo "</div>";
							}
						?>
                    </td>
                </tr>
				<tr>
					<td width="100">
						<label for="tile">
							<b><?php echo JText::_( 'Hits' ); ?>:</b>
						</label>
					</td>
					<td width="100">
						<?php echo $item->hit; ?>
					</td>
				</tr>
                <tr>
					<td width="100">
						<label for="tile">
							<b><?php echo JText::_( 'Date Create' ); ?>:</b>
						</label>
					</td>
					<td width="100">
						<?php echo $item->date_created; ?>
					</td>
				</tr>
                <tr>
					<td width="50">
						<label for="tile">
							<b><?php echo JText::_( 'Last update' ); ?>:</b>
						</label>
					</td>
					<td width="100">
						<?php echo $item->last_modify; ?>
					</td>
				</tr>
             </table>
         </fieldset>
    </div>
  	<form action="index.php" method="post" name="adminForm" autocomplete="off" enctype="multipart/form-data">
	<div class="col width-70">
		<fieldset class="adminform">
		<legend><?php echo JText::_( 'Item Details' ); ?></legend>
			<table class="admintable" cellspacing="1">
            	<tr>
					<td width="150" class="key">
						<label for="tile">
							<?php echo JText::_( 'Select category' ); ?>
						</label>
					</td>
					<td>
						<?php echo $lists['catid']; ?>
					</td>
				</tr>
				<tr>
					<td width="150" class="key">
						<label for="tile">
							<?php echo JText::_( 'Title' ); ?>
						</label>
					</td>
					<td>
						<input type="text" name="title" id="title" class="inputbox" size="40" value="<?php echo $item->title; ?>" />
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="url">
							<?php echo JText::_( 'Url' ); ?>
						</label>
					</td>
					<td>
						<input type="text" name="url" id="url" class="inputbox" size="40" value="<?php echo $item->url; ?>" />
					</td>
				</tr>
                <tr>
					<td width="150" class="key" valign="top">
						<label for="description">
							<?php echo JText::_( 'Description' ); ?>
						</label>
					</td>
					<td>
						<?php 
                        	echo $editor->display('description', $item->description, '580', '150', '20', '10');
						?>
					</td>
				</tr>
				
				<tr>
					<td width="150" class="key" valign="top">
						<label for="description">
							<?php echo JText::_( 'Full Description' ); ?>
						</label>
					</td>
					<td>
						<?php 
                        	echo $editor->display('fulldescription', $item->fulldescription, '580', '300', '20', '10');
						?>
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="public">
							<?php echo JText::_( 'Public' ); ?>
						</label>
					</td>
					<td>
						<fieldset class="radio">
                    	<input type="radio" name="public" id="published1" value="1" <?php if($item->public == 1) echo "checked"; ?>  />
						<label for="published1">Yes</label>
						<input type="radio" name="public" id="published0" value="0"  <?php if($item->public == 0) echo "checked"; ?> />
						<label for="published0">No</label>
						</fieldset>
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="public">
							<?php echo JText::_( 'Recent' ); ?>
						</label>
					</td>
					<td>
                    	<input type="checkbox" name="feature" id="feature" value="1" <?php if($item->feature == 1) echo "checked"; ?>  />
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="image">
							<?php echo JText::_( 'Image' ); ?>
						</label>
                        
					</td>
					<td>
						<input type="file" name="images[]" id="image" class="multi" size="40" accept="gif|jpg|png" />
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="url">
							<?php echo JText::_( 'Contact link' ); ?>
						</label>
					</td>
					<td>
						<input type="text" name="contact_link" id="contact_link" class="inputbox" size="40" value="<?php echo $item->contact_link; ?>" />
					</td>
				</tr>
                <tr>
                	<td colspan="2">
                    	* Upload multi images, type ( gif | jpg | png)
                    </td>
                </tr>
            </table>
        </fieldset>
        <fieldset class="adminform">
		<legend><?php echo JText::_( 'Item Extra Fields' ); ?></legend>
			<table class="admintable" cellspacing="1">
            	<tr>
					<td width="150" class="key">
						<label for="tile">
							<?php echo JText::_( 'Type Project:' ); ?>
						</label>
					</td>
					<td>
						<?php echo $lists['type']; ?>
					</td>
				</tr>
                <tr>
					<td width="150" class="key" valign="top">
						<label for="specification">
							<?php echo JText::_( 'Project specification' ); ?>
						</label>
					</td>
					<td>
                        <textarea name="specification" id="specification" class="inputbox" cols="60" rows="9"><?php echo $item->specification; ?></textarea>
					</td>
				</tr>
                <tr>
					<td width="150" class="key">
						<label for="tile">
							<?php echo JText::_( 'Developers' ); ?>
						</label>
					</td>
					<td>
                    	<?php if($config[3]->value == 1){
							echo $lists['users'];
						}else{
						?>
						<input type="text" name="developers" id="developers" class="inputbox" size="40" value="<?php echo $item->developers; ?>" />
                        <?php } ?>
					</td>
				</tr>
            </table>
        </fieldset>
    </div>
    <div class="col width-70">
		<fieldset class="adminform" >
		<legend><?php echo JText::_( 'Images' ); ?></legend>
			<table class="admintable"  width="100%">
				<tr>
					<td>
                    	<?php
							$image_folder = $mosConfig_live_site."cache/com_vportfolio/images/".$item->id."/";
							
						?>
                        <div id="gallery">
                        	<?php 
								for($i=0;$i<sizeof($item->images);$i++){ 
								  if($item->images[$i]->imageName !=""){
							?>
                            	<div class="imageBorder">
                                	<div class="imageBackground">
                                    	<span class="editlinktip hasTip" title="<?php echo JText::_( 'Image Size' );?>::<?php echo $item->images[$i]->imageSize; ?>">
										<?php
											$param = " alt=\"".$item->images[$i]->imageTitle."\"";
                                            echo displayImage($image_folder.$item->images[$i]->imageName,125,125,$param);
                                        ?>
                                        </span>
                                    </div>
                                    <a href="#" onclick="deleteImage('<?php echo $item->images[$i]->id; ?>')">Delete</a>
                                    <input type="radio" class="defaultRadio" style="width:auto;display:inline;float:none;" name="default" id="default<?php echo $i ?>" onclick="setDefault('<?php echo $item->images[$i]->id; ?>')" <?php if($item->images[$i]->default == 1) echo "checked"; ?>/><label for="default<?php echo $i ?>" style="min-width: 50px;float: none;display: inline-block;clear: none;margin: 0;padding: 0;font-size: 11px; cursor:pointer;">Set default</label>
                                </div>
                            <?php 
								} 
							  }
							?>
                        </div>
					</td>
				</tr>
			</table>
		</fieldset>
        <fieldset class="adminform">
		<legend><?php echo JText::_( 'Reviews' ); ?></legend>
			<table class="admintable">
				<tr>
					<td>
                    	<div id="reviewList">
							<?php
                                for($i=0;$i<sizeof($item->reviews);$i++){
								  if($item->reviews[$i]->id){
								?>
                                	<p><?php echo $item->reviews[$i]->review;?></p>
                                    <b>- <?php echo $item->reviews[$i]->customer;?> -</b>
                                    	<?php if($item->reviews[$i]->public == 0){ ?>
											 <span class="spanLink" onclick="publicReview('<?php echo $item->reviews[$i]->id; ?>','1')">
                                             	Public
                                             </span>
										<?php
											 }else{
										?>
                                        	<span class="spanLink" onclick="publicReview('<?php echo $item->reviews[$i]->id; ?>','0')">
                                             	UnPublic
                                             </span>
                                        <?php
											 }
										?> 
                                    &nbsp;&nbsp;|&nbsp;&nbsp;
                                    <span class="spanLink" onclick="deleteReview('<?php echo $item->reviews[$i]->id; ?>')">Remove</span>
                                <?php
								}
                               }
                            ?>
                        </div>
                        <p>Click <span onclick="showReviewForm();" class="spanLink">here</span> to add review.</p>
                        <div id="reviewForm">
                        	<table class="admintable" cellspacing="1">
                                <tr>
                                    <td width="150" class="key">
                                        <label for="tile">
                                            <?php echo JText::_( 'Customer' ); ?>
                                        </label>
                                    </td>
                                    <td>
                                        <input type="text" name="customer" id="customer" class="inputbox" size="40" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="150" class="key">
                                        <label for="url">
                                            <?php echo JText::_( 'Review' ); ?>
                                        </label>
                                    </td>
                                    <td>
                                        <textarea name="review" id="review" class="inputbox" cols="40" rows="5"></textarea>
                                    </td>
                                </tr>
                                <tr>
                                	<td colspan="2">
                                    	<input type="button"  value="Save" onclick="saveReview();"/>&nbsp;<input type="button" value="Hide" onclick="hideReviewForm();"/>
                                    </td>
                                </tr>
                            </table>
                        </div>
					</td>
				</tr>
			</table>
		</fieldset>
    </div>
    <div class="clr"></div>

	<input type="hidden" name="id" value="<?php echo $item->id; ?>" />
	<input type="hidden" name="cid[]" value="<?php echo $item->id; ?>" />
    <input type="hidden" name="hit" value="<?php echo $item->hit; ?>" />
    <input type="hidden" name="date_created" value="<?php echo $item->date_created; ?>" />
	<input type="hidden" name="option" value="com_vportfolio" />
	<input type="hidden" name="task" value="" />
	<?php echo JHTML::_( 'form.token' ); ?>
</form>
  <?php
  }
}
?>
