<?php
/**
* @version 1.0.0
* @package RSTester! 1.0.0
* @copyright (C) 2009-2012 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-2.0.html
*/

class RSTesterHelper 
{

	 /**
	 * Open a connection through several methods
	 */
	 function fopen($url,$int=1)
	 {
		$app 	=& JFactory::getApplication();
		$u 		=& JURI::getInstance('SERVER');
		$base 	= $u->getHost();

		$errors 	= array();
		$url_info 	= parse_url($url);
		if(isset($url_info['host']) && $url_info['host'] == 'localhost') $url_info['host'] = '127.0.0.1';
		$useragent 	= "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 (.NET CLR 3.5.30729)";
		$data 		= false;

		$url = html_entity_decode($url);

		// cURL
		if (extension_loaded('curl'))
		{
			// Init cURL
			$ch = @curl_init();
			
			// Set options
			@curl_setopt($ch, CURLOPT_URL, $url);
			@curl_setopt($ch, CURLOPT_HEADER, $int);
			@curl_setopt($ch, CURLOPT_FAILONERROR, 1);
			@curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			@curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
			@curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

			// Set timeout
			@curl_setopt($ch, CURLOPT_TIMEOUT, 5);
			
			// Grab data
			$data = @curl_exec($ch);
			
			$objs = explode("\n",$data);
			foreach($objs as $obj)
				if(strpos($obj,'Location:') !== false)
				{
					$new_url = trim(str_replace('Location: ','',$obj));
					if(strpos($new_url,$base) !== false) $data = RSTesterHelper::fopen($new_url,0);
				}
			
			$curl_error = curl_error($ch);
			
			// Clean up
			@curl_close($ch);
			
			if(empty($data)) $errors[] = 'cURL';
			
			// Return data
			if ($data !== false)
				return $data;
		}
		

		// fsockopen
		if (function_exists('fsockopen'))
		{
			$errno = 0;
			$errstr = '';

			// Set timeout
			$fsock = @fsockopen($url_info['host'], 80, $errno, $errstr, 5);
		
			if ($fsock)
			{
				@fputs($fsock, 'GET '.$url_info['path'].(!empty($url_info['query']) ? '?'.$url_info['query'] : '').' HTTP/1.1'."\r\n");
				@fputs($fsock, 'HOST: '.$url_info['host']."\r\n");
				@fputs($fsock, "User-Agent: ".$useragent."\r\n");
				@fputs($fsock, 'Connection: close'."\r\n\r\n");
        
				// Set timeout
				@stream_set_blocking($fsock, 1);
				@stream_set_timeout($fsock, 5);
				
				$data = '';
				$passed_header = false;
				while (!@feof($fsock))
				{
					if ($passed_header)
						$data .= @fread($fsock, 1024);
					else
					{
						if (@fgets($fsock, 1024) == "\r\n")
							$passed_header = true;
					}
				}
				
				// Clean up
				@fclose($fsock);
				
				if(empty($data)) $errors[] = 'fsockopen';
				
				// Return data
				if ($data !== false)
					return $data;
			}
		}

	 	// fopen
		if (function_exists('fopen') && ini_get('allow_url_fopen'))
		{
			// Set timeout
			if (ini_get('default_socket_timeout') < 5)
				ini_set('default_socket_timeout', 5);
			@stream_set_blocking($handle, 1);
			@stream_set_timeout($handle, 5);
			@ini_set('user_agent',$useragent);
			
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			
			$handle = @fopen ($url, 'r');
			
			if ($handle)
			{
				$data = '';
				while (!feof($handle))
					$data .= @fread($handle, 8192);
			
				// Clean up
				@fclose($handle);
			
				if(empty($data)) $errors[] = 'fopen';
			
				// Return data
				if ($data !== false)
					return $data;
			}
		}
						
		// file_get_contents
		if(function_exists('file_get_contents') && ini_get('allow_url_fopen'))
		{
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			@ini_set('user_agent',$useragent);
			$data = @file_get_contents($url);
			
			if(empty($data)) $errors[] = 'file_get_contents';
			
			// Return data
			if ($data !== false)
				return $data;
		}

		return $data;
	}
}

class RSTesterGoogle
{
	/*
	* The URL
	*/
	var $url = null;

	function RSTesterGoogle($url)
	{
		$this->url = $url;
	}
	
	function prank()
	{
		$reqgr = "info:" . $this->url;
		$reqgre = "info:" . urlencode($this->url);
		$mGoogleCH = $this->googleCH($this->strord($reqgr) );
		$mGoogleCH = "6" . $this->googleNewCh($mGoogleCH);
		$link = "http://toolbarqueries.google.com/tbr?client=navclient-auto&ch=".$mGoogleCH."&ie=UTF-8&oe=UTF-8&features=Rank&q=".$reqgre;
		$contents = RSTesterHelper::fopen($link,0);
		
		$contents = explode(':',$contents);
		
		if (isset($contents[2])) return $contents[2]; else return -1;
	}
	
	function check()
	{
		$reqgr = "info:" . $this->url;
		$reqgre = "info:" . urlencode($this->url);
		$mGoogleCH = $this->googleCH($this->strord($reqgr) );
		$mGoogleCH = "6" . $this->googleNewCh($mGoogleCH);
		$link = "http://toolbarqueries.google.com/tbr?client=navclient-auto&ch=".$mGoogleCH."&ie=UTF-8&oe=UTF-8&features=Rank&q=".$reqgre;
		$contents = RSTesterHelper::fopen($link,0);
		
		$pagerank = explode(':',$contents);
		
		if (isset($pagerank[2]))
		{
			$return = trim($pagerank[2]);
			if ($return == '0')
				return $return;
			else 
				$return = (int) $return;
			
			if ($return) return true;
				else return $contents;
		} else return $contents;
	}
	
	function googleCH($url)
	{
		$init = 0xE6359A60;	
		$length = count($url);
		$a = 0x9E3779B9;
		$b = 0x9E3779B9;
		$c = 0xE6359A60;
		$k = 0;
		$len = $length;
		$mixo = array(); 
		
		while( $len >= 12 ) 
		{
			$a += ($url[$k+0] +($url[$k+1]<<8) +($url[$k+2]<<16) +($url[$k+3]<<24));
			$b += ($url[$k+4] +($url[$k+5]<<8) +($url[$k+6]<<16) +($url[$k+7]<<24));
			$c += ($url[$k+8] +($url[$k+9]<<8) +($url[$k+10]<<16)+($url[$k+11]<<24));
			$mixo = $this->mix($a,$b,$c);
			
			$a = $mixo[0]; $b = $mixo[1]; $c = $mixo[2];
			$k += 12;
			$len -= 12;
		}
		
		$c += $length;
		
		switch( $len ) 
		{
			case 11:
			$c += $url[$k+10]<<24;
			
			case 10: 
			$c+=$url[$k+9]<<16;
			
			case 9 : 
			$c+=$url[$k+8]<<8;
			
			case 8 : 
			$b+=($url[$k+7]<<24);
			
			case 7 : 
			$b+=($url[$k+6]<<16);
			
			case 6 : 
			$b+=($url[$k+5]<<8);
			
			case 5 : 
			$b+=($url[$k+4]);
			
			case 4 : 
			$a+=($url[$k+3]<<24);
			
			case 3 : 
			$a+=($url[$k+2]<<16);
			
			case 2 : 
			$a+=($url[$k+1]<<8);
			
			case 1 : 
			$a+=($url[$k+0]);
		}
		
		$mixo = $this->mix( $a, $b, $c );
		
		if( $mixo[2] < 0 )
			return ( 0x100000000 + $mixo[2] );
		else
			return $mixo[2];
	}

	function mix( $a, $b, $c ) 
	{
		$a -= $b; $a -= $c; $a ^= ( $this->zeroFill( $c, 13 ) );
		$b -= $c; $b -= $a; $b ^= ( $a << 8 );
		$c -= $a; $c -= $b; $c ^= ( $this->zeroFill( $b, 13 ) );
		$a -= $b; $a -= $c; $a ^= ( $this->zeroFill( $c, 12 ) );
		$b -= $c; $b -= $a; $b ^= ( $a << 16);
		$c -= $a; $c -= $b; $c ^= ( $this->zeroFill( $b, 5 ) );
		$a -= $b; $a -= $c; $a ^= ( $this->zeroFill( $c, 3 ) ); 
		$b -= $c; $b -= $a; $b ^= ( $a << 10);
		$c -= $a; $c -= $b; $c ^= ( $this->zeroFill( $b, 15 ) );
		
		return array($a,$b,$c);
	}
	
	function zeroFill( $a, $b )
	{
		$z = hexdec(80000000);
		
		if( $z & $a )
		{
			$a = $a >> 1;
			$a &= ~$z;
			$a |= 0x40000000;
			$a = $a >> ( $b - 1 );
		} 
		else
			$a = $a >> $b;
		
		return $a;
	}

	function strord($string) 
	{	

		$result = array();
		for($i = 0; $i < strlen($string); $i++ ) 
		{
			$result[$i] =  ord($string[$i]);
		}	
		return $result;
	}

	function googleNewCh( $ch )
	{
		$ch = ( ( ( $ch / 7 ) << 2 ) | ( ( $this->myfmod( $ch,13 ) ) & 7 ) );
	  
		$prbuf = array();
		$prbuf[0] = $ch;
		for( $i = 1; $i < 20; $i++ ) 
		{
		  $prbuf[$i] = $prbuf[$i-1] - 9;
		}
		$ch = $this->googleCH($this->c32to8bit( $prbuf ), 80 );
		
		return $ch;
	 }
	 
	function c32to8bit( $arr32 ) 
	{
		$arr8 = array();	
		
		for( $i = 0; $i < count($arr32); $i++ ) 
		{
			for( $bitOrder = $i * 4; $bitOrder <= $i * 4 + 3; $bitOrder++ ) 
			{
			$arr8[$bitOrder] = $arr32[$i] & 255;
			$arr32[$i] = $this->zeroFill( $arr32[$i], 8 );
		  }
		}
		
		return $arr8;
	}
	  
	function myfmod( $x, $y )
	{
		$i = floor( $x / $y );
		return ( $x - $i * $y );
	}
}