<?php
/**
* @version 1.0.0
* @package RSTester! 1.0.0
* @copyright (C) 2012 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class RSTesterModelRSTester extends JModelLegacy
{
	function __construct()
	{
		parent::__construct();
	}

	function getComponent()
	{
		return JRequest::getVar('component');
	}

	function getResults()
	{
		$result = array(
			'PHP' 				=> $this->getPHPVersion(),
			'MySQL'				=> $this->getMySQLVersion(),
			'Joomla! Version' 	=> $this->getJoomlaVersion(),
			'is_compatible' 	=> true
		);

		switch ($this->getComponent())
		{
			case 'com_rsform':
				$result['GD']				= $this->getGD();
				$result['FreeType'] 		= $this->getFreeType();
				$result['fsockopen()'] 		= $this->getFSockOpen();
				$result['cURL'] 			= $this->getcURL();

				if (version_compare($result['Joomla! Version']->status, '2.5.8', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				} elseif (version_compare($result['Joomla! Version']->status, '3.0.0', '>=') && version_compare($result['Joomla! Version']->status, '3.0.2', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '2.5.8, 3.0.2');
				}

				if(!$result['GD']->is_correct || !$result['cURL']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct)
					$result['is_compatible'] = false;

			break;
			case 'com_rsforme':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 1.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5');
				}

				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
				
			break;
			case 'com_rsblog':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['cURL'] 			 = $this->getcURL();
				$result['fopen'] 			 = $this->getFopen();
				$result['file_get_contents'] = $this->getFilegetcontents();
				$result['IMAP'] 			 = $this->getImap();
				
				if (version_compare($result['Joomla! Version']->status, '2.5.8', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				} elseif (version_compare($result['Joomla! Version']->status, '3.0.0', '>=') && version_compare($result['Joomla! Version']->status, '3.0.2', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '2.5.8, 3.0.2');
				}
				
				if(!$result['GD']->is_correct || !$result['cURL']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['fopen']->is_correct || !$result['file_get_contents']->is_correct || !$result['IMAP']->is_correct )
					$result['is_compatible'] = false;
			break;
			
			case 'com_rscomments':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if (!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct) 
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsevents':
				$result['GD']				 = $this->getGD();
				$result['cURL'] 			 = $this->getcURL();
				$result['mb_strlen'] 		 = $this->getMbstrlen();
				$result['json_encode'] 		 = $this->getJsonencode();
				
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if(!$result['mb_strlen']->is_correct || !$result['GD']->is_correct || !$result['cURL']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rseventspro':
				$result['MooTools'] 		 = $this->getMootools('1.2.5');
				$result['GD']				 = $this->getGD();
				$result['cURL'] 			 = $this->getcURL();
				$result['fopen'] 			 = $this->getFopen();
				$result['mb_strlen'] 		 = $this->getMbstrlen();
				$result['json_encode'] 		 = $this->getJsonencode();
				
				/*
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}
				*/
				
				if(!$result['mb_strlen']->is_correct || !$result['MooTools']->is_correct || !$result['GD']->is_correct || !$result['cURL']->is_correct || !$result['fopen']->is_correct || !$result['mb_strlen']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsfeedback':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsfiles':
				$result['MooTools'] 		 = $this->getMootools('1.2.5');
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;

			case 'com_rsfirewall':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();

				if (version_compare($result['Joomla! Version']->status, '2.5.8', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				} elseif (version_compare($result['Joomla! Version']->status, '3.0.0', '>=') && version_compare($result['Joomla! Version']->status, '3.0.2', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '2.5.8, 3.0.2');
				}
				
				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct)
					$result['is_compatible'] = false;
				$result['PHP']				 = $this->getPHPVersion('5.2');
			break;
			
			case 'com_rsmail':
				$result['IMAP'] 			 = $this->getImap();
				$result['iconv'] 			 = $this->getIconv();

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if(!$result['IMAP']->is_correct || !$result['iconv']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsmediagallery':
				$result['GD']				 = $this->getGD();
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if (!$result['GD']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsmembership':
				$result['GD']				 = $this->getGD();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['cURL'] 			 = $this->getcURL();
				$result['FreeType'] 		 = $this->getFreeType();

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if(!$result['GD']->is_correct || !$result['FreeType']->is_correct || !$result['fsockopen()']->is_correct || !$result['cURL']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'com_rsseo':
				$result['loopback']		= $this->getLoopback();
				$result['mb_strlen'] 	= $this->getMbstrlen();

				if (version_compare($result['Joomla! Version']->status, '2.5.8', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				} elseif (version_compare($result['Joomla! Version']->status, '3.0.0', '>=') && version_compare($result['Joomla! Version']->status, '3.0.2', '<')) {
					$result['Joomla! Version']->is_correct = false;
					$result['is_compatible'] = false;
				}

				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '2.5.8, 3.0.2');
				}
				
				
				if (!$result['loopback']->is_correct || !$result['mb_strlen']->is_correct)
					$result['is_compatible'] = false;
					
				$result['Google Connectivity Check'] 	= $this->getGoogleConnectivityCheck();
			break;
			
			case 'com_rsticketspro':
				$result['GD']				 = $this->getGD();
				$result['FreeType'] 		 = $this->getFreeType();
				$result['fsockopen()'] 		 = $this->getFSockOpen();
				$result['MooTools'] 		 = $this->getMootools();
				
				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if(!$result['MooTools']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
			case 'plg_rsticketspro_cron':
				$result['iconv'] 			 = $this->getIconv();
				$result['IMAP'] 			 = $this->getImap();

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if (!$result['iconv']->is_correct || !$result['IMAP']->is_correct || !$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			case 'com_rssearch':

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if (!$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			case 'com_rsfinder':

				$result['Joomla! Version']->is_correct	= $result['Joomla! Version']->status > 2.5 ? false : true;
				if (!$result['Joomla! Version']->is_correct) {
					$result['Joomla! Version']->description	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION_ERROR');
					$result['Joomla! Version']->solution	= JText::sprintf('RSTE_JOOMLA_VERSION_SOLUTION', '1.5, 2.5');
				}

				if (!$result['Joomla! Version']->is_correct)
					$result['is_compatible'] = false;
			break;
			
		}

		if (!$result['PHP']->is_correct || !$result['MySQL']->is_correct)
			$result['is_compatible'] = false;
			
		return $result;
	}
	
	function getPHPVersion($min = '5.0')
	{
		$your_php 	 = phpversion();
		$correct_php = version_compare($your_php, $min, '>=');

		$requirement 				= new stdClass();
		$requirement->status 		= $your_php;
		$requirement->is_correct 	= $correct_php;
		$requirement->description 	= JText::_('RSTE_PHP_DESCRIPTION');
		$requirement->solution		= JText::sprintf('RSTE_PHP_SOLUTION', $min);

		return $requirement;
	}

	function getMySQLVersion($min = '5.0')
	{
		$db =& JFactory::getDBO();

		$db->setQuery("SELECT VERSION()");
		$your_sql 	 = $db->loadResult();
		$correct_sql = version_compare($your_sql, $min);

		$requirement 			= new stdClass();
		$requirement->status 		= $your_sql;
		$requirement->is_correct 	= $correct_sql;
		$requirement->description 	= JText::_('RSTE_MYSQL_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MYSQL_SOLUTION');
		
		return $requirement;
	}
	
	function getGD()
	{
		$correct_gd = extension_loaded('gd') && function_exists('gd_info');
		
		$requirement 				= new stdClass();
		$requirement->status 		= $correct_gd ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_gd;
		$requirement->description 	= JText::_('RSTE_GD_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_GD_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	function getJoomlaVersion()
	{
		jimport('joomla.version');
		$version = new JVersion();

		$requirement 				= new stdClass();
		$requirement->status 		= $version->getShortVersion();
		$requirement->is_correct 	= true;
		$requirement->description 	= JText::_('RSTE_JOOMLA_VERSION_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_JOOMLA_VERSION_SOLUTION');

		return $requirement;
	}
	
	function getFreeType()
	{
		$correct_freetype = function_exists('imagettftext');
		
		$requirement 				= new stdClass();
		$requirement->status 		= $correct_freetype ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_freetype;
		$requirement->description 	= JText::_('RSTE_FREETYPE_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FREETYPE_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	function getFSockOpen()
	{
		$correct_fsockopen = function_exists('fsockopen');
		
		$requirement 				= new stdClass();
		$requirement->status 		= $correct_fsockopen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_fsockopen;
		$requirement->description 	= JText::_('RSTE_FSOCKOPEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FSOCKOPEN_SOLUTION_'.$this->getComponent());

		return $requirement;
	}

	function getcURL()
	{
		$correct_curl = extension_loaded('curl') && function_exists('curl_init');
		
		$requirement 				= new stdClass();
		$requirement->status 		= $correct_curl ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_curl;
		$requirement->description 	= JText::_('RSTE_CURL_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_CURL_SOLUTION_'.$this->getComponent());

		return $requirement;
	}
	
	function getFopen()
	{
		
		$correct_fopen = function_exists('fopen') && ini_get('allow_url_fopen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_fopen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_fopen;
		$requirement->description 	= JText::_('RSTE_FOPEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FOPEN_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getFilegetcontents()
	{
		$correct_filegetcontents = function_exists('file_get_contents') && ini_get('allow_url_fopen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_filegetcontents ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_filegetcontents;
		$requirement->description 	= JText::_('RSTE_FILEGETCONTENTS_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_FILEGETCONTENTS_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getImap()
	{
		$correct_imap = function_exists('imap_open');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_imap ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_imap;
		$requirement->description 	= JText::_('RSTE_IMAP_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_IMAP_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getMbstrlen()
	{
		$correct_mbstrlen = function_exists('mb_strlen');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_mbstrlen ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_mbstrlen;
		$requirement->description 	= JText::_('RSTE_MBSTRLEN_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MBSTRLEN_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}

	function getJsonencode()
	{
		$correct_json_encode = function_exists('json_encode');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_json_encode ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_json_encode;
		$requirement->description 	= JText::_('RSTE_JSONENCODE_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_JSONENCODE_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getIconv()
	{
		$correct_iconv = function_exists('iconv');

		$requirement 				= new stdClass();
		$requirement->status 		= $correct_iconv ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $correct_iconv;
		$requirement->description 	= JText::_('RSTE_ICONV_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_ICONV_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getMootools($min = '1.2.4')
	{
		jimport('joomla.version');
		jimport('joomla.plugin.helper');

		$version 	 = new JVersion();
		$requirement = new stdClass();

		if($version->isCompatible('1.6.0'))
		{
			if (file_exists(JPATH_SITE.'/media/system/js/mootools-core.js'))
			{
				$mooContents = file_get_contents(JPATH_SITE.'/media/system/js/mootools-core.js');
				preg_match('#version:"([0-9\.]+)"#is',$mooContents,$match);
				if (!empty($match) && !empty($match[1]))
					$requirement->status = 'MooTools '.$match[1];
				else
				{
					preg_match('#version: \'([0-9\.]+)\'#is',$mooContents,$match);
					if (!empty($match) && !empty($match[1]))
						$requirement->status = 'MooTools '.$match[1];
				}
				
			} else 
				$requirement->status 	= 'Mootools 1.3';
			
			$requirement->is_correct 		= true;
		} elseif(JPluginHelper::isEnabled('system', 'mtupgrade'))
		{
			if (file_exists(JPATH_SITE.'/plugins/system/mtupgrade/mootools.js'))
			{
				$mooContents = file_get_contents(JPATH_SITE.'/plugins/system/mtupgrade/mootools.js');
				preg_match('#\'version\': \'([0-9\.]+)\'#is',$mooContents,$match);
				if (!empty($match) && !empty($match[1]))
				{
					$requirement->status = 'MooTools '.$match[1];
					$requirement->is_correct = version_compare($match[1], $min,'>=');
				}
				else
				{
					preg_match('#version:"([0-9\.]+)"#is',$mooContents,$match);
					if (!empty($match) && !empty($match[1]))
					{
						$requirement->status = 'MooTools '.$match[1];
						$requirement->is_correct = version_compare($match[1], $min,'>=');
					}
				}
				
			} else
			{
				$requirement->status 	 =  'Mootools 1.2.4';
				$requirement->is_correct = version_compare('1.2.4', $min);
			}
		} else {
			$requirement->status 	= 'Mootools 1.12';
			$requirement->is_correct 		= false;
		}

		$requirement->description 	= JText::_('RSTE_MOOTOOLS_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_MOOTOOLS_SOLUTION_'.$this->getComponent());
		
		return $requirement;
	}
	
	function getLoopback()
	{
		$url = JURI::root();
		$url_info = parse_url($url);
		if ($url_info['host'] == 'localhost') $url_info['host'] = '127.0.0.1';
		$useragent = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 (.NET CLR 3.5.30729)";
		$data = false;
		
		// cURL
		if (extension_loaded('curl'))
		{
			// Init cURL
			$ch = @curl_init();
			
			// Set options
			@curl_setopt($ch, CURLOPT_URL, $url);
			@curl_setopt($ch, CURLOPT_HEADER, 1);
			@curl_setopt($ch, CURLOPT_FAILONERROR, 1);
			@curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			@curl_setopt($ch, CURLOPT_USERAGENT, $useragent);
			@curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			@curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			
			// Set timeout
			@curl_setopt($ch, CURLOPT_TIMEOUT, 5);
			
			// Grab data
			$data = @curl_exec($ch);
			
			// Clean up
			@curl_close($ch);
		}

		// fsockopen
		if (function_exists('fsockopen'))
		{
			$errno = 0;
			$errstr = '';

			// Set timeout
			$fsock = @fsockopen($url_info['host'], 80, $errno, $errstr, 5);
		
			if ($fsock)
			{
				@fputs($fsock, 'GET '.$url_info['path'].(!empty($url_info['query']) ? '?'.$url_info['query'] : '').' HTTP/1.1'."\r\n");
				@fputs($fsock, 'HOST: '.$url_info['host']."\r\n");
				@fputs($fsock, "User-Agent: ".$useragent."\r\n");
				@fputs($fsock, 'Connection: close'."\r\n\r\n");
        
				// Set timeout
				@stream_set_blocking($fsock, 1);
				@stream_set_timeout($fsock, 5);
				
				$data = '';
				$passed_header = false;
				while (!@feof($fsock))
				{
					if ($passed_header)
						$data .= @fread($fsock, 1024);
					else
					{
						if (@fgets($fsock, 1024) == "\r\n")
							$passed_header = true;
					}
				}
				
				// Clean up
				@fclose($fsock);
			}
		}

	 	// fopen
		if (function_exists('fopen') && ini_get('allow_url_fopen'))
		{
			// Set timeout
			if (ini_get('default_socket_timeout') < 5)
				ini_set('default_socket_timeout', 5);
			@stream_set_blocking($handle, 1);
			@stream_set_timeout($handle, 5);
			@ini_set('user_agent',$useragent);
			
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			
			$handle = @fopen ($url, 'r');

			if ($handle)
			{
				$data = '';
				while (!feof($handle))
					$data .= @fread($handle, 8192);

				// Clean up
				@fclose($handle);
			}
		}
						
		// file_get_contents
		if(function_exists('file_get_contents') && ini_get('allow_url_fopen'))
		{
			$url = str_replace('://localhost', '://127.0.0.1', $url);
			@ini_set('user_agent',$useragent);
			$data = @file_get_contents($url);
		}
		
		$requirement 				= new stdClass();
		$requirement->status 		= $data ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $data ? true : false;
		$requirement->description 	= JText::_('RSTE_LOOPBACK_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_LOOPBACK_SOLUTION');
		
		return $requirement;
	}
	
	function getGoogleConnectivityCheck()
	{
		$app =& JFactory::getApplication();
		require_once(JPATH_SITE.'/administrator/components/com_rstester/helpers/google.php');

		$url = 'http://www.rsjoomla.com';

		$google = new RSTesterGoogle($url);
		$response = $google->check();

		$google_response = false;
		if ($response && strpos($response, 'html') === false)
			$google_response = true;

		$requirement 				= new stdClass();
		$requirement->status 		= $google_response ? JText::_('RSTE_ON') : JText::_('RSTE_OFF');
		$requirement->is_correct 	= $google_response;
		$requirement->description 	= JText::_('RSTE_GOOGLE_CONNECTIVITY_CHECK_DESCRIPTION');
		$requirement->solution		= JText::_('RSTE_GOOGLE_CONNECTIVITY_SOLUTION_'.$this->getComponent());

		return $requirement;
	}

}