/*
* @name			Address Picker ByGiro jQuery plugin
* @version		0.0.1
* @package		jForms
* @copyright	G. Tomaselli
* @author		Girolamo Tomaselli - http://bygiro.com - girotomaselli@gmail.com
* @license		GNU GPL v3 or later
*/

// the semi-colon before function invocation is a safety net against concatenated
// scripts and/or other plugins which may not be closed properly.
;(function ( $, window, document, undefined ) {
	"use strict";
    var pluginName = "addressPickerByGiro",
		// the name of using in .data()
        dataPlugin = "plugin_" + pluginName,
        defaults = {
            latitude: 51.751724,
            longitude: -1.255284,
            zoom: 2,
				mapType: 'ROADMAP',
            mode: "modal",	/* modal or plain */
				distanceWidget: false,
				distanceWidgetType: 'circle',  /* circle / rectangle / triangle */
				distanceWidgetRadius: 30000,  /* meters */
				map: null, /* google map object */
            map_options: {
					zoomControlOptions: {
						style:google.maps.ZoomControlStyle.SMALL
					},
            },
            maxResultShow: 10,
				markerType: '',	// labeled: utility library needed, see: http://google-maps-utility-library-v3.googlecode.com/svn/trunk/markerwithlabel
									// styled: utility library needed, see: http://google-maps-utility-library-v3.googlecode.com/svn/trunk/styledmarker/
            markerLabelClass: "youarehere",
				
			// update input fields if CLASS provided
            cssSelectorTarget: null,
            targets_prefix: null,
				
			// internationalization
            language: "en",
            text: {
                genericerror: "Sorry, something went wrong. Try again!",
                cancel: "Cancel",
                ok: "Ok",
                edit: "Edit",
                search: "Search",
                you_are_here: "You are here!",
                noresults: "Sorry! We couldn't find the address for the specified terms. Try a different search term, or click the map.",
                toofar: "Woah... that's pretty remote! You're going to have to manually enter a place name.",
                set_your_address: "Set your address",
                set_your_address_info: "You can search for an address or click on the map and drag the marker."
            },
			// callbacks
            onInit: false,
            onOpenModal: false,
            onCancelModal: false,
            onSuccess: false,
            onViewportChanged: false,
        };
    var generateRandom = function () {
            var randomId = "",
                alfabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            for (var i = 0; i < 7; i++) {
                randomId += alfabet.charAt(Math.floor(Math.random() * alfabet.length));
            }
            return randomId;
        },
		delay = (function(){
			var timer = {};
			return function(callback, ms, type){
					clearTimeout (timer[type]);
					timer[type] = setTimeout(callback, ms);
				};
		})(),
        addHTML = function () {
            switch (this.options.mode) {
            case "modal":
                var html = "";
                if (!this.options.isElementInput) {
						html += '<a id="' + this.options.userInputId + '_edit" href="#" onclick="return false;" style="margin-left: 5px;" class="btn btn-primary btn-mini">' + this.options.text.edit + "</a>";
						$(html).insertAfter(this.element);
                }
                html = '<div id="' + this.options.userInputId + '_modal" class="modal addresspicker hide fade ' + this.options.aPicker + '" tabindex="-1" role="dialog" aria-labelledby="' + this.options.userInputId + 'Label" aria-hidden="true">';
                html += '	<div class="modal-header">';
                html += '		<a href="#" onclick="return false;" class="close" data-dismiss="modal" aria-hidden="true">&times;</a>';
                html += '		<h3 id="' + this.options.userInputId + 'Label">' + this.options.text.set_your_address + "</h3>";
                html += '		<span class="info">' + this.options.text.set_your_address_info + "</span>";
                html += '	</div>';
                html += '	<div class="modal-body" style="overflow:hidden;">';
                html += '  		<input autocomplete="off" id="' + this.options.pickerInputId + '" style="width: 80%;"/>';
                html += '		<a id="' + this.options.userInputId + '_search" href="#" onclick="return false;" class="btn btn-mini btn-success">' + this.options.text.search + "</a>";
                html += '		<br /><span id="' + this.options.userInputId + '_error"></span>';
                html += '		<div class="map_container">';
                html += '			<div id="' + this.options.map_id + '" class="picker_map"></div>';
                html += '		</div>';
                html += '	</div>';
                html += '	<div class="modal-footer">';
                html += '		<span onclick="return false;" class="btn" data-dismiss="modal" aria-hidden="true">' + this.options.text.cancel + "</span>";
                html += '		<span id="' + this.options.userInputId + '_ok" onclick="return false;" data-dismiss="modal" aria-hidden="true" class="btn btn-primary">' + this.options.text.ok + "</span>";
                html += '	</div>';
                html += '</div>';
				$('body').append(html);
                break;
            case "plain":
            default:
                this.element.css("margin-bottom", "0");
                var html = "";
                if (!this.options.isElementInput) {
                    html += '<input type="text" value="" id="' + this.options.userInputId + '" />';
                }
                html += '<span id="' + this.options.userInputId + '_search" class="picker_search_btn btn btn-mini btn-success ' + this.options.aPicker + '">' + this.options.text.search + "</span><br />";
                html += '<span class="info">' + this.options.text.set_your_address_info + "</span>";
                html += '<span id="' + this.options.userInputId + "_error " + this.options.aPicker + '"></span>';
                html += '<div class="map_container ' + this.options.aPicker + '">';
                html += '<div class="picker_map" id="' + this.options.map_id + '"></div>';
                html += "</div>";
				$(html).insertAfter(this.element);
                break;
            }
        },
        checkMapVisibility = function () {
            if ($("#" + this.options.map_id).is(":visible")) {
                this.resizeMap();
                this.options.map_visible = window.clearInterval(this.options.map_visible);
            }
        },

			createCircle = function(){		
				var that = this,
				radius = $('.'+ this.options.targets_prefix +'distance').val();				
				if(radius){
					radius = radius * 1000; // Km
				}
				radius = radius || this.options.distanceWidgetRadius;
				var circle =  new google.maps.Circle({
					center: this.options.map_options.center,
					radius: radius, // Km
					strokeColor: "#005DE0",
					strokeOpacity: 0.8,
					strokeWeight: 2,
					fillColor: "#005DE0",
					fillOpacity: 0.25,
					map: this.options.map
				}),
				handleMouseEnter = function ( event ) {
					circle.setEditable( true );
				},
				handleMouseLeave = function ( event ) {
					circle.setEditable( false );
				};
				
				if(that.options.targets_prefix != ""){
					var radiusInput = $('.'+ that.options.targets_prefix +'distance');
					if(radiusInput.length > 0){
						radiusInput.on('change keyup',function(){
							delay.call(that,function(){
								var newRadius = parseFloat(radiusInput.val()) * 1000;
								circle.setRadius((newRadius || 0));
								that.options.map.fitBounds(circle.getBounds());
							},400);						
						});
					}
				}
				
				google.maps.event.addListener(circle, 'radius_changed', function(){
					that.options.location_components.distance = Math.round(circle.getRadius()) / 1000;
					that.updateFields('distance');
				});
				google.maps.event.addListener( circle, 'mouseover', handleMouseEnter );
				google.maps.event.addListener( circle, 'mouseout' , handleMouseLeave );
				return circle;
			},
		  
        initGmap = function () {
            if (this.options.map_rendered == true) {
                this.resizeMap();
                return;
            }
            var that = this;
				
            this.options.map_options.zoom = this.options.zoom;
            this.options.map_options.center = new google.maps.LatLng(this.options.latitude, this.options.longitude);				
				this.options.map_options.mapTypeId = google.maps.MapTypeId[this.options.mapTypeId];
			// create our map object
			if(typeof this.options.map == 'undefined' || this.options.map == null){
				if(typeof $.fn.gmap3 != 'undefined'){
					this.options.map = $("#"+ this.options.map_id).gmap3({
						map:{
							options: this.options.map_options
						}
					}).gmap3("get");
				} else {			
					this.options.map = new google.maps.Map($("#" + this.options.map_id).get(0), this.options.map_options);
				}
			} else {
				var old_map_id = this.options.map_id;
				this.options.map_id = $(this.options.map.getDiv()).attr('id');
				$("#" + old_map_id).replaceWith($('#'+ this.options.map_id));
			}
			// the geocoder object allows us to do latlng lookup based on address
            this.options.geocoder = new google.maps.Geocoder();
			
			// the marker shows us the position of the latest address
			var markerOptions = {
					position: this.options.map_options.center,
					draggable: true,
					raiseOnDrag: true,
					map: this.options.map,
					labelContent: this.options.text.you_are_here,
					labelAnchor: new google.maps.Point(0, 0),
					labelClass: this.options.markerLabelClass,
					labelStyle: {
						opacity: 1
					}
         };

			// marker
            if (this.options.markerType == 'styled' && typeof StyledMarker == "function"){
				// styled marker
				var styleIcon = new StyledIcon(StyledIconTypes.BUBBLE,{color:"#51A351",fore:'#ffffff',text:this.options.text.you_are_here});
				markerOptions.styleIcon = styleIcon;				
				this.options.marker = new StyledMarker(markerOptions);				
            } else if (this.options.markerType == 'labeled' && typeof MarkerWithLabel == "function"){
				// labeled marker
				this.options.marker = new MarkerWithLabel(markerOptions);
            } else {
				// default marker
                this.options.marker = new google.maps.Marker(markerOptions);
            }
			
            var currentAddress = $("#" + this.options.userInputId).text();
            if (this.options.isElementInput) {
                currentAddress = $("#" + this.options.userInputId).val();
            }

            if (currentAddress != "") {
               this.geocodeLookup("address", currentAddress, true);
            } else if(this.options.targets_prefix != "") {
					var currLatitude = parseFloat($('.'+ this.options.targets_prefix +'latitude').val()),
					currLongitude = parseFloat($('.'+ this.options.targets_prefix +'longitude').val());
					
					var radius = $('.'+ this.options.targets_prefix +'distance').val();
					if(radius && radius > 0){
						this.options.distanceWidgetRadius = parseFloat(radius);
					}
					
					if(currLatitude && currLatitude != '' && currLongitude && currLongitude != ''){
						that.geocodeLookup("latLng", new google.maps.LatLng(currLatitude, currLongitude));
					}
				}
				
				// add the distanceArea
				if(this.options.distanceWidget){
					switch(this.options.distanceWidgetType){
						case 'circle':
						default:
							this.options.distanceArea = createCircle.call(this);
							break;
					}
					this.options.distanceArea.bindTo('center', this.options.marker, 'position');
				}
				
			// event triggered when marker is dragged and dropped
            google.maps.event.addListener(this.options.marker, "dragend", function () {
                that.geocodeLookup("latLng", that.options.marker.getPosition());
            });
			// event triggered when map is clicked
            google.maps.event.addListener(this.options.map, "click", function (event) {
                that.options.marker.setPosition(event.latLng);
                that.geocodeLookup("latLng", event.latLng);
            });
			
			// event triggered when viewport changes
			var first=0;
			google.maps.event.addListener(this.options.map, 'bounds_changed', function(){
				delay.call(that,function(){
					// skip the MAP initialization
					first++;
					if(first <= 1){
						return;
					}
					var viewport = that.options.map.getBounds(),
						NE = viewport.getNorthEast(),
						SW = viewport.getSouthWest();
					that.options.location_components.ne_lat = Number(NE.lat().toFixed(8));
					that.options.location_components.ne_lng = Number(NE.lng().toFixed(8));
					that.options.location_components.sw_lat = Number(SW.lat().toFixed(8));
					that.options.location_components.sw_lng = Number(SW.lng().toFixed(8));
				
					that.updateFields('bounds');
					var evt = $.Event(that.options.event_viewport_change);
					that.element.trigger(evt, that.options.location_components);
					if (typeof that.options.onViewportChanged == "function") {
						that.options.onViewportChanged.call(that, that.options.event_viewport_change);
					}
				},300,that.options.event_viewport_change);
			});
            this.options.map_rendered = true;
        },
		// move the marker to a new location, and center the map on it
        update_map = function (geometry, latLng) {
            latLng = (latLng) ? latLng : geometry.location;
            this.options.marker.setPosition(latLng);
            geometry.viewport.extend(latLng);
				if(this.options.distanceWidget){				
					this.options.map.fitBounds(this.options.distanceArea.getBounds());
				} else {
					this.options.map.fitBounds(geometry.viewport);
				}
        },
		// update the UI elements with new location data
        update_ui = function (address, latLng, components) {
			var that = this;
            this.options.location_components.formatted_address = address;
			
            for (var i = 0; i < components.length; i++) {
                var addr = components[i];
                if (addr.types.indexOf("country") >= 0) {
                    this.options.location_components.country = addr.long_name;
                    this.options.location_components.country_code = addr.short_name;
                }
                if (addr.types.indexOf("administrative_area_level_1") >= 0) {
                    this.options.location_components.region = addr.long_name;
                    this.options.location_components.region_code = addr.short_name;
                }
                if (addr.types.indexOf("administrative_area_level_2") >= 0) {
                    this.options.location_components.county = addr.long_name;
                    this.options.location_components.county_code = addr.short_name;
                }
                if (addr.types.indexOf("locality") >= 0) {
                    this.options.location_components.city = addr.long_name;
                }
                if (addr.types.indexOf("sublocality") >= 0) {
                    this.options.location_components.city_district = addr.long_name;
                }
                if (addr.types.indexOf("postal_code") >= 0) {
                    this.options.location_components.zip = addr.long_name;
                }
                if (addr.types.indexOf("route") >= 0) {
                    this.options.location_components.street = addr.long_name;
                }
                if (addr.types.indexOf("street_number") >= 0) {
                    this.options.location_components.street_number = addr.long_name;
                }
            }
				
				if(this.options.distanceWidget){
					this.options.location_components.distance = Math.round(this.options.distanceArea.getRadius()) / 1000; // Km
				}
			
            if (typeof latLng == "object") {
				/* round decimal digits on lat lon */
                this.options.location_components.latitude = Number(latLng.lat().toFixed(8));
                this.options.location_components.longitude = Number(latLng.lng().toFixed(8));
            }
					
			/* update addresspicker input */
				$('body').find('#'+ that.element.attr('id')).val(this.options.location_components.formatted_address).trigger('keyup');
			/* triggered only if we are in PLAIN mode */
            if (this.options.mode != "modal") {
				delay.call(this,function(){
					that.updateFields();
					var evt = $.Event(that.options.event_success);
					that.element.trigger(evt, that.options.location_components);
					if (typeof that.options.onSuccess == "function") {
						that.options.onSuccess.call(that, that.options.event_success);
					}
				},300,that.options.event_success);
            }
        },
        typeaheadAddresses = function () {
            if ($.fn.typeahead == "undefined") {
                return;
            }
            var that = this;
            $("#" + this.options.userInputId).attr("autocomplete", "off");
            if (typeof $.fn.typeahead != "undefined") {
                $("#" + this.options.pickerInputId).typeahead({
                    source: function (query, process) {
                        var request = {};
                        request.address = query;
                        request.language = that.options.language;
                        that.options.geocoder.geocode(request, function (results, status) {
                            $("#" + that.options.userInputId + "_error").html("");
                            if (status == google.maps.GeocoderStatus.OK) {
                                process($.map(results, function (item) {
                                    return item.formatted_address;
                                }));
                            }
                        });
                    },
                    updater: function (item) {
                        that.geocodeLookup("address", item);
                        return item;
                    },
                    minLength: 3,
                    items: this.options.maxResultShow
                });
            }
        },
		// Add addressPickerByGiro's event bindings
        addBindings = function () {
            var that = this;
			/* add trigger on input focus for modal (twitter bootstrap required) */
            if (this.options.mode == "modal") {
                this.element.on("focus click", function () {
                    $("#" + that.options.userInputId + "_modal").modal("show");
                });
                $("#" + this.options.userInputId + "_edit").on("click", function () {
                    $("#" + that.options.userInputId + "_modal").modal("show");
                });
                $("#" + this.options.userInputId + "_modal").on("shown", function () {
					that.resizeMap();
					
                    var evt = $.Event(that.options.event_open_modal);
                    that.element.trigger(evt, that.options.location_components);
                    if (typeof that.options.onOpenModal == "function") {
                        that.options.onOpenModal.call(that, that.options.event_open_modal);
                    }
                });
				// triggered when user click on OK button
                $("#" + this.options.userInputId + "_ok").on("click", function (e) {
					delay.call(this,function(){
						var formatted_address = that.options.location_components.formatted_address;
						if(typeof formatted_address == 'undefined' || formatted_address == '' ){
							e.preventDefault();
							alert(that.options.text.set_your_address);
							return;
						}
						if (that.options.isElementInput && typeof that.options.location_components == "object") {							
							$('body').find('#'+ that.element.attr('id')).val(that.options.location_components.formatted_address).trigger('keyup');
						}
						that.updateFields();
						var evt = $.Event(that.options.event_success);
						that.element.trigger(evt, that.options.location_components);
						if (typeof that.options.onSuccess == "function") {
							that.options.onSuccess.call(that, that.options.event_success);
						}
					},300,that.options.event_success);
                });
				// triggered when user click on CANCEL button
                $("#" + this.options.userInputId + "_modal").on("click", '[data-dismiss="modal"]', function () {
                    var evt = $.Event(that.options.event_close_modal);
                    that.element.trigger(evt, that.options.location_components);
                    if (typeof that.options.onCancelModal == "function") {
                        that.options.onCancelModal.call(that, that.options.event_close_modal);
                    }
                });
            } else {
					this.options.map_visible = window.setInterval(checkMapVisibility.call(this), 300);
            }
			// triggered when user presses a key in the address box
            $("#" + this.options.pickerInputId).on("keydown", function (event) {
                if (event.keyCode == 13) {
                    that.geocodeLookup("address", $('body').find("#" + that.options.pickerInputId).val());
                }
            });
			// triggered when user click on GO button
            $("#" + this.options.userInputId + "_search").on("click", function () {
                that.geocodeLookup("address", $('body').find("#" + that.options.pickerInputId).val());
            });
        };
    // The actual plugin constructor
    var Plugin = function (element) {
        /*
         * Plugin instantiation
         */		
            this.others_opts = {
				// Events
                event_initialized: pluginName + "_initialized",
                event_open_modal: pluginName + "_open_modal",
                event_close_modal: pluginName + "_close_modal",
                event_success: pluginName + "_success",
                event_viewport_change: pluginName + "_viewport_change",
				// Cached jQuery Object Variables
                $events: $("<a/>"),
                $related: null,
				// Variables for cached values or use across multiple functions
                map_rendered: false,
                userInputId: null,
                aPicker: null,
                elementClass: null,
                isElementInput: true,
                pickerInputId: null,
                geocoder: null,
				globalCluster: null,
                marker: null,
                location_components: {
					country: '',
					country_code: '',
					county: '',
					county_code: '',
					region: '',
					region_code: '',
					city: '',
					city_district: '',
					zip: '',
					street: '',
					street_number: '',
					latitude: '',
					longitude: '',
					formatted_address: '',
					ne_lat: '',
					ne_lng: '',
					sw_lat: '',
					sw_lng: ''
				},
                map_visible: null,
                element: null,
                initialized: false
            };
            this.options = $.extend({}, defaults);
        };
    Plugin.prototype = {
        init: function (options) {
            var that = this;
            if (this.options.initialized) {
                return;
            }				

				// check we have some data on the element
				var ele = this.element,
				inlineData = ele.data();				
				
            $.extend(this.options, options, inlineData, this.others_opts);
            this.options.pickerInputId = this.options.userInputId = this.id = ele.attr("id");
            
			// generate a random id for this input
            if (this.options.userInputId == "") {
                this.options.userInputId = generateRandom();
            }
            if (!this.element.is('input[type="text"],textarea')) {
                this.options.isElementInput = false;
                this.options.pickerInputId = this.options.userInputId = generateRandom();
				// add an update text to this element
                if (!this.options.targets_prefix) {
                    this.options.targets_prefix = this.options.userInputId + "_location_";
                }
                elementClass = this.options.targets_prefix + "formatted_address";
                this.element.addClass(elementClass);
            }
            if (this.options.mode == "modal") {
                this.options.pickerInputId = this.options.userInputId + "_addresspicker";
            }
            this.options.aPicker = this.options.userInputId + "_apicker";
            this.options.map_id = this.options.userInputId + "_map_canvas";
				
				this.options.mapTypeId = /ROADMAP|HYBRID|TERRAIN|SATELLITE/i.test(this.options.mapType) ? this.options.mapType.toUpperCase() : 'ROADMAP';
				
            addHTML.call(this);
			/* add map to the document */
            initGmap.call(this);
			// typeahead autocomplete
            typeaheadAddresses.call(this);
            addBindings.call(this);
			// initialization completed
            this.options.initialized = true;
            var evt = $.Event(this.options.event_initialized);
            this.element.trigger(evt, this.options.location_components);
            if (typeof this.options.onInit == "function") {
                this.options.onInit.call(this, this.options.event_initialized);
            }
        },
        geocodeLookup: function (type, value, update) {
            var latLng = false;
            var that = this;
            if (typeof value == "string" && type == "latLng") {
                value = value.split(",");
                value = new google.maps.LatLng(value[0], value[1]);
            }
            if (type == "latLng") {
                latLng = value;
            }
			// default value: update = true
            update = typeof update !== "undefined" ? update : true;
            var request = {};
            request[type] = value;
            request.language = this.options.language;
            this.options.geocoder.geocode(request, function (results, status) {
                $("#" + that.options.userInputId + "_error").html("");
                if (status == google.maps.GeocoderStatus.OK) {
					// update the map (position marker and center map)
                    update_map.call(that, results[0].geometry, latLng);
						  
						// update addresspicker input
						if (that.options.mode == "modal" && results[0]) {
							$('body').find('#'+ that.options.pickerInputId).val(results[0].formatted_address);
						}
						
					// Google geocoding has succeeded!
                    if (update) {
                        if (results[0]) {
                            var location = results[0].geometry.location;
                            if (type == "latLng") {
                                location = latLng;
                            }
							// update the UI elements with new location data
                            update_ui.call(that, results[0].formatted_address, location, results[0].address_components);
                        } else {
							// Geocoder status ok but no results!?
                            $("#" + that.options.userInputId + "_error").html(that.options.text.genericerror);
                        }
                    }
					return true;
                } else {
					// Google Geocoding has failed. Two common reasons:
					//   * Address not recognised (e.g. search for 'kjdckjdnksjjdpwpid')
					//   * Location doesn't map to address (e.g. click in middle of the ocean)
                    if (update) {
                        if (type == "address") {
							// User has typed in an address which we can't geocode to a location
                            $("#" + that.options.userInputId + "_error").html(that.options.text.noresults);
                        } else {
							// User has clicked or dragged marker to somewhere that Google can't do a reverse lookup for
							// In this case we display a warning, clear the address box, but fill in LatLng
                            $("#" + that.options.userInputId + "_error").html(that.options.text.toofar);
                            update_ui.call(that, "", "", "");
                        }
                    }
					return false;
                }
            });
        },
		/* update input fields or DOM elements in the document */
        updateFields: function(type){
            var that = this,valid=[];
				if(typeof type != 'undefined'){
					if(type == 'bounds'){
						valid = ['sw_lat','sw_lng','ne_lat','ne_lng'];
					} else if(type instanceof Array){
						valid = type;
					} else if(typeof type == 'string'){
						valid = [type];
					}
				}
				
            if (this.options.targets_prefix || this.options.cssSelectorTarget){
					var targets = $();
					if(this.options.targets_prefix){
						/* set all elements values/text related to targets_prefix */
						targets = targets.add($('body').find('[class^="' + this.options.targets_prefix + '"],[class*=" ' + this.options.targets_prefix + '"]'));
					}
					
					if(this.options.cssSelectorTarget){
						targets = targets.add($('body').find(this.options.cssSelectorTarget));
					}

					targets.each(function (index, value) {
                    var ele = $(this);
                    $.each(that.options.location_components, function (index, element) {
								if(valid.length > 0 && valid.indexOf(index) < 0){
									return true;
								}
						
                        if (!ele.hasClass(that.options.targets_prefix + index) && !ele.hasClass(index)) {
									return true;
                        }
                        if (ele.is('input:not([type="radio"]), textarea')) {
                            ele.val(that.options.location_components[index]);
							/* check for validation engine and fire it on the element */
                            if ($.fn.validationEngine == "function") {
                                ele.validationEngine("validate");
                            }
                        } else {
                            ele.text(that.options.location_components[index]);
                        }
                    });
                });
            }
        },
        getMap: function (){
            return this.options.map;
        },
        getAddress: function (){
            return this.options.location_components;
        },
        resizeMap: function (latitude, longitude) {
			var that = this;
			delay(function(){
            var lastCenter, map_cont = $("#" + that.options.map_id).closest(".map_container");
            var parent_map_cont = map_cont.parent();
            var h = parent_map_cont.height();
            var w = parent_map_cont.width();
            map_cont.css("height", h);
            map_cont.css("width", w);
            if (typeof latitude != "undefined" && typeof longitude != "undefined") {
					lastCenter = new google.maps.LatLng(latitude, longitude);
				} else {
					lastCenter = that.options.map.getCenter();
            }
				
            google.maps.event.trigger(that.options.map, "resize");
            that.options.map.setCenter(lastCenter);			
			},300);
			
        },
        destroy: function () {
            // unset Plugin data instance
            this.element.data(dataPlugin, null);
        }
    };
    /*
     * Plugin wrapper, preventing against multiple instantiations and
     * allowing any public function to be called via the jQuery plugin,
     * e.g. $(element).pluginName('functionName', arg1, arg2, ...)
     */
    $.fn[pluginName] = function (arg) {
        var args, instance;
		// return if our jQuery obj doesn't have elements
        if (this.length <= 0) {
            return this;
        }
        // only allow the plugin to be instantiated once
        if (!(this.data(dataPlugin) instanceof Plugin)) {
            // if no instance, create one
            this.data(dataPlugin, new Plugin(this));
        }
        instance = this.data(dataPlugin);
        instance.element = this;
        // Is the first parameter an object (arg), or was omitted,
        // call Plugin.init( arg )
        if (typeof arg === "undefined" || typeof arg === "object") {
            if (typeof instance.init === "function") {
                instance.init(arg);
            }
        } else {
			// checks that the requested public method exists
            if (typeof arg === "string" && typeof instance[arg] === "function") {
				// copy arguments & remove function name
                args = Array.prototype.slice.call(arguments, 1);
				// call the method
                return instance[arg].apply(instance, args);
            } else {
                $.error("Method " + arg + " does not exist on jQuery." + pluginName);
            }
        }
    };
}(jQuery, window, document));