<?php
/**
* @author		Girolamo Tomaselli http://bygiro.com - girotomaselli@gmail.com
* @license		GNU General Public License
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


class JDomFrameworkJqueryUnveil extends JDomFrameworkJquery
{	

	var $assetName = 'unveil';
	
	var $attachJs = array();
	var $attachCss = array();
	
	protected static $loaded = array();	
	
	/*
	 * Constuctor
	 * 	@namespace 	: requested class
	 *  @options	: Configuration
	 *
	 *
	 */
	function __construct($args)
	{
		parent::__construct($args);
		
		/* example arguments */
		$this->arg('options1'	, null, $args);
		$this->arg('options2'	, null, $args);		
	}
	
	function build()
	{	
		// Only load once
		if (!empty(static::$loaded[__METHOD__]))
		{
			return;
		}
			
		$doc = JFactory::getDocument();
		
		//Requires jQuery
		JDom::_('framework.jquery');		
		
		// addresspicker manager files needed
		$this->attachJs[] = 'jquery.unveil.js';
	
		$script = '
		function enableUnveil($obj){
			if(!($obj instanceof jQuery)){
				$obj = jQuery($obj);
			}
			
			$obj.find(".img-zone img").not("[data-src]").each(function(){
				var src = jQuery(this).attr("src");
				
				jQuery(this)
					.attr("data-src",src)
					.attr("src","#")
					.unveil();
			});
		}
jQuery(document).ready(function(){
	enableUnveil("body");
});';
		$doc->addScriptDeclaration($script);
		
		static::$loaded[__METHOD__] = true;
	}
	
	function buildCss()
	{
	//	$this->attachCss[] = 'bootstrap.min.css';
	}
	
	function buildJs()
	{
	//	$this->attachCss[] = 'bootstrap.min.css';
	}
}