<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

function attr($s,$attrname) { // return html attribute
	preg_match_all('#\s*('.$attrname.')\s*=\s*["|\']([^"\']*)["|\']\s*#i', $s, $x);
	if (count($x)>=3) return $x[2][0]; else return "";
}

function url_get_contents2($Url) {
    if (!function_exists('curl_init')){ 
        echo 'CURL is not installed! Flickr Feed module needs CURL extension to be installed on your server. Please talk with your webhosting support to activate it on this account.';
		return;
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $Url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

// id = id of the feed
// n = number of thumbs
function parseFlickrFeed($id,$n) {
	$url = "http://api.flickr.com/services/feeds/photos_public.gne?id={$id}&lang=it-it&format=rss_200";
	$s = url_get_contents2($url);
	preg_match_all('#<item>(.*)</item>#Us', $s, $items);
	$out = "";
	for($i=0;$i<count($items[1]);$i++) {
		if($i>=$n) return $out;
		$item = $items[1][$i];
		preg_match_all('#<link>(.*)</link>#Us', $item, $temp);
		$link = $temp[1][0];
		preg_match_all('#<title>(.*)</title>#Us', $item, $temp);
		$title = $temp[1][0];
		preg_match_all('#<media:content([^>]*)>#Us', $item, $temp);
		$imglink = attr($temp[0][0],"url");
		preg_match_all('#<media:thumbnail([^>]*)>#Us', $item, $temp);
		$thumb = attr($temp[0][0],"url");
		
		$out.="<li><a href=\"".$imglink."\" target='_blank' class=\"colorbox\" title=\"".str_replace('"','',$title)."\"><img src='$thumb'/></a></li>";
	}
	return $out;
}