<?php
/**
 * @version 0.1 $Id: helper.php 0 2013-04-10
 * @package Joomla
 * @subpackage mod_hideblock
 * @author daryl
 * @copyright (C) 2013 RMIS
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');

class mod_hideblockHelper {
	public $lists = array();
	private $params;
	function __construct($params) {
		$this->params = $params;
	}
	public function loadCSS() {
		$document	= JFactory::getDocument();
		if ($css = $this->params->get('css')) {
			$files = explode("\n", $css);
			foreach($files as $file) {
				$file = trim($file);
				if (empty($file)) continue;
				if (substr($file, 0, 4) == 'http') {
					$url = $file;
				} else {
					$url = JURI::root().'/'.$file;
				}
				$document->addStyleSheet($file);
			}
		}
	}
	public function loadJS() {
		$document	= JFactory::getDocument();
		if ($js = $this->params->get('javascript')) {
			$files = explode("\n", $js);
			foreach($files as $file) {
				$file = trim($file);
				if (empty($file)) continue;
				if (substr($file, 0, 4) == 'http') {
					$url = $file;
				} else {
					$url = JURI::root().'/'.$file;
				}
				$document->addScript($file);
			}
		}
	}
	public function loadInlineCSS() {
		$document	= JFactory::getDocument();
		if (!$css = $this->params->get('inline_css')) {
			$css = '';
		}
		$css .= "\n#hideblock".$this->params->get('bid')." { top: ".$this->params->get('block_top')." !important; }";
		if ($this->params->get('block_location') == 'left') {
			$css .= "\n#hideblock".$this->params->get('bid')." .hdb-innerl { background: url(".JURI::root()."/modules/mod_hideblock/images/left/slider-button-".$this->params->get('tab_color').".png) right 21px no-repeat; }";
		} else {
			$css .= "\n#hideblock".$this->params->get('bid')." .hdb-inner { background: url(".JURI::root()."/modules/mod_hideblock/images/right/slider-button-".$this->params->get('tab_color').".png) 10px 21px no-repeat; }";
		}
		$document->addStyleDeclaration($css);
	}
	public function loadInlineJS() {
		$document	= JFactory::getDocument();
		$jsh = "
		function hdbblend".$this->params->get('bid')."() {";
		if ($js = $this->params->get('inline_javascript')) {
			$jsh .= "\n".$js;
		}
		$jsh .= "
		}
		";
		$document->addScriptDeclaration($jsh);
	}
	function haveFlow() {
		$flow_admin = JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_flow';
		$flow_front = JPATH_ROOT . DS . 'components' . DS . 'com_flow';
		
		if(!is_dir($flow_admin))
			return false;
		
		if(!is_dir($flow_front))
			return false;
		
		return true;
	}
}
