/*
 * jQuery Quovolver v1.0 - http://sandbox.sebnitu.com/jquery/quovolver
 *
 * By Sebastian Nitu - Copyright 2009 - All rights reserved
 * 
 */

(function($) {
	$.fn.quovolver = function(speed, delay) {
		
		/* Sets default values */
		if (!speed) speed = 500;
		if (!delay) delay = 6000;
		
		// If "delay" is less than 4 times the "speed", it will break the effect 
		// If that's the case, make "delay" exactly 4 times "speed"
		var quaSpd = (speed*4);
		if (quaSpd > (delay)) delay = quaSpd;
		
		
		
		// Create the variables needed
		var	quote = $(this),
			firstQuo = $(this).filter(':first'),
			lastQuo = $(this).filter(':last'),
			wrapElem = '<div id="quote_wrap"></div>';
			currElem = firstQuo;
			theparent = $(this).parent();
		
		var currNr=0;
		
		// Wrap the quotes
		$(this).wrapAll(wrapElem);
		
		$(this).css({'position': 'absolute',
		'top' : 0,
		'left' : 0,
		'opacity' : 0});
		$(firstQuo).css({'opacity' : 1});
		
		// Set the hight of the wrapper
		$(this).parent().css({height: $(firstQuo).height()});		
		
		// Where the magic happens
		setInterval(function(){
			currNr++;
			// Set required hight and element in variables for animation
			if(currNr > quote.length - 1) {
				currNr=0;
			}
				var nextElem = quote.eq(currNr);
				var wrapHeight = $(nextElem).height();
			// Fadeout the quote that is currently visible
			//$(quote).filter(':visible').fadeOut(speed);
			
			$(currElem).animate({'opacity' : 0}
				, {duration:speed*2,queue:false});
				
			// Set the wrapper to the hight of the next element, then fade that element in
			setTimeout(function() {
				$(quote).parent().animate({height: wrapHeight}, {queue:false, duration:speed});
			}, speed);
			
					$(nextElem).animate({'opacity' : 1}
				, {duration:speed*2,queue:false});
				
			currElem = nextElem;
			
			
		}, delay);
	
	};
})(jQuery);