<?php
/**
 * @version		$Id$
 * @author		Hogas Marius (mhogas@gmail.com)
 * @package		Joomla.Site
 * @subpakage	Hogash.HGAssets
 * @copyright	Copyright (c) 2012 Hogash Templates (http://www.hogash.com). All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die();

jimport('joomla.plugin.plugin');
//jimport('zauan.shortcodes.shortcodes');



/**
 * System - HG Assets
 *
 * @package		Joomla.Plugin
 * @subpakage	Hogash.HGAssets
 */
class plgSystemHG_Assets extends JPlugin {

	/**
	 * Constructor.
	 *
	 * @param 	$subject
	 * @param	array $config
	 */
	function __construct(&$subject, $config = array()) {
		// call parent constructor
		parent::__construct($subject, $config);
	}

	//onAfterRoute hook.
	public function onAfterRoute() {
		$app	= JFactory::getApplication();

		if ($app->isAdmin()) {
			if($this->params->get('hidemenu',1)) {
				// check to see if the user is admin
				$user = JFactory::getUser();
				if(!$user->authorise('manage', 'com_banners'))
					return;	
			}
			$document	= JFactory::getDocument();
			$document->addStyleSheet(JURI::root(true) . '/plugins/system/hg_assets/assets/css/style.css');
			
		}
	}
	public function onAfterDispatch() {
		if($this->params->get('hidemenu',1))
	        JRequest::setVar('hidemainmenu', 0);

		$app = JFactory::getApplication();
        if (!$app->isAdmin()) return;
		$option = JRequest::getWord('option');
        $layout = JRequest::getWord('layout');
		
		
		if ($option == 'com_content' && $layout == 'edit'){
			JFactory::getDocument()->addScript(JURI::root(true) . '/plugins/system/hg_assets/assets/js/hgscript.js');

        }
    }

	//Add the forms from the template path
	public function onContentPrepareForm($form, $data) {
	
		$template = $this->params->get('theme', 'ekho');
		$app = JFactory::getApplication();
        if (!$app->isAdmin()) return;

        $option = JRequest::getWord('option');
        $layout = JRequest::getWord('layout');
		$view = JRequest::getWord('view');
		
		if ($option == 'com_content' && $layout == 'edit'){
			$form->loadFile(JPATH_SITE.'/templates/'.$template.'/html/com_content/fields/article.xml', true);
        }
	}


// Do BBCode replacements on the whole page 
public function onContentPrepare($context, &$article, &$params, $limitstart)
{
if($this->params->get(shortcodes,1)) {
/*Added the import of the shortcode plugin in this statement*/
jimport(zauan.shortcodes.shortcodes);
error_reporting (E_ALL ^ E_NOTICE);
$article->text = wpautop($article->text);
$article->text = shortcode_unautop($article->text);
$article->text = do_shortcode($article->text);
}
}

}