/* 
 * smartSeo
 * ========
 * custom javascript code for smartSeo plugin.
 * @author Andrei Dinca, AA-Team
 * @date 25.05.2012
 */
 
 
var smartSeoPanel = {

    option: {
        uri: '',
        seoSettings: {},
        running: false,
        autoCheck : 0,
        countDown: 0,
		autoCheckTimes: 10,
		autoCheck: true,
		primary_key: '',
        maxScore: 0,
		rules: null,
		panel: null,
		nr_execution: 0,
        script: 'request.php'
    },

    init: function(options) {
        var self = this;
        
        //function that will initialize the script and do all the bindings
        self.option = jQuery.extend({}, self.option, options);
		
		// inject to html
		jQuery("#item-form").find(".pane-sliders").first().find('.panel').last().after("<div id='smartSeoPanel' />");
		self.option.panel = jQuery("div#smartSeoPanel");
        
		// if not exist
        if(!self.option.panel.size()){
            return false;
        }
		
		// init show rules
        self.showRules();
		
		// append smartSeo panel
		self.appendPanel();
		
        jQuery("#smartSeoCheck").live('click', function(){
            jQuery("#seoTimeMarker").text(self.option.autoCheckTimes);
            self.seoCheckUpdate();
            return false;
        });
    },
	
	appendPanel: function() {
		var self = this;
		
		// call ajax method for printing the panel
		jQuery.ajax({
			type		: "POST",
			url			: self.option.uri + self.option.script,
			data		: {
				'action' 		: 'print-panel',
				'plugin_url'	: self.option.uri,
				'primary_key'	: self.option.primary_key,
				'rules'			: self.option.rules
			},
			dataType	: "json",
			success		: function(dataResponse) {
				if(dataResponse.status == 'valid'){
					self.option.panel.html( dataResponse.html );
					
					self.option.panel.hide();
					
					// run first checking
					self.seoCheckUpdate();
					
					// autocheck
					if(self.option.autoCheck == true){
						jQuery("#seoTimeMarker").text(self.option.autoCheckTimes);
						self.option.countDown = setInterval(function(){ self.pushCountDown() }, 1000);
					}
				}
			}
		});
		
	},
    
    pushCountDown: function(){
        var self = this;
        
        var currCount = jQuery("#seoTimeMarker").text();
        if(currCount == 0){
            self.seoCheckUpdate();
            jQuery("#seoTimeMarker").text(self.option.autoCheckTimes);
        }else{
            jQuery("#seoTimeMarker").text(currCount - 1);
        }
    },
    
    showRules: function(){
        var self = this;

        jQuery.each(self.option.rules, function(key, val) {
			if( val === 1 && key != 'checkdensity' && key != 'thedensity' && key != 'debug' ){
                self.option.maxScore++;
            }
        });
    },

    seoCheckUpdate: function(){
        var self = this;
        
        // collision prevent
        if(self.option.running == true) return false; // exit
        
        self.option.running = true;

        jQuery('#smartSeoOverlay')
			.css('display', 'block')
			.css('height', jQuery('#smartSeoChecklist').height());
        

		var theContent = jQuery('#jform_articletext').val();
		if (self.option.nr_execution > 0) {
			theContent = tinyMCE.get('jform_articletext').getContent();
		}
		
		if(jQuery("#smartSeoPhrases").val() == ""){
			self.option.panel.show();
			self.option.running = false;
			return false;
		}
		
        jQuery.post(self.option.uri + self.option.script, 
        {
            'primary_keyword' 	: jQuery("#smartSeoPhrases").val(),
            'action' 			: 'seocheck',
            'meta_title'		: jQuery("#jform_title").val(),
            'meta_description'	: jQuery("#jform_metadesc").val(),
            'meta_keywords'		: jQuery("#jform_metakey").val(),
            'content'			: theContent
        }, function(data) {
			self.option.nr_execution++;
			
			if(data.status == 'invalid'){
				alert(data.html);
				return false;
			}
			
			// update status
            var points = 0;
            jQuery.each(data.array, function(key, val) {
                if(self.option.rules[key] == 1){
                    if(val > 0){
						points++;
						jQuery("#stats-" + key).attr('src', self.option.uri + 'images/ok.png');
                    }else{
                        jQuery("#stats-" + key).attr('src', self.option.uri + 'images/no.png');
                    }
                }
            });
			if(self.option.rules.checkdensity == 1){
				// particular case for density
				var keyword_density = self.option.rules.thedensity,
					curr_den 		=  data.array.thedensity;
				
				// update density
				jQuery("#seoCurretDensity").text(curr_den + "%");
				if(curr_den <= keyword_density && curr_den >= (keyword_density- 1)){
					points++;
					jQuery("#stats-keyword_meta_density").attr('src', self.option.uri + 'images/ok.png');
				}
				if(curr_den >= keyword_density && curr_den <= (keyword_density + 1)){
					points++;
					jQuery("#stats-keyword_meta_density").attr('src', self.option.uri + 'images/ok.png');
				}
			}
            
            // Hide the label at start
            jQuery('#progress_bar .ui-progress .ui-label').hide();
			
            // Set initial value
            jQuery('#progress_bar .ui-progress').css('width', '0%');
			
			// show the panel
			self.option.panel.show();

            var progressCount = ((points / (self.option.maxScore + 1))  * 100).toFixed(1);
            // Simulate some progress
            jQuery('#progress_bar .ui-progress').animateProgress({
                progress : progressCount,
                duration : 600,
                easing   : 'swing'
            }, function() {});
            
            // unblock script
            self.option.running = false;
			
        }, 'json');
    }
};

(function( $ ){
    // Simple wrapper around jQuery animate to simplify animating options.progress from your app
    // Inputs: options.progress as a percent, Callback
    // TODO: Add options and jQuery UI support.
    $.fn.animateProgress = function(options, callback) { 
        
        return this.each(function() {
            
            var progress = options.progress;
            $(this).animate({
                width: options.progress + '%'
            }, {
                duration: options.duration, 
        
                // swing or linear
                easing: options.easing,

                // this gets called every step of the animation, and updates the label
                step: function( progress ){
                    var labelEl = $('.ui-label'),
                    valueEl = labelEl.find('.value');
          
                    if (Math.ceil(progress) < 20 && $('.ui-label', this).is(":visible")) {
                        labelEl.hide();
                    }else{
                        if (labelEl.is(":hidden")) {
                            labelEl.fadeIn();
                        };
                    }
                    valueEl.text((progress.toFixed(1)) + '%');
                    
                },
                complete: function(scope, i, elem) {
                    if (callback) {
                        callback.call(this, i, elem );
                    };
                }
            });
        });
    };
})( jQuery );