<?php
/**
* @author AA-Team
* The easiest way to optimize your wordpress website for search engines!
* version 1.0
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport('joomla.plugin.plugin');
jimport('joomla.html.parameter');

class plgSystemsmartSeo extends JPlugin {
	
	private $dbSeoName = '#__content_smartseo';
	
	// Constructor
    function plgSystemsmartSeo(&$subject, $params) {
		parent::__construct( $subject, $params );
    }

    function onAfterDispatch()
	{
		//global $mainframe, $thebuffer;
		$app = &JFactory::getApplication();
		$document =& JFactory::getDocument();
		$docType = $document->getType();
		if (
			!$app->isSite() /* not in fronend */
			&& $_GET['option'] == 'com_content'
			&& $_GET['view'] == 'article'
			&& $_GET['layout'] == 'edit'
		) {
		
			
			// retrive options from DB
			$options = $this->getPluginParams();
			
			// construct js Object for configuration of smartSeo
			$jsObj = "rules: {\n";
			
			foreach ($options as $key => $value){
				$jsObj .= "\t'{$key}': {$value},\n";
			}
			$jsObj .= "\t'debug': 1\n";
			$jsObj .= "}";
			
			// get the primary key from DB
			$seoPrimaryKey = '';
			$article_id = (int) $_GET['id'];
			if($article_id  > 0){
				$db = JFactory::getDBO();
				$query = 'SELECT *' . ' FROM ' . ( $this->dbSeoName ) . ' WHERE content_id = ' . $article_id;
				$db->setQuery($query);
				$seoKey = $db->loadObject(); 
				$seoPrimaryKey = $seoKey->primary_keyworkds;
			}
			
			$plugin_url = JURI::root() . 'plugins/system/smartSeo/';
			$document->addStyleSheet  ( $plugin_url . 'style.css' );
			$document->addScript( $plugin_url . 'jquery.min.js' );
			$document->addScript( $plugin_url . 'app.js' );
			$document->addScriptDeclaration ( 'jQuery.noConflict(); jQuery(document).ready(function() {
				smartSeoPanel.init({
					"uri": "'. ( $plugin_url ) .'",
					"primary_key": "' . ( $seoPrimaryKey ) . '",
					' . ( $jsObj ) . '
				});
			} )' );
		}
	}
	private function getPluginParams () 
	{
		return array(
			'checkdensity' => (int) $this->params->get('smartSeo_checkdensity'),
			'thedensity' => (int) $this->params->get('smartSeo_thedensity'),
			'in_title' => (int) $this->params->get('smartSeo_in_title'),
			'in_desc' => (int) $this->params->get('smartSeo_in_desc'),
			'in_key' =>  (int) $this->params->get('smartSeo_in_key'),
			'h1' => (int) $this->params->get('smartSeo_h1'),
			'h2' => (int) $this->params->get('smartSeo_h2'),
			'h3' => (int) $this->params->get('smartSeo_h3'),
			'fontsize' => (int) $this->params->get('smartSeo_fontsize'),
			'alt' => (int) $this->params->get('smartSeo_alt')
		);
	}
	
	public function onContentAfterSave($context, &$article, $isNew)
	{ 
		global $mainframe;
		
		$db = JFactory::getDBO();
		$article_id = $article->id;
		$thePrimaryKey = htmlentities( $_POST['smartSeoPrimary'] );
		
		// exit if no article ID or key empty
		if((int) $article_id == 0 ) return true;
		
		$query = 'SELECT *' . ' FROM ' . ( $this->dbSeoName ) . ' WHERE content_id = ' . $article_id;
		$db->setQuery($query);
		$seoKey = $db->loadObject();
		
		
		if(!$seoKey){
			// There are no key yet, so lets insert our key
			$query = 'INSERT INTO ' . ( $this->dbSeoName ) . ' ( content_id, primary_keyworkds, data )' . ' VALUES ( ' . ( $article_id ) . ', ' . $db->Quote( $thePrimaryKey ) . ', NOW() )';
			$db->setQuery($query);
			$db->query();
		}else{
			// We weren't the last key so lets add our key
			$query = 'UPDATE ' . ( $this->dbSeoName ) . ' SET primary_keyworkds = ' . $db->Quote( $thePrimaryKey ) . ', data = NOW() WHERE content_id = ' . $article_id;
			$db->setQuery($query);
			$db->query();
			
		}
		
		//add your plugin codes here
		return true;
	}
}