<?php
/**
 * @package     gantry
 * @subpackage  features
 * @version		3.2.8 August 1, 2011
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2011 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Gantry uses the Joomla Framework (http://www.joomla.org), a GNU/GPLv2 content management system
 *
 */

defined('JPATH_BASE') or die();

gantry_import('core.gantryfeature');

/**
 * @package     gantry
 * @subpackage  features
 */
class GantryFeatureJSTools extends GantryFeature {
    var $_feature_name = 'jstools';

    function isEnabled(){
        return true;
    }
    function isInPosition($position) {
        return false;
    }
	function isOrderable(){
		return false;
	}
	

	function init() {
        global $gantry;
		
		// date
		if ($gantry->get('date-enabled') && $gantry->get('date-clientside')) {
			$gantry->addScript('gantry-date.js');
			$gantry->addInlineScript($this->_dateFormat());
		}
		// build spans
		if ($gantry->get('buildspans-enabled')) {
			$modules = "['rt-block']";
			$headers = "['h3','h2','h1']";
			
			$gantry->addScript('gantry-buildspans.js');
			$gantry->addInlineScript($this->_buildSpans($modules, $headers));
		}
		// inputs
		if ($gantry->get('inputstyling-enabled') && !($gantry->browser->name == 'ie' && $gantry->browser->shortversion == '6')) {
			$exclusions = $gantry->get('inputstyling-exclusions');
			$gantry->addScript('gantry-inputs.js');
			$gantry->addInlineScript("InputsExclusion.push($exclusions)");
		}
		
		
		
		// start custom bloora code
		//////////////////////////
		$doc =& JFactory::getDocument();
		$getapps= & JFactory::getApplication();
		$template = $getapps->getTemplate();
		$template_dir = JURI::base().'templates/'.$template;
		/*
		// add Load jQuery
		if($gantry->get('jquery-enabled') == 1) {
			$doc->addScript("http://ajax.googleapis.com/ajax/libs/jquery/1.6.4/jquery.min.js");

			// add noconflict so it won't conflict with mootools
			if($gantry->get('noconflict-enabled') == 1) {
				$doc->addScript($template_dir."/js/jquery.noconflict.js");
			}
		}
		*/
		
		// load Colorbox (Javascript Lightbox )
		if($gantry->get('colorbox-enabled') == 1) {
			$doc->addScript($template_dir."/js/jquery.colorbox.js");
			$doc->addStyleSheet($template_dir."/css/colorbox".$gantry->get('colorbox-model','1').".css");
			$script = '
			jQuery(document).ready(function($) {
				jQuery(".colorbox").colorbox(); 
			});';
				
			$doc->addScriptDeclaration( $script );
		}
		// load infield label
		$doc->addScript($template_dir."/js/jquery.infieldlabel.min.js");
		// load easing for jquery
		$doc->addScript($template_dir."/js/jquery.easing.1.3.js");
		
		if ($gantry->get('totop-enabled')) {
			$doc->addScript($template_dir.'/js/jquery.totop.js');
		}
		
		// load TipTip ( Tooltips )
		if($gantry->get('tiptip') == 1) {
			$doc->addScript($template_dir."/js/jquery.tipTip.minified.js");
			$doc->addStyleSheet($template_dir."/css/tipTip.css");
			$script = '
			jQuery(document).ready(function($) {
				jQuery(".hasTip").tipTip();
			});';
			$doc->addScriptDeclaration( $script );
		}
		
		// add custom javascript code
		$script = '
		function gVars() {
			gVars = new Object(); 
			gVars.template_dir = "'.urlencode($template_dir).'",
			gVars.chaser = '.$gantry->get('chaser').';
			
			return gVars;
		}
		console.log( gVars() );

		';
		//$doc->addScriptDeclaration( $script );
		//$doc->addScript($template_dir.'/js/functions.js', "text/javascript");
		
	}
	
	function _dateLanguage() {
		
		$days = array(
			'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat',
			'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'
		);
		
		$months = array(
			'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec',
			'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'		
		);
		
		return "dayNames:['" . implode("', '", $days) . "'], monthNames:['" . implode("', '", $months) . "']";
	}
	
	function _dateFormat() {
		global $gantry;
		
		$formats = str_replace("%", "$", $gantry->get('date-formats'));

		$js = "
			dateFormat.i18n = {
				".$this->_dateLanguage()."
			};
			var dateFeature = new Date().format('$formats');
			window.addEvent('domready', function() {
				var dates = $$('.date-block .date, .date, .rt-date-feature');
				if (dates.length) {
					dates.each(function(date) {
						date.set('text', dateFeature);
					});
				}
			});
		";
		
		return $js;
	}
	
	function _buildSpans($modules, $headers) {
		global $gantry;
		
		$js = "
			window.addEvent('domready', function() {
				var modules = $modules;
				var header = $headers;
				GantryBuildSpans(modules, header);
			});
		";
		
		return $js;
	}
}