<?php
/**
 * @package		Joomla.Site
 * @subpackage	com_content
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

// Create a shortcut for params.
$params = &$this->item->params;
$images = json_decode($this->item->images);
$canEdit	= $this->item->params->get('access-edit');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::core();
$template_path = JURI::base().'templates/'.JFactory::getApplication()->getTemplate();
$ptparams = new JRegistry($this->item->attribs);
$pt_image = $ptparams->get('pt_image');
$url_type = $ptparams->get('pt_urltype');
$rel = '';
$target = '';

$cr_width = 440; // carousel width
$cr_height = 260; // carousel height

$doc =& JFactory::getDocument();
$css = '.rhinoslider {width:'.$cr_width.'px; height:'.$cr_height.'px;}';
$doc->addStyleDeclaration($css); 


$pt_other = array(
	array($ptparams->get('pt_image_01'), $ptparams->get('pt_media_01')),
	array($ptparams->get('pt_image_02'), $ptparams->get('pt_media_02')),
	array($ptparams->get('pt_image_03'), $ptparams->get('pt_media_03')),
	array($ptparams->get('pt_image_04'), $ptparams->get('pt_media_04')),
	array($ptparams->get('pt_image_05'), $ptparams->get('pt_media_05')),
	array($ptparams->get('pt_image_06'), $ptparams->get('pt_media_06')),
	array($ptparams->get('pt_image_07'), $ptparams->get('pt_media_07')),
	array($ptparams->get('pt_image_08'), $ptparams->get('pt_media_08')),
	array($ptparams->get('pt_image_09'), $ptparams->get('pt_media_09')),
	array($ptparams->get('pt_image_10'), $ptparams->get('pt_media_10')),
);


if ($params->get('access-view')) :
	$itemlink = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid));
else :
	$menu = JFactory::getApplication()->getMenu();
	$active = $menu->getActive();
	$itemId = $active->id;
	$link1 = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId);
	$returnURL = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid));
	$itemlink = new JURI($link1);
	$itemlink->setVar('return', base64_encode($returnURL));
endif;

if ($url_type != 5) :
	// if 0 - Portfolio item page
	if($url_type == 0){
		$link = $itemlink;
	}// if 0 (normal link)
	else if($url_type == 1){
		$link = ($ptparams->get('pt_image_full')) ? $ptparams->get('pt_image_full') : $pt_image;
		$rel = 'data-rel="colorbox"';
	}//if 1 (lightbox image)
	else if($url_type == 2){
		$link = 'http://www.youtube.com/watch?v='.$ptparams->get('pt_videoid');
		$rel = 'data-rel="colorbox_video"';
	}//if 2 (youtube)
	else if($url_type == 3){
		$link = 'http://www.vimeo.com/'.$ptparams->get('pt_videoid');
		$rel = 'data-rel="colorbox_video"';
	}//if 3 (vimeo)
	else if($url_type == 4){
		$link = $ptparams->get('pt_url');
		$target = 'target="_blank"';
	}//if 4 (external)
endif;

?>

<?php if ($this->item->state == 0) : ?>
<div class="system-unpublished">
<?php endif; ?>

<div class="inner-item">
<?php if (!$params->get('show_intro')) : ?>
	<?php echo $this->item->event->afterDisplayTitle; ?>
<?php endif; ?>

<?php echo $this->item->event->beforeDisplayContent; ?>

<div class="ptcontent rt-grid-6 rt-alpha">
	<?php if ($params->get('show_title')) : ?>
        <h4 class="title">
            <?php if ($params->get('link_titles') && $params->get('access-view')) : ?>
                
                <a href="<?php echo $itemlink; ?>"><?php echo $this->escape($this->item->title); ?></a>
                
            <?php else : ?>
                <?php echo $this->escape($this->item->title); ?>
            <?php endif; ?>
        </h4>
    <?php endif; ?>
    
    <div class="pt-cat-desc">
        <?php echo $this->item->introtext; ?>
    </div>
    <div class="itemLinks">
        <?php
		$pt_livepreview = $ptparams->get('pt_livepreview');
		if($pt_livepreview) echo '<span><a href="'.$pt_livepreview.'" target="_blank" >'.JText::_('PORTFOLIO_CAROUSEL_LIVE_PREVIEW').' '.str_replace('http:','',str_replace('/','',$pt_livepreview)).'</a></span>'; ?>
        <span class="seemore"><a href="<?php echo $itemlink; ?>" ><?php echo JText::_('PORTFOLIO_CAROUSEL_SEE_MORE'); ?></a></span>
    </div>
</div>

<div class="ptcarousel rt-grid-6 rt-omega">
	<ul id="rhinoslider<?php echo $this->item->id ?>" class="rhinoslider">
    
    <li>
	<?php if ($params->get('access-view') && $url_type != 5) { ?>
        <a href="<?php echo $link; ?>" <?php echo $rel; ?> <?php echo $target; ?>>
        
        <?php } ?>
            <img src="<?php echo $template_path.'/php/img.php?src='.JURI::base(true).'/'.$pt_image; ?>&amp;w=<?php echo $cr_width ?>&amp;h=<?php echo $cr_height ?>&amp;zc=1" alt="<?php echo $this->escape($this->item->title); ?>"/>
        <?php if ($params->get('access-view') && $url_type != 5) { ?>
        </a>
    <?php } ?>
    </li>
    
<?php
foreach($pt_other as $other){
	
	if($other[0] || $other[1]) {
		echo '<li>';
		if($other[0]) {
			echo '
			<a href="'.$other[0].'" rel="prettyPhoto">
				<img src="'.$template_path.'/php/img.php?src='.JURI::base(true).'/'.$other[0].'&amp;w='.$cr_width.'&amp;h='.$cr_height.'&amp;zc=1" alt="'.$this->escape($this->item->title).'" />
			</a>';
		} else if($other[1]) {
			if(is_numeric($other[1])) {
				echo '<iframe src="http://player.vimeo.com/video/'.$other[1].'?title=0&amp;byline=0&amp;portrait=0" width="'.$cr_width.'" height="'.$cr_height.'" frameborder="0" webkitallowfullscreen="" allowfullscreen=""></iframe>';
			} else {
				echo '<iframe src="http://www.youtube.com/embed/'.$other[1].'?wmode=transparent&amp;rel=0" width="'.$cr_width.'" height="'.$cr_height.'" frameborder="0" webkitallowfullscreen="" allowfullscreen=""></iframe>';
			}
		}
		echo '</li>';
	}
}
?>
    </ul>
</div>
<div class="clear"></div>

</div>

<?php if ($this->item->state == 0) : ?>
</div>
<?php endif; ?>

<?php echo $this->item->event->afterDisplayContent; ?>
